<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZgAccount
 *
 * @ORM\Table(name="zg_account", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zg_account_trf_yn", columns={"zg_account_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZgAccount
{
    /**
     * @var string
     *
     * @ORM\Column(name="zg_account_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zgAccountIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_account_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zgAccountDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zg_account_id", type="integer", nullable=false)
     */
    private $zgAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_acc_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zgAccName;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_acc_username", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zgAccUsername;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_acc_password", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zgAccPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_acc_api_url", type="string", length=255, nullable=false, options={"default"="http://www.divtech.co.za/bizapp/xmlapi/eguestsurv/"})
     */
    private $zgAccApiUrl;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_acc_site_url", type="string", length=255, nullable=false, options={"default"="http://www.divtech.co.za/bizapp/login.cfm"})
     */
    private $zgAccSiteUrl;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_account_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgAccountInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_account_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgAccountTrfYn;



    /**
     * Get zgAccountIx
     *
     * @return string
     */
    public function getZgAccountIx()
    {
        return $this->zgAccountIx;
    }

    /**
     * Set zgAccountDb
     *
     * @param string $zgAccountDb
     *
     * @return ZgAccount
     */
    public function setZgAccountDb($zgAccountDb)
    {
        $this->zgAccountDb = $zgAccountDb;

        return $this;
    }

    /**
     * Get zgAccountDb
     *
     * @return string
     */
    public function getZgAccountDb()
    {
        return $this->zgAccountDb;
    }

    /**
     * Set zgAccountId
     *
     * @param integer $zgAccountId
     *
     * @return ZgAccount
     */
    public function setZgAccountId($zgAccountId)
    {
        $this->zgAccountId = $zgAccountId;

        return $this;
    }

    /**
     * Get zgAccountId
     *
     * @return integer
     */
    public function getZgAccountId()
    {
        return $this->zgAccountId;
    }

    /**
     * Set zgAccName
     *
     * @param string $zgAccName
     *
     * @return ZgAccount
     */
    public function setZgAccName($zgAccName)
    {
        $this->zgAccName = $zgAccName;

        return $this;
    }

    /**
     * Get zgAccName
     *
     * @return string
     */
    public function getZgAccName()
    {
        return $this->zgAccName;
    }

    /**
     * Set zgAccUsername
     *
     * @param string $zgAccUsername
     *
     * @return ZgAccount
     */
    public function setZgAccUsername($zgAccUsername)
    {
        $this->zgAccUsername = $zgAccUsername;

        return $this;
    }

    /**
     * Get zgAccUsername
     *
     * @return string
     */
    public function getZgAccUsername()
    {
        return $this->zgAccUsername;
    }

    /**
     * Set zgAccPassword
     *
     * @param string $zgAccPassword
     *
     * @return ZgAccount
     */
    public function setZgAccPassword($zgAccPassword)
    {
        $this->zgAccPassword = $zgAccPassword;

        return $this;
    }

    /**
     * Get zgAccPassword
     *
     * @return string
     */
    public function getZgAccPassword()
    {
        return $this->zgAccPassword;
    }

    /**
     * Set zgAccApiUrl
     *
     * @param string $zgAccApiUrl
     *
     * @return ZgAccount
     */
    public function setZgAccApiUrl($zgAccApiUrl)
    {
        $this->zgAccApiUrl = $zgAccApiUrl;

        return $this;
    }

    /**
     * Get zgAccApiUrl
     *
     * @return string
     */
    public function getZgAccApiUrl()
    {
        return $this->zgAccApiUrl;
    }

    /**
     * Set zgAccSiteUrl
     *
     * @param string $zgAccSiteUrl
     *
     * @return ZgAccount
     */
    public function setZgAccSiteUrl($zgAccSiteUrl)
    {
        $this->zgAccSiteUrl = $zgAccSiteUrl;

        return $this;
    }

    /**
     * Get zgAccSiteUrl
     *
     * @return string
     */
    public function getZgAccSiteUrl()
    {
        return $this->zgAccSiteUrl;
    }

    /**
     * Set zgAccountInactiveYn
     *
     * @param boolean $zgAccountInactiveYn
     *
     * @return ZgAccount
     */
    public function setZgAccountInactiveYn($zgAccountInactiveYn)
    {
        $this->zgAccountInactiveYn = $zgAccountInactiveYn;

        return $this;
    }

    /**
     * Get zgAccountInactiveYn
     *
     * @return boolean
     */
    public function getZgAccountInactiveYn()
    {
        return $this->zgAccountInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZgAccount
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zgAccountTrfYn
     *
     * @param boolean $zgAccountTrfYn
     *
     * @return ZgAccount
     */
    public function setZgAccountTrfYn($zgAccountTrfYn)
    {
        $this->zgAccountTrfYn = $zgAccountTrfYn;

        return $this;
    }

    /**
     * Get zgAccountTrfYn
     *
     * @return boolean
     */
    public function getZgAccountTrfYn()
    {
        return $this->zgAccountTrfYn;
    }
}
