<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZgAccountProp
 *
 * @ORM\Table(name="zg_account_prop", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zg_account_prop_trf_yn", columns={"zg_account_prop_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZgAccountProp
{
    /**
     * @var string
     *
     * @ORM\Column(name="zg_account_prop_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zgAccountPropIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_account_prop_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zgAccountPropDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zg_account_prop_id", type="integer", nullable=false)
     */
    private $zgAccountPropId;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_acc_prop_code", type="string", length=20, nullable=false, options={"default"=""})
     */
    private $zgAccPropCode;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_account_id", type="string", length=36, nullable=true)
     */
    private $zgAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_account_prop_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgAccountPropTrfYn;



    /**
     * Get zgAccountPropIx
     *
     * @return string
     */
    public function getZgAccountPropIx()
    {
        return $this->zgAccountPropIx;
    }

    /**
     * Set zgAccountPropDb
     *
     * @param string $zgAccountPropDb
     *
     * @return ZgAccountProp
     */
    public function setZgAccountPropDb($zgAccountPropDb)
    {
        $this->zgAccountPropDb = $zgAccountPropDb;

        return $this;
    }

    /**
     * Get zgAccountPropDb
     *
     * @return string
     */
    public function getZgAccountPropDb()
    {
        return $this->zgAccountPropDb;
    }

    /**
     * Set zgAccountPropId
     *
     * @param integer $zgAccountPropId
     *
     * @return ZgAccountProp
     */
    public function setZgAccountPropId($zgAccountPropId)
    {
        $this->zgAccountPropId = $zgAccountPropId;

        return $this;
    }

    /**
     * Get zgAccountPropId
     *
     * @return integer
     */
    public function getZgAccountPropId()
    {
        return $this->zgAccountPropId;
    }

    /**
     * Set zgAccPropCode
     *
     * @param string $zgAccPropCode
     *
     * @return ZgAccountProp
     */
    public function setZgAccPropCode($zgAccPropCode)
    {
        $this->zgAccPropCode = $zgAccPropCode;

        return $this;
    }

    /**
     * Get zgAccPropCode
     *
     * @return string
     */
    public function getZgAccPropCode()
    {
        return $this->zgAccPropCode;
    }

    /**
     * Set zgAccountId
     *
     * @param string $zgAccountId
     *
     * @return ZgAccountProp
     */
    public function setZgAccountId($zgAccountId)
    {
        $this->zgAccountId = $zgAccountId;

        return $this;
    }

    /**
     * Get zgAccountId
     *
     * @return string
     */
    public function getZgAccountId()
    {
        return $this->zgAccountId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return ZgAccountProp
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZgAccountProp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zgAccountPropTrfYn
     *
     * @param boolean $zgAccountPropTrfYn
     *
     * @return ZgAccountProp
     */
    public function setZgAccountPropTrfYn($zgAccountPropTrfYn)
    {
        $this->zgAccountPropTrfYn = $zgAccountPropTrfYn;

        return $this;
    }

    /**
     * Get zgAccountPropTrfYn
     *
     * @return boolean
     */
    public function getZgAccountPropTrfYn()
    {
        return $this->zgAccountPropTrfYn;
    }
}
