<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZgTransfer
 *
 * @ORM\Table(name="zg_transfer", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zg_transfer_trf_yn", columns={"zg_transfer_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZgTransfer
{
    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zgTransferIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zgTransferDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zg_transfer_id", type="integer", nullable=false)
     */
    private $zgTransferId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zg_trf_date_open", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zgTrfDateOpen;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_trf_date_open_tz", type="string", length=40, nullable=false)
     */
    private $zgTrfDateOpenTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zg_trf_date_close", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zgTrfDateClose;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_trf_date_close_tz", type="string", length=40, nullable=false)
     */
    private $zgTrfDateCloseTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_trf_status_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgTrfStatusInd;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_trf_log", type="text", length=65535, nullable=true)
     */
    private $zgTrfLog;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_trf_request", type="text", length=65535, nullable=true)
     */
    private $zgTrfRequest;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_trf_response", type="text", length=65535, nullable=true)
     */
    private $zgTrfResponse;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_account_id", type="string", length=36, nullable=true)
     */
    private $zgAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_transfer_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgTransferTrfYn;



    /**
     * Get zgTransferIx
     *
     * @return string
     */
    public function getZgTransferIx()
    {
        return $this->zgTransferIx;
    }

    /**
     * Set zgTransferDb
     *
     * @param string $zgTransferDb
     *
     * @return ZgTransfer
     */
    public function setZgTransferDb($zgTransferDb)
    {
        $this->zgTransferDb = $zgTransferDb;

        return $this;
    }

    /**
     * Get zgTransferDb
     *
     * @return string
     */
    public function getZgTransferDb()
    {
        return $this->zgTransferDb;
    }

    /**
     * Set zgTransferId
     *
     * @param integer $zgTransferId
     *
     * @return ZgTransfer
     */
    public function setZgTransferId($zgTransferId)
    {
        $this->zgTransferId = $zgTransferId;

        return $this;
    }

    /**
     * Get zgTransferId
     *
     * @return integer
     */
    public function getZgTransferId()
    {
        return $this->zgTransferId;
    }

    /**
     * Set zgTrfDateOpen
     *
     * @param \DateTime $zgTrfDateOpen
     *
     * @return ZgTransfer
     */
    public function setZgTrfDateOpen($zgTrfDateOpen)
    {
        $this->zgTrfDateOpen = $zgTrfDateOpen;

        return $this;
    }

    /**
     * Get zgTrfDateOpen
     *
     * @return \DateTime
     */
    public function getZgTrfDateOpen()
    {
        return $this->zgTrfDateOpen;
    }

    /**
     * Set zgTrfDateOpenTz
     *
     * @param string $zgTrfDateOpenTz
     *
     * @return ZgTransfer
     */
    public function setZgTrfDateOpenTz($zgTrfDateOpenTz)
    {
        $this->zgTrfDateOpenTz = $zgTrfDateOpenTz;

        return $this;
    }

    /**
     * Get zgTrfDateOpenTz
     *
     * @return string
     */
    public function getZgTrfDateOpenTz()
    {
        return $this->zgTrfDateOpenTz;
    }

    /**
     * Set zgTrfDateClose
     *
     * @param \DateTime $zgTrfDateClose
     *
     * @return ZgTransfer
     */
    public function setZgTrfDateClose($zgTrfDateClose)
    {
        $this->zgTrfDateClose = $zgTrfDateClose;

        return $this;
    }

    /**
     * Get zgTrfDateClose
     *
     * @return \DateTime
     */
    public function getZgTrfDateClose()
    {
        return $this->zgTrfDateClose;
    }

    /**
     * Set zgTrfDateCloseTz
     *
     * @param string $zgTrfDateCloseTz
     *
     * @return ZgTransfer
     */
    public function setZgTrfDateCloseTz($zgTrfDateCloseTz)
    {
        $this->zgTrfDateCloseTz = $zgTrfDateCloseTz;

        return $this;
    }

    /**
     * Get zgTrfDateCloseTz
     *
     * @return string
     */
    public function getZgTrfDateCloseTz()
    {
        return $this->zgTrfDateCloseTz;
    }

    /**
     * Set zgTrfStatusInd
     *
     * @param boolean $zgTrfStatusInd
     *
     * @return ZgTransfer
     */
    public function setZgTrfStatusInd($zgTrfStatusInd)
    {
        $this->zgTrfStatusInd = $zgTrfStatusInd;

        return $this;
    }

    /**
     * Get zgTrfStatusInd
     *
     * @return boolean
     */
    public function getZgTrfStatusInd()
    {
        return $this->zgTrfStatusInd;
    }

    /**
     * Set zgTrfLog
     *
     * @param string $zgTrfLog
     *
     * @return ZgTransfer
     */
    public function setZgTrfLog($zgTrfLog)
    {
        $this->zgTrfLog = $zgTrfLog;

        return $this;
    }

    /**
     * Get zgTrfLog
     *
     * @return string
     */
    public function getZgTrfLog()
    {
        return $this->zgTrfLog;
    }

    /**
     * Set zgTrfRequest
     *
     * @param string $zgTrfRequest
     *
     * @return ZgTransfer
     */
    public function setZgTrfRequest($zgTrfRequest)
    {
        $this->zgTrfRequest = $zgTrfRequest;

        return $this;
    }

    /**
     * Get zgTrfRequest
     *
     * @return string
     */
    public function getZgTrfRequest()
    {
        return $this->zgTrfRequest;
    }

    /**
     * Set zgTrfResponse
     *
     * @param string $zgTrfResponse
     *
     * @return ZgTransfer
     */
    public function setZgTrfResponse($zgTrfResponse)
    {
        $this->zgTrfResponse = $zgTrfResponse;

        return $this;
    }

    /**
     * Get zgTrfResponse
     *
     * @return string
     */
    public function getZgTrfResponse()
    {
        return $this->zgTrfResponse;
    }

    /**
     * Set zgAccountId
     *
     * @param string $zgAccountId
     *
     * @return ZgTransfer
     */
    public function setZgAccountId($zgAccountId)
    {
        $this->zgAccountId = $zgAccountId;

        return $this;
    }

    /**
     * Get zgAccountId
     *
     * @return string
     */
    public function getZgAccountId()
    {
        return $this->zgAccountId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZgTransfer
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zgTransferTrfYn
     *
     * @param boolean $zgTransferTrfYn
     *
     * @return ZgTransfer
     */
    public function setZgTransferTrfYn($zgTransferTrfYn)
    {
        $this->zgTransferTrfYn = $zgTransferTrfYn;

        return $this;
    }

    /**
     * Get zgTransferTrfYn
     *
     * @return boolean
     */
    public function getZgTransferTrfYn()
    {
        return $this->zgTransferTrfYn;
    }
}
