<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZgTransferGuest
 *
 * @ORM\Table(name="zg_transfer_guest", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zg_transfer_guest_trf_yn", columns={"zg_transfer_guest_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZgTransferGuest
{
    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_guest_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zgTransferGuestIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_guest_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zgTransferGuestDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zg_transfer_guest_id", type="integer", nullable=false)
     */
    private $zgTransferGuestId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_trf_guest_status_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgTrfGuestStatusInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_id", type="string", length=36, nullable=true)
     */
    private $prGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_id", type="string", length=36, nullable=true)
     */
    private $zgTransferId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_transfer_guest_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgTransferGuestTrfYn;



    /**
     * Get zgTransferGuestIx
     *
     * @return string
     */
    public function getZgTransferGuestIx()
    {
        return $this->zgTransferGuestIx;
    }

    /**
     * Set zgTransferGuestDb
     *
     * @param string $zgTransferGuestDb
     *
     * @return ZgTransferGuest
     */
    public function setZgTransferGuestDb($zgTransferGuestDb)
    {
        $this->zgTransferGuestDb = $zgTransferGuestDb;

        return $this;
    }

    /**
     * Get zgTransferGuestDb
     *
     * @return string
     */
    public function getZgTransferGuestDb()
    {
        return $this->zgTransferGuestDb;
    }

    /**
     * Set zgTransferGuestId
     *
     * @param integer $zgTransferGuestId
     *
     * @return ZgTransferGuest
     */
    public function setZgTransferGuestId($zgTransferGuestId)
    {
        $this->zgTransferGuestId = $zgTransferGuestId;

        return $this;
    }

    /**
     * Get zgTransferGuestId
     *
     * @return integer
     */
    public function getZgTransferGuestId()
    {
        return $this->zgTransferGuestId;
    }

    /**
     * Set zgTrfGuestStatusInd
     *
     * @param boolean $zgTrfGuestStatusInd
     *
     * @return ZgTransferGuest
     */
    public function setZgTrfGuestStatusInd($zgTrfGuestStatusInd)
    {
        $this->zgTrfGuestStatusInd = $zgTrfGuestStatusInd;

        return $this;
    }

    /**
     * Get zgTrfGuestStatusInd
     *
     * @return boolean
     */
    public function getZgTrfGuestStatusInd()
    {
        return $this->zgTrfGuestStatusInd;
    }

    /**
     * Set prGuestId
     *
     * @param string $prGuestId
     *
     * @return ZgTransferGuest
     */
    public function setPrGuestId($prGuestId)
    {
        $this->prGuestId = $prGuestId;

        return $this;
    }

    /**
     * Get prGuestId
     *
     * @return string
     */
    public function getPrGuestId()
    {
        return $this->prGuestId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return ZgTransferGuest
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set zgTransferId
     *
     * @param string $zgTransferId
     *
     * @return ZgTransferGuest
     */
    public function setZgTransferId($zgTransferId)
    {
        $this->zgTransferId = $zgTransferId;

        return $this;
    }

    /**
     * Get zgTransferId
     *
     * @return string
     */
    public function getZgTransferId()
    {
        return $this->zgTransferId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZgTransferGuest
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zgTransferGuestTrfYn
     *
     * @param boolean $zgTransferGuestTrfYn
     *
     * @return ZgTransferGuest
     */
    public function setZgTransferGuestTrfYn($zgTransferGuestTrfYn)
    {
        $this->zgTransferGuestTrfYn = $zgTransferGuestTrfYn;

        return $this;
    }

    /**
     * Get zgTransferGuestTrfYn
     *
     * @return boolean
     */
    public function getZgTransferGuestTrfYn()
    {
        return $this->zgTransferGuestTrfYn;
    }
}
