<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZgTransferGuestProp
 *
 * @ORM\Table(name="zg_transfer_guest_prop", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zg_transfer_guest_prop_trf_yn", columns={"zg_transfer_guest_prop_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZgTransferGuestProp
{
    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_guest_prop_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zgTransferGuestPropIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_guest_prop_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zgTransferGuestPropDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zg_transfer_guest_prop_id", type="integer", nullable=false)
     */
    private $zgTransferGuestPropId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="zg_transfer_guest_id", type="string", length=36, nullable=true)
     */
    private $zgTransferGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zg_transfer_guest_prop_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zgTransferGuestPropTrfYn;



    /**
     * Get zgTransferGuestPropIx
     *
     * @return string
     */
    public function getZgTransferGuestPropIx()
    {
        return $this->zgTransferGuestPropIx;
    }

    /**
     * Set zgTransferGuestPropDb
     *
     * @param string $zgTransferGuestPropDb
     *
     * @return ZgTransferGuestProp
     */
    public function setZgTransferGuestPropDb($zgTransferGuestPropDb)
    {
        $this->zgTransferGuestPropDb = $zgTransferGuestPropDb;

        return $this;
    }

    /**
     * Get zgTransferGuestPropDb
     *
     * @return string
     */
    public function getZgTransferGuestPropDb()
    {
        return $this->zgTransferGuestPropDb;
    }

    /**
     * Set zgTransferGuestPropId
     *
     * @param integer $zgTransferGuestPropId
     *
     * @return ZgTransferGuestProp
     */
    public function setZgTransferGuestPropId($zgTransferGuestPropId)
    {
        $this->zgTransferGuestPropId = $zgTransferGuestPropId;

        return $this;
    }

    /**
     * Get zgTransferGuestPropId
     *
     * @return integer
     */
    public function getZgTransferGuestPropId()
    {
        return $this->zgTransferGuestPropId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return ZgTransferGuestProp
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set zgTransferGuestId
     *
     * @param string $zgTransferGuestId
     *
     * @return ZgTransferGuestProp
     */
    public function setZgTransferGuestId($zgTransferGuestId)
    {
        $this->zgTransferGuestId = $zgTransferGuestId;

        return $this;
    }

    /**
     * Get zgTransferGuestId
     *
     * @return string
     */
    public function getZgTransferGuestId()
    {
        return $this->zgTransferGuestId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZgTransferGuestProp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zgTransferGuestPropTrfYn
     *
     * @param boolean $zgTransferGuestPropTrfYn
     *
     * @return ZgTransferGuestProp
     */
    public function setZgTransferGuestPropTrfYn($zgTransferGuestPropTrfYn)
    {
        $this->zgTransferGuestPropTrfYn = $zgTransferGuestPropTrfYn;

        return $this;
    }

    /**
     * Get zgTransferGuestPropTrfYn
     *
     * @return boolean
     */
    public function getZgTransferGuestPropTrfYn()
    {
        return $this->zgTransferGuestPropTrfYn;
    }
}
