<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZmAccount
 *
 * @ORM\Table(name="zm_account", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zm_account_trf_yn", columns={"zm_account_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZmAccount
{
    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zmAccountIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zmAccountDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zm_account_id", type="integer", nullable=false)
     */
    private $zmAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zmAccountName;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_type_id", type="string", length=36, nullable=true)
     */
    private $zmAccountTypeId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zm_account_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zmAccountInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zm_account_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zmAccountTrfYn;



    /**
     * Get zmAccountIx
     *
     * @return string
     */
    public function getZmAccountIx()
    {
        return $this->zmAccountIx;
    }

    /**
     * Set zmAccountDb
     *
     * @param string $zmAccountDb
     *
     * @return ZmAccount
     */
    public function setZmAccountDb($zmAccountDb)
    {
        $this->zmAccountDb = $zmAccountDb;

        return $this;
    }

    /**
     * Get zmAccountDb
     *
     * @return string
     */
    public function getZmAccountDb()
    {
        return $this->zmAccountDb;
    }

    /**
     * Set zmAccountId
     *
     * @param integer $zmAccountId
     *
     * @return ZmAccount
     */
    public function setZmAccountId($zmAccountId)
    {
        $this->zmAccountId = $zmAccountId;

        return $this;
    }

    /**
     * Get zmAccountId
     *
     * @return integer
     */
    public function getZmAccountId()
    {
        return $this->zmAccountId;
    }

    /**
     * Set zmAccountName
     *
     * @param string $zmAccountName
     *
     * @return ZmAccount
     */
    public function setZmAccountName($zmAccountName)
    {
        $this->zmAccountName = $zmAccountName;

        return $this;
    }

    /**
     * Get zmAccountName
     *
     * @return string
     */
    public function getZmAccountName()
    {
        return $this->zmAccountName;
    }

    /**
     * Set zmAccountTypeId
     *
     * @param string $zmAccountTypeId
     *
     * @return ZmAccount
     */
    public function setZmAccountTypeId($zmAccountTypeId)
    {
        $this->zmAccountTypeId = $zmAccountTypeId;

        return $this;
    }

    /**
     * Get zmAccountTypeId
     *
     * @return string
     */
    public function getZmAccountTypeId()
    {
        return $this->zmAccountTypeId;
    }

    /**
     * Set zmAccountInactiveYn
     *
     * @param boolean $zmAccountInactiveYn
     *
     * @return ZmAccount
     */
    public function setZmAccountInactiveYn($zmAccountInactiveYn)
    {
        $this->zmAccountInactiveYn = $zmAccountInactiveYn;

        return $this;
    }

    /**
     * Get zmAccountInactiveYn
     *
     * @return boolean
     */
    public function getZmAccountInactiveYn()
    {
        return $this->zmAccountInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZmAccount
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zmAccountTrfYn
     *
     * @param boolean $zmAccountTrfYn
     *
     * @return ZmAccount
     */
    public function setZmAccountTrfYn($zmAccountTrfYn)
    {
        $this->zmAccountTrfYn = $zmAccountTrfYn;

        return $this;
    }

    /**
     * Get zmAccountTrfYn
     *
     * @return boolean
     */
    public function getZmAccountTrfYn()
    {
        return $this->zmAccountTrfYn;
    }
}
