<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZmAccountCredentials
 *
 * @ORM\Table(name="zm_account_credentials", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class ZmAccountCredentials
{
    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_cred_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zmAccountCredIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_cred_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zmAccountCredDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zm_account_cred_id", type="integer", nullable=false)
     */
    private $zmAccountCredId;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_credential_field_id", type="string", length=36, nullable=true)
     */
    private $zmCredentialFieldId;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_cred_value", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zmAccountCredValue;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_id", type="string", length=36, nullable=true)
     */
    private $zmAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zm_account_cred_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zmAccountCredTrfYn;



    /**
     * Get zmAccountCredIx
     *
     * @return string
     */
    public function getZmAccountCredIx()
    {
        return $this->zmAccountCredIx;
    }

    /**
     * Set zmAccountCredDb
     *
     * @param string $zmAccountCredDb
     *
     * @return ZmAccountCredentials
     */
    public function setZmAccountCredDb($zmAccountCredDb)
    {
        $this->zmAccountCredDb = $zmAccountCredDb;

        return $this;
    }

    /**
     * Get zmAccountCredDb
     *
     * @return string
     */
    public function getZmAccountCredDb()
    {
        return $this->zmAccountCredDb;
    }

    /**
     * Set zmAccountCredId
     *
     * @param integer $zmAccountCredId
     *
     * @return ZmAccountCredentials
     */
    public function setZmAccountCredId($zmAccountCredId)
    {
        $this->zmAccountCredId = $zmAccountCredId;

        return $this;
    }

    /**
     * Get zmAccountCredId
     *
     * @return integer
     */
    public function getZmAccountCredId()
    {
        return $this->zmAccountCredId;
    }

    /**
     * Set zmCredentialFieldId
     *
     * @param string $zmCredentialFieldId
     *
     * @return ZmAccountCredentials
     */
    public function setZmCredentialFieldId($zmCredentialFieldId)
    {
        $this->zmCredentialFieldId = $zmCredentialFieldId;

        return $this;
    }

    /**
     * Get zmCredentialFieldId
     *
     * @return string
     */
    public function getZmCredentialFieldId()
    {
        return $this->zmCredentialFieldId;
    }

    /**
     * Set zmAccountCredValue
     *
     * @param string $zmAccountCredValue
     *
     * @return ZmAccountCredentials
     */
    public function setZmAccountCredValue($zmAccountCredValue)
    {
        $this->zmAccountCredValue = $zmAccountCredValue;

        return $this;
    }

    /**
     * Get zmAccountCredValue
     *
     * @return string
     */
    public function getZmAccountCredValue()
    {
        return $this->zmAccountCredValue;
    }

    /**
     * Set zmAccountId
     *
     * @param string $zmAccountId
     *
     * @return ZmAccountCredentials
     */
    public function setZmAccountId($zmAccountId)
    {
        $this->zmAccountId = $zmAccountId;

        return $this;
    }

    /**
     * Get zmAccountId
     *
     * @return string
     */
    public function getZmAccountId()
    {
        return $this->zmAccountId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZmAccountCredentials
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zmAccountCredTrfYn
     *
     * @param boolean $zmAccountCredTrfYn
     *
     * @return ZmAccountCredentials
     */
    public function setZmAccountCredTrfYn($zmAccountCredTrfYn)
    {
        $this->zmAccountCredTrfYn = $zmAccountCredTrfYn;

        return $this;
    }

    /**
     * Get zmAccountCredTrfYn
     *
     * @return boolean
     */
    public function getZmAccountCredTrfYn()
    {
        return $this->zmAccountCredTrfYn;
    }
}
