<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZmAccountType
 *
 * @ORM\Table(name="zm_account_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zm_account_type_trf_yn", columns={"zm_account_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZmAccountType
{
    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zmAccountTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zmAccountTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zm_account_type_id", type="integer", nullable=false)
     */
    private $zmAccountTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_account_type_desc", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zmAccountTypeDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zm_account_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zmAccountTypeTrfYn;



    /**
     * Get zmAccountTypeIx
     *
     * @return string
     */
    public function getZmAccountTypeIx()
    {
        return $this->zmAccountTypeIx;
    }

    /**
     * Set zmAccountTypeDb
     *
     * @param string $zmAccountTypeDb
     *
     * @return ZmAccountType
     */
    public function setZmAccountTypeDb($zmAccountTypeDb)
    {
        $this->zmAccountTypeDb = $zmAccountTypeDb;

        return $this;
    }

    /**
     * Get zmAccountTypeDb
     *
     * @return string
     */
    public function getZmAccountTypeDb()
    {
        return $this->zmAccountTypeDb;
    }

    /**
     * Set zmAccountTypeId
     *
     * @param integer $zmAccountTypeId
     *
     * @return ZmAccountType
     */
    public function setZmAccountTypeId($zmAccountTypeId)
    {
        $this->zmAccountTypeId = $zmAccountTypeId;

        return $this;
    }

    /**
     * Get zmAccountTypeId
     *
     * @return integer
     */
    public function getZmAccountTypeId()
    {
        return $this->zmAccountTypeId;
    }

    /**
     * Set zmAccountTypeDesc
     *
     * @param string $zmAccountTypeDesc
     *
     * @return ZmAccountType
     */
    public function setZmAccountTypeDesc($zmAccountTypeDesc)
    {
        $this->zmAccountTypeDesc = $zmAccountTypeDesc;

        return $this;
    }

    /**
     * Get zmAccountTypeDesc
     *
     * @return string
     */
    public function getZmAccountTypeDesc()
    {
        return $this->zmAccountTypeDesc;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZmAccountType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zmAccountTypeTrfYn
     *
     * @param boolean $zmAccountTypeTrfYn
     *
     * @return ZmAccountType
     */
    public function setZmAccountTypeTrfYn($zmAccountTypeTrfYn)
    {
        $this->zmAccountTypeTrfYn = $zmAccountTypeTrfYn;

        return $this;
    }

    /**
     * Get zmAccountTypeTrfYn
     *
     * @return boolean
     */
    public function getZmAccountTypeTrfYn()
    {
        return $this->zmAccountTypeTrfYn;
    }
}
