<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZmCredentialField
 *
 * @ORM\Table(name="zm_credential_field", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zm_credential_field_trf_yn", columns={"zm_credential_field_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZmCredentialField
{
    /**
     * @var string
     *
     * @ORM\Column(name="zm_credential_field_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zmCredentialFieldIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_credential_field_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zmCredentialFieldDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zm_credential_field_id", type="integer", nullable=false)
     */
    private $zmCredentialFieldId;

    /**
     * @var string
     *
     * @ORM\Column(name="zm_credential_field_label", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $zmCredentialFieldLabel;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zm_credential_field_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zmCredentialFieldTrfYn;



    /**
     * Get zmCredentialFieldIx
     *
     * @return string
     */
    public function getZmCredentialFieldIx()
    {
        return $this->zmCredentialFieldIx;
    }

    /**
     * Set zmCredentialFieldDb
     *
     * @param string $zmCredentialFieldDb
     *
     * @return ZmCredentialField
     */
    public function setZmCredentialFieldDb($zmCredentialFieldDb)
    {
        $this->zmCredentialFieldDb = $zmCredentialFieldDb;

        return $this;
    }

    /**
     * Get zmCredentialFieldDb
     *
     * @return string
     */
    public function getZmCredentialFieldDb()
    {
        return $this->zmCredentialFieldDb;
    }

    /**
     * Set zmCredentialFieldId
     *
     * @param integer $zmCredentialFieldId
     *
     * @return ZmCredentialField
     */
    public function setZmCredentialFieldId($zmCredentialFieldId)
    {
        $this->zmCredentialFieldId = $zmCredentialFieldId;

        return $this;
    }

    /**
     * Get zmCredentialFieldId
     *
     * @return integer
     */
    public function getZmCredentialFieldId()
    {
        return $this->zmCredentialFieldId;
    }

    /**
     * Set zmCredentialFieldLabel
     *
     * @param string $zmCredentialFieldLabel
     *
     * @return ZmCredentialField
     */
    public function setZmCredentialFieldLabel($zmCredentialFieldLabel)
    {
        $this->zmCredentialFieldLabel = $zmCredentialFieldLabel;

        return $this;
    }

    /**
     * Get zmCredentialFieldLabel
     *
     * @return string
     */
    public function getZmCredentialFieldLabel()
    {
        return $this->zmCredentialFieldLabel;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZmCredentialField
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zmCredentialFieldTrfYn
     *
     * @param boolean $zmCredentialFieldTrfYn
     *
     * @return ZmCredentialField
     */
    public function setZmCredentialFieldTrfYn($zmCredentialFieldTrfYn)
    {
        $this->zmCredentialFieldTrfYn = $zmCredentialFieldTrfYn;

        return $this;
    }

    /**
     * Get zmCredentialFieldTrfYn
     *
     * @return boolean
     */
    public function getZmCredentialFieldTrfYn()
    {
        return $this->zmCredentialFieldTrfYn;
    }
}
