<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZpSession
 *
 * @ORM\Table(name="zp_session", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class ZpSession
{
    /**
     * @var integer
     *
     * @ORM\Column(name="zp_session_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $zpSessionId;

    /**
     * @var string
     *
     * @ORM\Column(name="zp_session_code", type="string", length=4, nullable=false, options={"default"=""})
     */
    private $zpSessionCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zp_session_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zpSessionTime;

    /**
     * @var string
     *
     * @ORM\Column(name="zp_session_time_tz", type="string", length=40, nullable=false)
     */
    private $zpSessionTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_group_id", type="string", length=36, nullable=true)
     */
    private $rvResItemGroupId;



    /**
     * Get zpSessionId
     *
     * @return integer
     */
    public function getZpSessionId()
    {
        return $this->zpSessionId;
    }

    /**
     * Set zpSessionCode
     *
     * @param string $zpSessionCode
     *
     * @return ZpSession
     */
    public function setZpSessionCode($zpSessionCode)
    {
        $this->zpSessionCode = $zpSessionCode;

        return $this;
    }

    /**
     * Get zpSessionCode
     *
     * @return string
     */
    public function getZpSessionCode()
    {
        return $this->zpSessionCode;
    }

    /**
     * Set zpSessionTime
     *
     * @param \DateTime $zpSessionTime
     *
     * @return ZpSession
     */
    public function setZpSessionTime($zpSessionTime)
    {
        $this->zpSessionTime = $zpSessionTime;

        return $this;
    }

    /**
     * Get zpSessionTime
     *
     * @return \DateTime
     */
    public function getZpSessionTime()
    {
        return $this->zpSessionTime;
    }

    /**
     * Set zpSessionTimeTz
     *
     * @param string $zpSessionTimeTz
     *
     * @return ZpSession
     */
    public function setZpSessionTimeTz($zpSessionTimeTz)
    {
        $this->zpSessionTimeTz = $zpSessionTimeTz;

        return $this;
    }

    /**
     * Get zpSessionTimeTz
     *
     * @return string
     */
    public function getZpSessionTimeTz()
    {
        return $this->zpSessionTimeTz;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return ZpSession
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvResItemGroupId
     *
     * @param string $rvResItemGroupId
     *
     * @return ZpSession
     */
    public function setRvResItemGroupId($rvResItemGroupId)
    {
        $this->rvResItemGroupId = $rvResItemGroupId;

        return $this;
    }

    /**
     * Get rvResItemGroupId
     *
     * @return string
     */
    public function getRvResItemGroupId()
    {
        return $this->rvResItemGroupId;
    }
}
