<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZsQueue
 *
 * @ORM\Table(name="zs_queue", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zs_queue_trf_yn", columns={"zs_queue_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZsQueue
{
    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zsQueueIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zsQueueDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_queue_id", type="integer", nullable=false)
     */
    private $zsQueueId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_queue_attempt_count", type="boolean", nullable=true, options={"default"="0"})
     */
    private $zsQueueAttemptCount;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_queue_attempt_next", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsQueueAttemptNext;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_attempt_next_tz", type="string", length=40, nullable=false)
     */
    private $zsQueueAttemptNextTz;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_command", type="text", length=65535, nullable=true)
     */
    private $zsQueueCommand;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_queue_date_end", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsQueueDateEnd;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_date_end_tz", type="string", length=40, nullable=false)
     */
    private $zsQueueDateEndTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_queue_date_sched", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsQueueDateSched;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_date_sched_tz", type="string", length=40, nullable=false)
     */
    private $zsQueueDateSchedTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_queue_date_start", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsQueueDateStart;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_date_start_tz", type="string", length=40, nullable=false)
     */
    private $zsQueueDateStartTz;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_details", type="string", length=50, nullable=true)
     */
    private $zsQueueDetails;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_queue_status_ind", type="boolean", nullable=true)
     */
    private $zsQueueStatusInd;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_task_title", type="string", length=50, nullable=true)
     */
    private $zsQueueTaskTitle;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_schedule_id", type="string", length=36, nullable=true)
     */
    private $zsScheduleId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_id", type="string", length=36, nullable=true)
     */
    private $zsTaskId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_parent_id", type="string", length=36, nullable=true)
     */
    private $zsQueueParentId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_queue_parent_attempt_next", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsQueueParentAttemptNext;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_parent_attempt_next_tz", type="string", length=40, nullable=false)
     */
    private $zsQueueParentAttemptNextTz;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_notify_id", type="string", length=36, nullable=true)
     */
    private $zsTaskNotifyId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_queue_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsQueueInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_queue_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsQueueTrfYn;



    /**
     * Get zsQueueIx
     *
     * @return string
     */
    public function getZsQueueIx()
    {
        return $this->zsQueueIx;
    }

    /**
     * Set zsQueueDb
     *
     * @param string $zsQueueDb
     *
     * @return ZsQueue
     */
    public function setZsQueueDb($zsQueueDb)
    {
        $this->zsQueueDb = $zsQueueDb;

        return $this;
    }

    /**
     * Get zsQueueDb
     *
     * @return string
     */
    public function getZsQueueDb()
    {
        return $this->zsQueueDb;
    }

    /**
     * Set zsQueueId
     *
     * @param integer $zsQueueId
     *
     * @return ZsQueue
     */
    public function setZsQueueId($zsQueueId)
    {
        $this->zsQueueId = $zsQueueId;

        return $this;
    }

    /**
     * Get zsQueueId
     *
     * @return integer
     */
    public function getZsQueueId()
    {
        return $this->zsQueueId;
    }

    /**
     * Set zsQueueAttemptCount
     *
     * @param boolean $zsQueueAttemptCount
     *
     * @return ZsQueue
     */
    public function setZsQueueAttemptCount($zsQueueAttemptCount)
    {
        $this->zsQueueAttemptCount = $zsQueueAttemptCount;

        return $this;
    }

    /**
     * Get zsQueueAttemptCount
     *
     * @return boolean
     */
    public function getZsQueueAttemptCount()
    {
        return $this->zsQueueAttemptCount;
    }

    /**
     * Set zsQueueAttemptNext
     *
     * @param \DateTime $zsQueueAttemptNext
     *
     * @return ZsQueue
     */
    public function setZsQueueAttemptNext($zsQueueAttemptNext)
    {
        $this->zsQueueAttemptNext = $zsQueueAttemptNext;

        return $this;
    }

    /**
     * Get zsQueueAttemptNext
     *
     * @return \DateTime
     */
    public function getZsQueueAttemptNext()
    {
        return $this->zsQueueAttemptNext;
    }

    /**
     * Set zsQueueAttemptNextTz
     *
     * @param string $zsQueueAttemptNextTz
     *
     * @return ZsQueue
     */
    public function setZsQueueAttemptNextTz($zsQueueAttemptNextTz)
    {
        $this->zsQueueAttemptNextTz = $zsQueueAttemptNextTz;

        return $this;
    }

    /**
     * Get zsQueueAttemptNextTz
     *
     * @return string
     */
    public function getZsQueueAttemptNextTz()
    {
        return $this->zsQueueAttemptNextTz;
    }

    /**
     * Set zsQueueCommand
     *
     * @param string $zsQueueCommand
     *
     * @return ZsQueue
     */
    public function setZsQueueCommand($zsQueueCommand)
    {
        $this->zsQueueCommand = $zsQueueCommand;

        return $this;
    }

    /**
     * Get zsQueueCommand
     *
     * @return string
     */
    public function getZsQueueCommand()
    {
        return $this->zsQueueCommand;
    }

    /**
     * Set zsQueueDateEnd
     *
     * @param \DateTime $zsQueueDateEnd
     *
     * @return ZsQueue
     */
    public function setZsQueueDateEnd($zsQueueDateEnd)
    {
        $this->zsQueueDateEnd = $zsQueueDateEnd;

        return $this;
    }

    /**
     * Get zsQueueDateEnd
     *
     * @return \DateTime
     */
    public function getZsQueueDateEnd()
    {
        return $this->zsQueueDateEnd;
    }

    /**
     * Set zsQueueDateEndTz
     *
     * @param string $zsQueueDateEndTz
     *
     * @return ZsQueue
     */
    public function setZsQueueDateEndTz($zsQueueDateEndTz)
    {
        $this->zsQueueDateEndTz = $zsQueueDateEndTz;

        return $this;
    }

    /**
     * Get zsQueueDateEndTz
     *
     * @return string
     */
    public function getZsQueueDateEndTz()
    {
        return $this->zsQueueDateEndTz;
    }

    /**
     * Set zsQueueDateSched
     *
     * @param \DateTime $zsQueueDateSched
     *
     * @return ZsQueue
     */
    public function setZsQueueDateSched($zsQueueDateSched)
    {
        $this->zsQueueDateSched = $zsQueueDateSched;

        return $this;
    }

    /**
     * Get zsQueueDateSched
     *
     * @return \DateTime
     */
    public function getZsQueueDateSched()
    {
        return $this->zsQueueDateSched;
    }

    /**
     * Set zsQueueDateSchedTz
     *
     * @param string $zsQueueDateSchedTz
     *
     * @return ZsQueue
     */
    public function setZsQueueDateSchedTz($zsQueueDateSchedTz)
    {
        $this->zsQueueDateSchedTz = $zsQueueDateSchedTz;

        return $this;
    }

    /**
     * Get zsQueueDateSchedTz
     *
     * @return string
     */
    public function getZsQueueDateSchedTz()
    {
        return $this->zsQueueDateSchedTz;
    }

    /**
     * Set zsQueueDateStart
     *
     * @param \DateTime $zsQueueDateStart
     *
     * @return ZsQueue
     */
    public function setZsQueueDateStart($zsQueueDateStart)
    {
        $this->zsQueueDateStart = $zsQueueDateStart;

        return $this;
    }

    /**
     * Get zsQueueDateStart
     *
     * @return \DateTime
     */
    public function getZsQueueDateStart()
    {
        return $this->zsQueueDateStart;
    }

    /**
     * Set zsQueueDateStartTz
     *
     * @param string $zsQueueDateStartTz
     *
     * @return ZsQueue
     */
    public function setZsQueueDateStartTz($zsQueueDateStartTz)
    {
        $this->zsQueueDateStartTz = $zsQueueDateStartTz;

        return $this;
    }

    /**
     * Get zsQueueDateStartTz
     *
     * @return string
     */
    public function getZsQueueDateStartTz()
    {
        return $this->zsQueueDateStartTz;
    }

    /**
     * Set zsQueueDetails
     *
     * @param string $zsQueueDetails
     *
     * @return ZsQueue
     */
    public function setZsQueueDetails($zsQueueDetails)
    {
        $this->zsQueueDetails = $zsQueueDetails;

        return $this;
    }

    /**
     * Get zsQueueDetails
     *
     * @return string
     */
    public function getZsQueueDetails()
    {
        return $this->zsQueueDetails;
    }

    /**
     * Set zsQueueStatusInd
     *
     * @param boolean $zsQueueStatusInd
     *
     * @return ZsQueue
     */
    public function setZsQueueStatusInd($zsQueueStatusInd)
    {
        $this->zsQueueStatusInd = $zsQueueStatusInd;

        return $this;
    }

    /**
     * Get zsQueueStatusInd
     *
     * @return boolean
     */
    public function getZsQueueStatusInd()
    {
        return $this->zsQueueStatusInd;
    }

    /**
     * Set zsQueueTaskTitle
     *
     * @param string $zsQueueTaskTitle
     *
     * @return ZsQueue
     */
    public function setZsQueueTaskTitle($zsQueueTaskTitle)
    {
        $this->zsQueueTaskTitle = $zsQueueTaskTitle;

        return $this;
    }

    /**
     * Get zsQueueTaskTitle
     *
     * @return string
     */
    public function getZsQueueTaskTitle()
    {
        return $this->zsQueueTaskTitle;
    }

    /**
     * Set zsScheduleId
     *
     * @param string $zsScheduleId
     *
     * @return ZsQueue
     */
    public function setZsScheduleId($zsScheduleId)
    {
        $this->zsScheduleId = $zsScheduleId;

        return $this;
    }

    /**
     * Get zsScheduleId
     *
     * @return string
     */
    public function getZsScheduleId()
    {
        return $this->zsScheduleId;
    }

    /**
     * Set zsTaskId
     *
     * @param string $zsTaskId
     *
     * @return ZsQueue
     */
    public function setZsTaskId($zsTaskId)
    {
        $this->zsTaskId = $zsTaskId;

        return $this;
    }

    /**
     * Get zsTaskId
     *
     * @return string
     */
    public function getZsTaskId()
    {
        return $this->zsTaskId;
    }

    /**
     * Set zsQueueParentId
     *
     * @param string $zsQueueParentId
     *
     * @return ZsQueue
     */
    public function setZsQueueParentId($zsQueueParentId)
    {
        $this->zsQueueParentId = $zsQueueParentId;

        return $this;
    }

    /**
     * Get zsQueueParentId
     *
     * @return string
     */
    public function getZsQueueParentId()
    {
        return $this->zsQueueParentId;
    }

    /**
     * Set zsQueueParentAttemptNext
     *
     * @param \DateTime $zsQueueParentAttemptNext
     *
     * @return ZsQueue
     */
    public function setZsQueueParentAttemptNext($zsQueueParentAttemptNext)
    {
        $this->zsQueueParentAttemptNext = $zsQueueParentAttemptNext;

        return $this;
    }

    /**
     * Get zsQueueParentAttemptNext
     *
     * @return \DateTime
     */
    public function getZsQueueParentAttemptNext()
    {
        return $this->zsQueueParentAttemptNext;
    }

    /**
     * Set zsQueueParentAttemptNextTz
     *
     * @param string $zsQueueParentAttemptNextTz
     *
     * @return ZsQueue
     */
    public function setZsQueueParentAttemptNextTz($zsQueueParentAttemptNextTz)
    {
        $this->zsQueueParentAttemptNextTz = $zsQueueParentAttemptNextTz;

        return $this;
    }

    /**
     * Get zsQueueParentAttemptNextTz
     *
     * @return string
     */
    public function getZsQueueParentAttemptNextTz()
    {
        return $this->zsQueueParentAttemptNextTz;
    }

    /**
     * Set zsTaskNotifyId
     *
     * @param string $zsTaskNotifyId
     *
     * @return ZsQueue
     */
    public function setZsTaskNotifyId($zsTaskNotifyId)
    {
        $this->zsTaskNotifyId = $zsTaskNotifyId;

        return $this;
    }

    /**
     * Get zsTaskNotifyId
     *
     * @return string
     */
    public function getZsTaskNotifyId()
    {
        return $this->zsTaskNotifyId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return ZsQueue
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ZsQueue
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ZsQueue
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return ZsQueue
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return ZsQueue
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return ZsQueue
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return ZsQueue
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return ZsQueue
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return ZsQueue
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set zsQueueInactiveYn
     *
     * @param boolean $zsQueueInactiveYn
     *
     * @return ZsQueue
     */
    public function setZsQueueInactiveYn($zsQueueInactiveYn)
    {
        $this->zsQueueInactiveYn = $zsQueueInactiveYn;

        return $this;
    }

    /**
     * Get zsQueueInactiveYn
     *
     * @return boolean
     */
    public function getZsQueueInactiveYn()
    {
        return $this->zsQueueInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZsQueue
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zsQueueTrfYn
     *
     * @param boolean $zsQueueTrfYn
     *
     * @return ZsQueue
     */
    public function setZsQueueTrfYn($zsQueueTrfYn)
    {
        $this->zsQueueTrfYn = $zsQueueTrfYn;

        return $this;
    }

    /**
     * Get zsQueueTrfYn
     *
     * @return boolean
     */
    public function getZsQueueTrfYn()
    {
        return $this->zsQueueTrfYn;
    }
}
