<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZsSchedule
 *
 * @ORM\Table(name="zs_schedule", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zs_schedule_trf_yn", columns={"zs_schedule_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZsSchedule
{
    /**
     * @var string
     *
     * @ORM\Column(name="zs_schedule_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zsScheduleIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_schedule_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zsScheduleDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_schedule_id", type="integer", nullable=false)
     */
    private $zsScheduleId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_sched_last_execution", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsSchedLastExecution;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_sched_last_execution_tz", type="string", length=40, nullable=false)
     */
    private $zsSchedLastExecutionTz;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_sched_sch_dom", type="string", length=255, nullable=true)
     */
    private $zsSchedSchDom;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_sched_sch_dow", type="string", length=255, nullable=true)
     */
    private $zsSchedSchDow;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_sched_sch_hour", type="string", length=255, nullable=true)
     */
    private $zsSchedSchHour;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_sched_sch_minute", type="string", length=255, nullable=true)
     */
    private $zsSchedSchMinute;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_sched_sch_month", type="string", length=255, nullable=true)
     */
    private $zsSchedSchMonth;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_sched_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsSchedSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_sched_type_ind", type="boolean", nullable=true)
     */
    private $zsSchedTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_id", type="string", length=36, nullable=true)
     */
    private $zsTaskId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_schedule_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsScheduleTrfYn;



    /**
     * Get zsScheduleIx
     *
     * @return string
     */
    public function getZsScheduleIx()
    {
        return $this->zsScheduleIx;
    }

    /**
     * Set zsScheduleDb
     *
     * @param string $zsScheduleDb
     *
     * @return ZsSchedule
     */
    public function setZsScheduleDb($zsScheduleDb)
    {
        $this->zsScheduleDb = $zsScheduleDb;

        return $this;
    }

    /**
     * Get zsScheduleDb
     *
     * @return string
     */
    public function getZsScheduleDb()
    {
        return $this->zsScheduleDb;
    }

    /**
     * Set zsScheduleId
     *
     * @param integer $zsScheduleId
     *
     * @return ZsSchedule
     */
    public function setZsScheduleId($zsScheduleId)
    {
        $this->zsScheduleId = $zsScheduleId;

        return $this;
    }

    /**
     * Get zsScheduleId
     *
     * @return integer
     */
    public function getZsScheduleId()
    {
        return $this->zsScheduleId;
    }

    /**
     * Set zsSchedLastExecution
     *
     * @param \DateTime $zsSchedLastExecution
     *
     * @return ZsSchedule
     */
    public function setZsSchedLastExecution($zsSchedLastExecution)
    {
        $this->zsSchedLastExecution = $zsSchedLastExecution;

        return $this;
    }

    /**
     * Get zsSchedLastExecution
     *
     * @return \DateTime
     */
    public function getZsSchedLastExecution()
    {
        return $this->zsSchedLastExecution;
    }

    /**
     * Set zsSchedLastExecutionTz
     *
     * @param string $zsSchedLastExecutionTz
     *
     * @return ZsSchedule
     */
    public function setZsSchedLastExecutionTz($zsSchedLastExecutionTz)
    {
        $this->zsSchedLastExecutionTz = $zsSchedLastExecutionTz;

        return $this;
    }

    /**
     * Get zsSchedLastExecutionTz
     *
     * @return string
     */
    public function getZsSchedLastExecutionTz()
    {
        return $this->zsSchedLastExecutionTz;
    }

    /**
     * Set zsSchedSchDom
     *
     * @param string $zsSchedSchDom
     *
     * @return ZsSchedule
     */
    public function setZsSchedSchDom($zsSchedSchDom)
    {
        $this->zsSchedSchDom = $zsSchedSchDom;

        return $this;
    }

    /**
     * Get zsSchedSchDom
     *
     * @return string
     */
    public function getZsSchedSchDom()
    {
        return $this->zsSchedSchDom;
    }

    /**
     * Set zsSchedSchDow
     *
     * @param string $zsSchedSchDow
     *
     * @return ZsSchedule
     */
    public function setZsSchedSchDow($zsSchedSchDow)
    {
        $this->zsSchedSchDow = $zsSchedSchDow;

        return $this;
    }

    /**
     * Get zsSchedSchDow
     *
     * @return string
     */
    public function getZsSchedSchDow()
    {
        return $this->zsSchedSchDow;
    }

    /**
     * Set zsSchedSchHour
     *
     * @param string $zsSchedSchHour
     *
     * @return ZsSchedule
     */
    public function setZsSchedSchHour($zsSchedSchHour)
    {
        $this->zsSchedSchHour = $zsSchedSchHour;

        return $this;
    }

    /**
     * Get zsSchedSchHour
     *
     * @return string
     */
    public function getZsSchedSchHour()
    {
        return $this->zsSchedSchHour;
    }

    /**
     * Set zsSchedSchMinute
     *
     * @param string $zsSchedSchMinute
     *
     * @return ZsSchedule
     */
    public function setZsSchedSchMinute($zsSchedSchMinute)
    {
        $this->zsSchedSchMinute = $zsSchedSchMinute;

        return $this;
    }

    /**
     * Get zsSchedSchMinute
     *
     * @return string
     */
    public function getZsSchedSchMinute()
    {
        return $this->zsSchedSchMinute;
    }

    /**
     * Set zsSchedSchMonth
     *
     * @param string $zsSchedSchMonth
     *
     * @return ZsSchedule
     */
    public function setZsSchedSchMonth($zsSchedSchMonth)
    {
        $this->zsSchedSchMonth = $zsSchedSchMonth;

        return $this;
    }

    /**
     * Get zsSchedSchMonth
     *
     * @return string
     */
    public function getZsSchedSchMonth()
    {
        return $this->zsSchedSchMonth;
    }

    /**
     * Set zsSchedSysCode
     *
     * @param boolean $zsSchedSysCode
     *
     * @return ZsSchedule
     */
    public function setZsSchedSysCode($zsSchedSysCode)
    {
        $this->zsSchedSysCode = $zsSchedSysCode;

        return $this;
    }

    /**
     * Get zsSchedSysCode
     *
     * @return boolean
     */
    public function getZsSchedSysCode()
    {
        return $this->zsSchedSysCode;
    }

    /**
     * Set zsSchedTypeInd
     *
     * @param boolean $zsSchedTypeInd
     *
     * @return ZsSchedule
     */
    public function setZsSchedTypeInd($zsSchedTypeInd)
    {
        $this->zsSchedTypeInd = $zsSchedTypeInd;

        return $this;
    }

    /**
     * Get zsSchedTypeInd
     *
     * @return boolean
     */
    public function getZsSchedTypeInd()
    {
        return $this->zsSchedTypeInd;
    }

    /**
     * Set zsTaskId
     *
     * @param string $zsTaskId
     *
     * @return ZsSchedule
     */
    public function setZsTaskId($zsTaskId)
    {
        $this->zsTaskId = $zsTaskId;

        return $this;
    }

    /**
     * Get zsTaskId
     *
     * @return string
     */
    public function getZsTaskId()
    {
        return $this->zsTaskId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return ZsSchedule
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ZsSchedule
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ZsSchedule
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return ZsSchedule
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return ZsSchedule
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return ZsSchedule
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return ZsSchedule
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return ZsSchedule
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return ZsSchedule
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZsSchedule
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zsScheduleTrfYn
     *
     * @param boolean $zsScheduleTrfYn
     *
     * @return ZsSchedule
     */
    public function setZsScheduleTrfYn($zsScheduleTrfYn)
    {
        $this->zsScheduleTrfYn = $zsScheduleTrfYn;

        return $this;
    }

    /**
     * Get zsScheduleTrfYn
     *
     * @return boolean
     */
    public function getZsScheduleTrfYn()
    {
        return $this->zsScheduleTrfYn;
    }
}
