<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZsTask
 *
 * @ORM\Table(name="zs_task", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zs_task_trf_yn", columns={"zs_task_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZsTask
{
    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zsTaskIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zsTaskDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_task_id", type="integer", nullable=false)
     */
    private $zsTaskId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_command", type="text", length=65535, nullable=true)
     */
    private $zsTaskCommand;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_task_last_execution", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsTaskLastExecution;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_last_execution_tz", type="string", length=40, nullable=false)
     */
    private $zsTaskLastExecutionTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_recover_all_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskRecoverAllYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_task_retries", type="integer", nullable=true)
     */
    private $zsTaskRetries;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_task_retry_delay", type="integer", nullable=true)
     */
    private $zsTaskRetryDelay;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_suspend_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskSuspendYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_task_suspend_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsTaskSuspendDate;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_suspend_date_tz", type="string", length=40, nullable=false)
     */
    private $zsTaskSuspendDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_suspend_reason", type="text", length=65535, nullable=true)
     */
    private $zsTaskSuspendReason;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_target_db", type="string", length=2, nullable=true, options={"fixed"="true"})
     */
    private $zsTaskTargetDb;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_title", type="string", length=100, nullable=true)
     */
    private $zsTaskTitle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskTrfYn;



    /**
     * Get zsTaskIx
     *
     * @return string
     */
    public function getZsTaskIx()
    {
        return $this->zsTaskIx;
    }

    /**
     * Set zsTaskDb
     *
     * @param string $zsTaskDb
     *
     * @return ZsTask
     */
    public function setZsTaskDb($zsTaskDb)
    {
        $this->zsTaskDb = $zsTaskDb;

        return $this;
    }

    /**
     * Get zsTaskDb
     *
     * @return string
     */
    public function getZsTaskDb()
    {
        return $this->zsTaskDb;
    }

    /**
     * Set zsTaskId
     *
     * @param integer $zsTaskId
     *
     * @return ZsTask
     */
    public function setZsTaskId($zsTaskId)
    {
        $this->zsTaskId = $zsTaskId;

        return $this;
    }

    /**
     * Get zsTaskId
     *
     * @return integer
     */
    public function getZsTaskId()
    {
        return $this->zsTaskId;
    }

    /**
     * Set zsTaskCommand
     *
     * @param string $zsTaskCommand
     *
     * @return ZsTask
     */
    public function setZsTaskCommand($zsTaskCommand)
    {
        $this->zsTaskCommand = $zsTaskCommand;

        return $this;
    }

    /**
     * Get zsTaskCommand
     *
     * @return string
     */
    public function getZsTaskCommand()
    {
        return $this->zsTaskCommand;
    }

    /**
     * Set zsTaskLastExecution
     *
     * @param \DateTime $zsTaskLastExecution
     *
     * @return ZsTask
     */
    public function setZsTaskLastExecution($zsTaskLastExecution)
    {
        $this->zsTaskLastExecution = $zsTaskLastExecution;

        return $this;
    }

    /**
     * Get zsTaskLastExecution
     *
     * @return \DateTime
     */
    public function getZsTaskLastExecution()
    {
        return $this->zsTaskLastExecution;
    }

    /**
     * Set zsTaskLastExecutionTz
     *
     * @param string $zsTaskLastExecutionTz
     *
     * @return ZsTask
     */
    public function setZsTaskLastExecutionTz($zsTaskLastExecutionTz)
    {
        $this->zsTaskLastExecutionTz = $zsTaskLastExecutionTz;

        return $this;
    }

    /**
     * Get zsTaskLastExecutionTz
     *
     * @return string
     */
    public function getZsTaskLastExecutionTz()
    {
        return $this->zsTaskLastExecutionTz;
    }

    /**
     * Set zsTaskRecoverAllYn
     *
     * @param boolean $zsTaskRecoverAllYn
     *
     * @return ZsTask
     */
    public function setZsTaskRecoverAllYn($zsTaskRecoverAllYn)
    {
        $this->zsTaskRecoverAllYn = $zsTaskRecoverAllYn;

        return $this;
    }

    /**
     * Get zsTaskRecoverAllYn
     *
     * @return boolean
     */
    public function getZsTaskRecoverAllYn()
    {
        return $this->zsTaskRecoverAllYn;
    }

    /**
     * Set zsTaskRetries
     *
     * @param integer $zsTaskRetries
     *
     * @return ZsTask
     */
    public function setZsTaskRetries($zsTaskRetries)
    {
        $this->zsTaskRetries = $zsTaskRetries;

        return $this;
    }

    /**
     * Get zsTaskRetries
     *
     * @return integer
     */
    public function getZsTaskRetries()
    {
        return $this->zsTaskRetries;
    }

    /**
     * Set zsTaskRetryDelay
     *
     * @param integer $zsTaskRetryDelay
     *
     * @return ZsTask
     */
    public function setZsTaskRetryDelay($zsTaskRetryDelay)
    {
        $this->zsTaskRetryDelay = $zsTaskRetryDelay;

        return $this;
    }

    /**
     * Get zsTaskRetryDelay
     *
     * @return integer
     */
    public function getZsTaskRetryDelay()
    {
        return $this->zsTaskRetryDelay;
    }

    /**
     * Set zsTaskSysCode
     *
     * @param boolean $zsTaskSysCode
     *
     * @return ZsTask
     */
    public function setZsTaskSysCode($zsTaskSysCode)
    {
        $this->zsTaskSysCode = $zsTaskSysCode;

        return $this;
    }

    /**
     * Get zsTaskSysCode
     *
     * @return boolean
     */
    public function getZsTaskSysCode()
    {
        return $this->zsTaskSysCode;
    }

    /**
     * Set zsTaskSuspendYn
     *
     * @param boolean $zsTaskSuspendYn
     *
     * @return ZsTask
     */
    public function setZsTaskSuspendYn($zsTaskSuspendYn)
    {
        $this->zsTaskSuspendYn = $zsTaskSuspendYn;

        return $this;
    }

    /**
     * Get zsTaskSuspendYn
     *
     * @return boolean
     */
    public function getZsTaskSuspendYn()
    {
        return $this->zsTaskSuspendYn;
    }

    /**
     * Set zsTaskSuspendDate
     *
     * @param \DateTime $zsTaskSuspendDate
     *
     * @return ZsTask
     */
    public function setZsTaskSuspendDate($zsTaskSuspendDate)
    {
        $this->zsTaskSuspendDate = $zsTaskSuspendDate;

        return $this;
    }

    /**
     * Get zsTaskSuspendDate
     *
     * @return \DateTime
     */
    public function getZsTaskSuspendDate()
    {
        return $this->zsTaskSuspendDate;
    }

    /**
     * Set zsTaskSuspendDateTz
     *
     * @param string $zsTaskSuspendDateTz
     *
     * @return ZsTask
     */
    public function setZsTaskSuspendDateTz($zsTaskSuspendDateTz)
    {
        $this->zsTaskSuspendDateTz = $zsTaskSuspendDateTz;

        return $this;
    }

    /**
     * Get zsTaskSuspendDateTz
     *
     * @return string
     */
    public function getZsTaskSuspendDateTz()
    {
        return $this->zsTaskSuspendDateTz;
    }

    /**
     * Set zsTaskSuspendReason
     *
     * @param string $zsTaskSuspendReason
     *
     * @return ZsTask
     */
    public function setZsTaskSuspendReason($zsTaskSuspendReason)
    {
        $this->zsTaskSuspendReason = $zsTaskSuspendReason;

        return $this;
    }

    /**
     * Get zsTaskSuspendReason
     *
     * @return string
     */
    public function getZsTaskSuspendReason()
    {
        return $this->zsTaskSuspendReason;
    }

    /**
     * Set zsTaskTargetDb
     *
     * @param string $zsTaskTargetDb
     *
     * @return ZsTask
     */
    public function setZsTaskTargetDb($zsTaskTargetDb)
    {
        $this->zsTaskTargetDb = $zsTaskTargetDb;

        return $this;
    }

    /**
     * Get zsTaskTargetDb
     *
     * @return string
     */
    public function getZsTaskTargetDb()
    {
        return $this->zsTaskTargetDb;
    }

    /**
     * Set zsTaskTitle
     *
     * @param string $zsTaskTitle
     *
     * @return ZsTask
     */
    public function setZsTaskTitle($zsTaskTitle)
    {
        $this->zsTaskTitle = $zsTaskTitle;

        return $this;
    }

    /**
     * Get zsTaskTitle
     *
     * @return string
     */
    public function getZsTaskTitle()
    {
        return $this->zsTaskTitle;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return ZsTask
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ZsTask
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ZsTask
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return ZsTask
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return ZsTask
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return ZsTask
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return ZsTask
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return ZsTask
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return ZsTask
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set zsTaskInactiveYn
     *
     * @param boolean $zsTaskInactiveYn
     *
     * @return ZsTask
     */
    public function setZsTaskInactiveYn($zsTaskInactiveYn)
    {
        $this->zsTaskInactiveYn = $zsTaskInactiveYn;

        return $this;
    }

    /**
     * Get zsTaskInactiveYn
     *
     * @return boolean
     */
    public function getZsTaskInactiveYn()
    {
        return $this->zsTaskInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZsTask
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zsTaskTrfYn
     *
     * @param boolean $zsTaskTrfYn
     *
     * @return ZsTask
     */
    public function setZsTaskTrfYn($zsTaskTrfYn)
    {
        $this->zsTaskTrfYn = $zsTaskTrfYn;

        return $this;
    }

    /**
     * Get zsTaskTrfYn
     *
     * @return boolean
     */
    public function getZsTaskTrfYn()
    {
        return $this->zsTaskTrfYn;
    }
}
