<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZsTaskLog
 *
 * @ORM\Table(name="zs_task_log", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zs_task_log_trf_yn", columns={"zs_task_log_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZsTaskLog
{
    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zsTaskLogIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zsTaskLogDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_task_log_id", type="integer", nullable=false)
     */
    private $zsTaskLogId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_task_title", type="string", length=100, nullable=true)
     */
    private $zsTaskLogTaskTitle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_task_log_date_sched", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsTaskLogDateSched;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_date_sched_tz", type="string", length=40, nullable=false)
     */
    private $zsTaskLogDateSchedTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_task_log_date_start", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsTaskLogDateStart;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_date_start_tz", type="string", length=40, nullable=false)
     */
    private $zsTaskLogDateStartTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zs_task_log_date_end", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $zsTaskLogDateEnd;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_date_end_tz", type="string", length=40, nullable=false)
     */
    private $zsTaskLogDateEndTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_log_status_ind", type="boolean", nullable=true)
     */
    private $zsTaskLogStatusInd;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_log_details", type="text", length=65535, nullable=true)
     */
    private $zsTaskLogDetails;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_queue_id", type="string", length=36, nullable=true)
     */
    private $zsQueueId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_id", type="string", length=36, nullable=true)
     */
    private $zsTaskId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_log_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskLogTrfYn;



    /**
     * Get zsTaskLogIx
     *
     * @return string
     */
    public function getZsTaskLogIx()
    {
        return $this->zsTaskLogIx;
    }

    /**
     * Set zsTaskLogDb
     *
     * @param string $zsTaskLogDb
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDb($zsTaskLogDb)
    {
        $this->zsTaskLogDb = $zsTaskLogDb;

        return $this;
    }

    /**
     * Get zsTaskLogDb
     *
     * @return string
     */
    public function getZsTaskLogDb()
    {
        return $this->zsTaskLogDb;
    }

    /**
     * Set zsTaskLogId
     *
     * @param integer $zsTaskLogId
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogId($zsTaskLogId)
    {
        $this->zsTaskLogId = $zsTaskLogId;

        return $this;
    }

    /**
     * Get zsTaskLogId
     *
     * @return integer
     */
    public function getZsTaskLogId()
    {
        return $this->zsTaskLogId;
    }

    /**
     * Set zsTaskLogTaskTitle
     *
     * @param string $zsTaskLogTaskTitle
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogTaskTitle($zsTaskLogTaskTitle)
    {
        $this->zsTaskLogTaskTitle = $zsTaskLogTaskTitle;

        return $this;
    }

    /**
     * Get zsTaskLogTaskTitle
     *
     * @return string
     */
    public function getZsTaskLogTaskTitle()
    {
        return $this->zsTaskLogTaskTitle;
    }

    /**
     * Set zsTaskLogDateSched
     *
     * @param \DateTime $zsTaskLogDateSched
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDateSched($zsTaskLogDateSched)
    {
        $this->zsTaskLogDateSched = $zsTaskLogDateSched;

        return $this;
    }

    /**
     * Get zsTaskLogDateSched
     *
     * @return \DateTime
     */
    public function getZsTaskLogDateSched()
    {
        return $this->zsTaskLogDateSched;
    }

    /**
     * Set zsTaskLogDateSchedTz
     *
     * @param string $zsTaskLogDateSchedTz
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDateSchedTz($zsTaskLogDateSchedTz)
    {
        $this->zsTaskLogDateSchedTz = $zsTaskLogDateSchedTz;

        return $this;
    }

    /**
     * Get zsTaskLogDateSchedTz
     *
     * @return string
     */
    public function getZsTaskLogDateSchedTz()
    {
        return $this->zsTaskLogDateSchedTz;
    }

    /**
     * Set zsTaskLogDateStart
     *
     * @param \DateTime $zsTaskLogDateStart
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDateStart($zsTaskLogDateStart)
    {
        $this->zsTaskLogDateStart = $zsTaskLogDateStart;

        return $this;
    }

    /**
     * Get zsTaskLogDateStart
     *
     * @return \DateTime
     */
    public function getZsTaskLogDateStart()
    {
        return $this->zsTaskLogDateStart;
    }

    /**
     * Set zsTaskLogDateStartTz
     *
     * @param string $zsTaskLogDateStartTz
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDateStartTz($zsTaskLogDateStartTz)
    {
        $this->zsTaskLogDateStartTz = $zsTaskLogDateStartTz;

        return $this;
    }

    /**
     * Get zsTaskLogDateStartTz
     *
     * @return string
     */
    public function getZsTaskLogDateStartTz()
    {
        return $this->zsTaskLogDateStartTz;
    }

    /**
     * Set zsTaskLogDateEnd
     *
     * @param \DateTime $zsTaskLogDateEnd
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDateEnd($zsTaskLogDateEnd)
    {
        $this->zsTaskLogDateEnd = $zsTaskLogDateEnd;

        return $this;
    }

    /**
     * Get zsTaskLogDateEnd
     *
     * @return \DateTime
     */
    public function getZsTaskLogDateEnd()
    {
        return $this->zsTaskLogDateEnd;
    }

    /**
     * Set zsTaskLogDateEndTz
     *
     * @param string $zsTaskLogDateEndTz
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDateEndTz($zsTaskLogDateEndTz)
    {
        $this->zsTaskLogDateEndTz = $zsTaskLogDateEndTz;

        return $this;
    }

    /**
     * Get zsTaskLogDateEndTz
     *
     * @return string
     */
    public function getZsTaskLogDateEndTz()
    {
        return $this->zsTaskLogDateEndTz;
    }

    /**
     * Set zsTaskLogStatusInd
     *
     * @param boolean $zsTaskLogStatusInd
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogStatusInd($zsTaskLogStatusInd)
    {
        $this->zsTaskLogStatusInd = $zsTaskLogStatusInd;

        return $this;
    }

    /**
     * Get zsTaskLogStatusInd
     *
     * @return boolean
     */
    public function getZsTaskLogStatusInd()
    {
        return $this->zsTaskLogStatusInd;
    }

    /**
     * Set zsTaskLogDetails
     *
     * @param string $zsTaskLogDetails
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogDetails($zsTaskLogDetails)
    {
        $this->zsTaskLogDetails = $zsTaskLogDetails;

        return $this;
    }

    /**
     * Get zsTaskLogDetails
     *
     * @return string
     */
    public function getZsTaskLogDetails()
    {
        return $this->zsTaskLogDetails;
    }

    /**
     * Set zsQueueId
     *
     * @param string $zsQueueId
     *
     * @return ZsTaskLog
     */
    public function setZsQueueId($zsQueueId)
    {
        $this->zsQueueId = $zsQueueId;

        return $this;
    }

    /**
     * Get zsQueueId
     *
     * @return string
     */
    public function getZsQueueId()
    {
        return $this->zsQueueId;
    }

    /**
     * Set zsTaskId
     *
     * @param string $zsTaskId
     *
     * @return ZsTaskLog
     */
    public function setZsTaskId($zsTaskId)
    {
        $this->zsTaskId = $zsTaskId;

        return $this;
    }

    /**
     * Get zsTaskId
     *
     * @return string
     */
    public function getZsTaskId()
    {
        return $this->zsTaskId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return ZsTaskLog
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ZsTaskLog
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ZsTaskLog
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return ZsTaskLog
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return ZsTaskLog
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return ZsTaskLog
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return ZsTaskLog
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return ZsTaskLog
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return ZsTaskLog
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZsTaskLog
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zsTaskLogTrfYn
     *
     * @param boolean $zsTaskLogTrfYn
     *
     * @return ZsTaskLog
     */
    public function setZsTaskLogTrfYn($zsTaskLogTrfYn)
    {
        $this->zsTaskLogTrfYn = $zsTaskLogTrfYn;

        return $this;
    }

    /**
     * Get zsTaskLogTrfYn
     *
     * @return boolean
     */
    public function getZsTaskLogTrfYn()
    {
        return $this->zsTaskLogTrfYn;
    }
}
