<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ZsTaskNotify
 *
 * @ORM\Table(name="zs_task_notify", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="zs_task_notify_trf_yn", columns={"zs_task_notify_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class ZsTaskNotify
{
    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_notify_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $zsTaskNotifyIx;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_notify_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $zsTaskNotifyDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_task_notify_id", type="integer", nullable=false)
     */
    private $zsTaskNotifyId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_notify_cmd", type="text", length=65535, nullable=true)
     */
    private $zsTaskNotifyCmd;

    /**
     * @var integer
     *
     * @ORM\Column(name="zs_task_notify_delay", type="integer", nullable=true)
     */
    private $zsTaskNotifyDelay;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_notify_status", type="boolean", nullable=true)
     */
    private $zsTaskNotifyStatus;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_notify_method", type="boolean", nullable=true)
     */
    private $zsTaskNotifyMethod;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="zs_task_id", type="string", length=36, nullable=true)
     */
    private $zsTaskId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="zs_task_notify_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $zsTaskNotifyTrfYn;



    /**
     * Get zsTaskNotifyIx
     *
     * @return string
     */
    public function getZsTaskNotifyIx()
    {
        return $this->zsTaskNotifyIx;
    }

    /**
     * Set zsTaskNotifyDb
     *
     * @param string $zsTaskNotifyDb
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyDb($zsTaskNotifyDb)
    {
        $this->zsTaskNotifyDb = $zsTaskNotifyDb;

        return $this;
    }

    /**
     * Get zsTaskNotifyDb
     *
     * @return string
     */
    public function getZsTaskNotifyDb()
    {
        return $this->zsTaskNotifyDb;
    }

    /**
     * Set zsTaskNotifyId
     *
     * @param integer $zsTaskNotifyId
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyId($zsTaskNotifyId)
    {
        $this->zsTaskNotifyId = $zsTaskNotifyId;

        return $this;
    }

    /**
     * Get zsTaskNotifyId
     *
     * @return integer
     */
    public function getZsTaskNotifyId()
    {
        return $this->zsTaskNotifyId;
    }

    /**
     * Set zsTaskNotifyCmd
     *
     * @param string $zsTaskNotifyCmd
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyCmd($zsTaskNotifyCmd)
    {
        $this->zsTaskNotifyCmd = $zsTaskNotifyCmd;

        return $this;
    }

    /**
     * Get zsTaskNotifyCmd
     *
     * @return string
     */
    public function getZsTaskNotifyCmd()
    {
        return $this->zsTaskNotifyCmd;
    }

    /**
     * Set zsTaskNotifyDelay
     *
     * @param integer $zsTaskNotifyDelay
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyDelay($zsTaskNotifyDelay)
    {
        $this->zsTaskNotifyDelay = $zsTaskNotifyDelay;

        return $this;
    }

    /**
     * Get zsTaskNotifyDelay
     *
     * @return integer
     */
    public function getZsTaskNotifyDelay()
    {
        return $this->zsTaskNotifyDelay;
    }

    /**
     * Set zsTaskNotifyStatus
     *
     * @param boolean $zsTaskNotifyStatus
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyStatus($zsTaskNotifyStatus)
    {
        $this->zsTaskNotifyStatus = $zsTaskNotifyStatus;

        return $this;
    }

    /**
     * Get zsTaskNotifyStatus
     *
     * @return boolean
     */
    public function getZsTaskNotifyStatus()
    {
        return $this->zsTaskNotifyStatus;
    }

    /**
     * Set zsTaskNotifyMethod
     *
     * @param boolean $zsTaskNotifyMethod
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyMethod($zsTaskNotifyMethod)
    {
        $this->zsTaskNotifyMethod = $zsTaskNotifyMethod;

        return $this;
    }

    /**
     * Get zsTaskNotifyMethod
     *
     * @return boolean
     */
    public function getZsTaskNotifyMethod()
    {
        return $this->zsTaskNotifyMethod;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return ZsTaskNotify
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set zsTaskId
     *
     * @param string $zsTaskId
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskId($zsTaskId)
    {
        $this->zsTaskId = $zsTaskId;

        return $this;
    }

    /**
     * Get zsTaskId
     *
     * @return string
     */
    public function getZsTaskId()
    {
        return $this->zsTaskId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return ZsTaskNotify
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ZsTaskNotify
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ZsTaskNotify
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return ZsTaskNotify
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return ZsTaskNotify
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return ZsTaskNotify
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return ZsTaskNotify
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return ZsTaskNotify
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return ZsTaskNotify
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ZsTaskNotify
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set zsTaskNotifyTrfYn
     *
     * @param boolean $zsTaskNotifyTrfYn
     *
     * @return ZsTaskNotify
     */
    public function setZsTaskNotifyTrfYn($zsTaskNotifyTrfYn)
    {
        $this->zsTaskNotifyTrfYn = $zsTaskNotifyTrfYn;

        return $this;
    }

    /**
     * Get zsTaskNotifyTrfYn
     *
     * @return boolean
     */
    public function getZsTaskNotifyTrfYn()
    {
        return $this->zsTaskNotifyTrfYn;
    }
}
