<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20190316143948 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        $sql = "
            SET @dbName = DATABASE();
            SET @tableName = \"pr_business\";
            SET @columnName = \"fn_ledger_id_tax\";
            SET @preparedStatement = (SELECT IF(
                (
                    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
                    WHERE
                        (table_name = @tableName)
                        AND (table_schema = @dbName)
                        AND (column_name = @columnName)
                ) > 0,
                \"SELECT 1\",
                \"ALTER TABLE `pr_business` ADD `fn_ledger_id_tax` VARCHAR(36) DEFAULT NULL AFTER `fn_ledger_id_suspense_foreign`;\"
                ));
            PREPARE alterIfNotExists FROM @preparedStatement;
            EXECUTE alterIfNotExists;
            DEALLOCATE PREPARE alterIfNotExits;
        ";
        $this->addSql($sql);

        $sql = "
            INSERT IGNORE INTO `fn_option`(
                `fn_option_db`,
                `fn_option_id`,
                `fn_option_ix`,
                `fn_option_name`,
                `fn_option_desc`,
                `dt_temp_id`,
                `fn_option_trf_yn`
            ) VALUES(
                'RS',
                14,
                'RS14',
                'memo_format_pmt',
                'Select and sequence data in the tran item memo field for payments. Multiple fields separated by semicolon and space.',
                NULL,
                0
            );
        ";
        $this->addSql($sql);

        $sql = "
            INSERT IGNORE INTO `fn_option`(
                `fn_option_db`,
                `fn_option_id`,
                `fn_option_ix`,
                `fn_option_name`,
                `fn_option_desc`,
                `dt_temp_id`,
                `fn_option_trf_yn`
            ) VALUES(
                'RS',
                15,
                'RS15',
                'memo_format_inv',
                'Select and sequence data in the tran item memo field for invoices. Multiple fields separated by semicolon and space.',
                NULL,
                0
            );
        ";
        $this->addSql($sql);

        $sql = "
            SET @dbName = DATABASE();
            SET @tableName = \"fn_tran_item\";
            SET @columnName = \"fn_tran_item_note\";
            SET @preparedStatement = (SELECT IF(
                (
                    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
                    WHERE
                        (table_name = @tableName)
                        AND (table_schema = @dbName)
                        AND (column_name = @columnName)
                ) > 0,
                \"SELECT 1\",
                \"ALTER TABLE `fn_tran_item` ADD `fn_tran_item_note` mediumtext AFTER `fn_tran_item_type_ind`;\"
                ));
            PREPARE alterIfNotExists FROM @preparedStatement;
            EXECUTE alterIfNotExists;
            DEALLOCATE PREPARE alterIfNotExits;
        ";
        $this->addSql($sql);

        $sql = "
            SET @dbName = DATABASE();
            SET @tableName = \"fn_system\";
            SET @columnName = \"fn_sys_journal_yn\";
            SET @preparedStatement = (SELECT IF(
                (
                    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
                    WHERE
                        (table_name = @tableName)
                        AND (table_schema = @dbName)
                        AND (column_name = @columnName)
                ) > 0,
                \"SELECT 1\",
                \"ALTER TABLE `fn_system` ADD `fn_sys_journal_yn` TINYINT(1) NOT NULL DEFAULT 0 AFTER `fn_sys_tran_summary_yn`;\"
                ));
            PREPARE alterIfNotExists FROM @preparedStatement;
            EXECUTE alterIfNotExists;
            DEALLOCATE PREPARE alterIfNotExits;
        ";
        $this->addSql($sql);

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");
        $sql = "
            DELETE FROM `fn_option` WHERE `fn_option_ix` = 'RS14';
        ";
        $this->addSql($sql);
        $sql = "
            DELETE FROM `fn_option` WHERE `fn_option_ix` = 'RS15';
        ";
        $this->addSql($sql);
        $sql = "
            ALTER TABLE `fn_tran_item` DROP `fn_tran_item_note;
        ";
        $this->addSql($sql);
        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }
}
