<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20190628100921 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("                DROP TRIGGER IF EXISTS tr_ac_accomm_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_accomm_type_ins_be
                BEFORE INSERT ON ac_accomm_type FOR EACH ROW
                tr_ac_accomm_type_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_accomm_type_ix IS NULL or NEW.ac_accomm_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_accomm_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_accomm_type_ix = ix;
                            SET NEW.ac_accomm_type_id = 0;
                            SET NEW.ac_accomm_type_db = @db_code;

                            IF NEW.ac_accomm_type_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_accomm_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_accomm_type_ins_af
                        AFTER INSERT ON ac_accomm_type FOR EACH ROW
                        tr_ac_accomm_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_accomm_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_accomm_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_type_upd_be
                    BEFORE UPDATE ON ac_accomm_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_accomm_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_accomm_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_accomm_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_accomm_type_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_type_del_be
                    BEFORE DELETE ON ac_accomm_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_type\" INTO @tc_table_id;
                            SELECT ac_accomm_type_trf_yn FROM ac_accomm_type WHERE ac_accomm_type_ix = OLD.ac_accomm_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_accomm_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ad_user_log_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ad_user_log_ins_be
                BEFORE INSERT ON ad_user_log FOR EACH ROW
                tr_ad_user_log_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ad_user_log_ix IS NULL or NEW.ad_user_log_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ad_user_log_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ad_user_log_ix = ix;
                            SET NEW.ad_user_log_id = 0;
                            SET NEW.ad_user_log_db = @db_code;

                            IF NEW.ad_user_log_trf_yn IS NULL THEN
                                SET NEW.ad_user_log_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ad_user_log_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ad_user_log_ins_af
                        AFTER INSERT ON ad_user_log FOR EACH ROW
                        tr_ad_user_log_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_user_log\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ad_user_log_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ad_user_log_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_user_log_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_user_log_upd_be
                    BEFORE UPDATE ON ad_user_log FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_user_log\" INTO @tc_table_id;
                        SET row_transferred = OLD.ad_user_log_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ad_user_log_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ad_user_log_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ad_user_log_trf_yn IS NULL THEN
                                SET NEW.ad_user_log_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_user_log_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_user_log_del_be
                    BEFORE DELETE ON ad_user_log FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_user_log\" INTO @tc_table_id;
                            SELECT ad_user_log_trf_yn FROM ad_user_log WHERE ad_user_log_ix = OLD.ad_user_log_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ad_user_log_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_agent_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_agent_ins_be
                BEFORE INSERT ON pr_agent FOR EACH ROW
                tr_pr_agent_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.pr_agent_id IS NOT NULL THEN
                                LEAVE tr_pr_agent_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_agent_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_agent_ins_af
                        AFTER INSERT ON pr_agent FOR EACH ROW
                        tr_pr_agent_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_agent\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_agent_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_agent_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_agent_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_agent_upd_be
                    BEFORE UPDATE ON pr_agent FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_agent\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_agent_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_agent_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.pr_agent_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.pr_agent_trf_yn IS NULL THEN
                                    SET NEW.pr_agent_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_agent_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_agent_del_be
                    BEFORE DELETE ON pr_agent FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_agent\" INTO @tc_table_id;
                            SELECT pr_agent_trf_yn FROM pr_agent WHERE pr_agent_id = OLD.pr_agent_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_agent_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_business_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_business_ins_be
                BEFORE INSERT ON pr_business FOR EACH ROW
                tr_pr_business_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.pr_business_id IS NOT NULL THEN
                                LEAVE tr_pr_business_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_business_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_business_ins_af
                        AFTER INSERT ON pr_business FOR EACH ROW
                        tr_pr_business_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_business\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_business_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_business_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_business_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_business_upd_be
                    BEFORE UPDATE ON pr_business FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_business\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_business_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_business_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.pr_business_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.pr_business_trf_yn IS NULL THEN
                                    SET NEW.pr_business_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_business_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_business_del_be
                    BEFORE DELETE ON pr_business FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_business\" INTO @tc_table_id;
                            SELECT pr_business_trf_yn FROM pr_business WHERE pr_business_id = OLD.pr_business_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_business_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_persona_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_persona_ins_be
                BEFORE INSERT ON pr_persona FOR EACH ROW
                tr_pr_persona_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_persona_ix IS NULL or NEW.pr_persona_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_persona_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"pr_persona\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(pr_persona.pr_persona_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    pr_persona
                                WHERE
                                    pr_persona.pr_persona_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"pr_persona\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"pr_persona\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                pr_persona
                            WHERE
                                pr_persona.pr_persona_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(pr_persona.pr_persona_id) -- Get the highest ID in table
                            FROM
                                pr_persona
                            WHERE
                                pr_persona_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN pr_persona ON pr_persona.pr_persona_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"pr_persona\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN pr_persona ON pr_persona.pr_persona_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"pr_persona\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.pr_persona_db = @db_code;
                            SET NEW.pr_persona_id = id;
                            SET NEW.pr_persona_ix = ix;

                            IF NEW.pr_persona_trf_yn IS NULL THEN
                                SET NEW.pr_persona_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN pr_persona ON pr_persona.pr_persona_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"pr_persona\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_persona_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_persona_ins_af
                        AFTER INSERT ON pr_persona FOR EACH ROW
                        tr_pr_persona_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_persona\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_persona_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_persona_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_persona_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_persona_upd_be
                    BEFORE UPDATE ON pr_persona FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_persona\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_persona_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_persona_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_persona_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_persona_trf_yn IS NULL THEN
                                SET NEW.pr_persona_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_persona_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_persona_del_be
                    BEFORE DELETE ON pr_persona FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_persona\" INTO @tc_table_id;
                            SELECT pr_persona_trf_yn FROM pr_persona WHERE pr_persona_ix = OLD.pr_persona_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_persona_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_phone_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_phone_ins_be
                BEFORE INSERT ON pr_phone FOR EACH ROW
                tr_pr_phone_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_phone_ix IS NULL or NEW.pr_phone_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_phone_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"pr_phone\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(pr_phone.pr_phone_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    pr_phone
                                WHERE
                                    pr_phone.pr_phone_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"pr_phone\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"pr_phone\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                pr_phone
                            WHERE
                                pr_phone.pr_phone_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(pr_phone.pr_phone_id) -- Get the highest ID in table
                            FROM
                                pr_phone
                            WHERE
                                pr_phone_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN pr_phone ON pr_phone.pr_phone_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"pr_phone\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN pr_phone ON pr_phone.pr_phone_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"pr_phone\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.pr_phone_db = @db_code;
                            SET NEW.pr_phone_id = id;
                            SET NEW.pr_phone_ix = ix;

                            IF NEW.pr_phone_trf_yn IS NULL THEN
                                SET NEW.pr_phone_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN pr_phone ON pr_phone.pr_phone_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"pr_phone\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_phone_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_phone_ins_af
                        AFTER INSERT ON pr_phone FOR EACH ROW
                        tr_pr_phone_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_phone\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_phone_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_phone_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_phone_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_phone_upd_be
                    BEFORE UPDATE ON pr_phone FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_phone\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_phone_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_phone_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_phone_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_phone_trf_yn IS NULL THEN
                                SET NEW.pr_phone_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_phone_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_phone_del_be
                    BEFORE DELETE ON pr_phone FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_phone\" INTO @tc_table_id;
                            SELECT pr_phone_trf_yn FROM pr_phone WHERE pr_phone_ix = OLD.pr_phone_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_phone_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_user_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_user_ins_be
                BEFORE INSERT ON pr_user FOR EACH ROW
                tr_pr_user_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.pr_user_id IS NOT NULL THEN
                                LEAVE tr_pr_user_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_user_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_user_ins_af
                        AFTER INSERT ON pr_user FOR EACH ROW
                        tr_pr_user_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_user\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_user_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_user_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_user_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_user_upd_be
                    BEFORE UPDATE ON pr_user FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_user\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_user_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_user_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.pr_user_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.pr_user_trf_yn IS NULL THEN
                                    SET NEW.pr_user_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_user_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_user_del_be
                    BEFORE DELETE ON pr_user FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_user\" INTO @tc_table_id;
                            SELECT pr_user_trf_yn FROM pr_user WHERE pr_user_id = OLD.pr_user_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_user_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_comms_preference_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_comms_preference_ins_be
                BEFORE INSERT ON rf_comms_preference FOR EACH ROW
                tr_rf_comms_preference_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_comms_preference_ix IS NULL or NEW.rf_comms_preference_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_comms_preference_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_comms_preference_ix = ix;
                            SET NEW.rf_comms_preference_id = 0;
                            SET NEW.rf_comms_preference_db = @db_code;

                            IF NEW.rf_comms_preference_trf_yn IS NULL THEN
                                SET NEW.rf_comms_preference_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_comms_preference_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_comms_preference_ins_af
                        AFTER INSERT ON rf_comms_preference FOR EACH ROW
                        tr_rf_comms_preference_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_comms_preference\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_comms_preference_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_comms_preference_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_comms_preference_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_comms_preference_upd_be
                    BEFORE UPDATE ON rf_comms_preference FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_comms_preference\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_comms_preference_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_comms_preference_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_comms_preference_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_comms_preference_trf_yn IS NULL THEN
                                SET NEW.rf_comms_preference_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_comms_preference_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_comms_preference_del_be
                    BEFORE DELETE ON rf_comms_preference FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_comms_preference\" INTO @tc_table_id;
                            SELECT rf_comms_preference_trf_yn FROM rf_comms_preference WHERE rf_comms_preference_ix = OLD.rf_comms_preference_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_comms_preference_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_country_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_country_ins_be
                BEFORE INSERT ON rf_country FOR EACH ROW
                tr_rf_country_ins_be: BEGIN
                    -- Indicator: 2
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_country_ix IS NULL or NEW.rf_country_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_country_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_country_ix = ix;
                            SET NEW.rf_country_id = 0;
                            SET NEW.rf_country_db = @db_code;

                            IF NEW.rf_country_trf_yn IS NULL THEN
                                SET NEW.rf_country_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_country_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_country_ins_af
                        AFTER INSERT ON rf_country FOR EACH ROW
                        tr_rf_country_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_country\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_country_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_country_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_country_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_country_upd_be
                    BEFORE UPDATE ON rf_country FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_country\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_country_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_country_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_country_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_country_trf_yn IS NULL THEN
                                SET NEW.rf_country_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_country_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_country_del_be
                    BEFORE DELETE ON rf_country FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_country\" INTO @tc_table_id;
                            SELECT rf_country_trf_yn FROM rf_country WHERE rf_country_ix = OLD.rf_country_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_country_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_currency_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_currency_ins_be
                BEFORE INSERT ON rf_currency FOR EACH ROW
                tr_rf_currency_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_currency_ix IS NULL or NEW.rf_currency_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_currency_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_currency_ix = ix;
                            SET NEW.rf_currency_id = 0;
                            SET NEW.rf_currency_db = @db_code;

                            IF NEW.rf_currency_trf_yn IS NULL THEN
                                SET NEW.rf_currency_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_currency_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_currency_ins_af
                        AFTER INSERT ON rf_currency FOR EACH ROW
                        tr_rf_currency_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_currency\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_currency_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_currency_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_currency_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_currency_upd_be
                    BEFORE UPDATE ON rf_currency FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_currency\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_currency_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_currency_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_currency_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_currency_trf_yn IS NULL THEN
                                SET NEW.rf_currency_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_currency_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_currency_del_be
                    BEFORE DELETE ON rf_currency FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_currency\" INTO @tc_table_id;
                            SELECT rf_currency_trf_yn FROM rf_currency WHERE rf_currency_ix = OLD.rf_currency_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_currency_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_name_suffix_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_name_suffix_ins_be
                BEFORE INSERT ON rf_name_suffix FOR EACH ROW
                tr_rf_name_suffix_ins_be: BEGIN
                    -- Indicator: 2
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_name_suffix_ix IS NULL or NEW.rf_name_suffix_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_name_suffix_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_name_suffix_ix = ix;
                            SET NEW.rf_name_suffix_id = 0;
                            SET NEW.rf_name_suffix_db = @db_code;

                            IF NEW.rf_name_suffix_trf_yn IS NULL THEN
                                SET NEW.rf_name_suffix_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_name_suffix_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_name_suffix_ins_af
                        AFTER INSERT ON rf_name_suffix FOR EACH ROW
                        tr_rf_name_suffix_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_name_suffix\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_name_suffix_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_name_suffix_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_name_suffix_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_name_suffix_upd_be
                    BEFORE UPDATE ON rf_name_suffix FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_name_suffix\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_name_suffix_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_name_suffix_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_name_suffix_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_name_suffix_trf_yn IS NULL THEN
                                SET NEW.rf_name_suffix_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_name_suffix_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_name_suffix_del_be
                    BEFORE DELETE ON rf_name_suffix FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_name_suffix\" INTO @tc_table_id;
                            SELECT rf_name_suffix_trf_yn FROM rf_name_suffix WHERE rf_name_suffix_ix = OLD.rf_name_suffix_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_name_suffix_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_phone_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_phone_type_ins_be
                BEFORE INSERT ON rf_phone_type FOR EACH ROW
                tr_rf_phone_type_ins_be: BEGIN
                    -- Indicator: 2
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_phone_type_ix IS NULL or NEW.rf_phone_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_phone_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_phone_type_ix = ix;
                            SET NEW.rf_phone_type_id = 0;
                            SET NEW.rf_phone_type_db = @db_code;

                            IF NEW.rf_phone_type_trf_yn IS NULL THEN
                                SET NEW.rf_phone_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_phone_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_phone_type_ins_af
                        AFTER INSERT ON rf_phone_type FOR EACH ROW
                        tr_rf_phone_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_phone_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_phone_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_phone_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_phone_type_upd_be
                    BEFORE UPDATE ON rf_phone_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_phone_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_phone_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_phone_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_phone_type_trf_yn IS NULL THEN
                                SET NEW.rf_phone_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_phone_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_phone_type_del_be
                    BEFORE DELETE ON rf_phone_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_type\" INTO @tc_table_id;
                            SELECT rf_phone_type_trf_yn FROM rf_phone_type WHERE rf_phone_type_ix = OLD.rf_phone_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_phone_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_title_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_title_ins_be
                BEFORE INSERT ON rf_title FOR EACH ROW
                tr_rf_title_ins_be: BEGIN
                    -- Indicator: 2
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_title_ix IS NULL or NEW.rf_title_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_title_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_title_ix = ix;
                            SET NEW.rf_title_id = 0;
                            SET NEW.rf_title_db = @db_code;

                            IF NEW.rf_title_trf_yn IS NULL THEN
                                SET NEW.rf_title_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_title_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_title_ins_af
                        AFTER INSERT ON rf_title FOR EACH ROW
                        tr_rf_title_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_title\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_title_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_title_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_title_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_title_upd_be
                    BEFORE UPDATE ON rf_title FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_title\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_title_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_title_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_title_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_title_trf_yn IS NULL THEN
                                SET NEW.rf_title_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_title_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_title_del_be
                    BEFORE DELETE ON rf_title FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_title\" INTO @tc_table_id;
                            SELECT rf_title_trf_yn FROM rf_title WHERE rf_title_ix = OLD.rf_title_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_title_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_default_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_default_ins_be
                BEFORE INSERT ON rf_default FOR EACH ROW
                tr_rf_default_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.rf_default_id IS NOT NULL THEN
                                LEAVE tr_rf_default_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_default_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_default_ins_af
                        AFTER INSERT ON rf_default FOR EACH ROW
                        tr_rf_default_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_default\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_default_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_default_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_default_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_default_upd_be
                    BEFORE UPDATE ON rf_default FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_default\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_default_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_default_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.rf_default_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.rf_default_trf_yn IS NULL THEN
                                    SET NEW.rf_default_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_default_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_default_del_be
                    BEFORE DELETE ON rf_default FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_default\" INTO @tc_table_id;
                            SELECT rf_default_trf_yn FROM rf_default WHERE rf_default_id = OLD.rf_default_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_default_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_reservation_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_reservation_ins_be
                BEFORE INSERT ON rv_reservation FOR EACH ROW
                tr_rv_reservation_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_reservation_ix IS NULL or NEW.rv_reservation_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_reservation_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_reservation\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(rv_reservation.rv_reservation_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    rv_reservation
                                WHERE
                                    rv_reservation.rv_reservation_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"rv_reservation\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_reservation\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                rv_reservation
                            WHERE
                                rv_reservation.rv_reservation_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(rv_reservation.rv_reservation_id) -- Get the highest ID in table
                            FROM
                                rv_reservation
                            WHERE
                                rv_reservation_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_reservation ON rv_reservation.rv_reservation_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_reservation\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_reservation ON rv_reservation.rv_reservation_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_reservation\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.rv_reservation_db = @db_code;
                            SET NEW.rv_reservation_id = id;
                            SET NEW.rv_reservation_ix = ix;

                            IF NEW.rv_reservation_trf_yn IS NULL THEN
                                SET NEW.rv_reservation_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN rv_reservation ON rv_reservation.rv_reservation_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"rv_reservation\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_reservation_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_reservation_ins_af
                        AFTER INSERT ON rv_reservation FOR EACH ROW
                        tr_rv_reservation_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_reservation_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_reservation_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_reservation_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_reservation_upd_be
                    BEFORE UPDATE ON rv_reservation FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_reservation_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_reservation_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_reservation_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_reservation_trf_yn IS NULL THEN
                                SET NEW.rv_reservation_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_reservation_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_reservation_del_be
                    BEFORE DELETE ON rv_reservation FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation\" INTO @tc_table_id;
                            SELECT rv_reservation_trf_yn FROM rv_reservation WHERE rv_reservation_ix = OLD.rv_reservation_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_reservation_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_reservation_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_reservation_item_ins_be
                BEFORE INSERT ON rv_reservation_item FOR EACH ROW
                tr_rv_reservation_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_reservation_item_ix IS NULL or NEW.rv_reservation_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_reservation_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_reservation_item_ix = ix;
                            SET NEW.rv_reservation_item_id = 0;
                            SET NEW.rv_reservation_item_db = @db_code;

                            IF NEW.rv_reservation_item_trf_yn IS NULL THEN
                                SET NEW.rv_reservation_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_reservation_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_reservation_item_ins_af
                        AFTER INSERT ON rv_reservation_item FOR EACH ROW
                        tr_rv_reservation_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_reservation_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_reservation_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_reservation_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_reservation_item_upd_be
                    BEFORE UPDATE ON rv_reservation_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_reservation_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_reservation_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_reservation_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_reservation_item_trf_yn IS NULL THEN
                                SET NEW.rv_reservation_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_reservation_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_reservation_item_del_be
                    BEFORE DELETE ON rv_reservation_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation_item\" INTO @tc_table_id;
                            SELECT rv_reservation_item_trf_yn FROM rv_reservation_item WHERE rv_reservation_item_ix = OLD.rv_reservation_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_reservation_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_tc_table_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_tc_table_ins_be
                BEFORE INSERT ON tc_table FOR EACH ROW
                tr_tc_table_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.tc_table_id IS NOT NULL THEN
                                LEAVE tr_tc_table_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_tc_table_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_tc_table_ins_af
                        AFTER INSERT ON tc_table FOR EACH ROW
                        tr_tc_table_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_table\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.tc_table_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_tc_table_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tc_table_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tc_table_upd_be
                    BEFORE UPDATE ON tc_table FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_table\" INTO @tc_table_id;
                        SET row_transferred = OLD.tc_table_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.tc_table_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.tc_table_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.tc_table_trf_yn IS NULL THEN
                                    SET NEW.tc_table_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tc_table_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tc_table_del_be
                    BEFORE DELETE ON tc_table FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_table\" INTO @tc_table_id;
                            SELECT tc_table_trf_yn FROM tc_table WHERE tc_table_id = OLD.tc_table_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.tc_table_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sc_accomm_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sc_accomm_ins_be
                BEFORE INSERT ON sc_accomm FOR EACH ROW
                tr_sc_accomm_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.sc_accomm_id IS NOT NULL THEN
                                LEAVE tr_sc_accomm_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sc_accomm_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sc_accomm_ins_af
                        AFTER INSERT ON sc_accomm FOR EACH ROW
                        tr_sc_accomm_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_accomm\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sc_accomm_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sc_accomm_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_accomm_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_accomm_upd_be
                    BEFORE UPDATE ON sc_accomm FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_accomm\" INTO @tc_table_id;
                        SET row_transferred = OLD.sc_accomm_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sc_accomm_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.sc_accomm_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.sc_accomm_trf_yn IS NULL THEN
                                    SET NEW.sc_accomm_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_accomm_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_accomm_del_be
                    BEFORE DELETE ON sc_accomm FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_accomm\" INTO @tc_table_id;
                            SELECT sc_accomm_trf_yn FROM sc_accomm WHERE sc_accomm_id = OLD.sc_accomm_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sc_accomm_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sc_fun_group_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sc_fun_group_ins_be
                BEFORE INSERT ON sc_fun_group FOR EACH ROW
                tr_sc_fun_group_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.sc_fun_group_id IS NOT NULL THEN
                                LEAVE tr_sc_fun_group_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sc_fun_group_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sc_fun_group_ins_af
                        AFTER INSERT ON sc_fun_group FOR EACH ROW
                        tr_sc_fun_group_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_fun_group\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sc_fun_group_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sc_fun_group_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_fun_group_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_fun_group_upd_be
                    BEFORE UPDATE ON sc_fun_group FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_fun_group\" INTO @tc_table_id;
                        SET row_transferred = OLD.sc_fun_group_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sc_fun_group_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.sc_fun_group_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.sc_fun_group_trf_yn IS NULL THEN
                                    SET NEW.sc_fun_group_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_fun_group_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_fun_group_del_be
                    BEFORE DELETE ON sc_fun_group FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_fun_group\" INTO @tc_table_id;
                            SELECT sc_fun_group_trf_yn FROM sc_fun_group WHERE sc_fun_group_id = OLD.sc_fun_group_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sc_fun_group_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sc_group_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sc_group_ins_be
                BEFORE INSERT ON sc_group FOR EACH ROW
                tr_sc_group_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.sc_group_id IS NOT NULL THEN
                                LEAVE tr_sc_group_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sc_group_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sc_group_ins_af
                        AFTER INSERT ON sc_group FOR EACH ROW
                        tr_sc_group_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_group\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sc_group_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sc_group_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_group_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_group_upd_be
                    BEFORE UPDATE ON sc_group FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_group\" INTO @tc_table_id;
                        SET row_transferred = OLD.sc_group_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sc_group_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.sc_group_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.sc_group_trf_yn IS NULL THEN
                                    SET NEW.sc_group_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_group_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_group_del_be
                    BEFORE DELETE ON sc_group FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_group\" INTO @tc_table_id;
                            SELECT sc_group_trf_yn FROM sc_group WHERE sc_group_id = OLD.sc_group_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sc_group_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sc_user_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sc_user_ins_be
                BEFORE INSERT ON sc_user FOR EACH ROW
                tr_sc_user_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.sc_user_id IS NOT NULL THEN
                                LEAVE tr_sc_user_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sc_user_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sc_user_ins_af
                        AFTER INSERT ON sc_user FOR EACH ROW
                        tr_sc_user_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_user\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sc_user_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sc_user_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_user_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_user_upd_be
                    BEFORE UPDATE ON sc_user FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_user\" INTO @tc_table_id;
                        SET row_transferred = OLD.sc_user_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sc_user_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.sc_user_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.sc_user_trf_yn IS NULL THEN
                                    SET NEW.sc_user_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sc_user_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sc_user_del_be
                    BEFORE DELETE ON sc_user FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sc_user\" INTO @tc_table_id;
                            SELECT sc_user_trf_yn FROM sc_user WHERE sc_user_id = OLD.sc_user_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sc_user_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_em_mail_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_em_mail_ins_be
                BEFORE INSERT ON em_mail FOR EACH ROW
                tr_em_mail_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.em_mail_ix IS NULL or NEW.em_mail_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_em_mail_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.em_mail_ix = ix;
                            SET NEW.em_mail_id = 0;
                            SET NEW.em_mail_db = @db_code;

                            IF NEW.em_mail_trf_yn IS NULL THEN
                                SET NEW.em_mail_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_em_mail_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_em_mail_ins_af
                        AFTER INSERT ON em_mail FOR EACH ROW
                        tr_em_mail_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"em_mail\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.em_mail_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_em_mail_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_em_mail_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_em_mail_upd_be
                    BEFORE UPDATE ON em_mail FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"em_mail\" INTO @tc_table_id;
                        SET row_transferred = OLD.em_mail_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.em_mail_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.em_mail_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.em_mail_trf_yn IS NULL THEN
                                SET NEW.em_mail_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_em_mail_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_em_mail_del_be
                    BEFORE DELETE ON em_mail FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"em_mail\" INTO @tc_table_id;
                            SELECT em_mail_trf_yn FROM em_mail WHERE em_mail_ix = OLD.em_mail_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.em_mail_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_link_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_link_ins_be
                BEFORE INSERT ON pr_link FOR EACH ROW
                tr_pr_link_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_link_ix IS NULL or NEW.pr_link_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_link_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_link_ix = ix;
                            SET NEW.pr_link_id = 0;
                            SET NEW.pr_link_db = @db_code;

                            IF NEW.pr_link_trf_yn IS NULL THEN
                                SET NEW.pr_link_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_link_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_link_ins_af
                        AFTER INSERT ON pr_link FOR EACH ROW
                        tr_pr_link_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_link\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_link_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_link_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_link_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_link_upd_be
                    BEFORE UPDATE ON pr_link FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_link\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_link_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_link_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_link_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_link_trf_yn IS NULL THEN
                                SET NEW.pr_link_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_link_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_link_del_be
                    BEFORE DELETE ON pr_link FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_link\" INTO @tc_table_id;
                            SELECT pr_link_trf_yn FROM pr_link WHERE pr_link_ix = OLD.pr_link_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_link_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_reservation_status_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_reservation_status_ins_be
                BEFORE INSERT ON rf_reservation_status FOR EACH ROW
                tr_rf_reservation_status_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.rf_reservation_status_id IS NOT NULL THEN
                                LEAVE tr_rf_reservation_status_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_reservation_status_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_reservation_status_ins_af
                        AFTER INSERT ON rf_reservation_status FOR EACH ROW
                        tr_rf_reservation_status_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_reservation_status\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_reservation_status_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_reservation_status_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_reservation_status_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_reservation_status_upd_be
                    BEFORE UPDATE ON rf_reservation_status FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_reservation_status\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_reservation_status_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_reservation_status_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.rf_reservation_status_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.rf_reservation_status_trf_yn IS NULL THEN
                                    SET NEW.rf_reservation_status_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_reservation_status_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_reservation_status_del_be
                    BEFORE DELETE ON rf_reservation_status FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_reservation_status\" INTO @tc_table_id;
                            SELECT rf_reservation_status_trf_yn FROM rf_reservation_status WHERE rf_reservation_status_id = OLD.rf_reservation_status_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_reservation_status_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_extra_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_extra_ins_be
                BEFORE INSERT ON ac_extra FOR EACH ROW
                tr_ac_extra_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_extra_ix IS NULL or NEW.ac_extra_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_extra_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_extra_ix = ix;
                            SET NEW.ac_extra_id = 0;
                            SET NEW.ac_extra_db = @db_code;

                            IF NEW.ac_extra_trf_yn IS NULL THEN
                                SET NEW.ac_extra_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_extra_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_extra_ins_af
                        AFTER INSERT ON ac_extra FOR EACH ROW
                        tr_ac_extra_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_extra_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_extra_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_upd_be
                    BEFORE UPDATE ON ac_extra FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_extra_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_extra_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_extra_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_extra_trf_yn IS NULL THEN
                                SET NEW.ac_extra_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_del_be
                    BEFORE DELETE ON ac_extra FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra\" INTO @tc_table_id;
                            SELECT ac_extra_trf_yn FROM ac_extra WHERE ac_extra_ix = OLD.ac_extra_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_extra_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_pay_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_pay_item_ins_be
                BEFORE INSERT ON ac_pay_item FOR EACH ROW
                tr_ac_pay_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_pay_item_ix IS NULL or NEW.ac_pay_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_pay_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_pay_item_ix = ix;
                            SET NEW.ac_pay_item_id = 0;
                            SET NEW.ac_pay_item_db = @db_code;

                            IF NEW.ac_pay_item_trf_yn IS NULL THEN
                                SET NEW.ac_pay_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_pay_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_pay_item_ins_af
                        AFTER INSERT ON ac_pay_item FOR EACH ROW
                        tr_ac_pay_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pay_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_pay_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_pay_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pay_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pay_item_upd_be
                    BEFORE UPDATE ON ac_pay_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pay_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_pay_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_pay_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_pay_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_pay_item_trf_yn IS NULL THEN
                                SET NEW.ac_pay_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pay_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pay_item_del_be
                    BEFORE DELETE ON ac_pay_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pay_item\" INTO @tc_table_id;
                            SELECT ac_pay_item_trf_yn FROM ac_pay_item WHERE ac_pay_item_ix = OLD.ac_pay_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_pay_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_pay_plan_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_pay_plan_ins_be
                BEFORE INSERT ON ac_pay_plan FOR EACH ROW
                tr_ac_pay_plan_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_pay_plan_ix IS NULL or NEW.ac_pay_plan_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_pay_plan_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_pay_plan_ix = ix;
                            SET NEW.ac_pay_plan_id = 0;
                            SET NEW.ac_pay_plan_db = @db_code;

                            IF NEW.ac_pay_plan_trf_yn IS NULL THEN
                                SET NEW.ac_pay_plan_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_pay_plan_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_pay_plan_ins_af
                        AFTER INSERT ON ac_pay_plan FOR EACH ROW
                        tr_ac_pay_plan_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pay_plan\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_pay_plan_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_pay_plan_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pay_plan_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pay_plan_upd_be
                    BEFORE UPDATE ON ac_pay_plan FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pay_plan\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_pay_plan_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_pay_plan_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_pay_plan_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_pay_plan_trf_yn IS NULL THEN
                                SET NEW.ac_pay_plan_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pay_plan_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pay_plan_del_be
                    BEFORE DELETE ON ac_pay_plan FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pay_plan\" INTO @tc_table_id;
                            SELECT ac_pay_plan_trf_yn FROM ac_pay_plan WHERE ac_pay_plan_ix = OLD.ac_pay_plan_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_pay_plan_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_agent_rate_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_agent_rate_ins_be
                BEFORE INSERT ON pr_agent_rate FOR EACH ROW
                tr_pr_agent_rate_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_agent_rate_ix IS NULL or NEW.pr_agent_rate_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_agent_rate_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_agent_rate_ix = ix;
                            SET NEW.pr_agent_rate_id = 0;
                            SET NEW.pr_agent_rate_db = @db_code;

                            IF NEW.pr_agent_rate_trf_yn IS NULL THEN
                                SET NEW.pr_agent_rate_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_agent_rate_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_agent_rate_ins_af
                        AFTER INSERT ON pr_agent_rate FOR EACH ROW
                        tr_pr_agent_rate_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_agent_rate\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_agent_rate_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_agent_rate_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_agent_rate_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_agent_rate_upd_be
                    BEFORE UPDATE ON pr_agent_rate FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_agent_rate\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_agent_rate_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_agent_rate_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_agent_rate_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_agent_rate_trf_yn IS NULL THEN
                                SET NEW.pr_agent_rate_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_agent_rate_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_agent_rate_del_be
                    BEFORE DELETE ON pr_agent_rate FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_agent_rate\" INTO @tc_table_id;
                            SELECT pr_agent_rate_trf_yn FROM pr_agent_rate WHERE pr_agent_rate_ix = OLD.pr_agent_rate_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_agent_rate_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_bus_bank_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_bus_bank_ins_be
                BEFORE INSERT ON pr_bus_bank FOR EACH ROW
                tr_pr_bus_bank_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_bus_bank_ix IS NULL or NEW.pr_bus_bank_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_bus_bank_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_bus_bank_ix = ix;
                            SET NEW.pr_bus_bank_id = 0;
                            SET NEW.pr_bus_bank_db = @db_code;

                            IF NEW.pr_bus_bank_trf_yn IS NULL THEN
                                SET NEW.pr_bus_bank_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_bus_bank_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_bus_bank_ins_af
                        AFTER INSERT ON pr_bus_bank FOR EACH ROW
                        tr_pr_bus_bank_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_bus_bank\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_bus_bank_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_bus_bank_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_bus_bank_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_bus_bank_upd_be
                    BEFORE UPDATE ON pr_bus_bank FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_bus_bank\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_bus_bank_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_bus_bank_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_bus_bank_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_bus_bank_trf_yn IS NULL THEN
                                SET NEW.pr_bus_bank_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_bus_bank_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_bus_bank_del_be
                    BEFORE DELETE ON pr_bus_bank FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_bus_bank\" INTO @tc_table_id;
                            SELECT pr_bus_bank_trf_yn FROM pr_bus_bank WHERE pr_bus_bank_ix = OLD.pr_bus_bank_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_bus_bank_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_bank_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_bank_ins_be
                BEFORE INSERT ON rf_bank FOR EACH ROW
                tr_rf_bank_ins_be: BEGIN
                    -- Indicator: 2
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_bank_ix IS NULL or NEW.rf_bank_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_bank_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_bank_ix = ix;
                            SET NEW.rf_bank_id = 0;
                            SET NEW.rf_bank_db = @db_code;

                            IF NEW.rf_bank_trf_yn IS NULL THEN
                                SET NEW.rf_bank_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_bank_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_bank_ins_af
                        AFTER INSERT ON rf_bank FOR EACH ROW
                        tr_rf_bank_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_bank_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_bank_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_bank_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_bank_upd_be
                    BEFORE UPDATE ON rf_bank FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_bank_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_bank_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_bank_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_bank_trf_yn IS NULL THEN
                                SET NEW.rf_bank_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_bank_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_bank_del_be
                    BEFORE DELETE ON rf_bank FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank\" INTO @tc_table_id;
                            SELECT rf_bank_trf_yn FROM rf_bank WHERE rf_bank_ix = OLD.rf_bank_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_bank_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_default_rate_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_default_rate_ins_be
                BEFORE INSERT ON rf_default_rate FOR EACH ROW
                tr_rf_default_rate_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.rf_default_rate_id IS NOT NULL THEN
                                LEAVE tr_rf_default_rate_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_default_rate_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_default_rate_ins_af
                        AFTER INSERT ON rf_default_rate FOR EACH ROW
                        tr_rf_default_rate_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_default_rate\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_default_rate_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_default_rate_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_default_rate_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_default_rate_upd_be
                    BEFORE UPDATE ON rf_default_rate FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_default_rate\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_default_rate_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_default_rate_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.rf_default_rate_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.rf_default_rate_trf_yn IS NULL THEN
                                    SET NEW.rf_default_rate_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_default_rate_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_default_rate_del_be
                    BEFORE DELETE ON rf_default_rate FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_default_rate\" INTO @tc_table_id;
                            SELECT rf_default_rate_trf_yn FROM rf_default_rate WHERE rf_default_rate_id = OLD.rf_default_rate_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_default_rate_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_exchange_rate_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_exchange_rate_ins_be
                BEFORE INSERT ON rf_exchange_rate FOR EACH ROW
                tr_rf_exchange_rate_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_exchange_rate_ix IS NULL or NEW.rf_exchange_rate_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_exchange_rate_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_exchange_rate_ix = ix;
                            SET NEW.rf_exchange_rate_id = 0;
                            SET NEW.rf_exchange_rate_db = @db_code;

                            IF NEW.rf_exchange_rate_trf_yn IS NULL THEN
                                SET NEW.rf_exchange_rate_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_exchange_rate_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_exchange_rate_ins_af
                        AFTER INSERT ON rf_exchange_rate FOR EACH ROW
                        tr_rf_exchange_rate_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_exchange_rate\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_exchange_rate_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_exchange_rate_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_exchange_rate_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_exchange_rate_upd_be
                    BEFORE UPDATE ON rf_exchange_rate FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_exchange_rate\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_exchange_rate_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_exchange_rate_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_exchange_rate_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_exchange_rate_trf_yn IS NULL THEN
                                SET NEW.rf_exchange_rate_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_exchange_rate_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_exchange_rate_del_be
                    BEFORE DELETE ON rf_exchange_rate FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_exchange_rate\" INTO @tc_table_id;
                            SELECT rf_exchange_rate_trf_yn FROM rf_exchange_rate WHERE rf_exchange_rate_ix = OLD.rf_exchange_rate_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_exchange_rate_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_mthd_pmnt_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_mthd_pmnt_ins_be
                BEFORE INSERT ON rf_mthd_pmnt FOR EACH ROW
                tr_rf_mthd_pmnt_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_mthd_pmnt_ix IS NULL or NEW.rf_mthd_pmnt_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_mthd_pmnt_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_mthd_pmnt_ix = ix;
                            SET NEW.rf_mthd_pmnt_id = 0;
                            SET NEW.rf_mthd_pmnt_db = @db_code;

                            IF NEW.rf_mthd_pmnt_trf_yn IS NULL THEN
                                SET NEW.rf_mthd_pmnt_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_mthd_pmnt_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_mthd_pmnt_ins_af
                        AFTER INSERT ON rf_mthd_pmnt FOR EACH ROW
                        tr_rf_mthd_pmnt_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_mthd_pmnt\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_mthd_pmnt_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_mthd_pmnt_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_mthd_pmnt_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_mthd_pmnt_upd_be
                    BEFORE UPDATE ON rf_mthd_pmnt FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_mthd_pmnt\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_mthd_pmnt_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_mthd_pmnt_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_mthd_pmnt_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_mthd_pmnt_trf_yn IS NULL THEN
                                SET NEW.rf_mthd_pmnt_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_mthd_pmnt_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_mthd_pmnt_del_be
                    BEFORE DELETE ON rf_mthd_pmnt FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_mthd_pmnt\" INTO @tc_table_id;
                            SELECT rf_mthd_pmnt_trf_yn FROM rf_mthd_pmnt WHERE rf_mthd_pmnt_ix = OLD.rf_mthd_pmnt_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_mthd_pmnt_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_tax_rate_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_tax_rate_ins_be
                BEFORE INSERT ON rf_tax_rate FOR EACH ROW
                tr_rf_tax_rate_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_tax_rate_ix IS NULL or NEW.rf_tax_rate_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_tax_rate_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_tax_rate_ix = ix;
                            SET NEW.rf_tax_rate_id = 0;
                            SET NEW.rf_tax_rate_db = @db_code;

                            IF NEW.rf_tax_rate_trf_yn IS NULL THEN
                                SET NEW.rf_tax_rate_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_tax_rate_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_tax_rate_ins_af
                        AFTER INSERT ON rf_tax_rate FOR EACH ROW
                        tr_rf_tax_rate_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_tax_rate\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_tax_rate_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_tax_rate_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_tax_rate_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_tax_rate_upd_be
                    BEFORE UPDATE ON rf_tax_rate FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_tax_rate\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_tax_rate_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_tax_rate_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_tax_rate_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_tax_rate_trf_yn IS NULL THEN
                                SET NEW.rf_tax_rate_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_tax_rate_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_tax_rate_del_be
                    BEFORE DELETE ON rf_tax_rate FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_tax_rate\" INTO @tc_table_id;
                            SELECT rf_tax_rate_trf_yn FROM rf_tax_rate WHERE rf_tax_rate_ix = OLD.rf_tax_rate_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_tax_rate_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_extra_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_extra_ins_be
                BEFORE INSERT ON rv_extra FOR EACH ROW
                tr_rv_extra_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_extra_ix IS NULL or NEW.rv_extra_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_extra_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_extra_ix = ix;
                            SET NEW.rv_extra_id = 0;
                            SET NEW.rv_extra_db = @db_code;

                            IF NEW.rv_extra_trf_yn IS NULL THEN
                                SET NEW.rv_extra_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_extra_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_extra_ins_af
                        AFTER INSERT ON rv_extra FOR EACH ROW
                        tr_rv_extra_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_extra\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_extra_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_extra_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_extra_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_extra_upd_be
                    BEFORE UPDATE ON rv_extra FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_extra\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_extra_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_extra_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_extra_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_extra_trf_yn IS NULL THEN
                                SET NEW.rv_extra_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_extra_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_extra_del_be
                    BEFORE DELETE ON rv_extra FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_extra\" INTO @tc_table_id;
                            SELECT rv_extra_trf_yn FROM rv_extra WHERE rv_extra_ix = OLD.rv_extra_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_extra_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_pay_plan_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_pay_plan_item_ins_be
                BEFORE INSERT ON rv_pay_plan_item FOR EACH ROW
                tr_rv_pay_plan_item_ins_be: BEGIN
                    -- Indicator: 2
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_pay_plan_item_ix IS NULL or NEW.rv_pay_plan_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_pay_plan_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_pay_plan_item_ix = ix;
                            SET NEW.rv_pay_plan_item_id = 0;
                            SET NEW.rv_pay_plan_item_db = @db_code;

                            IF NEW.rv_pay_plan_item_trf_yn IS NULL THEN
                                SET NEW.rv_pay_plan_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_pay_plan_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_pay_plan_item_ins_af
                        AFTER INSERT ON rv_pay_plan_item FOR EACH ROW
                        tr_rv_pay_plan_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_pay_plan_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_pay_plan_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_pay_plan_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_pay_plan_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_pay_plan_item_upd_be
                    BEFORE UPDATE ON rv_pay_plan_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_pay_plan_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_pay_plan_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_pay_plan_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_pay_plan_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_pay_plan_item_trf_yn IS NULL THEN
                                SET NEW.rv_pay_plan_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_pay_plan_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_pay_plan_item_del_be
                    BEFORE DELETE ON rv_pay_plan_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_pay_plan_item\" INTO @tc_table_id;
                            SELECT rv_pay_plan_item_trf_yn FROM rv_pay_plan_item WHERE rv_pay_plan_item_ix = OLD.rv_pay_plan_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_pay_plan_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_payment_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_payment_ins_be
                BEFORE INSERT ON rv_payment FOR EACH ROW
                tr_rv_payment_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_payment_ix IS NULL or NEW.rv_payment_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_payment_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_payment\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(rv_payment.rv_payment_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    rv_payment
                                WHERE
                                    rv_payment.rv_payment_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"rv_payment\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_payment\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                rv_payment
                            WHERE
                                rv_payment.rv_payment_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(rv_payment.rv_payment_id) -- Get the highest ID in table
                            FROM
                                rv_payment
                            WHERE
                                rv_payment_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_payment ON rv_payment.rv_payment_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_payment\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_payment ON rv_payment.rv_payment_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_payment\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.rv_payment_db = @db_code;
                            SET NEW.rv_payment_id = id;
                            SET NEW.rv_payment_ix = ix;

                            IF NEW.rv_payment_trf_yn IS NULL THEN
                                SET NEW.rv_payment_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN rv_payment ON rv_payment.rv_payment_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"rv_payment\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_payment_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_payment_ins_af
                        AFTER INSERT ON rv_payment FOR EACH ROW
                        tr_rv_payment_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_payment_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_payment_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_payment_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_payment_upd_be
                    BEFORE UPDATE ON rv_payment FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_payment_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_payment_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_payment_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_payment_trf_yn IS NULL THEN
                                SET NEW.rv_payment_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_payment_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_payment_del_be
                    BEFORE DELETE ON rv_payment FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment\" INTO @tc_table_id;
                            SELECT rv_payment_trf_yn FROM rv_payment WHERE rv_payment_ix = OLD.rv_payment_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_payment_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_payment_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_payment_item_ins_be
                BEFORE INSERT ON rv_payment_item FOR EACH ROW
                tr_rv_payment_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_payment_item_ix IS NULL or NEW.rv_payment_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_payment_item_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_payment_item\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(rv_payment_item.rv_payment_item_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    rv_payment_item
                                WHERE
                                    rv_payment_item.rv_payment_item_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"rv_payment_item\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_payment_item\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                rv_payment_item
                            WHERE
                                rv_payment_item.rv_payment_item_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(rv_payment_item.rv_payment_item_id) -- Get the highest ID in table
                            FROM
                                rv_payment_item
                            WHERE
                                rv_payment_item_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_item_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_payment_item\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_item_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_payment_item\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.rv_payment_item_db = @db_code;
                            SET NEW.rv_payment_item_id = id;
                            SET NEW.rv_payment_item_ix = ix;

                            IF NEW.rv_payment_item_trf_yn IS NULL THEN
                                SET NEW.rv_payment_item_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_item_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"rv_payment_item\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_payment_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_payment_item_ins_af
                        AFTER INSERT ON rv_payment_item FOR EACH ROW
                        tr_rv_payment_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_payment_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_payment_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_payment_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_payment_item_upd_be
                    BEFORE UPDATE ON rv_payment_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_payment_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_payment_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_payment_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_payment_item_trf_yn IS NULL THEN
                                SET NEW.rv_payment_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_payment_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_payment_item_del_be
                    BEFORE DELETE ON rv_payment_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment_item\" INTO @tc_table_id;
                            SELECT rv_payment_item_trf_yn FROM rv_payment_item WHERE rv_payment_item_ix = OLD.rv_payment_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_payment_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_comp_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_comp_ins_be
                BEFORE INSERT ON rv_res_item_comp FOR EACH ROW
                tr_rv_res_item_comp_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_comp_ix IS NULL or NEW.rv_res_item_comp_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_comp_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_comp_ix = ix;
                            SET NEW.rv_res_item_comp_id = 0;
                            SET NEW.rv_res_item_comp_db = @db_code;

                            IF NEW.rv_res_item_comp_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_comp_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_comp_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_comp_ins_af
                        AFTER INSERT ON rv_res_item_comp FOR EACH ROW
                        tr_rv_res_item_comp_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_comp_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_comp_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_comp_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_comp_upd_be
                    BEFORE UPDATE ON rv_res_item_comp FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_comp_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_comp_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_comp_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_comp_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_comp_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_comp_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_comp_del_be
                    BEFORE DELETE ON rv_res_item_comp FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp\" INTO @tc_table_id;
                            SELECT rv_res_item_comp_trf_yn FROM rv_res_item_comp WHERE rv_res_item_comp_ix = OLD.rv_res_item_comp_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_comp_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_custom_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_custom_ins_be
                BEFORE INSERT ON rf_custom FOR EACH ROW
                tr_rf_custom_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.rf_custom_id IS NOT NULL THEN
                                LEAVE tr_rf_custom_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_custom_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_custom_ins_af
                        AFTER INSERT ON rf_custom FOR EACH ROW
                        tr_rf_custom_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_custom\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_custom_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_custom_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_custom_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_custom_upd_be
                    BEFORE UPDATE ON rf_custom FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_custom\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_custom_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_custom_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.rf_custom_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.rf_custom_trf_yn IS NULL THEN
                                    SET NEW.rf_custom_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_custom_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_custom_del_be
                    BEFORE DELETE ON rf_custom FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_custom\" INTO @tc_table_id;
                            SELECT rf_custom_trf_yn FROM rf_custom WHERE rf_custom_id = OLD.rf_custom_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_custom_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_em_mail_log_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_em_mail_log_ins_be
                BEFORE INSERT ON em_mail_log FOR EACH ROW
                tr_em_mail_log_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.em_mail_log_ix IS NULL or NEW.em_mail_log_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_em_mail_log_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.em_mail_log_ix = ix;
                            SET NEW.em_mail_log_id = 0;
                            SET NEW.em_mail_log_db = @db_code;

                            IF NEW.em_mail_log_trf_yn IS NULL THEN
                                SET NEW.em_mail_log_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_em_mail_log_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_em_mail_log_ins_af
                        AFTER INSERT ON em_mail_log FOR EACH ROW
                        tr_em_mail_log_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"em_mail_log\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.em_mail_log_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_em_mail_log_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_em_mail_log_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_em_mail_log_upd_be
                    BEFORE UPDATE ON em_mail_log FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"em_mail_log\" INTO @tc_table_id;
                        SET row_transferred = OLD.em_mail_log_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.em_mail_log_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.em_mail_log_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.em_mail_log_trf_yn IS NULL THEN
                                SET NEW.em_mail_log_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_em_mail_log_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_em_mail_log_del_be
                    BEFORE DELETE ON em_mail_log FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"em_mail_log\" INTO @tc_table_id;
                            SELECT em_mail_log_trf_yn FROM em_mail_log WHERE em_mail_log_ix = OLD.em_mail_log_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.em_mail_log_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_note_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_note_ins_be
                BEFORE INSERT ON rf_note FOR EACH ROW
                tr_rf_note_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_note_ix IS NULL or NEW.rf_note_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_note_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_note_ix = ix;
                            SET NEW.rf_note_id = 0;
                            SET NEW.rf_note_db = @db_code;

                            IF NEW.rf_note_trf_yn IS NULL THEN
                                SET NEW.rf_note_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_note_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_note_ins_af
                        AFTER INSERT ON rf_note FOR EACH ROW
                        tr_rf_note_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_note_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_note_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_upd_be
                    BEFORE UPDATE ON rf_note FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_note_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_note_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_note_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_note_trf_yn IS NULL THEN
                                SET NEW.rf_note_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_del_be
                    BEFORE DELETE ON rf_note FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note\" INTO @tc_table_id;
                            SELECT rf_note_trf_yn FROM rf_note WHERE rf_note_ix = OLD.rf_note_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_note_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ad_db_status_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ad_db_status_ins_be
                BEFORE INSERT ON ad_db_status FOR EACH ROW
                tr_ad_db_status_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ad_db_status_ix IS NULL or NEW.ad_db_status_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ad_db_status_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ad_db_status_ix = ix;
                            SET NEW.ad_db_status_id = 0;
                            SET NEW.ad_db_status_db = @db_code;

                            IF NEW.ad_db_status_trf_yn IS NULL THEN
                                SET NEW.ad_db_status_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ad_db_status_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ad_db_status_ins_af
                        AFTER INSERT ON ad_db_status FOR EACH ROW
                        tr_ad_db_status_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_db_status\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ad_db_status_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ad_db_status_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_db_status_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_db_status_upd_be
                    BEFORE UPDATE ON ad_db_status FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_db_status\" INTO @tc_table_id;
                        SET row_transferred = OLD.ad_db_status_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ad_db_status_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ad_db_status_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ad_db_status_trf_yn IS NULL THEN
                                SET NEW.ad_db_status_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_db_status_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_db_status_del_be
                    BEFORE DELETE ON ad_db_status FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_db_status\" INTO @tc_table_id;
                            SELECT ad_db_status_trf_yn FROM ad_db_status WHERE ad_db_status_ix = OLD.ad_db_status_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ad_db_status_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ad_reservation_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ad_reservation_ins_be
                BEFORE INSERT ON ad_reservation FOR EACH ROW
                tr_ad_reservation_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ad_reservation_ix IS NULL or NEW.ad_reservation_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ad_reservation_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ad_reservation_ix = ix;
                            SET NEW.ad_reservation_id = 0;
                            SET NEW.ad_reservation_db = @db_code;

                            IF NEW.ad_reservation_trf_yn IS NULL THEN
                                SET NEW.ad_reservation_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ad_reservation_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ad_reservation_ins_af
                        AFTER INSERT ON ad_reservation FOR EACH ROW
                        tr_ad_reservation_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_reservation\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ad_reservation_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ad_reservation_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_reservation_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_reservation_upd_be
                    BEFORE UPDATE ON ad_reservation FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_reservation\" INTO @tc_table_id;
                        SET row_transferred = OLD.ad_reservation_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ad_reservation_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ad_reservation_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ad_reservation_trf_yn IS NULL THEN
                                SET NEW.ad_reservation_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_reservation_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_reservation_del_be
                    BEFORE DELETE ON ad_reservation FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_reservation\" INTO @tc_table_id;
                            SELECT ad_reservation_trf_yn FROM ad_reservation WHERE ad_reservation_ix = OLD.ad_reservation_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ad_reservation_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_source_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_source_ins_be
                BEFORE INSERT ON rf_source FOR EACH ROW
                tr_rf_source_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_source_ix IS NULL or NEW.rf_source_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_source_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_source_ix = ix;
                            SET NEW.rf_source_id = 0;
                            SET NEW.rf_source_db = @db_code;

                            IF NEW.rf_source_trf_yn IS NULL THEN
                                SET NEW.rf_source_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_source_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_source_ins_af
                        AFTER INSERT ON rf_source FOR EACH ROW
                        tr_rf_source_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_source\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_source_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_source_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_source_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_source_upd_be
                    BEFORE UPDATE ON rf_source FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_source\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_source_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_source_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_source_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_source_trf_yn IS NULL THEN
                                SET NEW.rf_source_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_source_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_source_del_be
                    BEFORE DELETE ON rf_source FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_source\" INTO @tc_table_id;
                            SELECT rf_source_trf_yn FROM rf_source WHERE rf_source_ix = OLD.rf_source_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_source_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_accomm_block_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_accomm_block_ins_be
                BEFORE INSERT ON ac_accomm_block FOR EACH ROW
                tr_ac_accomm_block_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_accomm_block_ix IS NULL or NEW.ac_accomm_block_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_accomm_block_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_accomm_block_ix = ix;
                            SET NEW.ac_accomm_block_id = 0;
                            SET NEW.ac_accomm_block_db = @db_code;

                            IF NEW.ac_accomm_block_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_block_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_accomm_block_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_accomm_block_ins_af
                        AFTER INSERT ON ac_accomm_block FOR EACH ROW
                        tr_ac_accomm_block_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_block\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_accomm_block_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_accomm_block_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_block_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_block_upd_be
                    BEFORE UPDATE ON ac_accomm_block FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_block\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_accomm_block_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_accomm_block_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_accomm_block_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_accomm_block_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_block_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_block_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_block_del_be
                    BEFORE DELETE ON ac_accomm_block FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_block\" INTO @tc_table_id;
                            SELECT ac_accomm_block_trf_yn FROM ac_accomm_block WHERE ac_accomm_block_ix = OLD.ac_accomm_block_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_accomm_block_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_accomm_room_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_accomm_room_ins_be
                BEFORE INSERT ON ac_accomm_room FOR EACH ROW
                tr_ac_accomm_room_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_accomm_room_ix IS NULL or NEW.ac_accomm_room_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_accomm_room_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_accomm_room_ix = ix;
                            SET NEW.ac_accomm_room_id = 0;
                            SET NEW.ac_accomm_room_db = @db_code;

                            IF NEW.ac_accomm_room_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_room_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_accomm_room_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_accomm_room_ins_af
                        AFTER INSERT ON ac_accomm_room FOR EACH ROW
                        tr_ac_accomm_room_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_accomm_room_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_accomm_room_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_room_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_room_upd_be
                    BEFORE UPDATE ON ac_accomm_room FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_accomm_room_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_accomm_room_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_accomm_room_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_accomm_room_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_room_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_room_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_room_del_be
                    BEFORE DELETE ON ac_accomm_room FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room\" INTO @tc_table_id;
                            SELECT ac_accomm_room_trf_yn FROM ac_accomm_room WHERE ac_accomm_room_ix = OLD.ac_accomm_room_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_accomm_room_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_accomm_room_attr_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_accomm_room_attr_ins_be
                BEFORE INSERT ON ac_accomm_room_attr FOR EACH ROW
                tr_ac_accomm_room_attr_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_accomm_room_attr_ix IS NULL or NEW.ac_accomm_room_attr_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_accomm_room_attr_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_accomm_room_attr_ix = ix;
                            SET NEW.ac_accomm_room_attr_id = 0;
                            SET NEW.ac_accomm_room_attr_db = @db_code;

                            IF NEW.ac_accomm_room_attr_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_room_attr_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_accomm_room_attr_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_accomm_room_attr_ins_af
                        AFTER INSERT ON ac_accomm_room_attr FOR EACH ROW
                        tr_ac_accomm_room_attr_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room_attr\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_accomm_room_attr_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_accomm_room_attr_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_room_attr_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_room_attr_upd_be
                    BEFORE UPDATE ON ac_accomm_room_attr FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room_attr\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_accomm_room_attr_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_accomm_room_attr_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_accomm_room_attr_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_accomm_room_attr_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_room_attr_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_room_attr_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_room_attr_del_be
                    BEFORE DELETE ON ac_accomm_room_attr FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room_attr\" INTO @tc_table_id;
                            SELECT ac_accomm_room_attr_trf_yn FROM ac_accomm_room_attr WHERE ac_accomm_room_attr_ix = OLD.ac_accomm_room_attr_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_accomm_room_attr_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_accomm_room_block_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_accomm_room_block_ins_be
                BEFORE INSERT ON ac_accomm_room_block FOR EACH ROW
                tr_ac_accomm_room_block_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_accomm_room_block_ix IS NULL or NEW.ac_accomm_room_block_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_accomm_room_block_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_accomm_room_block_ix = ix;
                            SET NEW.ac_accomm_room_block_id = 0;
                            SET NEW.ac_accomm_room_block_db = @db_code;

                            IF NEW.ac_accomm_room_block_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_room_block_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_accomm_room_block_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_accomm_room_block_ins_af
                        AFTER INSERT ON ac_accomm_room_block FOR EACH ROW
                        tr_ac_accomm_room_block_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room_block\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_accomm_room_block_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_accomm_room_block_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_room_block_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_room_block_upd_be
                    BEFORE UPDATE ON ac_accomm_room_block FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room_block\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_accomm_room_block_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_accomm_room_block_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_accomm_room_block_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_accomm_room_block_trf_yn IS NULL THEN
                                SET NEW.ac_accomm_room_block_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_accomm_room_block_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_accomm_room_block_del_be
                    BEFORE DELETE ON ac_accomm_room_block FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_accomm_room_block\" INTO @tc_table_id;
                            SELECT ac_accomm_room_block_trf_yn FROM ac_accomm_room_block WHERE ac_accomm_room_block_ix = OLD.ac_accomm_room_block_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_accomm_room_block_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_extra_category_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_extra_category_ins_be
                BEFORE INSERT ON ac_extra_category FOR EACH ROW
                tr_ac_extra_category_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_extra_category_ix IS NULL or NEW.ac_extra_category_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_extra_category_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_extra_category_ix = ix;
                            SET NEW.ac_extra_category_id = 0;
                            SET NEW.ac_extra_category_db = @db_code;

                            IF NEW.ac_extra_category_trf_yn IS NULL THEN
                                SET NEW.ac_extra_category_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_extra_category_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_extra_category_ins_af
                        AFTER INSERT ON ac_extra_category FOR EACH ROW
                        tr_ac_extra_category_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_category\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_extra_category_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_extra_category_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_category_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_category_upd_be
                    BEFORE UPDATE ON ac_extra_category FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_category\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_extra_category_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_extra_category_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_extra_category_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_extra_category_trf_yn IS NULL THEN
                                SET NEW.ac_extra_category_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_category_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_category_del_be
                    BEFORE DELETE ON ac_extra_category FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_category\" INTO @tc_table_id;
                            SELECT ac_extra_category_trf_yn FROM ac_extra_category WHERE ac_extra_category_ix = OLD.ac_extra_category_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_extra_category_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_extra_prop_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_extra_prop_ins_be
                BEFORE INSERT ON ac_extra_prop FOR EACH ROW
                tr_ac_extra_prop_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_extra_prop_ix IS NULL or NEW.ac_extra_prop_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_extra_prop_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_extra_prop_ix = ix;
                            SET NEW.ac_extra_prop_id = 0;
                            SET NEW.ac_extra_prop_db = @db_code;

                            IF NEW.ac_extra_prop_trf_yn IS NULL THEN
                                SET NEW.ac_extra_prop_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_extra_prop_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_extra_prop_ins_af
                        AFTER INSERT ON ac_extra_prop FOR EACH ROW
                        tr_ac_extra_prop_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_prop\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_extra_prop_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_extra_prop_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_prop_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_prop_upd_be
                    BEFORE UPDATE ON ac_extra_prop FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_prop\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_extra_prop_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_extra_prop_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_extra_prop_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_extra_prop_trf_yn IS NULL THEN
                                SET NEW.ac_extra_prop_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_prop_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_prop_del_be
                    BEFORE DELETE ON ac_extra_prop FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_prop\" INTO @tc_table_id;
                            SELECT ac_extra_prop_trf_yn FROM ac_extra_prop WHERE ac_extra_prop_ix = OLD.ac_extra_prop_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_extra_prop_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_folio_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_folio_ins_be
                BEFORE INSERT ON fn_folio FOR EACH ROW
                tr_fn_folio_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_folio_ix IS NULL or NEW.fn_folio_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_folio_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_folio_ix = ix;
                            SET NEW.fn_folio_id = 0;
                            SET NEW.fn_folio_db = @db_code;

                            IF NEW.fn_folio_trf_yn IS NULL THEN
                                SET NEW.fn_folio_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_folio_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_folio_ins_af
                        AFTER INSERT ON fn_folio FOR EACH ROW
                        tr_fn_folio_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_folio\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_folio_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_folio_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_folio_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_folio_upd_be
                    BEFORE UPDATE ON fn_folio FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_folio\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_folio_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_folio_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_folio_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_folio_trf_yn IS NULL THEN
                                SET NEW.fn_folio_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_folio_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_folio_del_be
                    BEFORE DELETE ON fn_folio FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_folio\" INTO @tc_table_id;
                            SELECT fn_folio_trf_yn FROM fn_folio WHERE fn_folio_ix = OLD.fn_folio_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_folio_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_ins_be
                BEFORE INSERT ON fn_invoice FOR EACH ROW
                tr_fn_invoice_ins_be: BEGIN
                    -- Indicator: 3
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();
                            
                            IF IF(NEW.fn_invoice_ix IS NULL or NEW.fn_invoice_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_ins_be;
                            END IF;

                            SET prefix = NEW.fn_invoice_prefix;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"fn_invoice\"
                                AND tc_sequence_db_code = @db_code
                                AND tc_sequence_prefix = prefix;

                            IF tc_sequence_already_exists IS FALSE THEN
                                    SELECT DISTINCT
                                        pr_bus_inv_number
                                    INTO
                                        new_tc_sequence_increment
                                    FROM
                                        pr_business
                                    WHERE
                                        pr_bus_inv_prefix = prefix;
                                    IF new_tc_sequence_increment IS NULL THEN
                                        SET new_tc_sequence_increment = 1;
                                    ELSEIF new_tc_sequence_increment = 0 THEN
                                        SET new_tc_sequence_increment = 1;
                                    END IF;

                                    INSERT IGNORE INTO tc_sequence (
                                        tc_sequence_table_name,
                                        tc_sequence_db_code,
                                        tc_sequence_prefix,
                                        tc_sequence_next_id
                                    ) VALUES (
                                        \"fn_invoice\",
                                        @db_code,
                                        prefix,
                                        new_tc_sequence_increment
                                    );
                                END IF;

                                SELECT -- Get the ID to use for this insert
                                    tc_sequence_next_id
                                FROM
                                    tc_sequence
                                WHERE
                                    tc_sequence_table_name = \"fn_invoice\"
                                    AND tc_sequence_db_code = @db_code
                                    AND tc_sequence_prefix = prefix
                                INTO id;
                                
                                SET ix = CONCAT(@db_code, prefix, id);

                                SELECT COUNT(*) -- Check if a record with the next ID already exists
                                FROM
                                    fn_invoice
                                WHERE
                                    fn_invoice.fn_invoice_ix = ix
                                INTO ix_already_exists;

                                SELECT MAX(fn_invoice.fn_invoice_id) -- Get the highest ID in table
                                FROM
                                    fn_invoice
                                WHERE
                                    fn_invoice_db = @db_code
                                    AND fn_invoice_prefix = prefix
                                INTO table_max_id;

                                IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                    UPDATE
                                        tc_sequence
                                        INNER JOIN fn_invoice ON fn_invoice.fn_invoice_db = tc_sequence.tc_sequence_db_code
                                    SET
                                        tc_sequence.tc_sequence_next_id = table_max_id + 1
                                    WHERE
                                        tc_sequence_table_name = \"fn_invoice\"
                                        AND tc_sequence_db_code = @db_code
                                        AND tc_sequence_prefix = prefix;
                                    SET id = table_max_id + 1;
                                    SET ix = CONCAT(@db_code, prefix, id);
                                ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                    UPDATE
                                        tc_sequence
                                        INNER JOIN fn_invoice ON fn_invoice.fn_invoice_db = tc_sequence.tc_sequence_db_code
                                    SET
                                        tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                    WHERE
                                        tc_sequence_table_name = \"fn_invoice\"
                                        AND tc_sequence_db_code = @db_code
                                        AND tc_sequence_prefix = prefix;
                                    SET id = id + 1;
                                    SET ix = CONCAT(@db_code, prefix, id);
                                END IF;

                                SET NEW.fn_invoice_db = @db_code;
                                SET NEW.fn_invoice_id = id;
                                SET NEW.fn_invoice_ix = ix;
                                
                                IF NEW.fn_invoice_trf_yn IS NULL THEN
                                    SET NEW.fn_invoice_trf_yn = 0;
                                END IF;

                                UPDATE -- Increment tc_sequence entry for next record
                                    tc_sequence
                                    INNER JOIN fn_invoice ON fn_invoice.fn_invoice_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"fn_invoice\"
                                    AND tc_sequence_db_code = @db_code
                                    AND tc_sequence_prefix = prefix;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_ins_af
                        AFTER INSERT ON fn_invoice FOR EACH ROW
                        tr_fn_invoice_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_upd_be
                    BEFORE UPDATE ON fn_invoice FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_del_be
                    BEFORE DELETE ON fn_invoice FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice\" INTO @tc_table_id;
                            SELECT fn_invoice_trf_yn FROM fn_invoice WHERE fn_invoice_ix = OLD.fn_invoice_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_invoice_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_item_ins_be
                BEFORE INSERT ON fn_invoice_item FOR EACH ROW
                tr_fn_invoice_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_invoice_item_ix IS NULL or NEW.fn_invoice_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_invoice_item_ix = ix;
                            SET NEW.fn_invoice_item_id = 0;
                            SET NEW.fn_invoice_item_db = @db_code;

                            IF NEW.fn_invoice_item_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_item_ins_af
                        AFTER INSERT ON fn_invoice_item FOR EACH ROW
                        tr_fn_invoice_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_item_upd_be
                    BEFORE UPDATE ON fn_invoice_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_item_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_item_del_be
                    BEFORE DELETE ON fn_invoice_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_item\" INTO @tc_table_id;
                            SELECT fn_invoice_item_trf_yn FROM fn_invoice_item WHERE fn_invoice_item_ix = OLD.fn_invoice_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_invoice_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_guest_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_guest_ins_be
                BEFORE INSERT ON pr_guest FOR EACH ROW
                tr_pr_guest_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.pr_guest_id IS NOT NULL THEN
                                LEAVE tr_pr_guest_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_guest_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_guest_ins_af
                        AFTER INSERT ON pr_guest FOR EACH ROW
                        tr_pr_guest_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_guest\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_guest_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_guest_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_guest_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_guest_upd_be
                    BEFORE UPDATE ON pr_guest FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_guest\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_guest_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_guest_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.pr_guest_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.pr_guest_trf_yn IS NULL THEN
                                    SET NEW.pr_guest_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_guest_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_guest_del_be
                    BEFORE DELETE ON pr_guest FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_guest\" INTO @tc_table_id;
                            SELECT pr_guest_trf_yn FROM pr_guest WHERE pr_guest_id = OLD.pr_guest_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_guest_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_database_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_database_ins_be
                BEFORE INSERT ON rf_database FOR EACH ROW
                tr_rf_database_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.rf_database_id IS NOT NULL THEN
                                LEAVE tr_rf_database_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_database_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_database_ins_af
                        AFTER INSERT ON rf_database FOR EACH ROW
                        tr_rf_database_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_database\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_database_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_database_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_database_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_database_upd_be
                    BEFORE UPDATE ON rf_database FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_database\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_database_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_database_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.rf_database_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.rf_database_trf_yn IS NULL THEN
                                    SET NEW.rf_database_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_database_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_database_del_be
                    BEFORE DELETE ON rf_database FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_database\" INTO @tc_table_id;
                            SELECT rf_database_trf_yn FROM rf_database WHERE rf_database_id = OLD.rf_database_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_database_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_db_business_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_db_business_ins_be
                BEFORE INSERT ON rf_db_business FOR EACH ROW
                tr_rf_db_business_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.rf_db_business_id IS NOT NULL THEN
                                LEAVE tr_rf_db_business_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_db_business_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_db_business_ins_af
                        AFTER INSERT ON rf_db_business FOR EACH ROW
                        tr_rf_db_business_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_db_business\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_db_business_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_db_business_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_db_business_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_db_business_upd_be
                    BEFORE UPDATE ON rf_db_business FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_db_business\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_db_business_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_db_business_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.rf_db_business_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.rf_db_business_trf_yn IS NULL THEN
                                    SET NEW.rf_db_business_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_db_business_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_db_business_del_be
                    BEFORE DELETE ON rf_db_business FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_db_business\" INTO @tc_table_id;
                            SELECT rf_db_business_trf_yn FROM rf_db_business WHERE rf_db_business_id = OLD.rf_db_business_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_db_business_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_guest_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_guest_type_ins_be
                BEFORE INSERT ON rf_guest_type FOR EACH ROW
                tr_rf_guest_type_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_guest_type_ix IS NULL or NEW.rf_guest_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_guest_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_guest_type_ix = ix;
                            SET NEW.rf_guest_type_id = 0;
                            SET NEW.rf_guest_type_db = @db_code;

                            IF NEW.rf_guest_type_trf_yn IS NULL THEN
                                SET NEW.rf_guest_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_guest_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_guest_type_ins_af
                        AFTER INSERT ON rf_guest_type FOR EACH ROW
                        tr_rf_guest_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_guest_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_guest_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_guest_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_guest_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_guest_type_upd_be
                    BEFORE UPDATE ON rf_guest_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_guest_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_guest_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_guest_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_guest_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_guest_type_trf_yn IS NULL THEN
                                SET NEW.rf_guest_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_guest_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_guest_type_del_be
                    BEFORE DELETE ON rf_guest_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_guest_type\" INTO @tc_table_id;
                            SELECT rf_guest_type_trf_yn FROM rf_guest_type WHERE rf_guest_type_ix = OLD.rf_guest_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_guest_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_group_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_group_ins_be
                BEFORE INSERT ON rv_res_item_group FOR EACH ROW
                tr_rv_res_item_group_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_group_ix IS NULL or NEW.rv_res_item_group_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_group_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_group_ix = ix;
                            SET NEW.rv_res_item_group_id = 0;
                            SET NEW.rv_res_item_group_db = @db_code;

                            IF NEW.rv_res_item_group_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_group_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_group_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_group_ins_af
                        AFTER INSERT ON rv_res_item_group FOR EACH ROW
                        tr_rv_res_item_group_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_group\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_group_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_group_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_group_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_group_upd_be
                    BEFORE UPDATE ON rv_res_item_group FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_group\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_group_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_group_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_group_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_group_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_group_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_group_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_group_del_be
                    BEFORE DELETE ON rv_res_item_group FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_group\" INTO @tc_table_id;
                            SELECT rv_res_item_group_trf_yn FROM rv_res_item_group WHERE rv_res_item_group_ix = OLD.rv_res_item_group_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_group_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_guest_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_guest_ins_be
                BEFORE INSERT ON rv_res_item_guest FOR EACH ROW
                tr_rv_res_item_guest_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_guest_ix IS NULL or NEW.rv_res_item_guest_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_guest_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_guest_ix = ix;
                            SET NEW.rv_res_item_guest_id = 0;
                            SET NEW.rv_res_item_guest_db = @db_code;

                            IF NEW.rv_res_item_guest_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_guest_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_guest_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_guest_ins_af
                        AFTER INSERT ON rv_res_item_guest FOR EACH ROW
                        tr_rv_res_item_guest_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_guest\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_guest_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_guest_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_guest_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_guest_upd_be
                    BEFORE UPDATE ON rv_res_item_guest FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_guest\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_guest_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_guest_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_guest_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_guest_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_guest_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_guest_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_guest_del_be
                    BEFORE DELETE ON rv_res_item_guest FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_guest\" INTO @tc_table_id;
                            SELECT rv_res_item_guest_trf_yn FROM rv_res_item_guest WHERE rv_res_item_guest_ix = OLD.rv_res_item_guest_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_guest_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_reservation_guest_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_reservation_guest_ins_be
                BEFORE INSERT ON rv_reservation_guest FOR EACH ROW
                tr_rv_reservation_guest_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_reservation_guest_ix IS NULL or NEW.rv_reservation_guest_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_reservation_guest_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_reservation_guest_ix = ix;
                            SET NEW.rv_reservation_guest_id = 0;
                            SET NEW.rv_reservation_guest_db = @db_code;

                            IF NEW.rv_reservation_guest_trf_yn IS NULL THEN
                                SET NEW.rv_reservation_guest_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_reservation_guest_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_reservation_guest_ins_af
                        AFTER INSERT ON rv_reservation_guest FOR EACH ROW
                        tr_rv_reservation_guest_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation_guest\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_reservation_guest_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_reservation_guest_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_reservation_guest_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_reservation_guest_upd_be
                    BEFORE UPDATE ON rv_reservation_guest FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation_guest\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_reservation_guest_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_reservation_guest_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_reservation_guest_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_reservation_guest_trf_yn IS NULL THEN
                                SET NEW.rv_reservation_guest_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_reservation_guest_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_reservation_guest_del_be
                    BEFORE DELETE ON rv_reservation_guest FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_reservation_guest\" INTO @tc_table_id;
                            SELECT rv_reservation_guest_trf_yn FROM rv_reservation_guest WHERE rv_reservation_guest_ix = OLD.rv_reservation_guest_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_reservation_guest_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_ledger_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_ledger_ins_be
                BEFORE INSERT ON fn_ledger FOR EACH ROW
                tr_fn_ledger_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_ledger_ix IS NULL or NEW.fn_ledger_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_ledger_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_ledger_ix = ix;
                            SET NEW.fn_ledger_id = 0;
                            SET NEW.fn_ledger_db = @db_code;

                            IF NEW.fn_ledger_trf_yn IS NULL THEN
                                SET NEW.fn_ledger_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_ledger_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_ledger_ins_af
                        AFTER INSERT ON fn_ledger FOR EACH ROW
                        tr_fn_ledger_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_ledger\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_ledger_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_ledger_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_ledger_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_ledger_upd_be
                    BEFORE UPDATE ON fn_ledger FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_ledger\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_ledger_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_ledger_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_ledger_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_ledger_trf_yn IS NULL THEN
                                SET NEW.fn_ledger_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_ledger_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_ledger_del_be
                    BEFORE DELETE ON fn_ledger FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_ledger\" INTO @tc_table_id;
                            SELECT fn_ledger_trf_yn FROM fn_ledger WHERE fn_ledger_ix = OLD.fn_ledger_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_ledger_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_tc_transfer_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_tc_transfer_ins_be
                BEFORE INSERT ON tc_transfer FOR EACH ROW
                tr_tc_transfer_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.tc_transfer_ix IS NULL or NEW.tc_transfer_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_tc_transfer_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"tc_transfer\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(tc_transfer.tc_transfer_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    tc_transfer
                                WHERE
                                    tc_transfer.tc_transfer_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"tc_transfer\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"tc_transfer\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                tc_transfer
                            WHERE
                                tc_transfer.tc_transfer_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(tc_transfer.tc_transfer_id) -- Get the highest ID in table
                            FROM
                                tc_transfer
                            WHERE
                                tc_transfer_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN tc_transfer ON tc_transfer.tc_transfer_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"tc_transfer\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN tc_transfer ON tc_transfer.tc_transfer_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"tc_transfer\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.tc_transfer_db = @db_code;
                            SET NEW.tc_transfer_id = id;
                            SET NEW.tc_transfer_ix = ix;

                            IF NEW.tc_transfer_trf_yn IS NULL THEN
                                SET NEW.tc_transfer_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN tc_transfer ON tc_transfer.tc_transfer_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"tc_transfer\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_tc_transfer_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_tc_transfer_ins_af
                        AFTER INSERT ON tc_transfer FOR EACH ROW
                        tr_tc_transfer_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_transfer\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.tc_transfer_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_tc_transfer_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tc_transfer_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tc_transfer_upd_be
                    BEFORE UPDATE ON tc_transfer FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_transfer\" INTO @tc_table_id;
                        SET row_transferred = OLD.tc_transfer_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.tc_transfer_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.tc_transfer_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.tc_transfer_trf_yn IS NULL THEN
                                SET NEW.tc_transfer_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tc_transfer_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tc_transfer_del_be
                    BEFORE DELETE ON tc_transfer FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_transfer\" INTO @tc_table_id;
                            SELECT tc_transfer_trf_yn FROM tc_transfer WHERE tc_transfer_ix = OLD.tc_transfer_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.tc_transfer_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_tc_transfer_table_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_tc_transfer_table_ins_be
                BEFORE INSERT ON tc_transfer_table FOR EACH ROW
                tr_tc_transfer_table_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.tc_transfer_table_ix IS NULL or NEW.tc_transfer_table_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_tc_transfer_table_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.tc_transfer_table_ix = ix;
                            SET NEW.tc_transfer_table_id = 0;
                            SET NEW.tc_transfer_table_db = @db_code;

                            IF NEW.tc_transfer_table_trf_yn IS NULL THEN
                                SET NEW.tc_transfer_table_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_tc_transfer_table_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_tc_transfer_table_ins_af
                        AFTER INSERT ON tc_transfer_table FOR EACH ROW
                        tr_tc_transfer_table_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_transfer_table\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.tc_transfer_table_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_tc_transfer_table_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tc_transfer_table_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tc_transfer_table_upd_be
                    BEFORE UPDATE ON tc_transfer_table FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_transfer_table\" INTO @tc_table_id;
                        SET row_transferred = OLD.tc_transfer_table_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.tc_transfer_table_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.tc_transfer_table_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.tc_transfer_table_trf_yn IS NULL THEN
                                SET NEW.tc_transfer_table_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tc_transfer_table_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tc_transfer_table_del_be
                    BEFORE DELETE ON tc_transfer_table FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tc_transfer_table\" INTO @tc_table_id;
                            SELECT tc_transfer_table_trf_yn FROM tc_transfer_table WHERE tc_transfer_table_ix = OLD.tc_transfer_table_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.tc_transfer_table_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_pos_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_pos_ins_be
                BEFORE INSERT ON ac_pos FOR EACH ROW
                tr_ac_pos_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_pos_ix IS NULL or NEW.ac_pos_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_pos_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_pos_ix = ix;
                            SET NEW.ac_pos_id = 0;
                            SET NEW.ac_pos_db = @db_code;

                            IF NEW.ac_pos_trf_yn IS NULL THEN
                                SET NEW.ac_pos_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_pos_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_pos_ins_af
                        AFTER INSERT ON ac_pos FOR EACH ROW
                        tr_ac_pos_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_pos_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_pos_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pos_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pos_upd_be
                    BEFORE UPDATE ON ac_pos FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_pos_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_pos_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_pos_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_pos_trf_yn IS NULL THEN
                                SET NEW.ac_pos_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pos_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pos_del_be
                    BEFORE DELETE ON ac_pos FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos\" INTO @tc_table_id;
                            SELECT ac_pos_trf_yn FROM ac_pos WHERE ac_pos_ix = OLD.ac_pos_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_pos_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_grp_status_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_grp_status_ins_be
                BEFORE INSERT ON rv_res_item_grp_status FOR EACH ROW
                tr_rv_res_item_grp_status_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_grp_status_ix IS NULL or NEW.rv_res_item_grp_status_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_grp_status_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_grp_status_ix = ix;
                            SET NEW.rv_res_item_grp_status_id = 0;
                            SET NEW.rv_res_item_grp_status_db = @db_code;

                            IF NEW.rv_res_item_grp_status_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_grp_status_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_grp_status_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_grp_status_ins_af
                        AFTER INSERT ON rv_res_item_grp_status FOR EACH ROW
                        tr_rv_res_item_grp_status_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_grp_status\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_grp_status_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_grp_status_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_grp_status_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_grp_status_upd_be
                    BEFORE UPDATE ON rv_res_item_grp_status FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_grp_status\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_grp_status_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_grp_status_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_grp_status_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_grp_status_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_grp_status_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_grp_status_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_grp_status_del_be
                    BEFORE DELETE ON rv_res_item_grp_status FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_grp_status\" INTO @tc_table_id;
                            SELECT rv_res_item_grp_status_trf_yn FROM rv_res_item_grp_status WHERE rv_res_item_grp_status_ix = OLD.rv_res_item_grp_status_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_grp_status_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_supplier_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_supplier_ins_be
                BEFORE INSERT ON pr_supplier FOR EACH ROW
                tr_pr_supplier_ins_be: BEGIN
                    -- Indicator: 1
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.pr_supplier_id IS NOT NULL THEN
                                LEAVE tr_pr_supplier_ins_be;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_supplier_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_supplier_ins_af
                        AFTER INSERT ON pr_supplier FOR EACH ROW
                        tr_pr_supplier_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_supplier\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_supplier_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_supplier_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_supplier_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_supplier_upd_be
                    BEFORE UPDATE ON pr_supplier FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_supplier\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_supplier_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_supplier_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.pr_supplier_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.pr_supplier_trf_yn IS NULL THEN
                                    SET NEW.pr_supplier_trf_yn = 0;
                                END IF;
                            END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_supplier_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_supplier_del_be
                    BEFORE DELETE ON pr_supplier FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_supplier\" INTO @tc_table_id;
                            SELECT pr_supplier_trf_yn FROM pr_supplier WHERE pr_supplier_id = OLD.pr_supplier_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_supplier_id);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_bank_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_bank_ins_be
                BEFORE INSERT ON fn_invoice_bank FOR EACH ROW
                tr_fn_invoice_bank_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_invoice_bank_ix IS NULL or NEW.fn_invoice_bank_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_bank_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_invoice_bank_ix = ix;
                            SET NEW.fn_invoice_bank_id = 0;
                            SET NEW.fn_invoice_bank_db = @db_code;

                            IF NEW.fn_invoice_bank_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_bank_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_bank_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_bank_ins_af
                        AFTER INSERT ON fn_invoice_bank FOR EACH ROW
                        tr_fn_invoice_bank_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_bank\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_bank_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_bank_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_bank_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_bank_upd_be
                    BEFORE UPDATE ON fn_invoice_bank FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_bank\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_bank_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_bank_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_bank_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_bank_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_bank_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_bank_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_bank_del_be
                    BEFORE DELETE ON fn_invoice_bank FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_bank\" INTO @tc_table_id;
                            SELECT fn_invoice_bank_trf_yn FROM fn_invoice_bank WHERE fn_invoice_bank_ix = OLD.fn_invoice_bank_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_invoice_bank_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_phone_extn_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_phone_extn_ins_be
                BEFORE INSERT ON rf_phone_extn FOR EACH ROW
                tr_rf_phone_extn_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_phone_extn_ix IS NULL or NEW.rf_phone_extn_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_phone_extn_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_phone_extn_ix = ix;
                            SET NEW.rf_phone_extn_id = 0;
                            SET NEW.rf_phone_extn_db = @db_code;

                            IF NEW.rf_phone_extn_trf_yn IS NULL THEN
                                SET NEW.rf_phone_extn_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_phone_extn_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_phone_extn_ins_af
                        AFTER INSERT ON rf_phone_extn FOR EACH ROW
                        tr_rf_phone_extn_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_extn\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_phone_extn_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_phone_extn_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_phone_extn_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_phone_extn_upd_be
                    BEFORE UPDATE ON rf_phone_extn FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_extn\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_phone_extn_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_phone_extn_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_phone_extn_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_phone_extn_trf_yn IS NULL THEN
                                SET NEW.rf_phone_extn_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_phone_extn_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_phone_extn_del_be
                    BEFORE DELETE ON rf_phone_extn FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_extn\" INTO @tc_table_id;
                            SELECT rf_phone_extn_trf_yn FROM rf_phone_extn WHERE rf_phone_extn_ix = OLD.rf_phone_extn_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_phone_extn_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_phone_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_phone_ins_be
                BEFORE INSERT ON rv_phone FOR EACH ROW
                tr_rv_phone_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_phone_ix IS NULL or NEW.rv_phone_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_phone_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_phone\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(rv_phone.rv_phone_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    rv_phone
                                WHERE
                                    rv_phone.rv_phone_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"rv_phone\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"rv_phone\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                rv_phone
                            WHERE
                                rv_phone.rv_phone_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(rv_phone.rv_phone_id) -- Get the highest ID in table
                            FROM
                                rv_phone
                            WHERE
                                rv_phone_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_phone ON rv_phone.rv_phone_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_phone\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN rv_phone ON rv_phone.rv_phone_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"rv_phone\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.rv_phone_db = @db_code;
                            SET NEW.rv_phone_id = id;
                            SET NEW.rv_phone_ix = ix;

                            IF NEW.rv_phone_trf_yn IS NULL THEN
                                SET NEW.rv_phone_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN rv_phone ON rv_phone.rv_phone_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"rv_phone\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_phone_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_phone_ins_af
                        AFTER INSERT ON rv_phone FOR EACH ROW
                        tr_rv_phone_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_phone\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_phone_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_phone_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_phone_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_phone_upd_be
                    BEFORE UPDATE ON rv_phone FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_phone\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_phone_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_phone_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_phone_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_phone_trf_yn IS NULL THEN
                                SET NEW.rv_phone_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_phone_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_phone_del_be
                    BEFORE DELETE ON rv_phone FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_phone\" INTO @tc_table_id;
                            SELECT rv_phone_trf_yn FROM rv_phone WHERE rv_phone_ix = OLD.rv_phone_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_phone_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_note_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_note_ins_be
                BEFORE INSERT ON fn_invoice_note FOR EACH ROW
                tr_fn_invoice_note_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_invoice_note_ix IS NULL or NEW.fn_invoice_note_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_note_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_invoice_note_ix = ix;
                            SET NEW.fn_invoice_note_id = 0;
                            SET NEW.fn_invoice_note_db = @db_code;

                            IF NEW.fn_invoice_note_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_note_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_note_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_note_ins_af
                        AFTER INSERT ON fn_invoice_note FOR EACH ROW
                        tr_fn_invoice_note_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_note\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_note_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_note_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_note_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_note_upd_be
                    BEFORE UPDATE ON fn_invoice_note FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_note\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_note_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_note_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_note_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_note_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_note_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_note_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_note_del_be
                    BEFORE DELETE ON fn_invoice_note FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_note\" INTO @tc_table_id;
                            SELECT fn_invoice_note_trf_yn FROM fn_invoice_note WHERE fn_invoice_note_ix = OLD.fn_invoice_note_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_invoice_note_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_note_custom_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_note_custom_ins_be
                BEFORE INSERT ON rf_note_custom FOR EACH ROW
                tr_rf_note_custom_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_note_custom_ix IS NULL or NEW.rf_note_custom_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_note_custom_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_note_custom_ix = ix;
                            SET NEW.rf_note_custom_id = 0;
                            SET NEW.rf_note_custom_db = @db_code;

                            IF NEW.rf_note_custom_trf_yn IS NULL THEN
                                SET NEW.rf_note_custom_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_note_custom_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_note_custom_ins_af
                        AFTER INSERT ON rf_note_custom FOR EACH ROW
                        tr_rf_note_custom_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_custom\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_note_custom_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_note_custom_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_custom_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_custom_upd_be
                    BEFORE UPDATE ON rf_note_custom FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_custom\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_note_custom_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_note_custom_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_note_custom_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_note_custom_trf_yn IS NULL THEN
                                SET NEW.rf_note_custom_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_custom_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_custom_del_be
                    BEFORE DELETE ON rf_note_custom FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_custom\" INTO @tc_table_id;
                            SELECT rf_note_custom_trf_yn FROM rf_note_custom WHERE rf_note_custom_ix = OLD.rf_note_custom_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_note_custom_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_note_cust_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_note_cust_item_ins_be
                BEFORE INSERT ON rf_note_cust_item FOR EACH ROW
                tr_rf_note_cust_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_note_cust_item_ix IS NULL or NEW.rf_note_cust_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_note_cust_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_note_cust_item_ix = ix;
                            SET NEW.rf_note_cust_item_id = 0;
                            SET NEW.rf_note_cust_item_db = @db_code;

                            IF NEW.rf_note_cust_item_trf_yn IS NULL THEN
                                SET NEW.rf_note_cust_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_note_cust_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_note_cust_item_ins_af
                        AFTER INSERT ON rf_note_cust_item FOR EACH ROW
                        tr_rf_note_cust_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_cust_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_note_cust_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_note_cust_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_cust_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_cust_item_upd_be
                    BEFORE UPDATE ON rf_note_cust_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_cust_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_note_cust_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_note_cust_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_note_cust_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_note_cust_item_trf_yn IS NULL THEN
                                SET NEW.rf_note_cust_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_cust_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_cust_item_del_be
                    BEFORE DELETE ON rf_note_cust_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_cust_item\" INTO @tc_table_id;
                            SELECT rf_note_cust_item_trf_yn FROM rf_note_cust_item WHERE rf_note_cust_item_ix = OLD.rf_note_cust_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_note_cust_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_note_cust_default_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_note_cust_default_ins_be
                BEFORE INSERT ON rf_note_cust_default FOR EACH ROW
                tr_rf_note_cust_default_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_note_cust_default_ix IS NULL or NEW.rf_note_cust_default_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_note_cust_default_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_note_cust_default_ix = ix;
                            SET NEW.rf_note_cust_default_id = 0;
                            SET NEW.rf_note_cust_default_db = @db_code;

                            IF NEW.rf_note_cust_default_trf_yn IS NULL THEN
                                SET NEW.rf_note_cust_default_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_note_cust_default_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_note_cust_default_ins_af
                        AFTER INSERT ON rf_note_cust_default FOR EACH ROW
                        tr_rf_note_cust_default_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_cust_default\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_note_cust_default_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_note_cust_default_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_cust_default_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_cust_default_upd_be
                    BEFORE UPDATE ON rf_note_cust_default FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_cust_default\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_note_cust_default_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_note_cust_default_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_note_cust_default_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_note_cust_default_trf_yn IS NULL THEN
                                SET NEW.rf_note_cust_default_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_note_cust_default_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_note_cust_default_del_be
                    BEFORE DELETE ON rf_note_cust_default FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_note_cust_default\" INTO @tc_table_id;
                            SELECT rf_note_cust_default_trf_yn FROM rf_note_cust_default WHERE rf_note_cust_default_ix = OLD.rf_note_cust_default_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_note_cust_default_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_phone_prop_extra_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_phone_prop_extra_ins_be
                BEFORE INSERT ON rf_phone_prop_extra FOR EACH ROW
                tr_rf_phone_prop_extra_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_phone_prop_extra_ix IS NULL or NEW.rf_phone_prop_extra_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_phone_prop_extra_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_phone_prop_extra_ix = ix;
                            SET NEW.rf_phone_prop_extra_id = 0;
                            SET NEW.rf_phone_prop_extra_db = @db_code;

                            IF NEW.rf_phone_prop_extra_trf_yn IS NULL THEN
                                SET NEW.rf_phone_prop_extra_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_phone_prop_extra_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_phone_prop_extra_ins_af
                        AFTER INSERT ON rf_phone_prop_extra FOR EACH ROW
                        tr_rf_phone_prop_extra_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_prop_extra\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_phone_prop_extra_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_phone_prop_extra_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_phone_prop_extra_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_phone_prop_extra_upd_be
                    BEFORE UPDATE ON rf_phone_prop_extra FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_prop_extra\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_phone_prop_extra_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_phone_prop_extra_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_phone_prop_extra_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_phone_prop_extra_trf_yn IS NULL THEN
                                SET NEW.rf_phone_prop_extra_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_phone_prop_extra_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_phone_prop_extra_del_be
                    BEFORE DELETE ON rf_phone_prop_extra FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_phone_prop_extra\" INTO @tc_table_id;
                            SELECT rf_phone_prop_extra_trf_yn FROM rf_phone_prop_extra WHERE rf_phone_prop_extra_ix = OLD.rf_phone_prop_extra_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_phone_prop_extra_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_bank_env_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_bank_env_ins_be
                BEFORE INSERT ON rf_bank_env FOR EACH ROW
                tr_rf_bank_env_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_bank_env_ix IS NULL or NEW.rf_bank_env_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_bank_env_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_bank_env_ix = ix;
                            SET NEW.rf_bank_env_id = 0;
                            SET NEW.rf_bank_env_db = @db_code;

                            IF NEW.rf_bank_env_trf_yn IS NULL THEN
                                SET NEW.rf_bank_env_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_bank_env_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_bank_env_ins_af
                        AFTER INSERT ON rf_bank_env FOR EACH ROW
                        tr_rf_bank_env_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank_env\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_bank_env_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_bank_env_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_bank_env_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_bank_env_upd_be
                    BEFORE UPDATE ON rf_bank_env FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank_env\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_bank_env_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_bank_env_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_bank_env_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_bank_env_trf_yn IS NULL THEN
                                SET NEW.rf_bank_env_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_bank_env_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_bank_env_del_be
                    BEFORE DELETE ON rf_bank_env FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank_env\" INTO @tc_table_id;
                            SELECT rf_bank_env_trf_yn FROM rf_bank_env WHERE rf_bank_env_ix = OLD.rf_bank_env_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_bank_env_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_payment_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_payment_ins_be
                BEFORE INSERT ON fn_invoice_payment FOR EACH ROW
                tr_fn_invoice_payment_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_invoice_payment_ix IS NULL or NEW.fn_invoice_payment_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_payment_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_invoice_payment_ix = ix;
                            SET NEW.fn_invoice_payment_id = 0;
                            SET NEW.fn_invoice_payment_db = @db_code;

                            IF NEW.fn_invoice_payment_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_payment_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_payment_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_payment_ins_af
                        AFTER INSERT ON fn_invoice_payment FOR EACH ROW
                        tr_fn_invoice_payment_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_payment\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_payment_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_payment_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_payment_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_payment_upd_be
                    BEFORE UPDATE ON fn_invoice_payment FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_payment\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_payment_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_payment_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_payment_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_payment_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_payment_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_payment_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_payment_del_be
                    BEFORE DELETE ON fn_invoice_payment FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_payment\" INTO @tc_table_id;
                            SELECT fn_invoice_payment_trf_yn FROM fn_invoice_payment WHERE fn_invoice_payment_ix = OLD.fn_invoice_payment_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_invoice_payment_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_extra_prop_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_extra_prop_ins_be
                BEFORE INSERT ON rv_extra_prop FOR EACH ROW
                tr_rv_extra_prop_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_extra_prop_ix IS NULL or NEW.rv_extra_prop_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_extra_prop_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_extra_prop_ix = ix;
                            SET NEW.rv_extra_prop_id = 0;
                            SET NEW.rv_extra_prop_db = @db_code;

                            IF NEW.rv_extra_prop_trf_yn IS NULL THEN
                                SET NEW.rv_extra_prop_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_extra_prop_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_extra_prop_ins_af
                        AFTER INSERT ON rv_extra_prop FOR EACH ROW
                        tr_rv_extra_prop_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_extra_prop\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_extra_prop_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_extra_prop_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_extra_prop_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_extra_prop_upd_be
                    BEFORE UPDATE ON rv_extra_prop FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_extra_prop\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_extra_prop_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_extra_prop_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_extra_prop_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_extra_prop_trf_yn IS NULL THEN
                                SET NEW.rv_extra_prop_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_extra_prop_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_extra_prop_del_be
                    BEFORE DELETE ON rv_extra_prop FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_extra_prop\" INTO @tc_table_id;
                            SELECT rv_extra_prop_trf_yn FROM rv_extra_prop WHERE rv_extra_prop_ix = OLD.rv_extra_prop_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_extra_prop_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_extra_cat_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_extra_cat_inv_ins_be
                BEFORE INSERT ON ac_extra_cat_inv FOR EACH ROW
                tr_ac_extra_cat_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_extra_cat_inv_ix IS NULL or NEW.ac_extra_cat_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_extra_cat_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_extra_cat_inv_ix = ix;
                            SET NEW.ac_extra_cat_inv_id = 0;
                            SET NEW.ac_extra_cat_inv_db = @db_code;

                            IF NEW.ac_extra_cat_inv_trf_yn IS NULL THEN
                                SET NEW.ac_extra_cat_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_extra_cat_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_extra_cat_inv_ins_af
                        AFTER INSERT ON ac_extra_cat_inv FOR EACH ROW
                        tr_ac_extra_cat_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_cat_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_extra_cat_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_extra_cat_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_cat_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_cat_inv_upd_be
                    BEFORE UPDATE ON ac_extra_cat_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_cat_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_extra_cat_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_extra_cat_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_extra_cat_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_extra_cat_inv_trf_yn IS NULL THEN
                                SET NEW.ac_extra_cat_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_cat_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_cat_inv_del_be
                    BEFORE DELETE ON ac_extra_cat_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_cat_inv\" INTO @tc_table_id;
                            SELECT ac_extra_cat_inv_trf_yn FROM ac_extra_cat_inv WHERE ac_extra_cat_inv_ix = OLD.ac_extra_cat_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_extra_cat_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_extra_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_extra_inv_ins_be
                BEFORE INSERT ON ac_extra_inv FOR EACH ROW
                tr_ac_extra_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_extra_inv_ix IS NULL or NEW.ac_extra_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_extra_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_extra_inv_ix = ix;
                            SET NEW.ac_extra_inv_id = 0;
                            SET NEW.ac_extra_inv_db = @db_code;

                            IF NEW.ac_extra_inv_trf_yn IS NULL THEN
                                SET NEW.ac_extra_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_extra_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_extra_inv_ins_af
                        AFTER INSERT ON ac_extra_inv FOR EACH ROW
                        tr_ac_extra_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_extra_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_extra_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_inv_upd_be
                    BEFORE UPDATE ON ac_extra_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_extra_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_extra_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_extra_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_extra_inv_trf_yn IS NULL THEN
                                SET NEW.ac_extra_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_extra_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_extra_inv_del_be
                    BEFORE DELETE ON ac_extra_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_extra_inv\" INTO @tc_table_id;
                            SELECT ac_extra_inv_trf_yn FROM ac_extra_inv WHERE ac_extra_inv_ix = OLD.ac_extra_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_extra_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_cost_centre_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_cost_centre_ins_be
                BEFORE INSERT ON fn_cost_centre FOR EACH ROW
                tr_fn_cost_centre_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_cost_centre_ix IS NULL or NEW.fn_cost_centre_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_cost_centre_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_cost_centre_ix = ix;
                            SET NEW.fn_cost_centre_id = 0;
                            SET NEW.fn_cost_centre_db = @db_code;

                            IF NEW.fn_cost_centre_trf_yn IS NULL THEN
                                SET NEW.fn_cost_centre_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_cost_centre_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_cost_centre_ins_af
                        AFTER INSERT ON fn_cost_centre FOR EACH ROW
                        tr_fn_cost_centre_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_cost_centre\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_cost_centre_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_cost_centre_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_cost_centre_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_cost_centre_upd_be
                    BEFORE UPDATE ON fn_cost_centre FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_cost_centre\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_cost_centre_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_cost_centre_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_cost_centre_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_cost_centre_trf_yn IS NULL THEN
                                SET NEW.fn_cost_centre_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_cost_centre_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_cost_centre_del_be
                    BEFORE DELETE ON fn_cost_centre FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_cost_centre\" INTO @tc_table_id;
                            SELECT fn_cost_centre_trf_yn FROM fn_cost_centre WHERE fn_cost_centre_ix = OLD.fn_cost_centre_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_cost_centre_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_debtor_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_debtor_ins_be
                BEFORE INSERT ON fn_debtor FOR EACH ROW
                tr_fn_debtor_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_debtor_ix IS NULL or NEW.fn_debtor_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_debtor_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_debtor_ix = ix;
                            SET NEW.fn_debtor_id = 0;
                            SET NEW.fn_debtor_db = @db_code;

                            IF NEW.fn_debtor_trf_yn IS NULL THEN
                                SET NEW.fn_debtor_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_debtor_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_debtor_ins_af
                        AFTER INSERT ON fn_debtor FOR EACH ROW
                        tr_fn_debtor_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_debtor\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_debtor_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_debtor_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_debtor_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_debtor_upd_be
                    BEFORE UPDATE ON fn_debtor FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_debtor\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_debtor_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_debtor_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_debtor_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_debtor_trf_yn IS NULL THEN
                                SET NEW.fn_debtor_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_debtor_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_debtor_del_be
                    BEFORE DELETE ON fn_debtor FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_debtor\" INTO @tc_table_id;
                            SELECT fn_debtor_trf_yn FROM fn_debtor WHERE fn_debtor_ix = OLD.fn_debtor_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_debtor_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_system_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_system_ins_be
                BEFORE INSERT ON fn_system FOR EACH ROW
                tr_fn_system_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_system_ix IS NULL or NEW.fn_system_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_system_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_system_ix = ix;
                            SET NEW.fn_system_id = 0;
                            SET NEW.fn_system_db = @db_code;

                            IF NEW.fn_system_trf_yn IS NULL THEN
                                SET NEW.fn_system_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_system_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_system_ins_af
                        AFTER INSERT ON fn_system FOR EACH ROW
                        tr_fn_system_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_system\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_system_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_system_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_system_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_system_upd_be
                    BEFORE UPDATE ON fn_system FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_system\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_system_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_system_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_system_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_system_trf_yn IS NULL THEN
                                SET NEW.fn_system_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_system_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_system_del_be
                    BEFORE DELETE ON fn_system FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_system\" INTO @tc_table_id;
                            SELECT fn_system_trf_yn FROM fn_system WHERE fn_system_ix = OLD.fn_system_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_system_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_persona_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_persona_inv_ins_be
                BEFORE INSERT ON pr_persona_inv FOR EACH ROW
                tr_pr_persona_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_persona_inv_ix IS NULL or NEW.pr_persona_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_persona_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_persona_inv_ix = ix;
                            SET NEW.pr_persona_inv_id = 0;
                            SET NEW.pr_persona_inv_db = @db_code;

                            IF NEW.pr_persona_inv_trf_yn IS NULL THEN
                                SET NEW.pr_persona_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_persona_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_persona_inv_ins_af
                        AFTER INSERT ON pr_persona_inv FOR EACH ROW
                        tr_pr_persona_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_persona_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_persona_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_persona_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_persona_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_persona_inv_upd_be
                    BEFORE UPDATE ON pr_persona_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_persona_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_persona_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_persona_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_persona_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_persona_inv_trf_yn IS NULL THEN
                                SET NEW.pr_persona_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_persona_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_persona_inv_del_be
                    BEFORE DELETE ON pr_persona_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_persona_inv\" INTO @tc_table_id;
                            SELECT pr_persona_inv_trf_yn FROM pr_persona_inv WHERE pr_persona_inv_ix = OLD.pr_persona_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_persona_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_tax_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_tax_inv_ins_be
                BEFORE INSERT ON rf_tax_inv FOR EACH ROW
                tr_rf_tax_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_tax_inv_ix IS NULL or NEW.rf_tax_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_tax_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_tax_inv_ix = ix;
                            SET NEW.rf_tax_inv_id = 0;
                            SET NEW.rf_tax_inv_db = @db_code;

                            IF NEW.rf_tax_inv_trf_yn IS NULL THEN
                                SET NEW.rf_tax_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_tax_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_tax_inv_ins_af
                        AFTER INSERT ON rf_tax_inv FOR EACH ROW
                        tr_rf_tax_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_tax_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_tax_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_tax_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_tax_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_tax_inv_upd_be
                    BEFORE UPDATE ON rf_tax_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_tax_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_tax_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_tax_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_tax_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_tax_inv_trf_yn IS NULL THEN
                                SET NEW.rf_tax_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_tax_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_tax_inv_del_be
                    BEFORE DELETE ON rf_tax_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_tax_inv\" INTO @tc_table_id;
                            SELECT rf_tax_inv_trf_yn FROM rf_tax_inv WHERE rf_tax_inv_ix = OLD.rf_tax_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_tax_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pf_object_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pf_object_ins_be
                BEFORE INSERT ON pf_object FOR EACH ROW
                tr_pf_object_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pf_object_ix IS NULL or NEW.pf_object_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pf_object_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pf_object_ix = ix;
                            SET NEW.pf_object_id = 0;
                            SET NEW.pf_object_db = @db_code;

                            IF NEW.pf_object_trf_yn IS NULL THEN
                                SET NEW.pf_object_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pf_object_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pf_object_ins_af
                        AFTER INSERT ON pf_object FOR EACH ROW
                        tr_pf_object_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_object\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pf_object_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pf_object_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pf_object_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pf_object_upd_be
                    BEFORE UPDATE ON pf_object FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_object\" INTO @tc_table_id;
                        SET row_transferred = OLD.pf_object_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pf_object_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pf_object_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pf_object_trf_yn IS NULL THEN
                                SET NEW.pf_object_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pf_object_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pf_object_del_be
                    BEFORE DELETE ON pf_object FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_object\" INTO @tc_table_id;
                            SELECT pf_object_trf_yn FROM pf_object WHERE pf_object_ix = OLD.pf_object_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pf_object_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pf_option_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pf_option_ins_be
                BEFORE INSERT ON pf_option FOR EACH ROW
                tr_pf_option_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pf_option_ix IS NULL or NEW.pf_option_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pf_option_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pf_option_ix = ix;
                            SET NEW.pf_option_id = 0;
                            SET NEW.pf_option_db = @db_code;

                            IF NEW.pf_option_trf_yn IS NULL THEN
                                SET NEW.pf_option_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pf_option_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pf_option_ins_af
                        AFTER INSERT ON pf_option FOR EACH ROW
                        tr_pf_option_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_option\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pf_option_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pf_option_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pf_option_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pf_option_upd_be
                    BEFORE UPDATE ON pf_option FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_option\" INTO @tc_table_id;
                        SET row_transferred = OLD.pf_option_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pf_option_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pf_option_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pf_option_trf_yn IS NULL THEN
                                SET NEW.pf_option_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pf_option_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pf_option_del_be
                    BEFORE DELETE ON pf_option FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_option\" INTO @tc_table_id;
                            SELECT pf_option_trf_yn FROM pf_option WHERE pf_option_ix = OLD.pf_option_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pf_option_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pf_field_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pf_field_ins_be
                BEFORE INSERT ON pf_field FOR EACH ROW
                tr_pf_field_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pf_field_ix IS NULL or NEW.pf_field_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pf_field_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pf_field_ix = ix;
                            SET NEW.pf_field_id = 0;
                            SET NEW.pf_field_db = @db_code;

                            IF NEW.pf_field_trf_yn IS NULL THEN
                                SET NEW.pf_field_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pf_field_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pf_field_ins_af
                        AFTER INSERT ON pf_field FOR EACH ROW
                        tr_pf_field_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_field\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pf_field_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pf_field_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pf_field_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pf_field_upd_be
                    BEFORE UPDATE ON pf_field FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_field\" INTO @tc_table_id;
                        SET row_transferred = OLD.pf_field_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pf_field_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pf_field_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pf_field_trf_yn IS NULL THEN
                                SET NEW.pf_field_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pf_field_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pf_field_del_be
                    BEFORE DELETE ON pf_field FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pf_field\" INTO @tc_table_id;
                            SELECT pf_field_trf_yn FROM pf_field WHERE pf_field_ix = OLD.pf_field_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pf_field_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zs_task_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zs_task_ins_be
                BEFORE INSERT ON zs_task FOR EACH ROW
                tr_zs_task_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zs_task_ix IS NULL or NEW.zs_task_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zs_task_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zs_task_ix = ix;
                            SET NEW.zs_task_id = 0;
                            SET NEW.zs_task_db = @db_code;

                            IF NEW.zs_task_trf_yn IS NULL THEN
                                SET NEW.zs_task_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zs_task_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zs_task_ins_af
                        AFTER INSERT ON zs_task FOR EACH ROW
                        tr_zs_task_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zs_task_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zs_task_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_task_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_task_upd_be
                    BEFORE UPDATE ON zs_task FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task\" INTO @tc_table_id;
                        SET row_transferred = OLD.zs_task_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zs_task_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zs_task_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zs_task_trf_yn IS NULL THEN
                                SET NEW.zs_task_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_task_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_task_del_be
                    BEFORE DELETE ON zs_task FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task\" INTO @tc_table_id;
                            SELECT zs_task_trf_yn FROM zs_task WHERE zs_task_ix = OLD.zs_task_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zs_task_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zs_schedule_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zs_schedule_ins_be
                BEFORE INSERT ON zs_schedule FOR EACH ROW
                tr_zs_schedule_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zs_schedule_ix IS NULL or NEW.zs_schedule_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zs_schedule_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zs_schedule_ix = ix;
                            SET NEW.zs_schedule_id = 0;
                            SET NEW.zs_schedule_db = @db_code;

                            IF NEW.zs_schedule_trf_yn IS NULL THEN
                                SET NEW.zs_schedule_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zs_schedule_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zs_schedule_ins_af
                        AFTER INSERT ON zs_schedule FOR EACH ROW
                        tr_zs_schedule_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_schedule\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zs_schedule_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zs_schedule_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_schedule_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_schedule_upd_be
                    BEFORE UPDATE ON zs_schedule FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_schedule\" INTO @tc_table_id;
                        SET row_transferred = OLD.zs_schedule_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zs_schedule_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zs_schedule_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zs_schedule_trf_yn IS NULL THEN
                                SET NEW.zs_schedule_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_schedule_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_schedule_del_be
                    BEFORE DELETE ON zs_schedule FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_schedule\" INTO @tc_table_id;
                            SELECT zs_schedule_trf_yn FROM zs_schedule WHERE zs_schedule_ix = OLD.zs_schedule_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zs_schedule_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zs_task_notify_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zs_task_notify_ins_be
                BEFORE INSERT ON zs_task_notify FOR EACH ROW
                tr_zs_task_notify_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zs_task_notify_ix IS NULL or NEW.zs_task_notify_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zs_task_notify_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zs_task_notify_ix = ix;
                            SET NEW.zs_task_notify_id = 0;
                            SET NEW.zs_task_notify_db = @db_code;

                            IF NEW.zs_task_notify_trf_yn IS NULL THEN
                                SET NEW.zs_task_notify_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zs_task_notify_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zs_task_notify_ins_af
                        AFTER INSERT ON zs_task_notify FOR EACH ROW
                        tr_zs_task_notify_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task_notify\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zs_task_notify_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zs_task_notify_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_task_notify_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_task_notify_upd_be
                    BEFORE UPDATE ON zs_task_notify FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task_notify\" INTO @tc_table_id;
                        SET row_transferred = OLD.zs_task_notify_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zs_task_notify_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zs_task_notify_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zs_task_notify_trf_yn IS NULL THEN
                                SET NEW.zs_task_notify_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_task_notify_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_task_notify_del_be
                    BEFORE DELETE ON zs_task_notify FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task_notify\" INTO @tc_table_id;
                            SELECT zs_task_notify_trf_yn FROM zs_task_notify WHERE zs_task_notify_ix = OLD.zs_task_notify_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zs_task_notify_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zs_queue_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zs_queue_ins_be
                BEFORE INSERT ON zs_queue FOR EACH ROW
                tr_zs_queue_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zs_queue_ix IS NULL or NEW.zs_queue_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zs_queue_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zs_queue_ix = ix;
                            SET NEW.zs_queue_id = 0;
                            SET NEW.zs_queue_db = @db_code;

                            IF NEW.zs_queue_trf_yn IS NULL THEN
                                SET NEW.zs_queue_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zs_queue_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zs_queue_ins_af
                        AFTER INSERT ON zs_queue FOR EACH ROW
                        tr_zs_queue_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_queue\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zs_queue_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zs_queue_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_queue_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_queue_upd_be
                    BEFORE UPDATE ON zs_queue FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_queue\" INTO @tc_table_id;
                        SET row_transferred = OLD.zs_queue_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zs_queue_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zs_queue_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zs_queue_trf_yn IS NULL THEN
                                SET NEW.zs_queue_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_queue_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_queue_del_be
                    BEFORE DELETE ON zs_queue FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_queue\" INTO @tc_table_id;
                            SELECT zs_queue_trf_yn FROM zs_queue WHERE zs_queue_ix = OLD.zs_queue_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zs_queue_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zs_task_log_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zs_task_log_ins_be
                BEFORE INSERT ON zs_task_log FOR EACH ROW
                tr_zs_task_log_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zs_task_log_ix IS NULL or NEW.zs_task_log_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zs_task_log_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zs_task_log_ix = ix;
                            SET NEW.zs_task_log_id = 0;
                            SET NEW.zs_task_log_db = @db_code;

                            IF NEW.zs_task_log_trf_yn IS NULL THEN
                                SET NEW.zs_task_log_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zs_task_log_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zs_task_log_ins_af
                        AFTER INSERT ON zs_task_log FOR EACH ROW
                        tr_zs_task_log_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task_log\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zs_task_log_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zs_task_log_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_task_log_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_task_log_upd_be
                    BEFORE UPDATE ON zs_task_log FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task_log\" INTO @tc_table_id;
                        SET row_transferred = OLD.zs_task_log_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zs_task_log_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zs_task_log_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zs_task_log_trf_yn IS NULL THEN
                                SET NEW.zs_task_log_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zs_task_log_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zs_task_log_del_be
                    BEFORE DELETE ON zs_task_log FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zs_task_log\" INTO @tc_table_id;
                            SELECT zs_task_log_trf_yn FROM zs_task_log WHERE zs_task_log_ix = OLD.zs_task_log_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zs_task_log_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_bank_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_bank_inv_ins_be
                BEFORE INSERT ON rf_bank_inv FOR EACH ROW
                tr_rf_bank_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_bank_inv_ix IS NULL or NEW.rf_bank_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_bank_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_bank_inv_ix = ix;
                            SET NEW.rf_bank_inv_id = 0;
                            SET NEW.rf_bank_inv_db = @db_code;

                            IF NEW.rf_bank_inv_trf_yn IS NULL THEN
                                SET NEW.rf_bank_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_bank_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_bank_inv_ins_af
                        AFTER INSERT ON rf_bank_inv FOR EACH ROW
                        tr_rf_bank_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_bank_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_bank_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_bank_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_bank_inv_upd_be
                    BEFORE UPDATE ON rf_bank_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_bank_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_bank_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_bank_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_bank_inv_trf_yn IS NULL THEN
                                SET NEW.rf_bank_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_bank_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_bank_inv_del_be
                    BEFORE DELETE ON rf_bank_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_bank_inv\" INTO @tc_table_id;
                            SELECT rf_bank_inv_trf_yn FROM rf_bank_inv WHERE rf_bank_inv_ix = OLD.rf_bank_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_bank_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_batch_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_batch_ins_be
                BEFORE INSERT ON fn_batch FOR EACH ROW
                tr_fn_batch_ins_be: BEGIN
                    -- Indicator: 3
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();
                            
                            IF IF(NEW.fn_batch_ix IS NULL or NEW.fn_batch_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_batch_ins_be;
                            END IF;

                            SET prefix = NEW.fn_batch_prefix;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"fn_batch\"
                                AND tc_sequence_db_code = @db_code
                                AND tc_sequence_prefix = prefix;

                            IF tc_sequence_already_exists IS FALSE THEN
                                    SELECT 
                                        IFNULL(MAX(fn_batch.fn_batch_id),0) + 1
                                    INTO
                                        new_tc_sequence_increment
                                    FROM
                                        fn_batch
                                    WHERE
                                        fn_batch.fn_batch_db = @db_code
                                        AND fn_batch.fn_batch_prefix = prefix;
                                    IF new_tc_sequence_increment IS NULL THEN
                                        SET new_tc_sequence_increment = 1;
                                    ELSEIF new_tc_sequence_increment = 0 THEN
                                        SET new_tc_sequence_increment = 1;
                                    END IF;

                                    INSERT IGNORE INTO tc_sequence (
                                        tc_sequence_table_name,
                                        tc_sequence_db_code,
                                        tc_sequence_prefix,
                                        tc_sequence_next_id
                                    ) VALUES (
                                        \"fn_batch\",
                                        @db_code,
                                        prefix,
                                        new_tc_sequence_increment
                                    );
                                END IF;

                                SELECT -- Get the ID to use for this insert
                                    tc_sequence_next_id
                                FROM
                                    tc_sequence
                                WHERE
                                    tc_sequence_table_name = \"fn_batch\"
                                    AND tc_sequence_db_code = @db_code
                                    AND tc_sequence_prefix = prefix
                                INTO id;
                                
                                SET ix = CONCAT(@db_code, prefix, id);

                                SELECT COUNT(*) -- Check if a record with the next ID already exists
                                FROM
                                    fn_batch
                                WHERE
                                    fn_batch.fn_batch_ix = ix
                                INTO ix_already_exists;

                                SELECT MAX(fn_batch.fn_batch_id) -- Get the highest ID in table
                                FROM
                                    fn_batch
                                WHERE
                                    fn_batch_db = @db_code
                                    AND fn_batch_prefix = prefix
                                INTO table_max_id;

                                IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                    UPDATE
                                        tc_sequence
                                        INNER JOIN fn_batch ON fn_batch.fn_batch_db = tc_sequence.tc_sequence_db_code
                                    SET
                                        tc_sequence.tc_sequence_next_id = table_max_id + 1
                                    WHERE
                                        tc_sequence_table_name = \"fn_batch\"
                                        AND tc_sequence_db_code = @db_code
                                        AND tc_sequence_prefix = prefix;
                                    SET id = table_max_id + 1;
                                    SET ix = CONCAT(@db_code, prefix, id);
                                ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                    UPDATE
                                        tc_sequence
                                        INNER JOIN fn_batch ON fn_batch.fn_batch_db = tc_sequence.tc_sequence_db_code
                                    SET
                                        tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                    WHERE
                                        tc_sequence_table_name = \"fn_batch\"
                                        AND tc_sequence_db_code = @db_code
                                        AND tc_sequence_prefix = prefix;
                                    SET id = id + 1;
                                    SET ix = CONCAT(@db_code, prefix, id);
                                END IF;

                                SET NEW.fn_batch_db = @db_code;
                                SET NEW.fn_batch_id = id;
                                SET NEW.fn_batch_ix = ix;
                                
                                IF NEW.fn_batch_trf_yn IS NULL THEN
                                    SET NEW.fn_batch_trf_yn = 0;
                                END IF;

                                UPDATE -- Increment tc_sequence entry for next record
                                    tc_sequence
                                    INNER JOIN fn_batch ON fn_batch.fn_batch_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"fn_batch\"
                                    AND tc_sequence_db_code = @db_code
                                    AND tc_sequence_prefix = prefix;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_batch_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_batch_ins_af
                        AFTER INSERT ON fn_batch FOR EACH ROW
                        tr_fn_batch_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_batch\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_batch_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_batch_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_batch_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_batch_upd_be
                    BEFORE UPDATE ON fn_batch FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_batch\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_batch_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_batch_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_batch_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_batch_trf_yn IS NULL THEN
                                SET NEW.fn_batch_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_batch_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_batch_del_be
                    BEFORE DELETE ON fn_batch FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_batch\" INTO @tc_table_id;
                            SELECT fn_batch_trf_yn FROM fn_batch WHERE fn_batch_ix = OLD.fn_batch_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_batch_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_tran_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_tran_ins_be
                BEFORE INSERT ON fn_tran FOR EACH ROW
                tr_fn_tran_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_tran_ix IS NULL or NEW.fn_tran_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_tran_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"fn_tran\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(fn_tran.fn_tran_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    fn_tran
                                WHERE
                                    fn_tran.fn_tran_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"fn_tran\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"fn_tran\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                fn_tran
                            WHERE
                                fn_tran.fn_tran_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(fn_tran.fn_tran_id) -- Get the highest ID in table
                            FROM
                                fn_tran
                            WHERE
                                fn_tran_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN fn_tran ON fn_tran.fn_tran_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"fn_tran\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN fn_tran ON fn_tran.fn_tran_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"fn_tran\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.fn_tran_db = @db_code;
                            SET NEW.fn_tran_id = id;
                            SET NEW.fn_tran_ix = ix;

                            IF NEW.fn_tran_trf_yn IS NULL THEN
                                SET NEW.fn_tran_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN fn_tran ON fn_tran.fn_tran_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"fn_tran\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_tran_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_tran_ins_af
                        AFTER INSERT ON fn_tran FOR EACH ROW
                        tr_fn_tran_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_tran\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_tran_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_tran_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_tran_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_tran_upd_be
                    BEFORE UPDATE ON fn_tran FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_tran\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_tran_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_tran_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_tran_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_tran_trf_yn IS NULL THEN
                                SET NEW.fn_tran_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_tran_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_tran_del_be
                    BEFORE DELETE ON fn_tran FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_tran\" INTO @tc_table_id;
                            SELECT fn_tran_trf_yn FROM fn_tran WHERE fn_tran_ix = OLD.fn_tran_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_tran_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_tran_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_tran_item_ins_be
                BEFORE INSERT ON fn_tran_item FOR EACH ROW
                tr_fn_tran_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_tran_item_ix IS NULL or NEW.fn_tran_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_tran_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_tran_item_ix = ix;
                            SET NEW.fn_tran_item_id = 0;
                            SET NEW.fn_tran_item_db = @db_code;

                            IF NEW.fn_tran_item_trf_yn IS NULL THEN
                                SET NEW.fn_tran_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_tran_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_tran_item_ins_af
                        AFTER INSERT ON fn_tran_item FOR EACH ROW
                        tr_fn_tran_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_tran_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_tran_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_tran_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_tran_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_tran_item_upd_be
                    BEFORE UPDATE ON fn_tran_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_tran_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_tran_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_tran_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_tran_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_tran_item_trf_yn IS NULL THEN
                                SET NEW.fn_tran_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_tran_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_tran_item_del_be
                    BEFORE DELETE ON fn_tran_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_tran_item\" INTO @tc_table_id;
                            SELECT fn_tran_item_trf_yn FROM fn_tran_item WHERE fn_tran_item_ix = OLD.fn_tran_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_tran_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_year_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_year_ins_be
                BEFORE INSERT ON fn_year FOR EACH ROW
                tr_fn_year_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_year_ix IS NULL or NEW.fn_year_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_year_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_year_ix = ix;
                            SET NEW.fn_year_id = 0;
                            SET NEW.fn_year_db = @db_code;

                            IF NEW.fn_year_trf_yn IS NULL THEN
                                SET NEW.fn_year_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_year_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_year_ins_af
                        AFTER INSERT ON fn_year FOR EACH ROW
                        tr_fn_year_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_year\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_year_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_year_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_year_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_year_upd_be
                    BEFORE UPDATE ON fn_year FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_year\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_year_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_year_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_year_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_year_trf_yn IS NULL THEN
                                SET NEW.fn_year_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_year_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_year_del_be
                    BEFORE DELETE ON fn_year FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_year\" INTO @tc_table_id;
                            SELECT fn_year_trf_yn FROM fn_year WHERE fn_year_ix = OLD.fn_year_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_year_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ad_batch_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ad_batch_ins_be
                BEFORE INSERT ON ad_batch FOR EACH ROW
                tr_ad_batch_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ad_batch_ix IS NULL or NEW.ad_batch_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ad_batch_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ad_batch_ix = ix;
                            SET NEW.ad_batch_id = 0;
                            SET NEW.ad_batch_db = @db_code;

                            IF NEW.ad_batch_trf_yn IS NULL THEN
                                SET NEW.ad_batch_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ad_batch_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ad_batch_ins_af
                        AFTER INSERT ON ad_batch FOR EACH ROW
                        tr_ad_batch_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_batch\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ad_batch_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ad_batch_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_batch_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_batch_upd_be
                    BEFORE UPDATE ON ad_batch FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_batch\" INTO @tc_table_id;
                        SET row_transferred = OLD.ad_batch_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ad_batch_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ad_batch_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ad_batch_trf_yn IS NULL THEN
                                SET NEW.ad_batch_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_batch_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_batch_del_be
                    BEFORE DELETE ON ad_batch FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_batch\" INTO @tc_table_id;
                            SELECT ad_batch_trf_yn FROM ad_batch WHERE ad_batch_ix = OLD.ad_batch_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ad_batch_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_tr_rule_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_tr_rule_ins_be
                BEFORE INSERT ON tr_rule FOR EACH ROW
                tr_tr_rule_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.tr_rule_ix IS NULL or NEW.tr_rule_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_tr_rule_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.tr_rule_ix = ix;
                            SET NEW.tr_rule_id = 0;
                            SET NEW.tr_rule_db = @db_code;

                            IF NEW.tr_rule_trf_yn IS NULL THEN
                                SET NEW.tr_rule_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_tr_rule_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_tr_rule_ins_af
                        AFTER INSERT ON tr_rule FOR EACH ROW
                        tr_tr_rule_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tr_rule\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.tr_rule_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_tr_rule_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tr_rule_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tr_rule_upd_be
                    BEFORE UPDATE ON tr_rule FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tr_rule\" INTO @tc_table_id;
                        SET row_transferred = OLD.tr_rule_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.tr_rule_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.tr_rule_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.tr_rule_trf_yn IS NULL THEN
                                SET NEW.tr_rule_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tr_rule_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tr_rule_del_be
                    BEFORE DELETE ON tr_rule FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tr_rule\" INTO @tc_table_id;
                            SELECT tr_rule_trf_yn FROM tr_rule WHERE tr_rule_ix = OLD.tr_rule_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.tr_rule_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_tr_rule_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_tr_rule_item_ins_be
                BEFORE INSERT ON tr_rule_item FOR EACH ROW
                tr_tr_rule_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.tr_rule_item_ix IS NULL or NEW.tr_rule_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_tr_rule_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.tr_rule_item_ix = ix;
                            SET NEW.tr_rule_item_id = 0;
                            SET NEW.tr_rule_item_db = @db_code;

                            IF NEW.tr_rule_item_trf_yn IS NULL THEN
                                SET NEW.tr_rule_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_tr_rule_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_tr_rule_item_ins_af
                        AFTER INSERT ON tr_rule_item FOR EACH ROW
                        tr_tr_rule_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tr_rule_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.tr_rule_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_tr_rule_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tr_rule_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tr_rule_item_upd_be
                    BEFORE UPDATE ON tr_rule_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tr_rule_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.tr_rule_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.tr_rule_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.tr_rule_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.tr_rule_item_trf_yn IS NULL THEN
                                SET NEW.tr_rule_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_tr_rule_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_tr_rule_item_del_be
                    BEFORE DELETE ON tr_rule_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"tr_rule_item\" INTO @tc_table_id;
                            SELECT tr_rule_item_trf_yn FROM tr_rule_item WHERE tr_rule_item_ix = OLD.tr_rule_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.tr_rule_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zg_account_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zg_account_ins_be
                BEFORE INSERT ON zg_account FOR EACH ROW
                tr_zg_account_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zg_account_ix IS NULL or NEW.zg_account_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zg_account_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zg_account_ix = ix;
                            SET NEW.zg_account_id = 0;
                            SET NEW.zg_account_db = @db_code;

                            IF NEW.zg_account_trf_yn IS NULL THEN
                                SET NEW.zg_account_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zg_account_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zg_account_ins_af
                        AFTER INSERT ON zg_account FOR EACH ROW
                        tr_zg_account_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_account\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zg_account_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zg_account_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_account_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_account_upd_be
                    BEFORE UPDATE ON zg_account FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_account\" INTO @tc_table_id;
                        SET row_transferred = OLD.zg_account_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zg_account_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zg_account_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zg_account_trf_yn IS NULL THEN
                                SET NEW.zg_account_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_account_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_account_del_be
                    BEFORE DELETE ON zg_account FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_account\" INTO @tc_table_id;
                            SELECT zg_account_trf_yn FROM zg_account WHERE zg_account_ix = OLD.zg_account_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zg_account_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zg_account_prop_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zg_account_prop_ins_be
                BEFORE INSERT ON zg_account_prop FOR EACH ROW
                tr_zg_account_prop_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zg_account_prop_ix IS NULL or NEW.zg_account_prop_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zg_account_prop_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zg_account_prop_ix = ix;
                            SET NEW.zg_account_prop_id = 0;
                            SET NEW.zg_account_prop_db = @db_code;

                            IF NEW.zg_account_prop_trf_yn IS NULL THEN
                                SET NEW.zg_account_prop_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zg_account_prop_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zg_account_prop_ins_af
                        AFTER INSERT ON zg_account_prop FOR EACH ROW
                        tr_zg_account_prop_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_account_prop\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zg_account_prop_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zg_account_prop_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_account_prop_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_account_prop_upd_be
                    BEFORE UPDATE ON zg_account_prop FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_account_prop\" INTO @tc_table_id;
                        SET row_transferred = OLD.zg_account_prop_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zg_account_prop_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zg_account_prop_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zg_account_prop_trf_yn IS NULL THEN
                                SET NEW.zg_account_prop_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_account_prop_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_account_prop_del_be
                    BEFORE DELETE ON zg_account_prop FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_account_prop\" INTO @tc_table_id;
                            SELECT zg_account_prop_trf_yn FROM zg_account_prop WHERE zg_account_prop_ix = OLD.zg_account_prop_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zg_account_prop_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zg_transfer_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zg_transfer_ins_be
                BEFORE INSERT ON zg_transfer FOR EACH ROW
                tr_zg_transfer_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zg_transfer_ix IS NULL or NEW.zg_transfer_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zg_transfer_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zg_transfer_ix = ix;
                            SET NEW.zg_transfer_id = 0;
                            SET NEW.zg_transfer_db = @db_code;

                            IF NEW.zg_transfer_trf_yn IS NULL THEN
                                SET NEW.zg_transfer_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zg_transfer_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zg_transfer_ins_af
                        AFTER INSERT ON zg_transfer FOR EACH ROW
                        tr_zg_transfer_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zg_transfer_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zg_transfer_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_transfer_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_transfer_upd_be
                    BEFORE UPDATE ON zg_transfer FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer\" INTO @tc_table_id;
                        SET row_transferred = OLD.zg_transfer_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zg_transfer_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zg_transfer_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zg_transfer_trf_yn IS NULL THEN
                                SET NEW.zg_transfer_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_transfer_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_transfer_del_be
                    BEFORE DELETE ON zg_transfer FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer\" INTO @tc_table_id;
                            SELECT zg_transfer_trf_yn FROM zg_transfer WHERE zg_transfer_ix = OLD.zg_transfer_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zg_transfer_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zg_transfer_guest_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zg_transfer_guest_ins_be
                BEFORE INSERT ON zg_transfer_guest FOR EACH ROW
                tr_zg_transfer_guest_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zg_transfer_guest_ix IS NULL or NEW.zg_transfer_guest_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zg_transfer_guest_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"zg_transfer_guest\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(zg_transfer_guest.zg_transfer_guest_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    zg_transfer_guest
                                WHERE
                                    zg_transfer_guest.zg_transfer_guest_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"zg_transfer_guest\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"zg_transfer_guest\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                zg_transfer_guest
                            WHERE
                                zg_transfer_guest.zg_transfer_guest_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(zg_transfer_guest.zg_transfer_guest_id) -- Get the highest ID in table
                            FROM
                                zg_transfer_guest
                            WHERE
                                zg_transfer_guest_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN zg_transfer_guest ON zg_transfer_guest.zg_transfer_guest_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"zg_transfer_guest\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN zg_transfer_guest ON zg_transfer_guest.zg_transfer_guest_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"zg_transfer_guest\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.zg_transfer_guest_db = @db_code;
                            SET NEW.zg_transfer_guest_id = id;
                            SET NEW.zg_transfer_guest_ix = ix;

                            IF NEW.zg_transfer_guest_trf_yn IS NULL THEN
                                SET NEW.zg_transfer_guest_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN zg_transfer_guest ON zg_transfer_guest.zg_transfer_guest_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"zg_transfer_guest\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zg_transfer_guest_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zg_transfer_guest_ins_af
                        AFTER INSERT ON zg_transfer_guest FOR EACH ROW
                        tr_zg_transfer_guest_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer_guest\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zg_transfer_guest_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zg_transfer_guest_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_transfer_guest_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_transfer_guest_upd_be
                    BEFORE UPDATE ON zg_transfer_guest FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer_guest\" INTO @tc_table_id;
                        SET row_transferred = OLD.zg_transfer_guest_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zg_transfer_guest_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zg_transfer_guest_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zg_transfer_guest_trf_yn IS NULL THEN
                                SET NEW.zg_transfer_guest_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_transfer_guest_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_transfer_guest_del_be
                    BEFORE DELETE ON zg_transfer_guest FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer_guest\" INTO @tc_table_id;
                            SELECT zg_transfer_guest_trf_yn FROM zg_transfer_guest WHERE zg_transfer_guest_ix = OLD.zg_transfer_guest_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zg_transfer_guest_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_obj_guest_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_obj_guest_ins_be
                BEFORE INSERT ON rf_obj_guest FOR EACH ROW
                tr_rf_obj_guest_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_obj_guest_ix IS NULL or NEW.rf_obj_guest_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_obj_guest_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_obj_guest_ix = ix;
                            SET NEW.rf_obj_guest_id = 0;
                            SET NEW.rf_obj_guest_db = @db_code;

                            IF NEW.rf_obj_guest_trf_yn IS NULL THEN
                                SET NEW.rf_obj_guest_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_obj_guest_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_obj_guest_ins_af
                        AFTER INSERT ON rf_obj_guest FOR EACH ROW
                        tr_rf_obj_guest_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_guest\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_obj_guest_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_obj_guest_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_guest_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_guest_upd_be
                    BEFORE UPDATE ON rf_obj_guest FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_guest\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_obj_guest_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_obj_guest_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_obj_guest_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_obj_guest_trf_yn IS NULL THEN
                                SET NEW.rf_obj_guest_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_guest_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_guest_del_be
                    BEFORE DELETE ON rf_obj_guest FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_guest\" INTO @tc_table_id;
                            SELECT rf_obj_guest_trf_yn FROM rf_obj_guest WHERE rf_obj_guest_ix = OLD.rf_obj_guest_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_obj_guest_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_obj_guest_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_obj_guest_data_ins_be
                BEFORE INSERT ON rf_obj_guest_data FOR EACH ROW
                tr_rf_obj_guest_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_obj_guest_data_ix IS NULL or NEW.rf_obj_guest_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_obj_guest_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_obj_guest_data_ix = ix;
                            SET NEW.rf_obj_guest_data_id = 0;
                            SET NEW.rf_obj_guest_data_db = @db_code;

                            IF NEW.rf_obj_guest_data_trf_yn IS NULL THEN
                                SET NEW.rf_obj_guest_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_obj_guest_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_obj_guest_data_ins_af
                        AFTER INSERT ON rf_obj_guest_data FOR EACH ROW
                        tr_rf_obj_guest_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_guest_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_obj_guest_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_obj_guest_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_guest_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_guest_data_upd_be
                    BEFORE UPDATE ON rf_obj_guest_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_guest_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_obj_guest_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_obj_guest_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_obj_guest_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_obj_guest_data_trf_yn IS NULL THEN
                                SET NEW.rf_obj_guest_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_guest_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_guest_data_del_be
                    BEFORE DELETE ON rf_obj_guest_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_guest_data\" INTO @tc_table_id;
                            SELECT rf_obj_guest_data_trf_yn FROM rf_obj_guest_data WHERE rf_obj_guest_data_ix = OLD.rf_obj_guest_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_obj_guest_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_obj_trip_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_obj_trip_ins_be
                BEFORE INSERT ON rf_obj_trip FOR EACH ROW
                tr_rf_obj_trip_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_obj_trip_ix IS NULL or NEW.rf_obj_trip_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_obj_trip_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_obj_trip_ix = ix;
                            SET NEW.rf_obj_trip_id = 0;
                            SET NEW.rf_obj_trip_db = @db_code;

                            IF NEW.rf_obj_trip_trf_yn IS NULL THEN
                                SET NEW.rf_obj_trip_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_obj_trip_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_obj_trip_ins_af
                        AFTER INSERT ON rf_obj_trip FOR EACH ROW
                        tr_rf_obj_trip_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_obj_trip_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_obj_trip_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_trip_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_trip_upd_be
                    BEFORE UPDATE ON rf_obj_trip FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_obj_trip_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_obj_trip_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_obj_trip_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_obj_trip_trf_yn IS NULL THEN
                                SET NEW.rf_obj_trip_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_trip_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_trip_del_be
                    BEFORE DELETE ON rf_obj_trip FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip\" INTO @tc_table_id;
                            SELECT rf_obj_trip_trf_yn FROM rf_obj_trip WHERE rf_obj_trip_ix = OLD.rf_obj_trip_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_obj_trip_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_obj_trip_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_obj_trip_data_ins_be
                BEFORE INSERT ON rf_obj_trip_data FOR EACH ROW
                tr_rf_obj_trip_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_obj_trip_data_ix IS NULL or NEW.rf_obj_trip_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_obj_trip_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_obj_trip_data_ix = ix;
                            SET NEW.rf_obj_trip_data_id = 0;
                            SET NEW.rf_obj_trip_data_db = @db_code;

                            IF NEW.rf_obj_trip_data_trf_yn IS NULL THEN
                                SET NEW.rf_obj_trip_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_obj_trip_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_obj_trip_data_ins_af
                        AFTER INSERT ON rf_obj_trip_data FOR EACH ROW
                        tr_rf_obj_trip_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_obj_trip_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_obj_trip_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_trip_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_trip_data_upd_be
                    BEFORE UPDATE ON rf_obj_trip_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_obj_trip_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_obj_trip_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_obj_trip_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_obj_trip_data_trf_yn IS NULL THEN
                                SET NEW.rf_obj_trip_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_trip_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_trip_data_del_be
                    BEFORE DELETE ON rf_obj_trip_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip_data\" INTO @tc_table_id;
                            SELECT rf_obj_trip_data_trf_yn FROM rf_obj_trip_data WHERE rf_obj_trip_data_ix = OLD.rf_obj_trip_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_obj_trip_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_obj_trip_prop_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_obj_trip_prop_ins_be
                BEFORE INSERT ON rf_obj_trip_prop FOR EACH ROW
                tr_rf_obj_trip_prop_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_obj_trip_prop_ix IS NULL or NEW.rf_obj_trip_prop_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_obj_trip_prop_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_obj_trip_prop_ix = ix;
                            SET NEW.rf_obj_trip_prop_id = 0;
                            SET NEW.rf_obj_trip_prop_db = @db_code;

                            IF NEW.rf_obj_trip_prop_trf_yn IS NULL THEN
                                SET NEW.rf_obj_trip_prop_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_obj_trip_prop_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_obj_trip_prop_ins_af
                        AFTER INSERT ON rf_obj_trip_prop FOR EACH ROW
                        tr_rf_obj_trip_prop_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip_prop\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_obj_trip_prop_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_obj_trip_prop_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_trip_prop_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_trip_prop_upd_be
                    BEFORE UPDATE ON rf_obj_trip_prop FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip_prop\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_obj_trip_prop_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_obj_trip_prop_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_obj_trip_prop_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_obj_trip_prop_trf_yn IS NULL THEN
                                SET NEW.rf_obj_trip_prop_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_obj_trip_prop_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_obj_trip_prop_del_be
                    BEFORE DELETE ON rf_obj_trip_prop FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_obj_trip_prop\" INTO @tc_table_id;
                            SELECT rf_obj_trip_prop_trf_yn FROM rf_obj_trip_prop WHERE rf_obj_trip_prop_ix = OLD.rf_obj_trip_prop_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_obj_trip_prop_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_guest_obj_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_guest_obj_data_ins_be
                BEFORE INSERT ON pr_guest_obj_data FOR EACH ROW
                tr_pr_guest_obj_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_guest_obj_data_ix IS NULL or NEW.pr_guest_obj_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_guest_obj_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_guest_obj_data_ix = ix;
                            SET NEW.pr_guest_obj_data_id = 0;
                            SET NEW.pr_guest_obj_data_db = @db_code;

                            IF NEW.pr_guest_obj_data_trf_yn IS NULL THEN
                                SET NEW.pr_guest_obj_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_guest_obj_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_guest_obj_data_ins_af
                        AFTER INSERT ON pr_guest_obj_data FOR EACH ROW
                        tr_pr_guest_obj_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_guest_obj_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_guest_obj_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_guest_obj_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_guest_obj_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_guest_obj_data_upd_be
                    BEFORE UPDATE ON pr_guest_obj_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_guest_obj_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_guest_obj_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_guest_obj_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_guest_obj_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_guest_obj_data_trf_yn IS NULL THEN
                                SET NEW.pr_guest_obj_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_guest_obj_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_guest_obj_data_del_be
                    BEFORE DELETE ON pr_guest_obj_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_guest_obj_data\" INTO @tc_table_id;
                            SELECT pr_guest_obj_data_trf_yn FROM pr_guest_obj_data WHERE pr_guest_obj_data_ix = OLD.pr_guest_obj_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_guest_obj_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_trip_obj_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_trip_obj_data_ins_be
                BEFORE INSERT ON rv_trip_obj_data FOR EACH ROW
                tr_rv_trip_obj_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_trip_obj_data_ix IS NULL or NEW.rv_trip_obj_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_trip_obj_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_trip_obj_data_ix = ix;
                            SET NEW.rv_trip_obj_data_id = 0;
                            SET NEW.rv_trip_obj_data_db = @db_code;

                            IF NEW.rv_trip_obj_data_trf_yn IS NULL THEN
                                SET NEW.rv_trip_obj_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_trip_obj_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_trip_obj_data_ins_af
                        AFTER INSERT ON rv_trip_obj_data FOR EACH ROW
                        tr_rv_trip_obj_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_trip_obj_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_trip_obj_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_trip_obj_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_trip_obj_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_trip_obj_data_upd_be
                    BEFORE UPDATE ON rv_trip_obj_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_trip_obj_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_trip_obj_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_trip_obj_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_trip_obj_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_trip_obj_data_trf_yn IS NULL THEN
                                SET NEW.rv_trip_obj_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_trip_obj_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_trip_obj_data_del_be
                    BEFORE DELETE ON rv_trip_obj_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_trip_obj_data\" INTO @tc_table_id;
                            SELECT rv_trip_obj_data_trf_yn FROM rv_trip_obj_data WHERE rv_trip_obj_data_ix = OLD.rv_trip_obj_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_trip_obj_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_note_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_note_ins_be
                BEFORE INSERT ON rv_note FOR EACH ROW
                tr_rv_note_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_note_ix IS NULL or NEW.rv_note_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_note_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_note_ix = ix;
                            SET NEW.rv_note_id = 0;
                            SET NEW.rv_note_db = @db_code;

                            IF NEW.rv_note_trf_yn IS NULL THEN
                                SET NEW.rv_note_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_note_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_note_ins_af
                        AFTER INSERT ON rv_note FOR EACH ROW
                        tr_rv_note_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_note\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_note_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_note_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_note_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_note_upd_be
                    BEFORE UPDATE ON rv_note FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_note\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_note_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_note_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_note_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_note_trf_yn IS NULL THEN
                                SET NEW.rv_note_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_note_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_note_del_be
                    BEFORE DELETE ON rv_note FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_note\" INTO @tc_table_id;
                            SELECT rv_note_trf_yn FROM rv_note WHERE rv_note_ix = OLD.rv_note_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_note_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_event_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_event_ins_be
                BEFORE INSERT ON pr_event FOR EACH ROW
                tr_pr_event_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_event_ix IS NULL or NEW.pr_event_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_event_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_event_ix = ix;
                            SET NEW.pr_event_id = 0;
                            SET NEW.pr_event_db = @db_code;

                            IF NEW.pr_event_trf_yn IS NULL THEN
                                SET NEW.pr_event_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_event_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_event_ins_af
                        AFTER INSERT ON pr_event FOR EACH ROW
                        tr_pr_event_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_event\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_event_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_event_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_event_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_event_upd_be
                    BEFORE UPDATE ON pr_event FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_event\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_event_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_event_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_event_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_event_trf_yn IS NULL THEN
                                SET NEW.pr_event_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_event_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_event_del_be
                    BEFORE DELETE ON pr_event FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_event\" INTO @tc_table_id;
                            SELECT pr_event_trf_yn FROM pr_event WHERE pr_event_ix = OLD.pr_event_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_event_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_event_persona_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_event_persona_ins_be
                BEFORE INSERT ON pr_event_persona FOR EACH ROW
                tr_pr_event_persona_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_event_persona_ix IS NULL or NEW.pr_event_persona_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_event_persona_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_event_persona_ix = ix;
                            SET NEW.pr_event_persona_id = 0;
                            SET NEW.pr_event_persona_db = @db_code;

                            IF NEW.pr_event_persona_trf_yn IS NULL THEN
                                SET NEW.pr_event_persona_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_event_persona_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_event_persona_ins_af
                        AFTER INSERT ON pr_event_persona FOR EACH ROW
                        tr_pr_event_persona_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_event_persona\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_event_persona_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_event_persona_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_event_persona_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_event_persona_upd_be
                    BEFORE UPDATE ON pr_event_persona FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_event_persona\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_event_persona_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_event_persona_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_event_persona_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_event_persona_trf_yn IS NULL THEN
                                SET NEW.pr_event_persona_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_event_persona_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_event_persona_del_be
                    BEFORE DELETE ON pr_event_persona FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_event_persona\" INTO @tc_table_id;
                            SELECT pr_event_persona_trf_yn FROM pr_event_persona WHERE pr_event_persona_ix = OLD.pr_event_persona_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_event_persona_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_sales_obj_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_sales_obj_data_ins_be
                BEFORE INSERT ON pr_sales_obj_data FOR EACH ROW
                tr_pr_sales_obj_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_sales_obj_data_ix IS NULL or NEW.pr_sales_obj_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_sales_obj_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_sales_obj_data_ix = ix;
                            SET NEW.pr_sales_obj_data_id = 0;
                            SET NEW.pr_sales_obj_data_db = @db_code;

                            IF NEW.pr_sales_obj_data_trf_yn IS NULL THEN
                                SET NEW.pr_sales_obj_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_sales_obj_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_sales_obj_data_ins_af
                        AFTER INSERT ON pr_sales_obj_data FOR EACH ROW
                        tr_pr_sales_obj_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_sales_obj_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_sales_obj_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_sales_obj_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_sales_obj_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_sales_obj_data_upd_be
                    BEFORE UPDATE ON pr_sales_obj_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_sales_obj_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_sales_obj_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_sales_obj_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_sales_obj_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_sales_obj_data_trf_yn IS NULL THEN
                                SET NEW.pr_sales_obj_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_sales_obj_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_sales_obj_data_del_be
                    BEFORE DELETE ON pr_sales_obj_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_sales_obj_data\" INTO @tc_table_id;
                            SELECT pr_sales_obj_data_trf_yn FROM pr_sales_obj_data WHERE pr_sales_obj_data_ix = OLD.pr_sales_obj_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_sales_obj_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rc_action_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rc_action_ins_be
                BEFORE INSERT ON rc_action FOR EACH ROW
                tr_rc_action_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rc_action_ix IS NULL or NEW.rc_action_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rc_action_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rc_action_ix = ix;
                            SET NEW.rc_action_id = 0;
                            SET NEW.rc_action_db = @db_code;

                            IF NEW.rc_action_trf_yn IS NULL THEN
                                SET NEW.rc_action_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rc_action_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rc_action_ins_af
                        AFTER INSERT ON rc_action FOR EACH ROW
                        tr_rc_action_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_action\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rc_action_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rc_action_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_action_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_action_upd_be
                    BEFORE UPDATE ON rc_action FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_action\" INTO @tc_table_id;
                        SET row_transferred = OLD.rc_action_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rc_action_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rc_action_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rc_action_trf_yn IS NULL THEN
                                SET NEW.rc_action_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_action_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_action_del_be
                    BEFORE DELETE ON rc_action FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_action\" INTO @tc_table_id;
                            SELECT rc_action_trf_yn FROM rc_action WHERE rc_action_ix = OLD.rc_action_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rc_action_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rc_event_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rc_event_ins_be
                BEFORE INSERT ON rc_event FOR EACH ROW
                tr_rc_event_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rc_event_ix IS NULL or NEW.rc_event_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rc_event_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rc_event_ix = ix;
                            SET NEW.rc_event_id = 0;
                            SET NEW.rc_event_db = @db_code;

                            IF NEW.rc_event_trf_yn IS NULL THEN
                                SET NEW.rc_event_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rc_event_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rc_event_ins_af
                        AFTER INSERT ON rc_event FOR EACH ROW
                        tr_rc_event_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_event\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rc_event_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rc_event_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_event_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_event_upd_be
                    BEFORE UPDATE ON rc_event FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_event\" INTO @tc_table_id;
                        SET row_transferred = OLD.rc_event_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rc_event_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rc_event_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rc_event_trf_yn IS NULL THEN
                                SET NEW.rc_event_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_event_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_event_del_be
                    BEFORE DELETE ON rc_event FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_event\" INTO @tc_table_id;
                            SELECT rc_event_trf_yn FROM rc_event WHERE rc_event_ix = OLD.rc_event_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rc_event_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rc_event_tag_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rc_event_tag_ins_be
                BEFORE INSERT ON rc_event_tag FOR EACH ROW
                tr_rc_event_tag_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rc_event_tag_ix IS NULL or NEW.rc_event_tag_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rc_event_tag_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rc_event_tag_ix = ix;
                            SET NEW.rc_event_tag_id = 0;
                            SET NEW.rc_event_tag_db = @db_code;

                            IF NEW.rc_event_tag_trf_yn IS NULL THEN
                                SET NEW.rc_event_tag_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rc_event_tag_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rc_event_tag_ins_af
                        AFTER INSERT ON rc_event_tag FOR EACH ROW
                        tr_rc_event_tag_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_event_tag\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rc_event_tag_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rc_event_tag_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_event_tag_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_event_tag_upd_be
                    BEFORE UPDATE ON rc_event_tag FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_event_tag\" INTO @tc_table_id;
                        SET row_transferred = OLD.rc_event_tag_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rc_event_tag_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rc_event_tag_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rc_event_tag_trf_yn IS NULL THEN
                                SET NEW.rc_event_tag_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_event_tag_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_event_tag_del_be
                    BEFORE DELETE ON rc_event_tag FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_event_tag\" INTO @tc_table_id;
                            SELECT rc_event_tag_trf_yn FROM rc_event_tag WHERE rc_event_tag_ix = OLD.rc_event_tag_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rc_event_tag_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rc_obj_sales_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rc_obj_sales_ins_be
                BEFORE INSERT ON rc_obj_sales FOR EACH ROW
                tr_rc_obj_sales_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rc_obj_sales_ix IS NULL or NEW.rc_obj_sales_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rc_obj_sales_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rc_obj_sales_ix = ix;
                            SET NEW.rc_obj_sales_id = 0;
                            SET NEW.rc_obj_sales_db = @db_code;

                            IF NEW.rc_obj_sales_trf_yn IS NULL THEN
                                SET NEW.rc_obj_sales_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rc_obj_sales_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rc_obj_sales_ins_af
                        AFTER INSERT ON rc_obj_sales FOR EACH ROW
                        tr_rc_obj_sales_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_obj_sales\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rc_obj_sales_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rc_obj_sales_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_obj_sales_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_obj_sales_upd_be
                    BEFORE UPDATE ON rc_obj_sales FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_obj_sales\" INTO @tc_table_id;
                        SET row_transferred = OLD.rc_obj_sales_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rc_obj_sales_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rc_obj_sales_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rc_obj_sales_trf_yn IS NULL THEN
                                SET NEW.rc_obj_sales_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_obj_sales_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_obj_sales_del_be
                    BEFORE DELETE ON rc_obj_sales FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_obj_sales\" INTO @tc_table_id;
                            SELECT rc_obj_sales_trf_yn FROM rc_obj_sales WHERE rc_obj_sales_ix = OLD.rc_obj_sales_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rc_obj_sales_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rc_obj_sales_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rc_obj_sales_data_ins_be
                BEFORE INSERT ON rc_obj_sales_data FOR EACH ROW
                tr_rc_obj_sales_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rc_obj_sales_data_ix IS NULL or NEW.rc_obj_sales_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rc_obj_sales_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rc_obj_sales_data_ix = ix;
                            SET NEW.rc_obj_sales_data_id = 0;
                            SET NEW.rc_obj_sales_data_db = @db_code;

                            IF NEW.rc_obj_sales_data_trf_yn IS NULL THEN
                                SET NEW.rc_obj_sales_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rc_obj_sales_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rc_obj_sales_data_ins_af
                        AFTER INSERT ON rc_obj_sales_data FOR EACH ROW
                        tr_rc_obj_sales_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_obj_sales_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rc_obj_sales_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rc_obj_sales_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_obj_sales_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_obj_sales_data_upd_be
                    BEFORE UPDATE ON rc_obj_sales_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_obj_sales_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.rc_obj_sales_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rc_obj_sales_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rc_obj_sales_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rc_obj_sales_data_trf_yn IS NULL THEN
                                SET NEW.rc_obj_sales_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_obj_sales_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_obj_sales_data_del_be
                    BEFORE DELETE ON rc_obj_sales_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_obj_sales_data\" INTO @tc_table_id;
                            SELECT rc_obj_sales_data_trf_yn FROM rc_obj_sales_data WHERE rc_obj_sales_data_ix = OLD.rc_obj_sales_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rc_obj_sales_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rc_tag_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rc_tag_ins_be
                BEFORE INSERT ON rc_tag FOR EACH ROW
                tr_rc_tag_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rc_tag_ix IS NULL or NEW.rc_tag_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rc_tag_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rc_tag_ix = ix;
                            SET NEW.rc_tag_id = 0;
                            SET NEW.rc_tag_db = @db_code;

                            IF NEW.rc_tag_trf_yn IS NULL THEN
                                SET NEW.rc_tag_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rc_tag_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rc_tag_ins_af
                        AFTER INSERT ON rc_tag FOR EACH ROW
                        tr_rc_tag_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_tag\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rc_tag_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rc_tag_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_tag_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_tag_upd_be
                    BEFORE UPDATE ON rc_tag FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_tag\" INTO @tc_table_id;
                        SET row_transferred = OLD.rc_tag_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rc_tag_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rc_tag_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rc_tag_trf_yn IS NULL THEN
                                SET NEW.rc_tag_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rc_tag_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rc_tag_del_be
                    BEFORE DELETE ON rc_tag FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rc_tag\" INTO @tc_table_id;
                            SELECT rc_tag_trf_yn FROM rc_tag WHERE rc_tag_ix = OLD.rc_tag_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rc_tag_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_zg_transfer_guest_prop_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_zg_transfer_guest_prop_ins_be
                BEFORE INSERT ON zg_transfer_guest_prop FOR EACH ROW
                tr_zg_transfer_guest_prop_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.zg_transfer_guest_prop_ix IS NULL or NEW.zg_transfer_guest_prop_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_zg_transfer_guest_prop_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.zg_transfer_guest_prop_ix = ix;
                            SET NEW.zg_transfer_guest_prop_id = 0;
                            SET NEW.zg_transfer_guest_prop_db = @db_code;

                            IF NEW.zg_transfer_guest_prop_trf_yn IS NULL THEN
                                SET NEW.zg_transfer_guest_prop_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_zg_transfer_guest_prop_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_zg_transfer_guest_prop_ins_af
                        AFTER INSERT ON zg_transfer_guest_prop FOR EACH ROW
                        tr_zg_transfer_guest_prop_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer_guest_prop\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.zg_transfer_guest_prop_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_zg_transfer_guest_prop_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_transfer_guest_prop_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_transfer_guest_prop_upd_be
                    BEFORE UPDATE ON zg_transfer_guest_prop FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer_guest_prop\" INTO @tc_table_id;
                        SET row_transferred = OLD.zg_transfer_guest_prop_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.zg_transfer_guest_prop_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.zg_transfer_guest_prop_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.zg_transfer_guest_prop_trf_yn IS NULL THEN
                                SET NEW.zg_transfer_guest_prop_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_zg_transfer_guest_prop_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_zg_transfer_guest_prop_del_be
                    BEFORE DELETE ON zg_transfer_guest_prop FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"zg_transfer_guest_prop\" INTO @tc_table_id;
                            SELECT zg_transfer_guest_prop_trf_yn FROM zg_transfer_guest_prop WHERE zg_transfer_guest_prop_ix = OLD.zg_transfer_guest_prop_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.zg_transfer_guest_prop_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_component_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_component_ins_be
                BEFORE INSERT ON rt_component FOR EACH ROW
                tr_rt_component_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_component_ix IS NULL or NEW.rt_component_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_component_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_component_ix = ix;
                            SET NEW.rt_component_id = 0;
                            SET NEW.rt_component_db = @db_code;

                            IF NEW.rt_component_trf_yn IS NULL THEN
                                SET NEW.rt_component_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_component_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_component_ins_af
                        AFTER INSERT ON rt_component FOR EACH ROW
                        tr_rt_component_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_component\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_component_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_component_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_component_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_component_upd_be
                    BEFORE UPDATE ON rt_component FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_component\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_component_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_component_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_component_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_component_trf_yn IS NULL THEN
                                SET NEW.rt_component_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_component_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_component_del_be
                    BEFORE DELETE ON rt_component FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_component\" INTO @tc_table_id;
                            SELECT rt_component_trf_yn FROM rt_component WHERE rt_component_ix = OLD.rt_component_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_component_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_component_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_component_inv_ins_be
                BEFORE INSERT ON rt_component_inv FOR EACH ROW
                tr_rt_component_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_component_inv_ix IS NULL or NEW.rt_component_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_component_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_component_inv_ix = ix;
                            SET NEW.rt_component_inv_id = 0;
                            SET NEW.rt_component_inv_db = @db_code;

                            IF NEW.rt_component_inv_trf_yn IS NULL THEN
                                SET NEW.rt_component_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_component_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_component_inv_ins_af
                        AFTER INSERT ON rt_component_inv FOR EACH ROW
                        tr_rt_component_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_component_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_component_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_component_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_component_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_component_inv_upd_be
                    BEFORE UPDATE ON rt_component_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_component_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_component_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_component_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_component_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_component_inv_trf_yn IS NULL THEN
                                SET NEW.rt_component_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_component_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_component_inv_del_be
                    BEFORE DELETE ON rt_component_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_component_inv\" INTO @tc_table_id;
                            SELECT rt_component_inv_trf_yn FROM rt_component_inv WHERE rt_component_inv_ix = OLD.rt_component_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_component_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_period_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_period_ins_be
                BEFORE INSERT ON rt_period FOR EACH ROW
                tr_rt_period_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_period_ix IS NULL or NEW.rt_period_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_period_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_period_ix = ix;
                            SET NEW.rt_period_id = 0;
                            SET NEW.rt_period_db = @db_code;

                            IF NEW.rt_period_trf_yn IS NULL THEN
                                SET NEW.rt_period_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_period_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_period_ins_af
                        AFTER INSERT ON rt_period FOR EACH ROW
                        tr_rt_period_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_period\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_period_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_period_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_period_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_period_upd_be
                    BEFORE UPDATE ON rt_period FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_period\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_period_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_period_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_period_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_period_trf_yn IS NULL THEN
                                SET NEW.rt_period_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_period_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_period_del_be
                    BEFORE DELETE ON rt_period FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_period\" INTO @tc_table_id;
                            SELECT rt_period_trf_yn FROM rt_period WHERE rt_period_ix = OLD.rt_period_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_period_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_period_dates_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_period_dates_ins_be
                BEFORE INSERT ON rt_period_dates FOR EACH ROW
                tr_rt_period_dates_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_period_dates_ix IS NULL or NEW.rt_period_dates_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_period_dates_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_period_dates_ix = ix;
                            SET NEW.rt_period_dates_id = 0;
                            SET NEW.rt_period_dates_db = @db_code;

                            IF NEW.rt_period_dates_trf_yn IS NULL THEN
                                SET NEW.rt_period_dates_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_period_dates_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_period_dates_ins_af
                        AFTER INSERT ON rt_period_dates FOR EACH ROW
                        tr_rt_period_dates_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_period_dates\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_period_dates_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_period_dates_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_period_dates_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_period_dates_upd_be
                    BEFORE UPDATE ON rt_period_dates FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_period_dates\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_period_dates_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_period_dates_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_period_dates_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_period_dates_trf_yn IS NULL THEN
                                SET NEW.rt_period_dates_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_period_dates_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_period_dates_del_be
                    BEFORE DELETE ON rt_period_dates FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_period_dates\" INTO @tc_table_id;
                            SELECT rt_period_dates_trf_yn FROM rt_period_dates WHERE rt_period_dates_ix = OLD.rt_period_dates_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_period_dates_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_rate_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_rate_ins_be
                BEFORE INSERT ON rt_rate FOR EACH ROW
                tr_rt_rate_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_rate_ix IS NULL or NEW.rt_rate_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_rate_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_rate_ix = ix;
                            SET NEW.rt_rate_id = 0;
                            SET NEW.rt_rate_db = @db_code;

                            IF NEW.rt_rate_trf_yn IS NULL THEN
                                SET NEW.rt_rate_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_rate_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_rate_ins_af
                        AFTER INSERT ON rt_rate FOR EACH ROW
                        tr_rt_rate_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_rate_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_rate_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_upd_be
                    BEFORE UPDATE ON rt_rate FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_rate_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_rate_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_rate_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_rate_trf_yn IS NULL THEN
                                SET NEW.rt_rate_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_del_be
                    BEFORE DELETE ON rt_rate FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate\" INTO @tc_table_id;
                            SELECT rt_rate_trf_yn FROM rt_rate WHERE rt_rate_ix = OLD.rt_rate_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_rate_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_rate_comp_grp_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_rate_comp_grp_ins_be
                BEFORE INSERT ON rt_rate_comp_grp FOR EACH ROW
                tr_rt_rate_comp_grp_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_rate_comp_grp_ix IS NULL or NEW.rt_rate_comp_grp_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_rate_comp_grp_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_rate_comp_grp_ix = ix;
                            SET NEW.rt_rate_comp_grp_id = 0;
                            SET NEW.rt_rate_comp_grp_db = @db_code;

                            IF NEW.rt_rate_comp_grp_trf_yn IS NULL THEN
                                SET NEW.rt_rate_comp_grp_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_rate_comp_grp_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_rate_comp_grp_ins_af
                        AFTER INSERT ON rt_rate_comp_grp FOR EACH ROW
                        tr_rt_rate_comp_grp_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_comp_grp\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_rate_comp_grp_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_rate_comp_grp_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_comp_grp_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_comp_grp_upd_be
                    BEFORE UPDATE ON rt_rate_comp_grp FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_comp_grp\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_rate_comp_grp_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_rate_comp_grp_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_rate_comp_grp_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_rate_comp_grp_trf_yn IS NULL THEN
                                SET NEW.rt_rate_comp_grp_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_comp_grp_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_comp_grp_del_be
                    BEFORE DELETE ON rt_rate_comp_grp FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_comp_grp\" INTO @tc_table_id;
                            SELECT rt_rate_comp_grp_trf_yn FROM rt_rate_comp_grp WHERE rt_rate_comp_grp_ix = OLD.rt_rate_comp_grp_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_rate_comp_grp_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_rate_component_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_rate_component_ins_be
                BEFORE INSERT ON rt_rate_component FOR EACH ROW
                tr_rt_rate_component_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_rate_component_ix IS NULL or NEW.rt_rate_component_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_rate_component_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_rate_component_ix = ix;
                            SET NEW.rt_rate_component_id = 0;
                            SET NEW.rt_rate_component_db = @db_code;

                            IF NEW.rt_rate_component_trf_yn IS NULL THEN
                                SET NEW.rt_rate_component_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_rate_component_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_rate_component_ins_af
                        AFTER INSERT ON rt_rate_component FOR EACH ROW
                        tr_rt_rate_component_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_component\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_rate_component_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_rate_component_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_component_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_component_upd_be
                    BEFORE UPDATE ON rt_rate_component FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_component\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_rate_component_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_rate_component_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_rate_component_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_rate_component_trf_yn IS NULL THEN
                                SET NEW.rt_rate_component_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_component_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_component_del_be
                    BEFORE DELETE ON rt_rate_component FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_component\" INTO @tc_table_id;
                            SELECT rt_rate_component_trf_yn FROM rt_rate_component WHERE rt_rate_component_ix = OLD.rt_rate_component_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_rate_component_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_rate_group_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_rate_group_ins_be
                BEFORE INSERT ON rt_rate_group FOR EACH ROW
                tr_rt_rate_group_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_rate_group_ix IS NULL or NEW.rt_rate_group_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_rate_group_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_rate_group_ix = ix;
                            SET NEW.rt_rate_group_id = 0;
                            SET NEW.rt_rate_group_db = @db_code;

                            IF NEW.rt_rate_group_trf_yn IS NULL THEN
                                SET NEW.rt_rate_group_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_rate_group_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_rate_group_ins_af
                        AFTER INSERT ON rt_rate_group FOR EACH ROW
                        tr_rt_rate_group_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_group\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_rate_group_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_rate_group_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_group_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_group_upd_be
                    BEFORE UPDATE ON rt_rate_group FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_group\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_rate_group_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_rate_group_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_rate_group_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_rate_group_trf_yn IS NULL THEN
                                SET NEW.rt_rate_group_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_group_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_group_del_be
                    BEFORE DELETE ON rt_rate_group FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_group\" INTO @tc_table_id;
                            SELECT rt_rate_group_trf_yn FROM rt_rate_group WHERE rt_rate_group_ix = OLD.rt_rate_group_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_rate_group_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_rate_grp_amt_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_rate_grp_amt_ins_be
                BEFORE INSERT ON rt_rate_grp_amt FOR EACH ROW
                tr_rt_rate_grp_amt_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_rate_grp_amt_ix IS NULL or NEW.rt_rate_grp_amt_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_rate_grp_amt_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_rate_grp_amt_ix = ix;
                            SET NEW.rt_rate_grp_amt_id = 0;
                            SET NEW.rt_rate_grp_amt_db = @db_code;

                            IF NEW.rt_rate_grp_amt_trf_yn IS NULL THEN
                                SET NEW.rt_rate_grp_amt_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_rate_grp_amt_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_rate_grp_amt_ins_af
                        AFTER INSERT ON rt_rate_grp_amt FOR EACH ROW
                        tr_rt_rate_grp_amt_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_grp_amt\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_rate_grp_amt_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_rate_grp_amt_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_grp_amt_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_grp_amt_upd_be
                    BEFORE UPDATE ON rt_rate_grp_amt FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_grp_amt\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_rate_grp_amt_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_rate_grp_amt_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_rate_grp_amt_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_rate_grp_amt_trf_yn IS NULL THEN
                                SET NEW.rt_rate_grp_amt_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_grp_amt_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_grp_amt_del_be
                    BEFORE DELETE ON rt_rate_grp_amt FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_grp_amt\" INTO @tc_table_id;
                            SELECT rt_rate_grp_amt_trf_yn FROM rt_rate_grp_amt WHERE rt_rate_grp_amt_ix = OLD.rt_rate_grp_amt_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_rate_grp_amt_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_rate_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_rate_type_ins_be
                BEFORE INSERT ON rt_rate_type FOR EACH ROW
                tr_rt_rate_type_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_rate_type_ix IS NULL or NEW.rt_rate_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_rate_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_rate_type_ix = ix;
                            SET NEW.rt_rate_type_id = 0;
                            SET NEW.rt_rate_type_db = @db_code;

                            IF NEW.rt_rate_type_trf_yn IS NULL THEN
                                SET NEW.rt_rate_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_rate_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_rate_type_ins_af
                        AFTER INSERT ON rt_rate_type FOR EACH ROW
                        tr_rt_rate_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_rate_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_rate_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_type_upd_be
                    BEFORE UPDATE ON rt_rate_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_rate_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_rate_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_rate_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_rate_type_trf_yn IS NULL THEN
                                SET NEW.rt_rate_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_rate_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_rate_type_del_be
                    BEFORE DELETE ON rt_rate_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_rate_type\" INTO @tc_table_id;
                            SELECT rt_rate_type_trf_yn FROM rt_rate_type WHERE rt_rate_type_ix = OLD.rt_rate_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_rate_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_tax_group_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_tax_group_ins_be
                BEFORE INSERT ON rt_tax_group FOR EACH ROW
                tr_rt_tax_group_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_tax_group_ix IS NULL or NEW.rt_tax_group_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_tax_group_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_tax_group_ix = ix;
                            SET NEW.rt_tax_group_id = 0;
                            SET NEW.rt_tax_group_db = @db_code;

                            IF NEW.rt_tax_group_trf_yn IS NULL THEN
                                SET NEW.rt_tax_group_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_tax_group_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_tax_group_ins_af
                        AFTER INSERT ON rt_tax_group FOR EACH ROW
                        tr_rt_tax_group_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_tax_group\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_tax_group_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_tax_group_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_tax_group_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_tax_group_upd_be
                    BEFORE UPDATE ON rt_tax_group FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_tax_group\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_tax_group_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_tax_group_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_tax_group_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_tax_group_trf_yn IS NULL THEN
                                SET NEW.rt_tax_group_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_tax_group_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_tax_group_del_be
                    BEFORE DELETE ON rt_tax_group FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_tax_group\" INTO @tc_table_id;
                            SELECT rt_tax_group_trf_yn FROM rt_tax_group WHERE rt_tax_group_ix = OLD.rt_tax_group_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_tax_group_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rt_tax_group_item_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rt_tax_group_item_ins_be
                BEFORE INSERT ON rt_tax_group_item FOR EACH ROW
                tr_rt_tax_group_item_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rt_tax_group_item_ix IS NULL or NEW.rt_tax_group_item_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rt_tax_group_item_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rt_tax_group_item_ix = ix;
                            SET NEW.rt_tax_group_item_id = 0;
                            SET NEW.rt_tax_group_item_db = @db_code;

                            IF NEW.rt_tax_group_item_trf_yn IS NULL THEN
                                SET NEW.rt_tax_group_item_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rt_tax_group_item_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rt_tax_group_item_ins_af
                        AFTER INSERT ON rt_tax_group_item FOR EACH ROW
                        tr_rt_tax_group_item_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_tax_group_item\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rt_tax_group_item_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rt_tax_group_item_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_tax_group_item_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_tax_group_item_upd_be
                    BEFORE UPDATE ON rt_tax_group_item FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_tax_group_item\" INTO @tc_table_id;
                        SET row_transferred = OLD.rt_tax_group_item_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rt_tax_group_item_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rt_tax_group_item_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rt_tax_group_item_trf_yn IS NULL THEN
                                SET NEW.rt_tax_group_item_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rt_tax_group_item_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rt_tax_group_item_del_be
                    BEFORE DELETE ON rt_tax_group_item FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rt_tax_group_item\" INTO @tc_table_id;
                            SELECT rt_tax_group_item_trf_yn FROM rt_tax_group_item WHERE rt_tax_group_item_ix = OLD.rt_tax_group_item_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rt_tax_group_item_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_comp_tax_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_comp_tax_ins_be
                BEFORE INSERT ON rv_res_item_comp_tax FOR EACH ROW
                tr_rv_res_item_comp_tax_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_comp_tax_ix IS NULL or NEW.rv_res_item_comp_tax_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_comp_tax_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_comp_tax_ix = ix;
                            SET NEW.rv_res_item_comp_tax_id = 0;
                            SET NEW.rv_res_item_comp_tax_db = @db_code;

                            IF NEW.rv_res_item_comp_tax_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_comp_tax_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_comp_tax_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_comp_tax_ins_af
                        AFTER INSERT ON rv_res_item_comp_tax FOR EACH ROW
                        tr_rv_res_item_comp_tax_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp_tax\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_comp_tax_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_comp_tax_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_comp_tax_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_comp_tax_upd_be
                    BEFORE UPDATE ON rv_res_item_comp_tax FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp_tax\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_comp_tax_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_comp_tax_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_comp_tax_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_comp_tax_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_comp_tax_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_comp_tax_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_comp_tax_del_be
                    BEFORE DELETE ON rv_res_item_comp_tax FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp_tax\" INTO @tc_table_id;
                            SELECT rv_res_item_comp_tax_trf_yn FROM rv_res_item_comp_tax WHERE rv_res_item_comp_tax_ix = OLD.rv_res_item_comp_tax_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_comp_tax_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_comp_rate_grp_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_comp_rate_grp_ins_be
                BEFORE INSERT ON rv_res_item_comp_rate_grp FOR EACH ROW
                tr_rv_res_item_comp_rate_grp_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_comp_rate_grp_ix IS NULL or NEW.rv_res_item_comp_rate_grp_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_comp_rate_grp_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_comp_rate_grp_ix = ix;
                            SET NEW.rv_res_item_comp_rate_grp_id = 0;
                            SET NEW.rv_res_item_comp_rate_grp_db = @db_code;

                            IF NEW.rv_res_item_comp_rate_grp_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_comp_rate_grp_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_comp_rate_grp_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_comp_rate_grp_ins_af
                        AFTER INSERT ON rv_res_item_comp_rate_grp FOR EACH ROW
                        tr_rv_res_item_comp_rate_grp_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp_rate_grp\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_comp_rate_grp_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_comp_rate_grp_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_comp_rate_grp_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_comp_rate_grp_upd_be
                    BEFORE UPDATE ON rv_res_item_comp_rate_grp FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp_rate_grp\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_comp_rate_grp_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_comp_rate_grp_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_comp_rate_grp_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_comp_rate_grp_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_comp_rate_grp_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_comp_rate_grp_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_comp_rate_grp_del_be
                    BEFORE DELETE ON rv_res_item_comp_rate_grp FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_comp_rate_grp\" INTO @tc_table_id;
                            SELECT rv_res_item_comp_rate_grp_trf_yn FROM rv_res_item_comp_rate_grp WHERE rv_res_item_comp_rate_grp_ix = OLD.rv_res_item_comp_rate_grp_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_comp_rate_grp_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_res_item_rate_grp_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_res_item_rate_grp_ins_be
                BEFORE INSERT ON rv_res_item_rate_grp FOR EACH ROW
                tr_rv_res_item_rate_grp_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_res_item_rate_grp_ix IS NULL or NEW.rv_res_item_rate_grp_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_res_item_rate_grp_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_res_item_rate_grp_ix = ix;
                            SET NEW.rv_res_item_rate_grp_id = 0;
                            SET NEW.rv_res_item_rate_grp_db = @db_code;

                            IF NEW.rv_res_item_rate_grp_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_rate_grp_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_res_item_rate_grp_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_res_item_rate_grp_ins_af
                        AFTER INSERT ON rv_res_item_rate_grp FOR EACH ROW
                        tr_rv_res_item_rate_grp_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_rate_grp\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_res_item_rate_grp_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_res_item_rate_grp_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_rate_grp_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_rate_grp_upd_be
                    BEFORE UPDATE ON rv_res_item_rate_grp FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_rate_grp\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_res_item_rate_grp_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_res_item_rate_grp_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_res_item_rate_grp_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_res_item_rate_grp_trf_yn IS NULL THEN
                                SET NEW.rv_res_item_rate_grp_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_res_item_rate_grp_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_res_item_rate_grp_del_be
                    BEFORE DELETE ON rv_res_item_rate_grp FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_res_item_rate_grp\" INTO @tc_table_id;
                            SELECT rv_res_item_rate_grp_trf_yn FROM rv_res_item_rate_grp WHERE rv_res_item_rate_grp_ix = OLD.rv_res_item_rate_grp_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_rate_grp_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_item_tax_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_item_tax_ins_be
                BEFORE INSERT ON fn_invoice_item_tax FOR EACH ROW
                tr_fn_invoice_item_tax_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_invoice_item_tax_ix IS NULL or NEW.fn_invoice_item_tax_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_item_tax_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_invoice_item_tax_ix = ix;
                            SET NEW.fn_invoice_item_tax_id = 0;
                            SET NEW.fn_invoice_item_tax_db = @db_code;

                            IF NEW.fn_invoice_item_tax_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_item_tax_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_item_tax_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_item_tax_ins_af
                        AFTER INSERT ON fn_invoice_item_tax FOR EACH ROW
                        tr_fn_invoice_item_tax_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_item_tax\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_item_tax_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_item_tax_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_item_tax_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_item_tax_upd_be
                    BEFORE UPDATE ON fn_invoice_item_tax FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_item_tax\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_item_tax_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_item_tax_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_item_tax_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_item_tax_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_item_tax_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_item_tax_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_item_tax_del_be
                    BEFORE DELETE ON fn_invoice_item_tax FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_item_tax\" INTO @tc_table_id;
                            SELECT fn_invoice_item_tax_trf_yn FROM fn_invoice_item_tax WHERE fn_invoice_item_tax_ix = OLD.fn_invoice_item_tax_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_invoice_item_tax_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_pos_map_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_pos_map_ins_be
                BEFORE INSERT ON ac_pos_map FOR EACH ROW
                tr_ac_pos_map_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_pos_map_ix IS NULL or NEW.ac_pos_map_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_pos_map_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_pos_map_ix = ix;
                            SET NEW.ac_pos_map_id = 0;
                            SET NEW.ac_pos_map_db = @db_code;

                            IF NEW.ac_pos_map_trf_yn IS NULL THEN
                                SET NEW.ac_pos_map_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_pos_map_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_pos_map_ins_af
                        AFTER INSERT ON ac_pos_map FOR EACH ROW
                        tr_ac_pos_map_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos_map\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_pos_map_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_pos_map_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pos_map_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pos_map_upd_be
                    BEFORE UPDATE ON ac_pos_map FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos_map\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_pos_map_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_pos_map_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_pos_map_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_pos_map_trf_yn IS NULL THEN
                                SET NEW.ac_pos_map_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pos_map_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pos_map_del_be
                    BEFORE DELETE ON ac_pos_map FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos_map\" INTO @tc_table_id;
                            SELECT ac_pos_map_trf_yn FROM ac_pos_map WHERE ac_pos_map_ix = OLD.ac_pos_map_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_pos_map_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ac_pos_map_accomm_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ac_pos_map_accomm_ins_be
                BEFORE INSERT ON ac_pos_map_accomm FOR EACH ROW
                tr_ac_pos_map_accomm_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ac_pos_map_accomm_ix IS NULL or NEW.ac_pos_map_accomm_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ac_pos_map_accomm_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ac_pos_map_accomm_ix = ix;
                            SET NEW.ac_pos_map_accomm_id = 0;
                            SET NEW.ac_pos_map_accomm_db = @db_code;

                            IF NEW.ac_pos_map_accomm_trf_yn IS NULL THEN
                                SET NEW.ac_pos_map_accomm_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ac_pos_map_accomm_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ac_pos_map_accomm_ins_af
                        AFTER INSERT ON ac_pos_map_accomm FOR EACH ROW
                        tr_ac_pos_map_accomm_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos_map_accomm\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ac_pos_map_accomm_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ac_pos_map_accomm_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pos_map_accomm_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pos_map_accomm_upd_be
                    BEFORE UPDATE ON ac_pos_map_accomm FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos_map_accomm\" INTO @tc_table_id;
                        SET row_transferred = OLD.ac_pos_map_accomm_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ac_pos_map_accomm_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ac_pos_map_accomm_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ac_pos_map_accomm_trf_yn IS NULL THEN
                                SET NEW.ac_pos_map_accomm_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ac_pos_map_accomm_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ac_pos_map_accomm_del_be
                    BEFORE DELETE ON ac_pos_map_accomm FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ac_pos_map_accomm\" INTO @tc_table_id;
                            SELECT ac_pos_map_accomm_trf_yn FROM ac_pos_map_accomm WHERE ac_pos_map_accomm_ix = OLD.ac_pos_map_accomm_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ac_pos_map_accomm_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_db_business_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_db_business_ins_be
                BEFORE INSERT ON fn_db_business FOR EACH ROW
                tr_fn_db_business_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_db_business_ix IS NULL or NEW.fn_db_business_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_db_business_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_db_business_ix = ix;
                            SET NEW.fn_db_business_id = 0;
                            SET NEW.fn_db_business_db = @db_code;

                            IF NEW.fn_db_business_trf_yn IS NULL THEN
                                SET NEW.fn_db_business_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_db_business_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_db_business_ins_af
                        AFTER INSERT ON fn_db_business FOR EACH ROW
                        tr_fn_db_business_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_db_business\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_db_business_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_db_business_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_db_business_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_db_business_upd_be
                    BEFORE UPDATE ON fn_db_business FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_db_business\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_db_business_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_db_business_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_db_business_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_db_business_trf_yn IS NULL THEN
                                SET NEW.fn_db_business_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_db_business_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_db_business_del_be
                    BEFORE DELETE ON fn_db_business FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_db_business\" INTO @tc_table_id;
                            SELECT fn_db_business_trf_yn FROM fn_db_business WHERE fn_db_business_ix = OLD.fn_db_business_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_db_business_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_account_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_account_ins_be
                BEFORE INSERT ON pg_account FOR EACH ROW
                tr_pg_account_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_account_ix IS NULL or NEW.pg_account_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_account_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_account_ix = ix;
                            SET NEW.pg_account_id = 0;
                            SET NEW.pg_account_db = @db_code;

                            IF NEW.pg_account_trf_yn IS NULL THEN
                                SET NEW.pg_account_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_account_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_account_ins_af
                        AFTER INSERT ON pg_account FOR EACH ROW
                        tr_pg_account_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_account\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_account_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_account_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_account_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_account_upd_be
                    BEFORE UPDATE ON pg_account FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_account\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_account_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_account_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_account_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_account_trf_yn IS NULL THEN
                                SET NEW.pg_account_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_account_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_account_del_be
                    BEFORE DELETE ON pg_account FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_account\" INTO @tc_table_id;
                            SELECT pg_account_trf_yn FROM pg_account WHERE pg_account_ix = OLD.pg_account_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_account_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_acc_business_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_acc_business_ins_be
                BEFORE INSERT ON pg_acc_business FOR EACH ROW
                tr_pg_acc_business_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_acc_business_ix IS NULL or NEW.pg_acc_business_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_acc_business_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_acc_business_ix = ix;
                            SET NEW.pg_acc_business_id = 0;
                            SET NEW.pg_acc_business_db = @db_code;

                            IF NEW.pg_acc_business_trf_yn IS NULL THEN
                                SET NEW.pg_acc_business_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_acc_business_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_acc_business_ins_af
                        AFTER INSERT ON pg_acc_business FOR EACH ROW
                        tr_pg_acc_business_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_business\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_acc_business_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_acc_business_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_business_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_business_upd_be
                    BEFORE UPDATE ON pg_acc_business FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_business\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_acc_business_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_acc_business_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_acc_business_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_acc_business_trf_yn IS NULL THEN
                                SET NEW.pg_acc_business_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_business_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_business_del_be
                    BEFORE DELETE ON pg_acc_business FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_business\" INTO @tc_table_id;
                            SELECT pg_acc_business_trf_yn FROM pg_acc_business WHERE pg_acc_business_ix = OLD.pg_acc_business_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_acc_business_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_acc_currency_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_acc_currency_ins_be
                BEFORE INSERT ON pg_acc_currency FOR EACH ROW
                tr_pg_acc_currency_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_acc_currency_ix IS NULL or NEW.pg_acc_currency_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_acc_currency_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_acc_currency_ix = ix;
                            SET NEW.pg_acc_currency_id = 0;
                            SET NEW.pg_acc_currency_db = @db_code;

                            IF NEW.pg_acc_currency_trf_yn IS NULL THEN
                                SET NEW.pg_acc_currency_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_acc_currency_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_acc_currency_ins_af
                        AFTER INSERT ON pg_acc_currency FOR EACH ROW
                        tr_pg_acc_currency_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_currency\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_acc_currency_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_acc_currency_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_currency_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_currency_upd_be
                    BEFORE UPDATE ON pg_acc_currency FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_currency\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_acc_currency_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_acc_currency_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_acc_currency_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_acc_currency_trf_yn IS NULL THEN
                                SET NEW.pg_acc_currency_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_currency_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_currency_del_be
                    BEFORE DELETE ON pg_acc_currency FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_currency\" INTO @tc_table_id;
                            SELECT pg_acc_currency_trf_yn FROM pg_acc_currency WHERE pg_acc_currency_ix = OLD.pg_acc_currency_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_acc_currency_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_acc_method_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_acc_method_ins_be
                BEFORE INSERT ON pg_acc_method FOR EACH ROW
                tr_pg_acc_method_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_acc_method_ix IS NULL or NEW.pg_acc_method_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_acc_method_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_acc_method_ix = ix;
                            SET NEW.pg_acc_method_id = 0;
                            SET NEW.pg_acc_method_db = @db_code;

                            IF NEW.pg_acc_method_trf_yn IS NULL THEN
                                SET NEW.pg_acc_method_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_acc_method_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_acc_method_ins_af
                        AFTER INSERT ON pg_acc_method FOR EACH ROW
                        tr_pg_acc_method_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_method\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_acc_method_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_acc_method_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_method_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_method_upd_be
                    BEFORE UPDATE ON pg_acc_method FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_method\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_acc_method_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_acc_method_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_acc_method_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_acc_method_trf_yn IS NULL THEN
                                SET NEW.pg_acc_method_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_method_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_method_del_be
                    BEFORE DELETE ON pg_acc_method FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_method\" INTO @tc_table_id;
                            SELECT pg_acc_method_trf_yn FROM pg_acc_method WHERE pg_acc_method_ix = OLD.pg_acc_method_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_acc_method_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_acc_obj_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_acc_obj_data_ins_be
                BEFORE INSERT ON pg_acc_obj_data FOR EACH ROW
                tr_pg_acc_obj_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_acc_obj_data_ix IS NULL or NEW.pg_acc_obj_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_acc_obj_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_acc_obj_data_ix = ix;
                            SET NEW.pg_acc_obj_data_id = 0;
                            SET NEW.pg_acc_obj_data_db = @db_code;

                            IF NEW.pg_acc_obj_data_trf_yn IS NULL THEN
                                SET NEW.pg_acc_obj_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_acc_obj_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_acc_obj_data_ins_af
                        AFTER INSERT ON pg_acc_obj_data FOR EACH ROW
                        tr_pg_acc_obj_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_obj_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_acc_obj_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_acc_obj_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_obj_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_obj_data_upd_be
                    BEFORE UPDATE ON pg_acc_obj_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_obj_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_acc_obj_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_acc_obj_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_acc_obj_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_acc_obj_data_trf_yn IS NULL THEN
                                SET NEW.pg_acc_obj_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_acc_obj_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_acc_obj_data_del_be
                    BEFORE DELETE ON pg_acc_obj_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_acc_obj_data\" INTO @tc_table_id;
                            SELECT pg_acc_obj_data_trf_yn FROM pg_acc_obj_data WHERE pg_acc_obj_data_ix = OLD.pg_acc_obj_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_acc_obj_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_method_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_method_ins_be
                BEFORE INSERT ON pg_method FOR EACH ROW
                tr_pg_method_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_method_ix IS NULL or NEW.pg_method_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_method_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_method_ix = ix;
                            SET NEW.pg_method_id = 0;
                            SET NEW.pg_method_db = @db_code;

                            IF NEW.pg_method_trf_yn IS NULL THEN
                                SET NEW.pg_method_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_method_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_method_ins_af
                        AFTER INSERT ON pg_method FOR EACH ROW
                        tr_pg_method_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_method\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_method_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_method_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_method_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_method_upd_be
                    BEFORE UPDATE ON pg_method FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_method\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_method_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_method_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_method_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_method_trf_yn IS NULL THEN
                                SET NEW.pg_method_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_method_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_method_del_be
                    BEFORE DELETE ON pg_method FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_method\" INTO @tc_table_id;
                            SELECT pg_method_trf_yn FROM pg_method WHERE pg_method_ix = OLD.pg_method_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_method_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_type_ins_be
                BEFORE INSERT ON pg_type FOR EACH ROW
                tr_pg_type_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_type_ix IS NULL or NEW.pg_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_type_ix = ix;
                            SET NEW.pg_type_id = 0;
                            SET NEW.pg_type_db = @db_code;

                            IF NEW.pg_type_trf_yn IS NULL THEN
                                SET NEW.pg_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_type_ins_af
                        AFTER INSERT ON pg_type FOR EACH ROW
                        tr_pg_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_type_upd_be
                    BEFORE UPDATE ON pg_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_type_trf_yn IS NULL THEN
                                SET NEW.pg_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_type_del_be
                    BEFORE DELETE ON pg_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type\" INTO @tc_table_id;
                            SELECT pg_type_trf_yn FROM pg_type WHERE pg_type_ix = OLD.pg_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_type_obj_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_type_obj_ins_be
                BEFORE INSERT ON pg_type_obj FOR EACH ROW
                tr_pg_type_obj_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_type_obj_ix IS NULL or NEW.pg_type_obj_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_type_obj_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_type_obj_ix = ix;
                            SET NEW.pg_type_obj_id = 0;
                            SET NEW.pg_type_obj_db = @db_code;

                            IF NEW.pg_type_obj_trf_yn IS NULL THEN
                                SET NEW.pg_type_obj_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_type_obj_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_type_obj_ins_af
                        AFTER INSERT ON pg_type_obj FOR EACH ROW
                        tr_pg_type_obj_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type_obj\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_type_obj_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_type_obj_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_type_obj_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_type_obj_upd_be
                    BEFORE UPDATE ON pg_type_obj FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type_obj\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_type_obj_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_type_obj_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_type_obj_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_type_obj_trf_yn IS NULL THEN
                                SET NEW.pg_type_obj_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_type_obj_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_type_obj_del_be
                    BEFORE DELETE ON pg_type_obj FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type_obj\" INTO @tc_table_id;
                            SELECT pg_type_obj_trf_yn FROM pg_type_obj WHERE pg_type_obj_ix = OLD.pg_type_obj_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_type_obj_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pg_type_obj_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pg_type_obj_data_ins_be
                BEFORE INSERT ON pg_type_obj_data FOR EACH ROW
                tr_pg_type_obj_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pg_type_obj_data_ix IS NULL or NEW.pg_type_obj_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pg_type_obj_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pg_type_obj_data_ix = ix;
                            SET NEW.pg_type_obj_data_id = 0;
                            SET NEW.pg_type_obj_data_db = @db_code;

                            IF NEW.pg_type_obj_data_trf_yn IS NULL THEN
                                SET NEW.pg_type_obj_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pg_type_obj_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pg_type_obj_data_ins_af
                        AFTER INSERT ON pg_type_obj_data FOR EACH ROW
                        tr_pg_type_obj_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type_obj_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pg_type_obj_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pg_type_obj_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_type_obj_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_type_obj_data_upd_be
                    BEFORE UPDATE ON pg_type_obj_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type_obj_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.pg_type_obj_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pg_type_obj_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pg_type_obj_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pg_type_obj_data_trf_yn IS NULL THEN
                                SET NEW.pg_type_obj_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pg_type_obj_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pg_type_obj_data_del_be
                    BEFORE DELETE ON pg_type_obj_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pg_type_obj_data\" INTO @tc_table_id;
                            SELECT pg_type_obj_data_trf_yn FROM pg_type_obj_data WHERE pg_type_obj_data_ix = OLD.pg_type_obj_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pg_type_obj_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_payment_gateway_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_payment_gateway_ins_be
                BEFORE INSERT ON rv_payment_gateway FOR EACH ROW
                tr_rv_payment_gateway_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_payment_gateway_ix IS NULL or NEW.rv_payment_gateway_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_payment_gateway_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_payment_gateway_ix = ix;
                            SET NEW.rv_payment_gateway_id = 0;
                            SET NEW.rv_payment_gateway_db = @db_code;

                            IF NEW.rv_payment_gateway_trf_yn IS NULL THEN
                                SET NEW.rv_payment_gateway_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_payment_gateway_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_payment_gateway_ins_af
                        AFTER INSERT ON rv_payment_gateway FOR EACH ROW
                        tr_rv_payment_gateway_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment_gateway\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_payment_gateway_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_payment_gateway_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_payment_gateway_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_payment_gateway_upd_be
                    BEFORE UPDATE ON rv_payment_gateway FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment_gateway\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_payment_gateway_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_payment_gateway_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_payment_gateway_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_payment_gateway_trf_yn IS NULL THEN
                                SET NEW.rv_payment_gateway_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_payment_gateway_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_payment_gateway_del_be
                    BEFORE DELETE ON rv_payment_gateway FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_payment_gateway\" INTO @tc_table_id;
                            SELECT rv_payment_gateway_trf_yn FROM rv_payment_gateway WHERE rv_payment_gateway_ix = OLD.rv_payment_gateway_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_payment_gateway_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_option_data_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_option_data_ins_be
                BEFORE INSERT ON fn_option_data FOR EACH ROW
                tr_fn_option_data_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_option_data_ix IS NULL or NEW.fn_option_data_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_option_data_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_option_data_ix = ix;
                            SET NEW.fn_option_data_id = 0;
                            SET NEW.fn_option_data_db = @db_code;

                            IF NEW.fn_option_data_trf_yn IS NULL THEN
                                SET NEW.fn_option_data_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_option_data_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_option_data_ins_af
                        AFTER INSERT ON fn_option_data FOR EACH ROW
                        tr_fn_option_data_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_option_data\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_option_data_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_option_data_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_option_data_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_option_data_upd_be
                    BEFORE UPDATE ON fn_option_data FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_option_data\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_option_data_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_option_data_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_option_data_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_option_data_trf_yn IS NULL THEN
                                SET NEW.fn_option_data_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_option_data_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_option_data_del_be
                    BEFORE DELETE ON fn_option_data FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_option_data\" INTO @tc_table_id;
                            SELECT fn_option_data_trf_yn FROM fn_option_data WHERE fn_option_data_ix = OLD.fn_option_data_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_option_data_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_option_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_option_ins_be
                BEFORE INSERT ON fn_option FOR EACH ROW
                tr_fn_option_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_option_ix IS NULL or NEW.fn_option_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_option_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_option_ix = ix;
                            SET NEW.fn_option_id = 0;
                            SET NEW.fn_option_db = @db_code;

                            IF NEW.fn_option_trf_yn IS NULL THEN
                                SET NEW.fn_option_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_option_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_option_ins_af
                        AFTER INSERT ON fn_option FOR EACH ROW
                        tr_fn_option_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_option\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_option_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_option_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_option_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_option_upd_be
                    BEFORE UPDATE ON fn_option FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_option\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_option_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_option_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_option_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_option_trf_yn IS NULL THEN
                                SET NEW.fn_option_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_option_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_option_del_be
                    BEFORE DELETE ON fn_option FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_option\" INTO @tc_table_id;
                            SELECT fn_option_trf_yn FROM fn_option WHERE fn_option_ix = OLD.fn_option_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.fn_option_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rf_currency_inv_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rf_currency_inv_ins_be
                BEFORE INSERT ON rf_currency_inv FOR EACH ROW
                tr_rf_currency_inv_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rf_currency_inv_ix IS NULL or NEW.rf_currency_inv_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rf_currency_inv_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rf_currency_inv_ix = ix;
                            SET NEW.rf_currency_inv_id = 0;
                            SET NEW.rf_currency_inv_db = @db_code;

                            IF NEW.rf_currency_inv_trf_yn IS NULL THEN
                                SET NEW.rf_currency_inv_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rf_currency_inv_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rf_currency_inv_ins_af
                        AFTER INSERT ON rf_currency_inv FOR EACH ROW
                        tr_rf_currency_inv_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_currency_inv\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rf_currency_inv_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rf_currency_inv_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_currency_inv_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_currency_inv_upd_be
                    BEFORE UPDATE ON rf_currency_inv FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_currency_inv\" INTO @tc_table_id;
                        SET row_transferred = OLD.rf_currency_inv_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rf_currency_inv_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rf_currency_inv_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rf_currency_inv_trf_yn IS NULL THEN
                                SET NEW.rf_currency_inv_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rf_currency_inv_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rf_currency_inv_del_be
                    BEFORE DELETE ON rf_currency_inv FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rf_currency_inv\" INTO @tc_table_id;
                            SELECT rf_currency_inv_trf_yn FROM rf_currency_inv WHERE rf_currency_inv_ix = OLD.rf_currency_inv_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_currency_inv_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_pr_bus_tax_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_pr_bus_tax_ins_be
                BEFORE INSERT ON pr_bus_tax FOR EACH ROW
                tr_pr_bus_tax_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.pr_bus_tax_ix IS NULL or NEW.pr_bus_tax_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_pr_bus_tax_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.pr_bus_tax_ix = ix;
                            SET NEW.pr_bus_tax_id = 0;
                            SET NEW.pr_bus_tax_db = @db_code;

                            IF NEW.pr_bus_tax_trf_yn IS NULL THEN
                                SET NEW.pr_bus_tax_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_pr_bus_tax_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_pr_bus_tax_ins_af
                        AFTER INSERT ON pr_bus_tax FOR EACH ROW
                        tr_pr_bus_tax_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_bus_tax\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.pr_bus_tax_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_pr_bus_tax_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_bus_tax_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_bus_tax_upd_be
                    BEFORE UPDATE ON pr_bus_tax FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_bus_tax\" INTO @tc_table_id;
                        SET row_transferred = OLD.pr_bus_tax_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.pr_bus_tax_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.pr_bus_tax_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.pr_bus_tax_trf_yn IS NULL THEN
                                SET NEW.pr_bus_tax_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_pr_bus_tax_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_pr_bus_tax_del_be
                    BEFORE DELETE ON pr_bus_tax FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"pr_bus_tax\" INTO @tc_table_id;
                            SELECT pr_bus_tax_trf_yn FROM pr_bus_tax WHERE pr_bus_tax_ix = OLD.pr_bus_tax_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_bus_tax_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_special_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_special_ins_be
                BEFORE INSERT ON sp_special FOR EACH ROW
                tr_sp_special_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_special_ix IS NULL or NEW.sp_special_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_special_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_special_ix = ix;
                            SET NEW.sp_special_id = 0;
                            SET NEW.sp_special_db = @db_code;

                            IF NEW.sp_special_trf_yn IS NULL THEN
                                SET NEW.sp_special_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_special_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_special_ins_af
                        AFTER INSERT ON sp_special FOR EACH ROW
                        tr_sp_special_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_special_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_special_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_special_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_special_upd_be
                    BEFORE UPDATE ON sp_special FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_special_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_special_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_special_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_special_trf_yn IS NULL THEN
                                SET NEW.sp_special_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_special_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_special_del_be
                    BEFORE DELETE ON sp_special FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special\" INTO @tc_table_id;
                            SELECT sp_special_trf_yn FROM sp_special WHERE sp_special_ix = OLD.sp_special_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_special_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_accomm_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_accomm_type_ins_be
                BEFORE INSERT ON sp_accomm_type FOR EACH ROW
                tr_sp_accomm_type_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_accomm_type_ix IS NULL or NEW.sp_accomm_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_accomm_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_accomm_type_ix = ix;
                            SET NEW.sp_accomm_type_id = 0;
                            SET NEW.sp_accomm_type_db = @db_code;

                            IF NEW.sp_accomm_type_trf_yn IS NULL THEN
                                SET NEW.sp_accomm_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_accomm_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_accomm_type_ins_af
                        AFTER INSERT ON sp_accomm_type FOR EACH ROW
                        tr_sp_accomm_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_accomm_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_accomm_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_accomm_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_accomm_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_accomm_type_upd_be
                    BEFORE UPDATE ON sp_accomm_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_accomm_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_accomm_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_accomm_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_accomm_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_accomm_type_trf_yn IS NULL THEN
                                SET NEW.sp_accomm_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_accomm_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_accomm_type_del_be
                    BEFORE DELETE ON sp_accomm_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_accomm_type\" INTO @tc_table_id;
                            SELECT sp_accomm_type_trf_yn FROM sp_accomm_type WHERE sp_accomm_type_ix = OLD.sp_accomm_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_accomm_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_prop_rate_group_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_prop_rate_group_ins_be
                BEFORE INSERT ON sp_prop_rate_group FOR EACH ROW
                tr_sp_prop_rate_group_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_prop_rate_group_ix IS NULL or NEW.sp_prop_rate_group_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_prop_rate_group_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_prop_rate_group_ix = ix;
                            SET NEW.sp_prop_rate_group_id = 0;
                            SET NEW.sp_prop_rate_group_db = @db_code;

                            IF NEW.sp_prop_rate_group_trf_yn IS NULL THEN
                                SET NEW.sp_prop_rate_group_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_prop_rate_group_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_prop_rate_group_ins_af
                        AFTER INSERT ON sp_prop_rate_group FOR EACH ROW
                        tr_sp_prop_rate_group_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_prop_rate_group\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_prop_rate_group_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_prop_rate_group_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_prop_rate_group_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_prop_rate_group_upd_be
                    BEFORE UPDATE ON sp_prop_rate_group FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_prop_rate_group\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_prop_rate_group_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_prop_rate_group_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_prop_rate_group_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_prop_rate_group_trf_yn IS NULL THEN
                                SET NEW.sp_prop_rate_group_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_prop_rate_group_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_prop_rate_group_del_be
                    BEFORE DELETE ON sp_prop_rate_group FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_prop_rate_group\" INTO @tc_table_id;
                            SELECT sp_prop_rate_group_trf_yn FROM sp_prop_rate_group WHERE sp_prop_rate_group_ix = OLD.sp_prop_rate_group_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_prop_rate_group_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_rate_group_benefit_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_rate_group_benefit_ins_be
                BEFORE INSERT ON sp_rate_group_benefit FOR EACH ROW
                tr_sp_rate_group_benefit_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_rate_group_benefit_ix IS NULL or NEW.sp_rate_group_benefit_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_rate_group_benefit_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_rate_group_benefit_ix = ix;
                            SET NEW.sp_rate_group_benefit_id = 0;
                            SET NEW.sp_rate_group_benefit_db = @db_code;

                            IF NEW.sp_rate_group_benefit_trf_yn IS NULL THEN
                                SET NEW.sp_rate_group_benefit_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_rate_group_benefit_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_rate_group_benefit_ins_af
                        AFTER INSERT ON sp_rate_group_benefit FOR EACH ROW
                        tr_sp_rate_group_benefit_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_rate_group_benefit\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_rate_group_benefit_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_rate_group_benefit_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_rate_group_benefit_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_rate_group_benefit_upd_be
                    BEFORE UPDATE ON sp_rate_group_benefit FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_rate_group_benefit\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_rate_group_benefit_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_rate_group_benefit_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_rate_group_benefit_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_rate_group_benefit_trf_yn IS NULL THEN
                                SET NEW.sp_rate_group_benefit_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_rate_group_benefit_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_rate_group_benefit_del_be
                    BEFORE DELETE ON sp_rate_group_benefit FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_rate_group_benefit\" INTO @tc_table_id;
                            SELECT sp_rate_group_benefit_trf_yn FROM sp_rate_group_benefit WHERE sp_rate_group_benefit_ix = OLD.sp_rate_group_benefit_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_rate_group_benefit_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_rate_group_qualify_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_rate_group_qualify_ins_be
                BEFORE INSERT ON sp_rate_group_qualify FOR EACH ROW
                tr_sp_rate_group_qualify_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_rate_group_qualify_ix IS NULL or NEW.sp_rate_group_qualify_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_rate_group_qualify_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_rate_group_qualify_ix = ix;
                            SET NEW.sp_rate_group_qualify_id = 0;
                            SET NEW.sp_rate_group_qualify_db = @db_code;

                            IF NEW.sp_rate_group_qualify_trf_yn IS NULL THEN
                                SET NEW.sp_rate_group_qualify_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_rate_group_qualify_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_rate_group_qualify_ins_af
                        AFTER INSERT ON sp_rate_group_qualify FOR EACH ROW
                        tr_sp_rate_group_qualify_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_rate_group_qualify\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_rate_group_qualify_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_rate_group_qualify_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_rate_group_qualify_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_rate_group_qualify_upd_be
                    BEFORE UPDATE ON sp_rate_group_qualify FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_rate_group_qualify\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_rate_group_qualify_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_rate_group_qualify_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_rate_group_qualify_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_rate_group_qualify_trf_yn IS NULL THEN
                                SET NEW.sp_rate_group_qualify_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_rate_group_qualify_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_rate_group_qualify_del_be
                    BEFORE DELETE ON sp_rate_group_qualify FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_rate_group_qualify\" INTO @tc_table_id;
                            SELECT sp_rate_group_qualify_trf_yn FROM sp_rate_group_qualify WHERE sp_rate_group_qualify_ix = OLD.sp_rate_group_qualify_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_rate_group_qualify_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_special_period_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_special_period_ins_be
                BEFORE INSERT ON sp_special_period FOR EACH ROW
                tr_sp_special_period_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_special_period_ix IS NULL or NEW.sp_special_period_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_special_period_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_special_period_ix = ix;
                            SET NEW.sp_special_period_id = 0;
                            SET NEW.sp_special_period_db = @db_code;

                            IF NEW.sp_special_period_trf_yn IS NULL THEN
                                SET NEW.sp_special_period_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_special_period_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_special_period_ins_af
                        AFTER INSERT ON sp_special_period FOR EACH ROW
                        tr_sp_special_period_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special_period\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_special_period_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_special_period_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_special_period_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_special_period_upd_be
                    BEFORE UPDATE ON sp_special_period FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special_period\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_special_period_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_special_period_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_special_period_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_special_period_trf_yn IS NULL THEN
                                SET NEW.sp_special_period_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_special_period_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_special_period_del_be
                    BEFORE DELETE ON sp_special_period FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special_period\" INTO @tc_table_id;
                            SELECT sp_special_period_trf_yn FROM sp_special_period WHERE sp_special_period_ix = OLD.sp_special_period_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_special_period_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_sp_special_rate_type_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_sp_special_rate_type_ins_be
                BEFORE INSERT ON sp_special_rate_type FOR EACH ROW
                tr_sp_special_rate_type_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.sp_special_rate_type_ix IS NULL or NEW.sp_special_rate_type_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_sp_special_rate_type_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.sp_special_rate_type_ix = ix;
                            SET NEW.sp_special_rate_type_id = 0;
                            SET NEW.sp_special_rate_type_db = @db_code;

                            IF NEW.sp_special_rate_type_trf_yn IS NULL THEN
                                SET NEW.sp_special_rate_type_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_sp_special_rate_type_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_sp_special_rate_type_ins_af
                        AFTER INSERT ON sp_special_rate_type FOR EACH ROW
                        tr_sp_special_rate_type_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special_rate_type\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.sp_special_rate_type_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_sp_special_rate_type_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_special_rate_type_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_special_rate_type_upd_be
                    BEFORE UPDATE ON sp_special_rate_type FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special_rate_type\" INTO @tc_table_id;
                        SET row_transferred = OLD.sp_special_rate_type_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.sp_special_rate_type_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.sp_special_rate_type_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.sp_special_rate_type_trf_yn IS NULL THEN
                                SET NEW.sp_special_rate_type_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_sp_special_rate_type_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_sp_special_rate_type_del_be
                    BEFORE DELETE ON sp_special_rate_type FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"sp_special_rate_type\" INTO @tc_table_id;
                            SELECT sp_special_rate_type_trf_yn FROM sp_special_rate_type WHERE sp_special_rate_type_ix = OLD.sp_special_rate_type_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sp_special_rate_type_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_rv_special_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_rv_special_ins_be
                BEFORE INSERT ON rv_special FOR EACH ROW
                tr_rv_special_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.rv_special_ix IS NULL or NEW.rv_special_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_rv_special_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.rv_special_ix = ix;
                            SET NEW.rv_special_id = 0;
                            SET NEW.rv_special_db = @db_code;

                            IF NEW.rv_special_trf_yn IS NULL THEN
                                SET NEW.rv_special_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_rv_special_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_rv_special_ins_af
                        AFTER INSERT ON rv_special FOR EACH ROW
                        tr_rv_special_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_special\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.rv_special_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_rv_special_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_special_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_special_upd_be
                    BEFORE UPDATE ON rv_special FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_special\" INTO @tc_table_id;
                        SET row_transferred = OLD.rv_special_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.rv_special_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.rv_special_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.rv_special_trf_yn IS NULL THEN
                                SET NEW.rv_special_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_rv_special_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_rv_special_del_be
                    BEFORE DELETE ON rv_special FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"rv_special\" INTO @tc_table_id;
                            SELECT rv_special_trf_yn FROM rv_special WHERE rv_special_ix = OLD.rv_special_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_special_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_ad_res_detail_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_ad_res_detail_ins_be
                BEFORE INSERT ON ad_res_detail FOR EACH ROW
                tr_ad_res_detail_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.ad_res_detail_ix IS NULL or NEW.ad_res_detail_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_ad_res_detail_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.ad_res_detail_ix = ix;
                            SET NEW.ad_res_detail_id = 0;
                            SET NEW.ad_res_detail_db = @db_code;

                            IF NEW.ad_res_detail_trf_yn IS NULL THEN
                                SET NEW.ad_res_detail_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_ad_res_detail_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_ad_res_detail_ins_af
                        AFTER INSERT ON ad_res_detail FOR EACH ROW
                        tr_ad_res_detail_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_res_detail\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.ad_res_detail_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_ad_res_detail_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_res_detail_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_res_detail_upd_be
                    BEFORE UPDATE ON ad_res_detail FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_res_detail\" INTO @tc_table_id;
                        SET row_transferred = OLD.ad_res_detail_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ad_res_detail_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ad_res_detail_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ad_res_detail_trf_yn IS NULL THEN
                                SET NEW.ad_res_detail_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_ad_res_detail_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_ad_res_detail_del_be
                    BEFORE DELETE ON ad_res_detail FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"ad_res_detail\" INTO @tc_table_id;
                            SELECT ad_res_detail_trf_yn FROM ad_res_detail WHERE ad_res_detail_ix = OLD.ad_res_detail_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.ad_res_detail_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_bl_block_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_bl_block_ins_be
                BEFORE INSERT ON bl_block FOR EACH ROW
                tr_bl_block_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.bl_block_ix IS NULL or NEW.bl_block_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_bl_block_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"bl_block\"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(bl_block.bl_block_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    bl_block
                                WHERE
                                    bl_block.bl_block_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    \"bl_block\",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = \"bl_block\"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                bl_block
                            WHERE
                                bl_block.bl_block_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(bl_block.bl_block_id) -- Get the highest ID in table
                            FROM
                                bl_block
                            WHERE
                                bl_block_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN bl_block ON bl_block.bl_block_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = \"bl_block\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN bl_block ON bl_block.bl_block_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = \"bl_block\"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.bl_block_db = @db_code;
                            SET NEW.bl_block_id = id;
                            SET NEW.bl_block_ix = ix;

                            IF NEW.bl_block_trf_yn IS NULL THEN
                                SET NEW.bl_block_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN bl_block ON bl_block.bl_block_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, \"bl_block\");
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_bl_block_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_bl_block_ins_af
                        AFTER INSERT ON bl_block FOR EACH ROW
                        tr_bl_block_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.bl_block_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_bl_block_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_bl_block_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_bl_block_upd_be
                    BEFORE UPDATE ON bl_block FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block\" INTO @tc_table_id;
                        SET row_transferred = OLD.bl_block_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.bl_block_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.bl_block_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.bl_block_trf_yn IS NULL THEN
                                SET NEW.bl_block_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_bl_block_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_bl_block_del_be
                    BEFORE DELETE ON bl_block FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block\" INTO @tc_table_id;
                            SELECT bl_block_trf_yn FROM bl_block WHERE bl_block_ix = OLD.bl_block_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.bl_block_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_bl_block_period_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_bl_block_period_ins_be
                BEFORE INSERT ON bl_block_period FOR EACH ROW
                tr_bl_block_period_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.bl_block_period_ix IS NULL or NEW.bl_block_period_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_bl_block_period_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.bl_block_period_ix = ix;
                            SET NEW.bl_block_period_id = 0;
                            SET NEW.bl_block_period_db = @db_code;

                            IF NEW.bl_block_period_trf_yn IS NULL THEN
                                SET NEW.bl_block_period_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_bl_block_period_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_bl_block_period_ins_af
                        AFTER INSERT ON bl_block_period FOR EACH ROW
                        tr_bl_block_period_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block_period\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.bl_block_period_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_bl_block_period_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_bl_block_period_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_bl_block_period_upd_be
                    BEFORE UPDATE ON bl_block_period FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block_period\" INTO @tc_table_id;
                        SET row_transferred = OLD.bl_block_period_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.bl_block_period_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.bl_block_period_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.bl_block_period_trf_yn IS NULL THEN
                                SET NEW.bl_block_period_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_bl_block_period_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_bl_block_period_del_be
                    BEFORE DELETE ON bl_block_period FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block_period\" INTO @tc_table_id;
                            SELECT bl_block_period_trf_yn FROM bl_block_period WHERE bl_block_period_ix = OLD.bl_block_period_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.bl_block_period_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_bl_block_itinerary_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_bl_block_itinerary_ins_be
                BEFORE INSERT ON bl_block_itinerary FOR EACH ROW
                tr_bl_block_itinerary_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.bl_block_itinerary_ix IS NULL or NEW.bl_block_itinerary_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_bl_block_itinerary_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.bl_block_itinerary_ix = ix;
                            SET NEW.bl_block_itinerary_id = 0;
                            SET NEW.bl_block_itinerary_db = @db_code;

                            IF NEW.bl_block_itinerary_trf_yn IS NULL THEN
                                SET NEW.bl_block_itinerary_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_bl_block_itinerary_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_bl_block_itinerary_ins_af
                        AFTER INSERT ON bl_block_itinerary FOR EACH ROW
                        tr_bl_block_itinerary_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block_itinerary\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.bl_block_itinerary_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_bl_block_itinerary_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_bl_block_itinerary_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_bl_block_itinerary_upd_be
                    BEFORE UPDATE ON bl_block_itinerary FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block_itinerary\" INTO @tc_table_id;
                        SET row_transferred = OLD.bl_block_itinerary_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.bl_block_itinerary_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.bl_block_itinerary_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.bl_block_itinerary_trf_yn IS NULL THEN
                                SET NEW.bl_block_itinerary_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_bl_block_itinerary_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_bl_block_itinerary_del_be
                    BEFORE DELETE ON bl_block_itinerary FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"bl_block_itinerary\" INTO @tc_table_id;
                            SELECT bl_block_itinerary_trf_yn FROM bl_block_itinerary WHERE bl_block_itinerary_ix = OLD.bl_block_itinerary_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE \"45000\" SET
                                    MYSQL_ERRNO = \"30002\",
                                    MESSAGE_TEXT = \"Cannot delete data transferred row on slave environment\";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.bl_block_itinerary_ix);
                            END IF;

                            END; ");
        $this->addSql("
                DROP TRIGGER IF EXISTS tr_fn_invoice_special_ins_be; ");
        $this->addSql("
                CREATE TRIGGER tr_fn_invoice_special_ins_be
                BEFORE INSERT ON fn_invoice_special FOR EACH ROW
                tr_fn_invoice_special_ins_be: BEGIN
                    -- Indicator: 0
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.fn_invoice_special_ix IS NULL or NEW.fn_invoice_special_ix = \"\", FALSE, TRUE) THEN
                                LEAVE tr_fn_invoice_special_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.fn_invoice_special_ix = ix;
                            SET NEW.fn_invoice_special_id = 0;
                            SET NEW.fn_invoice_special_db = @db_code;

                            IF NEW.fn_invoice_special_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_special_trf_yn = 0;
                            END IF;
                        END; ");
        $this->addSql("

                        DROP TRIGGER IF EXISTS tr_fn_invoice_special_ins_af; ");
        $this->addSql("
                        CREATE TRIGGER tr_fn_invoice_special_ins_af
                        AFTER INSERT ON fn_invoice_special FOR EACH ROW
                        tr_fn_invoice_special_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_special\" INTO @tc_table_id;
                            SET @last_insert_id = NEW.fn_invoice_special_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_fn_invoice_special_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_special_upd_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_special_upd_be
                    BEFORE UPDATE ON fn_invoice_special FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_special\" INTO @tc_table_id;
                        SET row_transferred = OLD.fn_invoice_special_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE \"45000\" SET
                                MYSQL_ERRNO = \"30002\",
                                MESSAGE_TEXT = \"Cannot edit data transferred row on slave environment\";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.fn_invoice_special_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.fn_invoice_special_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.fn_invoice_special_trf_yn IS NULL THEN
                                SET NEW.fn_invoice_special_trf_yn = 0;
                            END IF;
                        END IF;
                    END; ");
        $this->addSql("
                    DROP TRIGGER IF EXISTS tr_fn_invoice_special_del_be; ");
        $this->addSql("
                    CREATE TRIGGER tr_fn_invoice_special_del_be
                    BEFORE DELETE ON fn_invoice_special FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = \"fn_invoice_special\" INTO @tc_table_id;
                            SELECT fn_invoice_spe