<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20190706095945 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        $sql = "
            SET @dbName = DATABASE();
            SET @tableName = \"fn_system\";
            SET @columnName = \"fn_sys_debtor_journal_yn\";
            SET @preparedStatement = (SELECT IF(
                (
                    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
                    WHERE
                        (table_name = @tableName)
                        AND (table_schema = @dbName)
                        AND (column_name = @columnName)
                ) > 0,
                \"SELECT 1\",
                \"ALTER TABLE `fn_system` ADD `fn_sys_debtor_journal_yn` TINYINT(1) NOT NULL DEFAULT 0 AFTER `fn_sys_tran_summary_yn`;\"
                ));
            PREPARE alterIfNotExists FROM @preparedStatement;
            EXECUTE alterIfNotExists;
            DEALLOCATE PREPARE alterIfNotExits;
        ";
        $this->addSql($sql);

        $sql = "UPDATE fn_system SET fn_sys_debtor_journal_yn = 1 WHERE fn_system_ix = 'RS8'";
        $this->addSql($sql);

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");
        $sql = "
            ALTER TABLE `fn_tran_item` DROP `fn_sys_debtor_journal_yn`;
        ";
        $this->addSql($sql);
        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }
}

