<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * RRDEV-1142 Rooming calendar
 */
class Version20190725124300 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

		$this->addSql("INSERT INTO sc_job VALUES (1024, 'Rooming module', 4, '\"1:1014:1\"', 0, NULL, 1)");
		$this->addSql("INSERT INTO sc_fun_job VALUES (null, 1024, 81, NULL, 1)");
		$this->addSql("INSERT INTO sc_route VALUES (null, '/rooming*', 'Rooming Module', 4, 1)");
		$this->addSql("SELECT sc_route_id INTO @rooming_route_id FROM sc_route WHERE sc_route_name = '/rooming*'");
		$this->addSql("INSERT INTO sc_fun_route VALUES (null, @rooming_route_id, 81, 1)");

        $roomingMenuIds = [114, 139, 195, 212, 243];
        $this->addSql("
            UPDATE sc_menu SET
                sc_function_id = 0,
                sc_job_id = 0
            WHERE
                sc_menu.sc_menu_id IN (" . join(",",$roomingMenuIds) . ")
        ");
        foreach($roomingMenuIds as $menuId) {
            $this->addSql("
                INSERT INTO sc_menu
                    (sc_menu_parent, sc_menu_seq, sc_menu_title, sc_function_id, sc_job_id, sc_menu_format_id)
                VALUES
                    ($menuId, 1, 'Classic', 81, 234, 7),
                    ($menuId, 2, 'Modern', 81, 1024, 7)
            ");
        }

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

		$this->addSql("DELETE FROM sc_job WHERE sc_job_id = '1024'");
		$this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = '1024'");
		$this->addSql("SELECT sc_route_id INTO @rooming_route_id FROM sc_route WHERE sc_route_name = '/rooming*'");
		$this->addSql("DELETE FROM sc_fun_route WHERE sc_route_id = @rooming_route_id");
		$this->addSql("DELETE FROM sc_route WHERE sc_route_name = '/rooming*'");

        $roomingMenuIds = [114, 139, 195, 212, 243];
        $this->addSql("
            UPDATE sc_menu SET
                sc_function_id = 81,
                sc_job_id = 234
            WHERE
                sc_menu.sc_menu_id IN (" . join(",",$roomingMenuIds) . ")
        ");
        $this->addSql("DELETE FROM sc_menu WHERE sc_menu_parent IN (" . join(",",$roomingMenuIds) . ")");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }
}
