<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20190804000001 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        $this->addSql("DROP TABLE IF EXISTS pr_notification");
        $this->addSql("
            CREATE TABLE pr_notification (
                pr_notification_db char(2) NOT NULL DEFAULT '',
                pr_notification_id int(11) NOT NULL,
                pr_notification_ix varchar(36) NOT NULL,
                pr_notification_subject text NOT NULL,
                pr_notification_message text NOT NULL,
                pr_notification_priority tinyint(1) NOT NULL,
                pr_notification_added timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                pr_notification_added_by varchar(36) NOT NULL,
                dt_temp_id varchar(36) DEFAULT NULL,
                pr_notification_trf_yn tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");
        $this->addSql("ALTER TABLE pr_notification ADD PRIMARY KEY (pr_notification_ix);");

        $this->addSql("DROP TABLE IF EXISTS pr_notification_target");
        $this->addSql("
            CREATE TABLE pr_notification_target (
                pr_notification_target_db char(2) NOT NULL DEFAULT '',
                pr_notification_target_id int(11) NOT NULL,
                pr_notification_target_ix varchar(36) NOT NULL,
                pr_notification_id varchar(36) NOT NULL,
                pr_user_id varchar(40) NOT NULL,
                dt_temp_id varchar(36) DEFAULT NULL,
                pr_notification_target_trf_yn tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");
        $this->addSql("ALTER TABLE pr_notification_target ADD PRIMARY KEY (pr_notification_target_ix);");

        $this->addSql("DROP TABLE IF EXISTS pr_notification_receipt");
        $this->addSql("
            CREATE TABLE pr_notification_receipt (
                pr_notification_receipt_db char(2) NOT NULL DEFAULT '',
                pr_notification_receipt_id int(11) NOT NULL,
                pr_notification_receipt_ix varchar(36) NOT NULL,
                pr_notification_id varchar(36) NOT NULL,
                pr_user_id varchar(40) NOT NULL,
                pr_notification_receipt_delivered_timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
                pr_notification_receipt_read_timestamp timestamp NULL DEFAULT NULL,
                pr_notification_receipt_acknowledged_timestamp timestamp NULL DEFAULT NULL,
                dt_temp_id varchar(36) DEFAULT NULL,
                pr_notification_receipt_trf_yn tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");
        $this->addSql("ALTER TABLE pr_notification_receipt ADD PRIMARY KEY (pr_notification_receipt_ix);");

        $this->addSql("DROP TABLE IF EXISTS pr_notification_archive");
        $this->addSql("
            CREATE TABLE pr_notification_archive (
                pr_notification_archive_db char(2) NOT NULL DEFAULT '',
                pr_notification_archive_id int(11) NOT NULL,
                pr_notification_archive_ix varchar(36) NOT NULL,
                pr_notification_id varchar(36) NOT NULL,
                pr_user_id varchar(40) NOT NULL,
                pr_notification_archive_timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
                dt_temp_id varchar(36) DEFAULT NULL,
                pr_notification_archive_trf_yn tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");
        $this->addSql("ALTER TABLE pr_notification_archive ADD PRIMARY KEY (pr_notification_archive_ix);");

        $this->addSql("DROP TABLE IF EXISTS pr_notification_prefs");
        $this->addSql("
            CREATE TABLE pr_notification_prefs (
                pr_notification_prefs_db char(2) NOT NULL DEFAULT '',
                pr_notification_prefs_id int(11) NOT NULL,
                pr_notification_prefs_ix varchar(36) NOT NULL,
                pr_user_id varchar(40) NOT NULL,
                pr_notification_prefs_show_popup tinyint(1) NOT NULL,
                pr_notification_prefs_timestamp timestamp DEFAULT CURRENT_TIMESTAMP,
                dt_temp_id varchar(36) DEFAULT NULL,
                pr_notification_prefs_trf_yn tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");
        $this->addSql("ALTER TABLE pr_notification_prefs ADD PRIMARY KEY (pr_notification_prefs_ix);");

        $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, dt_temp_id, sc_fun_job_trf_yn) VALUES ('3006', '66', NULL, '1')");
        $this->addSql("INSERT INTO sc_job (sc_job_id, sc_job_desc, sc_job_level, sc_job_cords, sc_job_homepage_yn, dt_temp_id, sc_job_trf_yn) VALUES ('3006', 'Notifications', '4', '\"1:3006:1\"', '0', NULL, '0')");
        $this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn) VALUES ('pr_notification', '30', '0', '0', '0', NULL, '0')");
        $this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn) VALUES ('pr_notification_target', '30', '0', '0', '0', NULL, '0')");
        $this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn) VALUES ('pr_notification_receipt', '30', '0', '0', '0', NULL, '0')");
        $this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn) VALUES ('pr_notification_archive', '30', '0', '0', '0', NULL, '0')");
        $this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn) VALUES ('pr_notification_prefs', '30', '0', '0', '0', NULL, '0')");

        

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // Do nothing
    }
}
