<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Add tables ch_chart, ch_chart_container, sc_group_chart and sc_group_chart_container
 */
class Version20191105202709 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        $this->addSql("
            CREATE TABLE `ch_chart` (
                `ch_chart_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '''''',
                `ch_chart_id` int(11) NOT NULL,
                `ch_chart_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_description` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
                `ch_chart_report_info` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
                `ch_chart_library` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_configuration` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json_array)',
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");
        $this->addSql("
            ALTER TABLE `ch_chart`
                ADD PRIMARY KEY (`ch_chart_ix`);
        ");




        $this->addSql("
            CREATE TABLE `ch_chart_container` (
                `ch_chart_container_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '''''',
                `ch_chart_container_id` int(11) NOT NULL,
                `ch_chart_container_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_container_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_container_description` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
                `ch_chart_container_configuration` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json_array)',
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ch_chart_container_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");
        $this->addSql("
            ALTER TABLE `ch_chart_container`
                ADD PRIMARY KEY (`ch_chart_container_ix`);
        ");




        $this->addSql("
            CREATE TABLE `sc_group_chart_container` (
                `sc_group_chart_container_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `sc_group_chart_container_id` int(11) NOT NULL,
                `sc_group_chart_container_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `sc_group_id` int(11) NOT NULL,
                `ch_chart_container_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `sc_group_chart_container_level` int(11) NOT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
                `sc_group_chart_container_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");
        $this->addSql("
            ALTER TABLE `sc_group_chart_container`
                ADD PRIMARY KEY (`sc_group_chart_container_ix`);
        ");




        $this->addSql("
            CREATE TABLE `sc_group_chart` (
                `sc_group_chart_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `sc_group_chart_id` int(11) NOT NULL,
                `sc_group_chart_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `sc_group_id` int(11) NOT NULL,
                `ch_chart_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `sc_group_chart_level` int(11) NOT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
                `sc_group_chart_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");
        $this->addSql("
            ALTER TABLE `sc_group_chart`
                ADD PRIMARY KEY (`sc_group_chart_ix`);
        ");


        // Add tc_table entries
        $this->addSql("
            INSERT INTO `tc_table` (`tc_table_name`, `tc_table_seq`, `tc_table_sys_code`, `tc_table_key_ind`, `tc_table_user_facing_yn`, `dt_temp_id`, `tc_table_trf_yn`) VALUES
            ('sc_group_chart_container', 35, 0, 0, 0, '', 1),
            ('ch_chart', 35, 0, 0, 0, '', 1),
            ('ch_chart_container', 35, 0, 0, 0, '', 1),
            ('sc_group_chart', 35, 0, 0, 0, '', 1)
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
