<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Insert charts and chart containers
 */
class Version20191105202714 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql(<<<'EOT'
        INSERT INTO `ch_chart` (`ch_chart_db`, `ch_chart_id`, `ch_chart_ix`, `ch_chart_name`, `ch_chart_description`, `ch_chart_report_info`, `ch_chart_library`, `ch_chart_type`, `ch_chart_configuration`, `dt_temp_id`, `ch_chart_trf_yn`) VALUES
        ('',	0,	'11e8439f3234ef708be40cc47a969e7c',	'New booking performance by consultant',	'Total new bookings created this past week (today and the previous six days), grouped by the user who created the booking and by status. The chart shows the name of the user who created the booking originally, i.e. not the consultant currently linked to the booking. This chart gives the team an idea of the volume of bookings created by different users. This week\'s performance is an overlay on the previous two weeks.',	'How to generate this data using a report: Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), in the Res filters set the Create date range to this week (or the previous week/s), set the Status filter to All and set the Created by filter to the respective consultant. Group your results by Status and select the Reservation Count field for your results.',	'FusionCharts',	'MsArea',	'{\r\n    \"library\": {\r\n        \"fusionCharts\": {\r\n            \"chart\": {\r\n                \"caption\": \"New booking performance by consultant\",\r\n                \"subcaption\": \"Today and the previous six days\",\r\n                \"xAxisName\": \"Consultant\",\r\n                \"yAxisName\": \"Bookings\",\r\n                \"plottooltext\": \"<b>$value $seriesName</b> bookings allocated to $label\",\r\n                \"theme\": \"fusion\",\r\n                \"captionAlignment\": \"center\",\r\n                \"baseFont\": \"Helvetica\",\r\n                \"legendItemFont\": \"Helvetica\",\r\n                \"legendItemFontSize\": \"13\",\r\n                \"outCnvBaseFontSize\": \"11\",\r\n                \"xAxisNameFontSize\": \"11\",\r\n                \"labelDisplay\": \"STAGGER\"\r\n            }\r\n        }\r\n    },\r\n    \"datasets\": [\r\n        {\r\n            \"name\": \"consultantBookingsByStatus\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"category\": \"consultantName\",\r\n                    \"series\": [\r\n                        {\r\n                            \"seriesName\": \"Last week\",\r\n                            \"data\": \"consultantTotalBookings\"\r\n                        }\r\n                    ]\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"dateRecordedPeriod\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"-6 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"today\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ],\r\n                \"modifiers\": [\r\n                    {\r\n                        \"modifier\": \"addition\",\r\n                        \"enabled\": true,\r\n                        \"config\": {\r\n                            \"resultField\": \"consultantTotalBookings\",\r\n                            \"additionFields\": [\r\n                                \"quotation\",\r\n                                \"waitlisted\",\r\n                                \"validProvisional\",\r\n                                \"expiredProvisional\",\r\n                                \"cancelled\",\r\n                                \"confirmed\",\r\n                                \"deleted\"\r\n                            ]\r\n                        }\r\n                    }\r\n                ]\r\n            }\r\n        },\r\n        {\r\n            \"name\": \"consultantBookingsByStatus\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"category\": \"consultantName\",\r\n                    \"series\": [\r\n                        {\r\n                            \"seriesName\": \"Previous week\",\r\n                            \"data\": \"consultantTotalBookings\"\r\n                        }\r\n                    ]\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"dateRecordedPeriod\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"-13 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"-7 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ],\r\n                \"modifiers\": [\r\n                    {\r\n                        \"modifier\": \"addition\",\r\n                        \"enabled\": true,\r\n                        \"config\": {\r\n                            \"resultField\": \"consultantTotalBookings\",\r\n                            \"additionFields\": [\r\n                                \"quotation\",\r\n                                \"waitlisted\",\r\n                                \"validProvisional\",\r\n                                \"expiredProvisional\",\r\n                                \"cancelled\",\r\n                                \"confirmed\",\r\n                                \"deleted\"\r\n                            ]\r\n                        }\r\n                    }\r\n                ]\r\n            }\r\n        },\r\n        {\r\n            \"name\": \"consultantBookingsByStatus\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"category\": \"consultantName\",\r\n                    \"series\": [\r\n                        {\r\n                            \"seriesName\": \"Previous, previous week\",\r\n                            \"data\": \"consultantTotalBookings\"\r\n                        }\r\n                    ]\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"dateRecordedPeriod\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"-20 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"-14 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ],\r\n                \"modifiers\": [\r\n                    {\r\n                        \"modifier\": \"addition\",\r\n                        \"enabled\": true,\r\n                        \"config\": {\r\n                            \"resultField\": \"consultantTotalBookings\",\r\n                            \"additionFields\": [\r\n                                \"quotation\",\r\n                                \"waitlisted\",\r\n                                \"validProvisional\",\r\n                                \"expiredProvisional\",\r\n                                \"cancelled\",\r\n                                \"confirmed\",\r\n                                \"deleted\"\r\n                            ]\r\n                        }\r\n                    }\r\n                ]\r\n            }\r\n        }\r\n    ]\r\n}',	'',	0),
        ('',	0,	'11e9ad14ad08dddf90da02399910d15e',	'Consultant bookings by arrival',	'This chart shows consultant workloads based on bookings due to arrive. The chart includes stock-holding bookings arriving \'This week\' (today and in the next six days) and \'Future\' bookings (bookings beyond this week). A booking is included in the results if the first arrival date for the booking falls within the date range and if bookings are confirmed or valid provisionals (valid means not-expired). The consultant is based on the allocated consultant, i.e. not the user who created the booking.',	'How to generate this data using a report: Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), set the Travel date range to Arrival for this week (or future weeks). Set the Status filter to Confirmed and Provisional, remember to select Exclude expired Provisionals. Group your results by Consultant and select the Reservation Count field for your results.',	'FusionCharts',	'ScrollStackedColumn2D',	'{\r\n        \"library\": {\r\n            \"fusionCharts\": {\r\n                \"chart\": {\r\n                    \"caption\": \"Consultant bookings by arrival\",\r\n                    \"subcaption\": \"Stock-holding bookings arriving from today\",\r\n                    \"yaxisname\": \"Bookings\",\r\n                    \"flatscrollbars\": \"1\",\r\n                    \"scrollheight\": \"12\",\r\n                    \"numvisibleplot\": \"8\",\r\n                    \"plottooltext\": \"<b>$dataValue</b> bookings allocated to $label\",\r\n                    \"showSum\": true,\r\n                    \"theme\": \"fusion\",\r\n                    \"captionAlignment\": \"center\",\r\n                    \"baseFont\": \"Helvetica\",\r\n                    \"legendItemFont\": \"Helvetica\",\r\n                    \"legendItemFontSize\": \"13\",\r\n                    \"outCnvBaseFontSize\": \"11\",\r\n                    \"xAxisNameFontSize\": \"11\",\r\n                    \"labelDisplay\": \"STAGGER\"\r\n                }\r\n            }\r\n        },\r\n        \"datasets\": [\r\n            {\r\n                \"name\": \"consultantWorkload\",\r\n                \"chartConfig\": {\r\n                    \"mappings\": {\r\n                        \"category\": \"consultantName\",\r\n                        \"series\": [\r\n                            {\r\n                                \"seriesName\": \"This week\",\r\n                                \"data\": \"currentAndFutureBookings\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Future\",\r\n                                \"data\": \"otherBookings\"\r\n                            }\r\n                        ]\r\n                    }\r\n                },\r\n                \"config\": {\r\n                    \"filters\": [\r\n                        {\r\n                            \"name\": \"accommodationAccess\",\r\n                            \"enabled\": true,\r\n                            \"visible\": true,\r\n                            \"options\": [\r\n                                {\r\n                                    \"optionName\": \"disableAcl\",\r\n                                    \"value\": false,\r\n                                    \"visible\": true,\r\n                                    \"enabled\": false\r\n                                },\r\n                                {\r\n                                    \"optionName\": \"endDate\",\r\n                                    \"value\": \"+6 days\",\r\n                                    \"visible\": true,\r\n                                    \"enabled\": true\r\n                                }\r\n                            ]\r\n                        }\r\n                    ],\r\n                    \"modifiers\": [\r\n                        {\r\n                            \"modifier\": \"total\",\r\n                            \"enabled\": true,\r\n                            \"config\": {\r\n                                \"resultField\": \"totalWorkload\",\r\n                                \"totalFields\": [\r\n                                    \"currentAndFutureBookings\",\r\n                                    \"otherBookings\"\r\n                                ]\r\n                            }\r\n                        }\r\n                    ]\r\n                }\r\n            }\r\n        ]\r\n    }',	'',	0),
        ('',	0,	'11e9c41c91446fdc928e02399910d15e',	'Arrivals by consultant without full payment',	'Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), set the Travel date range to Arrival for this week. Set the Res filters > Status filter to Confirmed and Provisional, remember to select Exclude expired Provisionals. Set Folio filters > Filter by amount owing to TBA, Unpaid and Part Paid. Group your results by Consultant and select the Reservation Count field for your results. Note: bookings with a 0.00 value are considered as fully paid on the chart; however the Financial Analysis report considers them as unpaid and fully paid, these bookings will need to be separated on the Financial Analysis report in order to balance with the chart.',	'How to generate this data using a report: Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), set the Travel date range to Arrival for this week. Set the Res filters > Status filter to Confirmed and Provisional, remember to select Exclude expired Provisionals. Set Folio filters > Filter by amount owing to TBA, Unpaid and Part Paid. Group your results by Consultant and select the Reservation Count field for your results.',	'FusionCharts',	'Doughnut2D',	'{\r\n    \"library\": {\r\n        \"fusionCharts\": {\r\n            \"chart\": {\r\n                \"caption\": \"Arrivals by consultant without full payment\",\r\n                \"subcaption\": \"For today and the next six days\",\r\n                \"decimals\": \"0\",\r\n                \"showPercentValues\": \"0\",\r\n                \"showValues\": \"1\",\r\n                \"theme\": \"fusion\",\r\n                \"animation\": \"1\",\r\n                \"animationDuration\": \"1\",\r\n                \"captionAlignment\": \"center\",\r\n                \"enableSmartLabels\": \"1\",\r\n                \"baseFont\": \"Helvetica\",\r\n                \"legendItemFont\": \"Helvetica\",\r\n                \"outCnvBaseFontSize\": \"12\",\r\n                \"legendItemFontSize\": \"13\",\r\n                \"labelFontSize\": \"12\",\r\n                \"manageLabelOverflow\": \"1\",\r\n                \"showLegend\": \"0\"\r\n            }\r\n        }\r\n    },\r\n    \"datasets\": [\r\n        {\r\n            \"name\": \"arrivalsWithoutFullPayment\",\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"arrivalPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"today\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"+6 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ]\r\n            },\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"label\": \"consultantName\",\r\n                    \"value\": \"bookingsWithoutFullPayment\"\r\n                }\r\n            }\r\n        }\r\n    ]\r\n}',	'',	0),
        ('',	0,	'11e9c4556a79d3db928e02399910d15e',	'Provisionals due to expire',	'All provisional bookings grouped by consultant that will expire this week, i.e. that will expire today and in the next six days.',	'How to generate this data using a report: Use the Provisional Expiry report. Select the Date range to Today and for the next six days. Set the Consultant filter and generate the report as a List.',	'FusionCharts',	'Doughnut2D',	'{\r\n    \"library\": {\r\n        \"fusionCharts\": {\r\n            \"chart\": {\r\n                \"caption\": \"Provisionals due to expire\",\r\n                \"subcaption\": \"For today and the next six days\",\r\n                \"animation\": \"1\",\r\n                \"animationDuration\": \"1\",\r\n                \"decimals\": \"0\",\r\n                \"showPercentValues\": \"0\",\r\n                \"showValues\": \"1\",\r\n                \"theme\": \"fusion\",\r\n                \"captionAlignment\": \"center\",\r\n                \"enableSmartLabels\": \"1\",\r\n                \"baseFont\": \"Helvetica\",\r\n                \"legendItemFont\": \"Helvetica\",\r\n                \"outCnvBaseFontSize\": \"12\",\r\n                \"legendItemFontSize\": \"12\",\r\n                \"labelFontSize\": \"12\",\r\n                \"manageLabelOverflow\": \"1\",\r\n                \"showLegend\": \"0\"\r\n            }\r\n        }\r\n    },\r\n    \"datasets\": [\r\n        {\r\n            \"name\": \"provisionalsDueToExpire\",\r\n            \"config\": {\r\n                \"filters\": [\r\n                        {\r\n                            \"name\": \"provisionalExpiryPeriod\",\r\n                            \"role\": \"hello\",\r\n                            \"enabled\": true,\r\n                            \"visible\": true,\r\n                            \"options\": [\r\n                                {\r\n                                    \"optionName\": \"startDate\",\r\n                                    \"value\": \"today\",\r\n                                    \"visible\": true,\r\n                                    \"enabled\": true\r\n                                },\r\n                                {\r\n                                    \"optionName\": \"endDate\",\r\n                                    \"value\": \"+6 days\",\r\n                                    \"visible\": true,\r\n                                    \"enabled\": true\r\n                                }\r\n                            ]\r\n                        }\r\n                    ]\r\n            },\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"label\": \"consultantName\",\r\n                    \"value\": \"provisionalsDueToExpire\"\r\n                }\r\n            }\r\n        }\r\n    ]\r\n}',	'',	0),
        ('',	0,	'11e9c46b31e53f5f928e02399910d15e',	'Arrivals without full payment',	'See payments on confirmed and valid provisional bookings (not expired provisionals) travelling today and in the next six days. This chart shows bookings where there is an outstanding amount on the total value of the booking. TBA bookings are included in the calculations and are considered unpaid, no matter how many receipts are recorded on the booking. Bookings that have a 0.00 total value are considered fully paid. Bookings that arrived today, are already checked in and have incurred direct guest charges at the property may skew the results for today\'s arrivals.',	'How to generate this data using a report: Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), set the Travel date range to Arrival for this week. Set the Res filters > Status filter to Confirmed and Provisional, remember to select Exclude expired Provisionals. Set Folio filters > Filter by amount owing to TBA, Unpaid and Part Paid. Group your results by Consultant and select the Reservation Count field for your results. Note: bookings with a 0.00 value are considered as fully paid on the chart; however the Financial Analysis report considers them as unpaid and fully paid, these bookings will need to be separated on the Financial Analysis report in order to balance with the chart.',	'FusionCharts',	'AngularGauge',	'{\r\n    \"library\": {\r\n        \"fusionCharts\": {\r\n            \"chart\": {\r\n                \"caption\": \"Arrivals without full payment\",\r\n                \"subcaption\": \"For today and the next six days\",\r\n                \"theme\": \"fusion\",\r\n                \"lowerlimit\": \"0\",\r\n                \"numbersuffix\": \"%\",\r\n                \"showtooltip\": \"1\",\r\n                \"baseFont\": \"Helvetica\",\r\n                \"outCnvBaseFont\": \"Helvetica\",\r\n                \"upperlimit\": 100\r\n            },\r\n            \"colorrange\": {\r\n                \"color\": [\r\n                    {\r\n                        \"minvalue\": \"0\",\r\n                        \"maxvalue\": \"10%\",\r\n                        \"code\": \"#F2726F\"\r\n                    },\r\n                    {\r\n                        \"minvalue\": \"10%\",\r\n                        \"maxvalue\": \"25%\",\r\n                        \"code\": \"#FFC533\"\r\n                    },\r\n                    {\r\n                        \"minvalue\": \"25%\",\r\n                        \"maxvalue\": \"50%\",\r\n                        \"code\": \"#62B58F\"\r\n                    },\r\n                    {\r\n                        \"minvalue\": \"50%\",\r\n                        \"maxvalue\": \"75%\",\r\n                        \"code\": \"#0080FF\"\r\n                    },\r\n                    {\r\n                        \"minvalue\": \"75%\",\r\n                        \"maxvalue\": \"100%\",\r\n                        \"code\": \"#BF00E5\"\r\n                    }\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    \"datasets\": [\r\n        {\r\n            \"name\": \"arrivalsWithoutFullPayment\",\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"arrivalPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"+6 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ],\r\n                \"modifiers\": [\r\n                    {\r\n                        \"modifier\": \"total\",\r\n                        \"enabled\": true,\r\n                        \"config\": {\r\n                            \"resultField\": \"totalBookingsWithoutFullPayment\",\r\n                            \"totalFields\": [\r\n                                \"bookingsWithoutFullPayment\"\r\n                            ]\r\n                        }\r\n                    },\r\n                    {\r\n                        \"modifier\": \"mathExpression\",\r\n                        \"enabled\": true,\r\n                        \"config\": {\r\n                            \"expressions\": [\r\n                                {\r\n                                    \"resultField\": \"bookingsWithoutFullPaymentPercentage\",\r\n                                    \"expression\": [\r\n                                        \"totalBookingsWithoutFullPayment\",\r\n                                        \"/\",\r\n                                        \"totalBookings\",\r\n                                        \"*\",\r\n                                        100\r\n                                    ]	\r\n                                }	\r\n                            ]\r\n                        }\r\n                    }\r\n                ]\r\n            },\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"dials\": [\r\n                        {\r\n                            \"value\": \"bookingsWithoutFullPaymentPercentage\"\r\n                        }\r\n                    ]\r\n                }\r\n            }\r\n        }\r\n    ]\r\n}',	'',	0),
        ('',	0,	'11e9c46b3f592816928e02399910d15e',	'Convertible waitlists',	'View consultant\'s waitlist bookings that can be converted to a stock-holding status i.e. where stock is available.',	'How to see this information on a calendar: Scan the Availability Calendar for days holding Waitlists (a purple handler at the bottom right of each cell indicates the days and room types where waitlists are held). If stock is available, the cell showing the waitlist will not be red for that day / room).',	'FusionCharts',	'Heatmap',	'{\r\n    \"library\": {\r\n        \"fusionCharts\": {\r\n            \"chart\": {\r\n                \"caption\": \"Convertible waitlists\",\r\n                \"subcaption\": \"Travelling in the next 30/60/90/120 days\",\r\n                \"plottooltext\": \"<b>$value</b> convertible waitlist bookings for <b>$rowLabel</b> travelling in the next <b>$columnLabel</b>\",\r\n                \"theme\": \"fusion\",\r\n                \"showValues\": \"true\",\r\n                \"captionAlignment\": \"center\",\r\n                \"baseFont\": \"Helvetica\",\r\n                \"xAxisNameFontSize\": \"12\",\r\n                \"xAxisNameFontColor\": \"#666666\",\r\n                \"labelFontSize\": \"12\"\r\n            },\r\n            \"colorrange\": {\r\n        \"gradient\": \"1\",\r\n        \"minvalue\": \"0\",\r\n        \"code\": \"#ffffff\",\r\n        \"color\": [\r\n        {\r\n          \"code\": \"#c9252f\",\r\n          \"maxvalue\": false\r\n        }]\r\n      }\r\n        }\r\n    },\r\n    \"datasets\": [\r\n        {\r\n            \"name\": \"waitlist\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"value\": \"convertibleWaitlistedReservations\",\r\n                    \"row\": {\r\n                        \"dynamicLabel\": \"consultantName\"\r\n                    },\r\n                    \"column\": {\r\n                        \"staticLabel\": \"30 days\"\r\n                    }\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"arrivalPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"today\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"+29 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ]\r\n            }\r\n        },\r\n        {\r\n            \"name\": \"waitlist\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"value\": \"convertibleWaitlistedReservations\",\r\n                    \"row\": {\r\n                        \"dynamicLabel\": \"consultantName\"\r\n                    },\r\n                    \"column\": {\r\n                        \"staticLabel\": \"60 days\"\r\n                    }\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"arrivalPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"+30 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"+59 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ]\r\n            }\r\n        },\r\n        {\r\n            \"name\": \"waitlist\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"value\": \"convertibleWaitlistedReservations\",\r\n                    \"row\": {\r\n                        \"dynamicLabel\": \"consultantName\"\r\n                    },\r\n                    \"column\": {\r\n                        \"staticLabel\": \"90 Days\"\r\n                    }\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"arrivalPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"+60 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"+89 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ]\r\n            }\r\n        },\r\n        {\r\n            \"name\": \"waitlist\",\r\n            \"chartConfig\": {\r\n                \"mappings\": {\r\n                    \"value\": \"convertibleWaitlistedReservations\",\r\n                    \"row\": {\r\n                        \"dynamicLabel\": \"consultantName\"\r\n                    },\r\n                    \"column\": {\r\n                        \"staticLabel\": \"120 days\"\r\n                    }\r\n                }\r\n            },\r\n            \"config\": {\r\n                \"filters\": [\r\n                    {\r\n                        \"name\": \"arrivalPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"+90 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"+120 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ]\r\n            }\r\n        }\r\n    ]\r\n}',	'',	0),
        ('',	0,	'11ea0fa2a2e55ffe904c02399910d15e',	'New bookings created by consultants',	'Total new bookings created this past week (today and the previous six days), grouped by the user who created the booking and by status. The chart shows the name of the user who created the booking originally, i.e. not the consultant currently linked to the booking. This chart gives the team an idea of the volume of bookings created by different users. This week\'s performance is an overlay on the previous two weeks.',	'How to generate this data using a report: Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), in the Res filters set the Create date range to this week, set the Status filter to All and set the Created by filter to the respective consultant. Group your results by Status and select the Reservation Count field for your results.',	'FusionCharts',	'ScrollStackedBar2D',	'{\r\n        \"library\": {\r\n            \"fusionCharts\": {\r\n                \"chart\": {\r\n                    \"caption\": \"New bookings created by consultants\",\r\n                                \"subcaption\": \"Today and the previous six days\",\r\n                    \"xAxisName\": \"Consultant\",\r\n                    \"yAxisName\": \"Bookings\",\r\n                    \"plottooltext\": \"<b>$value $seriesName</b> bookings allocated to $label\",\r\n                    \"theme\": \"fusion\",\r\n                    \"captionAlignment\": \"center\",\r\n                    \"baseFont\": \"Helvetica\",\r\n                    \"legendItemFont\": \"Helvetica\",\r\n                    \"legendItemFontSize\": \"13\",\r\n                    \"outCnvBaseFontSize\": \"12\",\r\n                    \"xAxisNameFontSize\": \"12\"\r\n                }\r\n            }\r\n        },\r\n        \"datasets\": [\r\n            {\r\n                \"name\": \"consultantBookingsByStatus\",\r\n                \"chartConfig\": {\r\n                    \"mappings\": {\r\n                        \"category\": \"consultantName\",\r\n                        \"series\": [\r\n                            {\r\n                                \"seriesName\": \"Waitlisted\",\r\n                                \"data\": \"waitlisted\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Quotation\",\r\n                                \"data\": \"quotation\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Provisional (valid)\",\r\n                                \"data\": \"validProvisional\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Provisional (expired)\",\r\n                                \"data\": \"expiredProvisional\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Confirmed\",\r\n                                \"data\": \"confirmed\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Cancelled\",\r\n                                \"data\": \"cancelled\"\r\n                            },\r\n                            {\r\n                                \"seriesName\": \"Deleted\",\r\n                                \"data\": \"deleted\"\r\n                            }\r\n                        ]\r\n                    }\r\n                },\r\n                \"config\": {\r\n                    \"filters\": [\r\n                    {\r\n                        \"name\": \"dateRecordedPeriod\",\r\n                        \"role\": \"hello\",\r\n                        \"enabled\": true,\r\n                        \"visible\": true,\r\n                        \"options\": [\r\n                            {\r\n                                \"optionName\": \"startDate\",\r\n                                \"value\": \"-6 days\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            },\r\n                            {\r\n                                \"optionName\": \"endDate\",\r\n                                \"value\": \"today\",\r\n                                \"visible\": true,\r\n                                \"enabled\": true\r\n                            }\r\n                        ]\r\n                    }\r\n                ]\r\n                }\r\n            }\r\n        ]\r\n    }',	'',	0);
EOT
);
        
        $this->addSql("
        INSERT INTO `ch_chart_container` (`ch_chart_container_db`, `ch_chart_container_id`, `ch_chart_container_ix`, `ch_chart_container_name`, `ch_chart_container_description`, `ch_chart_container_configuration`, `dt_temp_id`, `ch_chart_container_trf_yn`) VALUES
        ('',	0,	'11e9d3a1cbb8051b8f6902399910d15e',	'Reservation management',	'',	'{\r\n    \"dashboard\": {\r\n        \"configuration\": {\r\n            \"gridType\": \"verticalFixed\",\r\n            \"compactType\": \"compactUp&Left\",\r\n            \"margin\": 20,\r\n            \"outerMargin\": false,\r\n            \"useTransformPositioning\": true,\r\n            \"mobileBreakpoint\": 1000,\r\n            \"minCols\": 1,\r\n            \"maxCols\": 19,\r\n            \"minRows\": 1,\r\n            \"maxRows\": 100,\r\n            \"maxItemCols\": 100,\r\n            \"minItemCols\": 1,\r\n            \"maxItemRows\": 100,\r\n            \"minItemRows\": 1,\r\n            \"maxItemArea\": 2500,\r\n            \"minItemArea\": 1,\r\n            \"defaultItemCols\": 1,\r\n            \"defaultItemRows\": 1,\r\n            \"fixedColWidth\": 105,\r\n            \"fixedRowHeight\": 70,\r\n            \"keepFixedHeightInMobile\": true,\r\n            \"keepFixedWidthInMobile\": false,\r\n            \"scrollSensitivity\": 10,\r\n            \"scrollSpeed\": 20,\r\n            \"enableEmptyCellClick\": false,\r\n            \"enableEmptyCellContextMenu\": false,\r\n            \"enableEmptyCellDrop\": false,\r\n            \"enableEmptyCellDrag\": false,\r\n            \"emptyCellDragMaxCols\": 50,\r\n            \"emptyCellDragMaxRows\": 50,\r\n            \"ignoreMarginInRow\": false,\r\n            \"draggable\": {\r\n                \"enabled\": false\r\n            },\r\n            \"resizable\": {\r\n                \"enabled\": false\r\n            },\r\n            \"swap\": false,\r\n            \"pushItems\": true,\r\n            \"disablePushOnDrag\": true,\r\n            \"disablePushOnResize\": false,\r\n            \"pushDirections\": {\r\n                \"north\": true,\r\n                \"east\": true,\r\n                \"south\": true,\r\n                \"west\": true\r\n            },\r\n            \"pushResizeItems\": false,\r\n            \"displayGrid\": \"never\",\r\n            \"disableWindowResize\": false,\r\n            \"disableWarnings\": false,\r\n            \"scrollToNewItems\": false\r\n        },\r\n        \"items\": [\r\n            {\r\n                \"x\": 0,\r\n                \"y\": 0,\r\n                \"rows\": 4,\r\n                \"cols\": 7,\r\n                \"compactEnabled\": true\r\n            },\r\n            {\r\n                \"x\": 7,\r\n                \"y\": 0,\r\n                \"rows\": 4,\r\n                \"cols\": 5,\r\n                \"compactEnabled\": true\r\n            },\r\n            {\r\n                \"x\": 12,\r\n                \"y\": 0,\r\n                \"rows\": 4,\r\n                \"cols\": 5,\r\n                \"compactEnabled\": true\r\n            },\r\n            {\r\n                \"x\": 0,\r\n                \"y\": 4,\r\n                \"rows\": 4,\r\n                \"cols\": 7,\r\n                \"compactEnabled\": true\r\n            },\r\n            {\r\n                \"x\": 7,\r\n                \"y\": 4,\r\n                \"rows\": 4,\r\n                \"cols\": 5,\r\n                \"compactEnabled\": true\r\n            },\r\n            {\r\n                \"x\": 12,\r\n                \"y\": 4,\r\n                \"rows\": 4,\r\n                \"cols\": 5,\r\n                \"compactEnabled\": true\r\n            },\r\n            {\r\n                \"x\": 0,\r\n                \"y\": 8,\r\n                \"rows\": 4,\r\n                \"cols\": 17,\r\n                \"compactEnabled\": true\r\n            }\r\n        ]\r\n    },\r\n    \"charts\": [\r\n        \"11e9ad14ad08dddf90da02399910d15e\",\r\n        \"11e9c46b31e53f5f928e02399910d15e\",\r\n        \"11e9c41c91446fdc928e02399910d15e\",\r\n        \"11ea0fa2a2e55ffe904c02399910d15e\",\r\n        \"11e9c46b3f592816928e02399910d15e\",\r\n        \"11e9c4556a79d3db928e02399910d15e\",\r\n        \"11e8439f3234ef708be40cc47a969e7c\"\r\n    ]\r\n}',	'',	0);
        ");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
