<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20200217113533 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        $roomingMenuIds = [114, 139, 195, 212, 243];

        $this->addSql("
            UPDATE sc_menu SET
                sc_function_id = 0,
                sc_job_id = 0
            WHERE
                sc_menu.sc_menu_id IN (" . join(",",$roomingMenuIds) . ")
        ");

        foreach($roomingMenuIds as $menuId) {
            $this->addSql("
                INSERT INTO sc_menu
                    (sc_menu_parent, sc_menu_seq, sc_menu_title, sc_function_id, sc_job_id, sc_menu_format_id)
                VALUES
                    ($menuId, 1, 'Classic', 81, 234, 7),
                    ($menuId, 2, 'Modern', 81, 1024, 7)
            ");
        }

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
    }
}

