<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20200423151106 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        // Add rate rounding indicator
        $this->addSql("ALTER TABLE rt_rate ADD IF NOT EXISTS rt_rate_round_ind TINYINT(1) DEFAULT '0' NOT NULL AFTER rt_rate_ssupp_comm_yn");
        $this->addSql("UPDATE rt_rate SET rt_rate_round_ind = '1' WHERE rt_rate.rt_rate_round_scale > 0");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
