<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20200506065428 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs

        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        // Create sc_env_group table if it doesn't exist.  Contains Client data.
        $this->addSql("
            CREATE TABLE IF NOT EXISTS sc_env_group (
                sc_env_group_db CHAR(2) NOT NULL DEFAULT 'RS',
                sc_env_group_id INT(11) NOT NULL DEFAULT 0,
                sc_env_group_ix VARCHAR(36) NOT NULL,
                rf_database_id INT(11) NOT NULL DEFAULT 0,
                sc_group_id INT(11) NOT NULL DEFAULT 0,
                sc_env_group_create_date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                dt_temp_id VARCHAR(36),
                sc_env_group_trf_yn TINYINT(4) NOT NULL DEFAULT 0,
                PRIMARY KEY (sc_env_group_ix),
                FOREIGN KEY (rf_database_id) REFERENCES rf_database(rf_database_id),
                FOREIGN KEY (sc_group_id)    REFERENCES sc_group(sc_group_id)
            ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COMMENT='Links authorised environments to user groups';
        ");
        
        // Add record to tc_table
        $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'sc_env_group';");
        $this->addSql("
            INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_trf_yn)
            VALUES ('sc_env_group', 10, 0, 0, 1);
        ");
        
        // Initial population of sc_env_group table if table is empty. Contains Client data.
        $this->addSql("
            INSERT INTO sc_env_group (sc_env_group_ix, sc_group_id, rf_database_id)
            SELECT GET_UUID(), sc_group.sc_group_id, rf_database.rf_database_id
            FROM sc_group, rf_database
            WHERE NOT EXISTS (SELECT * FROM sc_env_group);
        ");
	
    	// Add record to sc_job
        $this->addSql("DELETE FROM sc_job WHERE sc_job_id = 4000;");
        $this->addSql("
            INSERT INTO sc_job (sc_job_id, sc_job_desc, sc_job_level, sc_job_cords, sc_job_homepage_yn, dt_temp_id, sc_job_trf_yn)
            VALUES ('4000', 'Unauthorised Access', '0', '\"1:4000:1\"', '0', NULL, '5');
        ");

    	// Add record to sc_fun_job
        $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 4000 AND sc_function_id = 66;");
        $this->addSql("
            INSERT INTO sc_fun_job (sc_job_id, sc_function_id, dt_temp_id, sc_fun_job_trf_yn)
            VALUES(4000, 66, NULL, 1);
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE);");
        $this->addSql("CALL sp_master_override(FALSE);");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
