<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20200519101758 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        // Add rate rounding indicator
        $this->addSql("DROP TABLE IF EXISTS pr_agent_prop;");
        $this->addSql("
            CREATE TABLE pr_agent_prop (
                pr_agent_prop_db CHAR(2) NOT NULL DEFAULT '',
                pr_agent_prop_id INT(11) NOT NULL,
                pr_agent_prop_ix VARCHAR(36) NOT NULL,
                pr_agent_id VARCHAR(36) NOT NULL,
                pr_business_id VARCHAR(36) NOT NULL,
                rt_rate_type_id VARCHAR(36) DEFAULT NULL,
                pr_agent_prop_comm_perc DECIMAL(16,2),    
                dt_temp_id VARCHAR(36) DEFAULT NULL,
                pr_agent_prop_trf_yn TINYINT(1) NOT NULL DEFAULT '0',
                PRIMARY KEY (pr_agent_prop_ix),
                KEY dt_temp_id (dt_temp_id),
                KEY pr_agent_prop_trf_yn (pr_agent_prop_trf_yn)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");

        // Seq: pr_agent=20, pr_business=20, rt_rate_type=10
		$this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'pr_agent_prop'");
        $this->addSql("
            INSERT INTO tc_table (
                tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn
            ) VALUES (
                'pr_agent_prop', '25', '0', '0', '0', NULL, '0')
        ");

        $this->addSql("
            ALTER TABLE rv_reservation_item ADD IF NOT EXISTS rv_item_comm_perc DECIMAL(16,2) NOT NULL DEFAULT '0' AFTER rv_item_comm_yn;
        ");
		$this->addSql("
			UPDATE
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			SET
				rv_reservation_item.rv_item_comm_perc = rv_reservation.rv_commission_perc
		");

		$this->addSql("DELETE FROM ad_module_field WHERE ad_module_field_name = 'rv_reservation_item.rv_item_comm_perc'");
		$this->addSql("
			INSERT INTO ad_module_field (
				ad_module_field_name, ad_module_field_description, tc_table_id, rf_audit_module_id, ad_module_field_display_type_ind, ad_module_field_trf_yn
			) VALUES (
				'rv_reservation_item.rv_item_comm_perc', 'Commission', 20, 3, 5 /*float*/, 1
			)
		");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
