<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20200626094315 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        // Add special split per itinerary
        $this->addSql("DROP TABLE IF EXISTS rv_res_item_special;");
        $this->addSql("
            CREATE TABLE rv_res_item_special (
                rv_res_item_special_db CHAR(2) NOT NULL DEFAULT '',
                rv_res_item_special_id INT(11) NOT NULL,
                rv_res_item_special_ix VARCHAR(36) NOT NULL,
                rv_sp_amt_discount DECIMAL(16,2) NOT NULL,
                sp_special_id VARCHAR(36) NOT NULL,
                rv_reservation_item_id VARCHAR(36) NOT NULL,
                dt_temp_id VARCHAR(36) DEFAULT NULL,
                rv_res_item_special_trf_yn TINYINT(1) NOT NULL DEFAULT '0',
                PRIMARY KEY (rv_res_item_special_ix),
                KEY dt_temp_id (dt_temp_id),
                KEY rv_res_item_special_trf_yn (rv_res_item_special_trf_yn),
                KEY rv_reservation_item_id (rv_reservation_item_id),
                KEY sp_special_id (sp_special_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");

        $this->addSql("
            INSERT INTO rv_res_item_special (
                rv_res_item_special_db,
                rv_res_item_special_id,
                rv_res_item_special_ix,
                rv_sp_amt_discount,
                sp_special_id,
                rv_reservation_item_id
            ) SELECT
                rv_reservation_item.rv_reservation_item_db,
                rv_reservation_item.rv_reservation_item_id,
                rv_reservation_item.rv_reservation_item_ix,
                rv_reservation_item.rv_item_amt_sp_discount,
                rv_reservation_item.sp_special_id,
                rv_reservation_item.rv_reservation_item_ix
            FROM
                rv_reservation_item
                INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
                INNER JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix
                LEFT JOIN sp_special ON sp_special.sp_special_ix = rv_special.sp_special_id
            WHERE
                sp_special.sp_special_ix IS NOT NULL
        ");

        // Seq: sp_special = 25, rv_reservation_item = 30
        $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'rv_res_item_special'");
        $this->addSql("
            INSERT INTO tc_table (
                tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn
            ) VALUES (
                'rv_res_item_special', '35', '0', '0', '0', NULL, '0')
        ");

        // Special combos
        $this->addSql("DROP TABLE IF EXISTS sp_combo;");
        $this->addSql("
            CREATE TABLE sp_combo (
                sp_combo_db CHAR(2) NOT NULL DEFAULT '',
                sp_combo_id INT(11) NOT NULL,
                sp_combo_ix VARCHAR(36) NOT NULL,
                sp_combo_name VARCHAR(100) NOT NULL,
                sp_combo_limit TINYINT(4) NOT NULL,
                sp_combo_sort_seq TINYINT(4) NOT NULL,
                ad_create_date TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
                ad_create_date_tz VARCHAR(40) NOT NULL,
                ad_create_user_id VARCHAR(36) DEFAULT NULL,
                ad_modify_date TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
                ad_modify_date_tz VARCHAR(40) NOT NULL,
                ad_modify_user_id VARCHAR(36) DEFAULT NULL,
                dt_temp_id VARCHAR(36) DEFAULT NULL,
                sp_combo_trf_yn TINYINT(1) NOT NULL DEFAULT '0',
                PRIMARY KEY (sp_combo_ix),
                KEY dt_temp_id (dt_temp_id),
                KEY sp_combo_trf_yn (sp_combo_trf_yn)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");

        // Seq: none
        $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'sp_combo'");
        $this->addSql("
            INSERT INTO tc_table (
                tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn
            ) VALUES (
                'sp_combo', '5', '0', '0', '0', NULL, '0')
        ");

        // Special combo items
        $this->addSql("DROP TABLE IF EXISTS sp_combo_item;");
        $this->addSql("
            CREATE TABLE sp_combo_item (
                sp_combo_item_db CHAR(2) NOT NULL DEFAULT '',
                sp_combo_item_id INT(11) NOT NULL,
                sp_combo_item_ix VARCHAR(36) NOT NULL,
                sp_combo_id VARCHAR(36) NOT NULL,
                sp_special_id VARCHAR(36) NOT NULL,
                dt_temp_id VARCHAR(36) DEFAULT NULL,
                sp_combo_item_trf_yn TINYINT(1) NOT NULL DEFAULT '0',
                PRIMARY KEY (sp_combo_item_ix),
                KEY dt_temp_id (dt_temp_id),
                KEY sp_combo_item_trf_yn (sp_combo_item_trf_yn)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");

        // Seq: sp_combo = 5, sp_special = 25
        $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'sp_combo_item'");
        $this->addSql("
            INSERT INTO tc_table (
                tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn
            ) VALUES (
                'sp_combo_item', '30', '0', '0', '0', NULL, '0')
        ");

        // Special combo rate periods
        $this->addSql("DROP TABLE IF EXISTS sp_combo_period;");
        $this->addSql("
            CREATE TABLE sp_combo_period (
                sp_combo_period_db CHAR(2) NOT NULL DEFAULT '',
                sp_combo_period_id INT(11) NOT NULL,
                sp_combo_period_ix VARCHAR(36) NOT NULL,
                sp_combo_id VARCHAR(36) NOT NULL,
                rt_period_id VARCHAR(36) NOT NULL,
                dt_temp_id VARCHAR(36) DEFAULT NULL,
                sp_combo_period_trf_yn TINYINT(1) NOT NULL DEFAULT '0',
                PRIMARY KEY (sp_combo_period_ix),
                KEY dt_temp_id (dt_temp_id),
                KEY sp_combo_period_trf_yn (sp_combo_period_trf_yn)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
        ");

        // Seq: sp_combo = 5, rt_period = 5
        $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'sp_combo_period'");
        $this->addSql("
            INSERT INTO tc_table (
                tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_user_facing_yn, dt_temp_id, tc_table_trf_yn
            ) VALUES (
                'sp_combo_period', '10', '0', '0', '0', NULL, '0')
        ");

        // Discount amount per applied special and populate with existing specials discount values
        $this->addSql("
            ALTER TABLE rv_special ADD IF NOT EXISTS rv_sp_amt_discount DECIMAL(16,2) NOT NULL DEFAULT '0' AFTER sp_special_id;
        ");
        $this->addSql("
            UPDATE
                rv_special
                INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_special.rv_reservation_id
                LEFT JOIN sp_special ON sp_special.sp_special_ix = rv_special.sp_special_id
            SET
                rv_special.rv_sp_amt_discount = rv_reservation.rv_amt_sp_discount
            WHERE
                sp_special.sp_special_ix IS NOT NULL
        ");

        // Discount override toggle on reservation. Populate using the existing rv_special field and then remove this unused field.
        $this->addSql("
            ALTER TABLE rv_reservation
                ADD IF NOT EXISTS rv_sp_override_yn TINYINT(1) NOT NULL DEFAULT '0' AFTER rv_amt_sp_discount,
                ADD IF NOT EXISTS rv_sp_override_user_id VARCHAR(36) NULL AFTER rv_sp_override_yn,
                ADD IF NOT EXISTS rv_sp_override_date TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00' AFTER rv_sp_override_user_id,
                ADD IF NOT EXISTS rv_sp_override_date_tz VARCHAR(40) NOT NULL DEFAULT '' AFTER rv_sp_override_date;
        ");
        $this->addSql("
            UPDATE
                rv_reservation
                INNER JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix
            SET
                rv_reservation.rv_sp_override_yn = rv_special.rv_sp_overide_yn,
                rv_reservation.rv_sp_override_user_id = rv_special.rv_sp_overide_user_id,
                rv_reservation.rv_sp_override_date = rv_special.rv_sp_overide_date_time,
                rv_reservation.rv_sp_override_date_tz = rv_special.rv_sp_overide_date_time_tz
        ");
        $this->addSql("
            ALTER TABLE rv_special
                DROP IF EXISTS rv_sp_overide_yn,
                DROP IF EXISTS rv_sp_overide_user_id,
                DROP IF EXISTS rv_sp_overide_date,
                DROP IF EXISTS rv_sp_overide_date_tz
        ");

        // Remove unused existing itinerary special link
        $this->addSql("
            ALTER TABLE rv_reservation_item DROP COLUMN IF EXISTS sp_special_id
        ");

        // Remove unused existing itinerary special benefit indicator
        $this->addSql("
            ALTER TABLE rv_reservation_item DROP COLUMN IF EXISTS rv_sp_benefit_ind
        ");

        // Job for special combo code table
        $this->addSql("INSERT INTO sc_job VALUES (1027, 'Special Combos', 4, '\"1:1017:1\"', 0, NULL, 1)");

        // Add job to function 2001 (Specials)
        $this->addSql("INSERT INTO sc_fun_job VALUES (null, 1027, 2001, NULL, 1)");

        // Add special combo code table to the menu
        $this->addSql("
            INSERT INTO sc_menu
                (sc_menu_parent, sc_menu_seq, sc_menu_title, sc_function_id, sc_job_id, sc_menu_job_top, sc_menu_format_id)
            VALUES
                (273, 5, 'Special Combos', 2001, 1027, 1027, 0)
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
