<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20200903090936 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
      $this->addSql("CALL sp_set_environment('RS')");
      $this->addSql("CALL sp_transfer_flagging(FALSE)");
      $this->addSql("CALL sp_master_override(TRUE)");

      // user access
      // prevent duplicate primary key issues and ensure sc values are correct
      $this->addSql("
        DELETE 
          sc_job, sc_fun_job 
        FROM
          sc_fun_job
          INNER JOIN sc_job ON sc_job.sc_job_id = sc_fun_job.sc_job_id
        WHERE sc_job_desc LIKE '%Automated Workflows%';
      ");
      $this->addSql("
        DELETE FROM sc_function 
        WHERE sc_fun_desc LIKE '%Automated Workflows%';
      ");
      $this->addSql("
        INSERT INTO sc_function 
          (sc_function_id, sc_fun_code, sc_fun_desc, sc_fun_sys_code, sc_function_trf_yn) 
        VALUES
          (6002, NULL, 'Automated Workflows', 0, 0);
      ");
      
      // jobs
      $this->addSql("DELETE FROM sc_job WHERE sc_job_desc = 'Display Automated Workflows';");
      $this->addSql("INSERT INTO sc_job (sc_job_id,sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) VALUES (6018, 'Display Automated Workflows',4,'\"1:6009:1\"',0,0);");
      $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 6018;");
      $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, sc_fun_job_trf_yn) VALUES (6018, 6002, 0);");

      $this->addSql("DELETE FROM sc_route WHERE sc_route_name = 'Automated Workflows';");
      $this->addSql("INSERT INTO sc_route (sc_route_id,sc_route_name,sc_route_desc,sc_route_level,sc_route_trf_yn) VALUES (2, '/app/admin/setup/workflows', 'Automated Workflows', 4, 0);");
      $this->addSql("DELETE FROM sc_fun_route WHERE sc_route_id = 2;");
      $this->addSql("INSERT INTO sc_fun_route (sc_route_id, sc_function_id, sc_fun_route_trf_yn) VALUES (2, 6002, 0);");

      $this->addSql("DELETE FROM sc_job WHERE sc_job_desc = 'Add Automated Workflows';");
      $this->addSql("INSERT INTO sc_job (sc_job_id,sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) VALUES (6019, 'Add Automated Workflows',4,'\"2:6009:1\"',0,0);");
      $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 6019;");
      $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, sc_fun_job_trf_yn) VALUES (6019, 6002, 0);");

      $this->addSql("DELETE FROM sc_job WHERE sc_job_desc = 'Add Automated Workflows to DB';");
      $this->addSql("INSERT INTO sc_job (sc_job_id,sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) VALUES (6020, 'Add Automated Workflows to DB',6,'\"2,1:6009:0\",\"1:6009:1\"',0,0);");
      $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 6020;");
      $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, sc_fun_job_trf_yn) VALUES (6020, 6002, 0);");

      $this->addSql("DELETE FROM sc_job WHERE sc_job_desc = 'Edit Automated Workflows';");
      $this->addSql("INSERT INTO sc_job (sc_job_id,sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) VALUES (6021, 'Edit Automated Workflows',6,'\"3,0:6009:1\"',0,0);");
      $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 6021;");
      $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, sc_fun_job_trf_yn) VALUES (6021, 6002, 0);");

      $this->addSql("DELETE FROM sc_job WHERE sc_job_desc = 'Update Automated Workflows on DB';");
      $this->addSql("INSERT INTO sc_job (sc_job_id,sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) VALUES (6022, 'Update Automated Workflows on DB',6,'\"3,1:6009:1\",\"1:6009:1\"',0,0);");
      $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 6022;");
      $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, sc_fun_job_trf_yn) VALUES (6022, 6002, 0);");

      $this->addSql("DELETE FROM sc_job WHERE sc_job_desc = 'Delete Automated Workflows';");
      $this->addSql("INSERT INTO sc_job (sc_job_id,sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) VALUES (6023, 'Delete Automated Workflows',6,'\"4,1:6009:1\",\"1:6009:1\"',0,0);");
      $this->addSql("DELETE FROM sc_fun_job WHERE sc_job_id = 6023;");
      $this->addSql("INSERT INTO sc_fun_job (sc_job_id, sc_function_id, sc_fun_job_trf_yn) VALUES (6023, 6002, 0);");

  
      // menu entry
      $this->addSql("
        DELETE FROM sc_menu 
        WHERE sc_menu_title = 'Automated Workflows';
      ");
      // Automated Workflows needs to be the first item in this menu
      $this->addSql("
        UPDATE
          sc_menu
        SET
          sc_menu_seq = sc_menu_seq + 1
        WHERE 
          sc_menu_parent = 218;
      ");
      // sc_menu_format_id = 13 (Code tables)
      $this->addSql("
        INSERT INTO sc_menu 
          (sc_menu_id, sc_menu_job_top, sc_menu_param, sc_menu_parent, sc_menu_seq, sc_menu_title, sc_function_id, sc_job_id, sc_menu_format_id, sc_menu_trf_yn)
        VALUES
          (6005, NULL, NULL, 218, 1, 'Automated Workflows', 6002, 6018, 13, 0);
      ");

      // new automated workflow tables
      $this->addSql("DROP TABLE IF EXISTS `aw_workflow_trigger`;");
      $this->addSql("
        CREATE TABLE `aw_workflow_trigger` (
          `aw_workflow_trigger_id` INT(11) NOT NULL,
          `aw_workflow_trigger_name` VARCHAR(50) NOT NULL,
          `aw_workflow_trigger_description` VARCHAR(200) NOT NULL,
          `aw_workflow_trigger_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0',
          PRIMARY KEY (`aw_workflow_trigger_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='System and read only lookup table that contains the types of triggers available for Automated Workflows';
      ");
      $this->addSql("DROP TABLE IF EXISTS `aw_workflow`;");
      $this->addSql("
        CREATE TABLE `aw_workflow` (
          `aw_workflow_db` CHAR(2) NOT NULL DEFAULT 'RS',
          `aw_workflow_id` INT(11) NOT NULL DEFAULT '0',
          `aw_workflow_ix` VARCHAR(36) NOT NULL,
          `aw_workflow_name` VARCHAR(50) NOT NULL,
          `aw_workflow_description` VARCHAR(200) NOT NULL,
          `aw_workflow_type_ind` TINYINT(1) NOT NULL DEFAULT '0',
          `aw_workflow_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0',
          `aw_workflow_schedule_days` INT(11) NOT NULL DEFAULT '0',
          `aw_workflow_before_after_ind` TINYINT(1) DEFAULT NULL,
          `aw_workflow_trigger_id` INT(11) NOT NULL,
          `aw_workflow_time` TIME NULL,
          `aw_workflow_time_tz` VARCHAR(40) NOT NULL,
          `aw_workflow_last_run_timestamp` DATETIME NULL DEFAULT '0000-00-00 00:00:00',
          `aw_workflow_last_run_timestamp_tz` VARCHAR(40) NULL,
          `ad_create_date` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
          `ad_create_date_tz` VARCHAR(40) NOT NULL,
          `ad_create_user_id` VARCHAR(36) DEFAULT NULL,
          `ad_delete_date` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00',
          `ad_delete_date_tz` VARCHAR(40) NULL,
          `ad_delete_user_id` VARCHAR(36) DEFAULT NULL,
          `ad_modify_date` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
          `ad_modify_date_tz` VARCHAR(40) NOT NULL,
          `ad_modify_user_id` VARCHAR(36) DEFAULT NULL,
          `dt_temp_id` VARCHAR(36) DEFAULT NULL,
          `aw_workflow_trf_yn` TINYINT(4) NOT NULL DEFAULT '0',
          PRIMARY KEY (`aw_workflow_ix`),
          KEY `aw_workflow_trigger_id` (`aw_workflow_trigger_id`),
          KEY `ad_create_user_id` (`ad_create_user_id`),
          KEY `ad_delete_user_id` (`ad_delete_user_id`),
          KEY `ad_modify_user_id` (`ad_modify_user_id`),
          CONSTRAINT `aw_workflow_constraint_aw_workflow_trigger` FOREIGN KEY (`aw_workflow_trigger_id`) REFERENCES `aw_workflow_trigger` (`aw_workflow_trigger_id`),
          CONSTRAINT `aw_workflow_constraint_pr_user_create` FOREIGN KEY (`ad_create_user_id`) REFERENCES `pr_user` (`pr_user_id`),
          CONSTRAINT `aw_workflow_constraint_pr_user_delete` FOREIGN KEY (`ad_delete_user_id`) REFERENCES `pr_user` (`pr_user_id`),
          CONSTRAINT `aw_workflow_constraint_pr_user_modify` FOREIGN KEY (`ad_modify_user_id`) REFERENCES `pr_user` (`pr_user_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Defines an Automated Workflow, that when triggered results in an action, such as the sending of an email, to occur';
      ");
      $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'aw_workflow';");
      $this->addSql("
          INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_trf_yn)
          VALUES ('aw_workflow', 10, 0, 0, 1);
      ");
      $this->addSql("ALTER TABLE `re_reminder` ADD `aw_workflow_id` VARCHAR(36) DEFAULT NULL AFTER `re_reminder_link_to_id`;");
      $this->addSql("ALTER TABLE `re_reminder` ADD INDEX( `aw_workflow_id`, `re_reminder_link_to_id`);");
      $this->addSql("ALTER TABLE `re_reminder_persona` ADD INDEX( `pr_persona_id`, `re_reminder_id`);");

      // insert workflow triggers
      $this->addSql("DELETE FROM aw_workflow_trigger;");
      $this->addSql("
        INSERT INTO aw_workflow_trigger
          (aw_workflow_trigger_id, aw_workflow_trigger_name, aw_workflow_trigger_description)
        VALUES  
          (1, 'Itinerary arrival', 'Based on the itinerary\'s arrival date'),
          (2, 'Itinerary departure', 'Based on the itinerary\'s departure date'),
          (3, 'Reservation arrival', 'Based on the reservation\'s arrival date'),
          (4, 'Reservation departure', 'Based on the reservation\'s departure date');
      ");

      $this->addSql("CALL sp_transfer_flagging(TRUE)");
      $this->addSql("CALL sp_master_override(FALSE)");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
