<?php
namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */

class Version20200922110000 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs

        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        // Create rf_sys_admin table if it doesn't exist.
        $this->addSql("
            CREATE TABLE IF NOT EXISTS rf_sys_admin (
                rf_sys_admin_db CHAR(2) NOT NULL DEFAULT 'RS',
                rf_sys_admin_id INT(11) NOT NULL DEFAULT 0,
                rf_sys_admin_ix VARCHAR(36) NOT NULL,
                pr_persona_id VARCHAR(36) NOT NULL,
                rf_sys_admin_primary TINYINT(1) DEFAULT 0,
                rf_sys_admin_create_date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                dt_temp_id VARCHAR(36),
                rf_sys_admin_trf_yn TINYINT(4) NOT NULL DEFAULT 0,
                PRIMARY KEY (rf_sys_admin_ix)
            ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;
        ");

        // Add record to tc_table
        $this->addSql("DELETE FROM tc_table WHERE tc_table_name = 'rf_sys_admin';");
        $this->addSql("
            INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_trf_yn)
            VALUES ('rf_sys_admin', 10, 0, 0, 1);
        ");
        
        // Initial population of rf_sys_admin table if table is empty.
        $this->addSql("
            INSERT INTO rf_sys_admin
            	(
            		rf_sys_admin_ix,
            		rf_sys_admin_id,
            		rf_sys_admin_db,
            		pr_persona_id,
            		rf_sys_admin_primary
            	)
            SELECT
            	GET_UUID(),
            	0,
            	'WB',
            	rf_default.rf_sys_admin_id,
            	1
            FROM
            	rf_default;
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE);");
        $this->addSql("CALL sp_master_override(FALSE);");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}