<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20201229082743 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

		/* Add option for bulk export of transaction data */
		$this->addSql("
			ALTER TABLE fn_system ADD COLUMN IF NOT EXISTS fn_sys_all_yn TINYINT(0) NOT NULL DEFAULT '0' AFTER fn_system_desc
		");

		/* Add Netsuite financial interface definition */
		$this->addSql("
			INSERT INTO fn_system (
				fn_system_db,
				fn_system_id,
				fn_system_ix,
				fn_system_name,
				fn_system_desc,
				fn_sys_all_yn,
				fn_sys_credit_note_yn,
				fn_sys_debtor_yn,
				fn_sys_invoice_yn,
				fn_sys_payment_yn,
				fn_sys_refund_yn,
				fn_sys_tran_yn,
				fn_sys_tran_summary_yn,
				fn_sys_journal_yn,
				fn_sys_tax_groups_yn,
				fn_system_trf_yn
			) VALUES (
				'RS',
				'18',
				'RS18',
				'netsuite',
				'Netsuite',
				'1',
				'0',
				'1',
				'1',
				'1',
				'0',
				'0',
				'0',
				'0',
				'1',
				'1'
			)
		");

		$this->addSql("ALTER TABLE rt_component ADD COLUMN IF NOT EXISTS rt_component_type_ind TINYINT(4) NOT NULL DEFAULT '0' AFTER rt_component_freq_ind");
		$this->addSql("ALTER TABLE pr_business ADD COLUMN IF NOT EXISTS fn_meal_component_default_id VARCHAR(36) NULL DEFAULT NULL AFTER fn_cost_centre_id");
		$this->addSql("ALTER TABLE rt_component_inv ADD COLUMN IF NOT EXISTS rt_component_inv_meal_code VARCHAR(50) NULL DEFAULT NULL AFTER pr_business_id");
		$this->addSql("ALTER TABLE fn_tran_item ADD COLUMN IF NOT EXISTS rt_component_inv_id VARCHAR(36) NULL DEFAULT NULL AFTER fn_tran_cost_ctr2_id");

		$this->addSql("DROP TABLE IF EXISTS fn_tran_stat");
		$this->addSql("
			CREATE TABLE fn_tran_stat (
				fn_tran_stat_db CHAR(2) NOT NULL DEFAULT '',
				fn_tran_stat_id INT(11) NOT NULL,
				fn_tran_stat_ix VARCHAR(36) NOT NULL,
				fn_tran_id VARCHAR(36) NOT NULL,
				fn_cost_centre_id VARCHAR(36) NOT NULL,
				rt_component_inv_id VARCHAR(36) NOT NULL,
				fn_tran_stat_nights INT(11) NOT NULL DEFAULT '0',
				fn_tran_stat_pax INT(11) NOT NULL DEFAULT '0',
				fn_tran_stat_bed_nights INT(11) NOT NULL DEFAULT '0',
				fn_tran_stat_room_nights INT(11) NOT NULL DEFAULT '0',
				dt_temp_id varchar(36) DEFAULT NULL,
				fn_tran_stat_trf_yn tinyint(1) NOT NULL DEFAULT '0',
				PRIMARY KEY (fn_tran_stat_ix),
				KEY dt_temp_id (dt_temp_id),
				KEY fn_tran_stat_trf_yn (fn_tran_stat_trf_yn)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
		");
		$this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq) VALUES ('fn_tran_stat', 50)");

		$this->addSql("
			INSERT INTO sc_job (sc_job_id, sc_job_desc, sc_job_level, sc_job_cords) VALUES
				(1030, 'GL Account Detail popup - Meal Plans Tab', 6, '\"1:1019:1\"')
		");
		$this->addSql("
			INSERT INTO sc_fun_job (sc_job_id, sc_function_id) VALUES
				(1030, 100)
		");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
