<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20210316091547 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

		// Create a new function for the agent role allocations tab and move all jobs to this new function
		$this->addSql("DELETE FROM sc_function WHERE sc_fun_desc = 'Contact Agent Role: Allocations'");
		$this->addSql("INSERT INTO sc_function (sc_fun_desc) VALUES ('Contact Agent Role: Allocations')");
		$this->addSql("
			SELECT sc_function_id FROM sc_function WHERE sc_fun_desc = 'Contact Agent Role: Allocations' INTO @agent_alloc_function_id;
			UPDATE sc_fun_job SET sc_function_id = @agent_alloc_function_id WHERE sc_job_id IN (267, 268, 269, 270, 271, 272);
		");

		// Apply the same access control level to all groups as the existing agent role popup function to the new function
		$this->addSql("
			SELECT sc_function_id FROM sc_function WHERE sc_fun_desc = 'Contact Agent Role' INTO @agent_role_function_id;
			SELECT sc_function_id FROM sc_function WHERE sc_fun_desc = 'Contact Agent Role: Allocations' INTO @agent_alloc_function_id;
			INSERT INTO sc_fun_group (sc_function_id, sc_group_id, sc_fun_grp_level, sc_fun_group_trf_yn)
				SELECT
					@agent_alloc_function_id,
					sc_fun_group.sc_group_id,
					sc_fun_group.sc_fun_grp_level,
					1 AS sc_fun_group_trf_yn
				FROM
					sc_fun_group
				WHERE
					sc_fun_group.sc_function_id = @agent_role_function_id;
		");

		// Add a field for allocation override access
		$this->addSql("ALTER TABLE sc_group ADD sc_grp_res_ovr_alloc_yn TINYINT(1) NOT NULL DEFAULT '0' AFTER sc_grp_cross_invoice_yn");

		$this->addSql("
			INSERT INTO ad_module_field
				(ad_module_field_name, ad_module_field_description, tc_table_id, rf_audit_module_id, ad_module_field_display_type_ind, ad_module_field_trf_yn)
			VALUES
				('rv_reservation.rv_alloc_expiry_days', 'Allocation expiry lead time', 19, '1', 6, 1),
				('rv_reservation.rv_alloc_expiry_date', 'Allocation expiry date', 19, '1', 4, 1);
		");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
