<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20210513210409 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

        // Add tc_table entries
        $this->addSql("
            INSERT INTO `tc_table` (`tc_table_name`, `tc_table_seq`, `tc_table_sys_code`, `tc_table_key_ind`, `tc_table_user_facing_yn`, `dt_temp_id`, `tc_table_trf_yn`) VALUES
            ('ml_rule', 35, 0, 0, 0, '', 1),
            ('ml_accomm', 35, 0, 0, 0, '', 1),
            ('ml_agent', 35, 0, 0, 0, '', 1),
            ('ml_period', 35, 0, 0, 0, '', 1),
            ('ml_rate_type', 35, 0, 0, 0, '', 1)
        ");

        

        $this->addSql("
            CREATE TABLE `ml_accomm` (
                `ml_accomm_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `ml_accomm_id` int(11) NOT NULL,
                `ml_accomm_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_rule_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ac_accomm_type_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_accomm_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");

        $this->addSql("
            CREATE TABLE `ml_agent` (
                `ml_agent_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `ml_agent_id` int(11) NOT NULL,
                `ml_agent_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_rule_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `pr_agent_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_agent_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");
        
        $this->addSql("
            CREATE TABLE `ml_period` (
                `ml_period_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `ml_period_id` int(11) NOT NULL,
                `ml_period_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_rule_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `rt_period_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_period_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");

        $this->addSql("
            CREATE TABLE `ml_rate_type` (
                `ml_rate_type_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `ml_rate_type_id` int(11) NOT NULL,
                `ml_rate_type_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_rule_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `rt_rate_type_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_rate_type_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");

        $this->addSql("
            CREATE TABLE `ml_rule` (
                `ml_rule_db` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
                `ml_rule_id` int(11) NOT NULL,
                `ml_rule_ix` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_min_los` int(11) NOT NULL DEFAULT '0',
                `ml_lapse_days` int(11) NOT NULL DEFAULT '0',
                `ml_rule_desc` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
                `ml_allocations_yn` tinyint(1) NOT NULL DEFAULT '0',
                `ml_days_of_week` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
                `dt_temp_id` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                `ml_rule_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
        ");

        $this->addSql("
            ALTER TABLE `ml_accomm`
                ADD PRIMARY KEY (`ml_accomm_ix`);

            ALTER TABLE `ml_agent`
                ADD PRIMARY KEY (`ml_agent_ix`);
            
            ALTER TABLE `ml_period`
                ADD PRIMARY KEY (`ml_period_ix`);
            
            ALTER TABLE `ml_rate_type`
                ADD PRIMARY KEY (`ml_rate_type_ix`);
            
            ALTER TABLE `ml_rule`
                ADD PRIMARY KEY (`ml_rule_ix`);
        ");

        $this->addSql("
            ALTER TABLE sc_group
            ADD COLUMN sc_grp_ovr_minlos_yn tinyint(1) NOT NULL DEFAULT 0 AFTER sc_grp_res_edit_itineraries_yn;
        ");


        $this->addSql("
            INSERT INTO `sc_job` (`sc_job_id`, `sc_job_desc`, `sc_job_level`, `sc_job_cords`, `sc_job_homepage_yn`, `dt_temp_id`, `sc_job_trf_yn`) VALUES ('9008', 'MinLOS rules', '4', '\"3:9007:1\"', '0', NULL, '0')
        ");

        $this->addSql("
            INSERT INTO `sc_fun_job` (`sc_fun_job_id`, `sc_job_id`, `sc_function_id`, `dt_temp_id`, `sc_fun_job_trf_yn`) VALUES (NULL, '9008', '68', NULL, '0')
        ");

        $this->addSql("
            INSERT INTO `sc_menu` (`sc_menu_id`, `sc_menu_job_top`, `sc_menu_param`, `sc_menu_parent`, `sc_menu_seq`, `sc_menu_title`, `sc_function_id`, `sc_job_id`, `sc_menu_format_id`, `dt_temp_id`, `sc_menu_trf_yn`) VALUES (NULL, NULL, NULL, '273', '5', 'MinLOS rules', '68', '9008', '0', NULL, '1')
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
