<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20210617102638 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");

		/* Generate a temporary list of all properties and their property billing units */
		/* NOTE: If any property doesn't have a property billing unit the migration will abort */
		$this->addSql("
			CREATE TABLE tmp_property_business (
				tmp_property_id VARCHAR(36) NOT NULL,
				tmp_business_id VARCHAR(36) NOT NULL
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
		");
		$properties = $this->connection->executeQuery("
			SELECT
				pr_business.pr_business_id	
			FROM
				pr_business
			WHERE
				pr_business.pr_bus_property_yn = '1'
			ORDER BY
				pr_business.pr_business_sequence
		")->fetchAll(\PDO::FETCH_COLUMN);

		$property_business = [];
		foreach($properties AS $property_id) {
			$billing_business_id = "";
			$current_business_id = $property_id;
			while(!empty($current_business_id) && empty($billing_business_id)) {
				$check = $this->connection->fetchColumn("
					SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$current_business_id'
				",[],0);
				if($check == "1") {
					$billing_business_id = $current_business_id;
				}
				$current_business_id = $this->connection->fetchColumn("
					SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$current_business_id'
				",[],0);
			}
			$this->abortIf(empty($billing_business_id), "No property billing unit found for property [$property_id]");
			$property_business[] = "('$property_id','$billing_business_id')";
		}
		if(!empty($property_business)) {
			$this->addSql("
				INSERT INTO tmp_property_business (
					tmp_property_id,
					tmp_business_id
				) VALUES " . join(",",$property_business) . "
			");
		}

		/* Make rf_db_business fully data transfer enabled */
		$this->addSql("
			ALTER TABLE rf_db_business
				ADD COLUMN rf_db_business_db CHAR(2) DEFAULT NULL FIRST,
				ADD COLUMN rf_db_business_ix VARCHAR(36) DEFAULT NULL AFTER rf_db_business_id,
				CHANGE COLUMN rf_db_business_id rf_db_business_id INT(11) NOT NULL DEFAULT '0',
				DROP PRIMARY KEY
		");
		$this->addSql("
			UPDATE rf_db_business SET
				rf_db_business_db = 'RS',
				rf_db_business_ix = CONCAT('RS',rf_db_business_id)
		");
		$this->addSql("
			ALTER TABLE rf_db_business
				CHANGE COLUMN rf_db_business_db rf_db_business_db CHAR(2) NOT NULL DEFAULT '',
				CHANGE COLUMN rf_db_business_ix rf_db_business_ix VARCHAR(36) NOT NULL,
				ADD PRIMARY KEY (rf_db_business_ix)
				
		");
		$this->addSql("UPDATE tc_table SET tc_table_key_ind = '0' WHERE tc_table_name = 'rf_db_business'");

		/* Add flag to extra category for POS enabled categories */
		$this->addSql("ALTER TABLE ac_extra_category ADD COLUMN ac_extra_cat_pos_yn TINYINT(1) NOT NULL DEFAULT '0' AFTER ac_extra_cat_ind");

		/* Enable POS category flag for all extras used by the existing mappings */
		$this->addSql("
			UPDATE
				ac_extra_category
				INNER JOIN ac_extra ON ac_extra.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
				INNER JOIN ac_pos ON ac_pos.ac_extra_id = ac_extra.ac_extra_ix
			SET
				ac_extra_category.ac_extra_cat_pos_yn = '1'
		");
		$this->addSql("
			UPDATE
				ac_extra_category
				INNER JOIN ac_extra ON ac_extra.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
				INNER JOIN ac_pos_map ON ac_pos_map.ac_extra_id = ac_extra.ac_extra_ix
			SET
				ac_extra_category.ac_extra_cat_pos_yn = '1'
		");

		$missing_property_codes = $this->connection->executeQuery("
			SELECT DISTINCT
				ac_pos.ac_pos_db
			FROM
				ac_pos
				LEFT JOIN rf_db_business ON rf_db_business.rf_db_code = ac_pos.ac_pos_db
			WHERE
				rf_db_business.rf_db_code IS NULL
		")->fetchAll(\PDO::FETCH_COLUMN);
		$this->abortIf(sizeof($missing_property_codes) > 0, "Environments uses for POS location(s) without any property links [" . join(", ", $missing_property_codes) . "]");

		/* Add property and stock mapping for the default to ac_pos */
		$this->addSql("
			ALTER TABLE ac_pos
				ADD COLUMN pr_business_id VARCHAR(36) NULL AFTER ac_pos_name_rr,
				ADD COLUMN ac_pos_stock_id VARCHAR(36) NULL AFTER ac_extra_id
		");

		/* Populate property on ac_pos */
		$this->addSql("
			UPDATE
				ac_pos
			SET
				ac_pos.pr_business_id = (
					SELECT
						rf_db_business.pr_business_id
					FROM
						rf_db_business
					WHERE
						rf_db_business.rf_db_code = ac_pos.ac_pos_db
					LIMIT 1
				)
		");
		
		$this->addSql("ALTER TABLE ac_pos CHANGE COLUMN pr_business_id pr_business_id VARCHAR(36) NOT NULL");

		/* Create new POS mapping table */
		$this->addSql("
			CREATE TABLE ac_pos_stock (
				ac_pos_stock_db CHAR(2) NOT NULL DEFAULT '',
				ac_pos_stock_id INT(11) NOT NULL,
				ac_pos_stock_ix VARCHAR(36) NOT NULL,
				pr_business_id VARCHAR(36) NOT NULL,
				ac_extra_id VARCHAR(36) NOT NULL,
				ac_pos_stock_code VARCHAR(255) NOT NULL,
				dt_temp_id varchar(36) DEFAULT NULL,
				ac_pos_stock_trf_yn tinyint(1) NOT NULL DEFAULT '0',
				PRIMARY KEY (ac_pos_stock_ix),
				KEY pr_business_id (pr_business_id),
				KEY dt_temp_id (dt_temp_id),
				KEY ac_pos_stock_trf_yn (ac_pos_stock_trf_yn)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
		");

		/* Remove inactive mappings */
		$this->addSql("
			DELETE ac_pos_map FROM
				ac_pos_map
				INNER JOIN ac_pos ON ac_pos.ac_pos_ix = ac_pos_map.ac_pos_id
			WHERE
				ac_pos.ac_inactive_yn != '0'
		");

		/* Generate a temporary table with all mapped extras, including default extras */
		$this->addSql("
			CREATE TABLE tmp_pos_stock (
				tmp_business_id VARCHAR(36) NOT NULL,
				tmp_extra_id VARCHAR(36) NOT NULL,
				tmp_stock_code VARCHAR(255) NOT NULL
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
			");

		$this->addSql("
			INSERT INTO tmp_pos_stock (
				tmp_business_id,
				tmp_extra_id,
				tmp_stock_code
			) SELECT
				tmp_property_business.tmp_business_id,
				ac_pos.ac_extra_id,
				CONCAT('default','-',ac_pos.ac_pos_ix)
			FROM
				ac_pos
				INNER JOIN tmp_property_business ON tmp_property_business.tmp_property_id = ac_pos.pr_business_id
			WHERE
				ac_pos.ac_inactive_yn = '0'
		");
		$this->addSql("
			INSERT INTO tmp_pos_stock (
				tmp_business_id,
				tmp_extra_id,
				tmp_stock_code
			) SELECT
				tmp_property_business.tmp_business_id,
				ac_pos_map.ac_extra_id,
				ac_pos_map.ac_pos_map_code
			FROM
				ac_pos_map
				INNER JOIN ac_pos ON ac_pos.ac_pos_ix = ac_pos_map.ac_pos_id
				INNER JOIN tmp_property_business ON tmp_property_business.tmp_property_id = ac_pos.pr_business_id
			WHERE
				ac_pos.ac_inactive_yn = '0'
		");

		/* Populate new POS mapping table with existing extras */
		$this->addSql("
			INSERT INTO ac_pos_stock (
				ac_pos_stock_db,
				ac_pos_stock_id,
				ac_pos_stock_ix,
				pr_business_id,
				ac_extra_id,
				ac_pos_stock_code
			) SELECT DISTINCT
				'RS',
				0,
				GET_UUID(),
				tmp_pos_stock.tmp_business_id,
				tmp_pos_stock.tmp_extra_id,
				tmp_pos_stock.tmp_stock_code
			FROM
				tmp_pos_stock
		");

		/* Link ac_pos default to ac_pos_stock */
		$this->addSql("
			UPDATE
				ac_pos
				INNER JOIN tmp_property_business ON tmp_property_business.tmp_property_id = ac_pos.pr_business_id
				INNER JOIN ac_pos_stock ON 
					ac_pos_stock.pr_business_id = tmp_property_business.tmp_business_id
					AND ac_pos_stock.ac_extra_id = ac_pos.ac_extra_id
					AND ac_pos_stock.ac_pos_stock_code = CONCAT('default','-',ac_pos.ac_pos_ix)
			SET
				ac_pos.ac_pos_stock_id = ac_pos_stock.ac_pos_stock_ix
		");
		$this->addSql("
			ALTER TABLE ac_pos
				DROP COLUMN ac_extra_id,
				CHANGE COLUMN pr_business_id pr_business_id VARCHAR(36) NOT NULL,
				CHANGE COLUMN ac_pos_stock_id ac_pos_stock_id VARCHAR(36) NOT NULL
		");

		/* Add link to the ac_pos_stock table to the existing ac_pos_map mapping table */
		$this->addSql("ALTER TABLE ac_pos_map ADD COLUMN ac_pos_stock_id VARCHAR(36) NULL AFTER ac_pos_map_ix");

		/* Populate ac_pos_map.ac_pos_stock_id and drop columns that are no longer needed */
		$this->addSql("
			UPDATE
				ac_pos_map
				INNER JOIN ac_pos ON ac_pos.ac_pos_ix = ac_pos_map.ac_pos_id
				INNER JOIN tmp_property_business ON tmp_property_business.tmp_property_id = ac_pos.pr_business_id
				INNER JOIN ac_pos_stock ON
					ac_pos_stock.pr_business_id = tmp_property_business.tmp_business_id
					AND ac_pos_stock.ac_extra_id = ac_pos_map.ac_extra_id
					AND ac_pos_stock.ac_pos_stock_code = ac_pos_map.ac_pos_map_code
			SET
				ac_pos_map.ac_pos_stock_id = ac_pos_stock.ac_pos_stock_ix
		");
		$this->addSql("
			ALTER TABLE ac_pos_map
				DROP COLUMN ac_extra_id,
				DROP COLUMN ac_pos_map_code,
				CHANGE COLUMN ac_pos_stock_id ac_pos_stock_id VARCHAR(36) NOT NULL
		");
				
		/* Remove unused ac_pos_map_accomm table */
		$this->addSql("DROP TABLE ac_pos_map_accomm");
		$this->addSql("DELETE FROM tc_table WHERE tc_table.tc_table_name = 'ac_pos_map_accomm'");

		/* Update tc_table info for affected tables */
		/* ac_pos_stock seq = MAX(pr_business = 20, ac_extra = 10) + 5 = 25 */
		$this->addSql("INSERT INTO tc_table (tc_table_name, tc_table_seq) VALUES ('ac_pos_stock', '25')");
		/* ac_pos seq = MAX(pr_business = 20, ac_pos_stock = 25) + 5 = 30 */
		$this->addSql("UPDATE tc_table SET tc_table_seq = '30' WHERE tc_table_name = 'ac_pos'");
		/* ac_pos_map seq = MAX(ac_pos_stock = 25, ac_pos = 30) + 5 = 35 */
		$this->addSql("UPDATE tc_table SET tc_table_seq = '35' WHERE tc_table_name = 'ac_pos_map'");

		/* Remove all temporary tables */
		$this->addSql("DROP TABLE tmp_pos_stock");
		$this->addSql("DROP TABLE tmp_property_business");

		/* Create ac_extra_prop entries for any property/extra pair used by POS mapping */
		/*
			Find duplicate properties on ac_extra_prop

			SELECT
				ac_extra_prop.ac_extra_id,
				ac_extra_prop.pr_business_id,
				COUNT(ac_extra_prop.ac_extra_prop_ix)
			FROM
				ac_extra_prop
			GROUP BY
				ac_extra_prop.ac_extra_id,
				ac_extra_prop.pr_business_id
			HAVING
			    COUNT(ac_extra_prop.ac_extra_prop_ix) > 1
		*/
		/* Create a list of all required extra/property pairs */
		$this->addSql("
			CREATE TABLE tmp_extra_property (
				tmp_business_id VARCHAR(36) NOT NULL,
				tmp_extra_id VARCHAR(36) NOT NULL
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
		");
		$this->addSql("
			INSERT INTO tmp_extra_property SELECT
				ac_pos.pr_business_id,
				ac_pos_stock.ac_extra_id
			FROM
				ac_pos
				INNER JOIN ac_pos_stock ON ac_pos_stock.ac_pos_stock_ix = ac_pos.ac_pos_stock_id
				LEFT JOIN ac_extra_prop ON
					ac_extra_prop.pr_business_id = ac_pos.pr_business_id
					AND ac_extra_prop.ac_extra_id = ac_pos_stock.ac_extra_id
			WHERE
				ac_extra_prop.ac_extra_prop_ix IS NULL
		");
		$this->addSql("
			INSERT INTO tmp_extra_property SELECT
				ac_pos.pr_business_id,
				ac_pos_stock.ac_extra_id
			FROM
				ac_pos_map
				INNER JOIN ac_pos ON ac_pos.ac_pos_ix = ac_pos_map.ac_pos_id
				INNER JOIN ac_pos_stock ON ac_pos_stock.ac_pos_stock_ix = ac_pos_map.ac_pos_stock_id
				LEFT JOIN ac_extra_prop ON
					ac_extra_prop.pr_business_id = ac_pos.pr_business_id
					AND ac_extra_prop.ac_extra_id = ac_pos_stock.ac_extra_id
			WHERE
				ac_extra_prop.ac_extra_prop_ix IS NULL
			
		");
		$this->addSql("
			INSERT INTO ac_extra_prop SELECT DISTINCT
				ac_extra.ac_extra_db,
				0,
				'',
				tmp_extra_property.tmp_extra_id,
				tmp_extra_property.tmp_business_id,
				NULL,
				1
			FROM
				tmp_extra_property
				INNER JOIN ac_extra ON ac_extra.ac_extra_ix = tmp_extra_property.tmp_extra_id
		");
		$this->addSql("DROP TABLE tmp_extra_property");

		/* Jobs for sales items */
		$this->addSql("
			INSERT INTO sc_job (sc_job_id, sc_job_desc, sc_job_level, sc_job_cords) VALUES
				(1028, 'Display POS sales items', 4, '\"1:1018:1\"'),
				(1029, 'Edit POS sales items', 6, '\"3,0:1018:1\"')
		");
		$this->addSql("
			INSERT INTO sc_fun_job (sc_job_id, sc_function_id) VALUES
				(1028, 86),
				(1029, 86)
		");

		/* POS menu with sub-items for Sales items and Sales locations */
		$this->addSql("UPDATE sc_menu SET sc_menu_seq = '7' WHERE sc_menu_id = '273'"); // Shift rates down
		$this->addSql("UPDATE sc_menu SET sc_menu_seq = '8' WHERE sc_menu_id = '10'"); // Shift user access down
		$this->addSql("UPDATE sc_menu SET sc_menu_seq = '6', sc_menu_parent = '218' WHERE sc_menu_id = '147'"); // Move integration to setup menu
		$this->addSql("UPDATE sc_menu SET sc_menu_seq = '3' WHERE sc_menu_id = '272'"); // Shift other up in code tables

		// 218 = Setup
		$this->addSql("INSERT INTO sc_menu (sc_menu_param, sc_menu_parent, sc_menu_seq, sc_menu_title) VALUES ('', 147, 3, 'New POS')");

		$this->addSql("
			SELECT sc_menu_id FROM sc_menu WHERE sc_menu_parent = '147' AND sc_menu_title = 'New POS' INTO @pos_menu_id;
			INSERT INTO sc_menu (sc_menu_job_top, sc_menu_param, sc_menu_parent, sc_menu_seq, sc_menu_title, sc_function_id, sc_job_id, sc_menu_format_id) 
				VALUES ('1029', '', @pos_menu_id, 1, 'Sales Items', 86, '1028', '15');
			UPDATE sc_menu SET
				sc_menu_title = 'Sales Locations',
				sc_menu_seq = 2,
				sc_menu_parent = @pos_menu_id,
				sc_function_id = '86'
			WHERE sc_menu_id = '130'
		");
		$this->addSql("UPDATE sc_menu SET sc_menu_title = 'POS' WHERE sc_menu_title = 'New POS'");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
