<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20211103174232 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs

        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");
                
        // ========== in_api_request ==========
        $this->addSql("
            DROP TABLE IF EXISTS `in_api_request`;
            CREATE TABLE IF NOT EXISTS `in_api_request` (
                `in_api_request_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `in_api_request_id` INT(11) NOT NULL DEFAULT '0',
                `in_api_request_ix` VARCHAR(36) NOT NULL,
                `pr_business_id` VARCHAR(36) NOT NULL COMMENT 'fk link to invoicing unit.',
                `pr_user_request_id` VARCHAR(36) NOT NULL COMMENT 'fk link to [pr_persona] identifying the user who initiated the pull event.',
                `in_api_request_start` TIMESTAMP NOT NULL DEFAULT 0 COMMENT 'Date time pull event initiated. ResRequest server.',
                `in_api_request_start_invntry` TIMESTAMP NULL COMMENT 'Date time pull event initiated. Inventory system server. First transaction processed.',
                `in_api_request_end` TIMESTAMP NOT NULL COMMENT 'Date time pull event completed.  ResRequest server.',
                `in_api_request_end_invntry` TIMESTAMP NULL COMMENT 'Date time pull event completed.  ResRequest server. Inventory server. Last transaction processed.',
                `in_api_request_item_tran_ind` VARCHAR(45) NOT NULL COMMENT '1 = PO, 2 = Return, 3=COS, 4 = Issue, 5 = Transfer',
                `in_api_request_item_count` INT(11) NOT NULL DEFAULT 0 COMMENT 'Number of transactions pulled',
                `in_api_request_result` VARCHAR(50) COMMENT 'API request result code',
                PRIMARY KEY (`in_api_request_ix`))
                COMMENT = 'All inventory pull requests initiated by a user.';
        ");

        // ========== in_api_tran ==========
        $this->addSql("
            DROP TABLE IF EXISTS `in_api_tran`;
            CREATE TABLE IF NOT EXISTS `in_api_tran` (
                `in_api_tran_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `in_api_tran_id` INT(11) NOT NULL DEFAULT '0',
                `in_api_tran_ix` VARCHAR(36) NOT NULL,
                `in_api_request_id` VARCHAR(36) NOT NULL COMMENT 'fk link to identify the pull event that imported the transaction.',
                `in_api_api_id` VARCHAR(36) NOT NULL COMMENT 'Transaction Id received from api',
                `in_api_tran_ref` VARCHAR(50) NOT NULL COMMENT 'This is the PO received Supplier invoice number.',
                `in_api_tran_doc_ref` VARCHAR(50) NOT NULL COMMENT 'In the case of an Issue or Transfer this is the document reference, in the case of COS it is the POS sales invoice number, PO received - Supplier invoice number.',
                `in_api_tran_location` VARCHAR(36) NOT NULL COMMENT 'This is the key of the sales or stock location that generated the transaction.  fk link to [ac_stock] or [ac_sales]',

                `in_api_tran_inv_amt` DECIMAL(16,2) NOT NULL DEFAULT 0 COMMENT 'Total payable amount of the supplier invoice.',
                `in_api_tran_vat_amt` DECIMAL(16,2) NOT NULL DEFAULT 0 COMMENT 'Amount of Input VAT included in the supplier invoice.',
                `in_api_tran_supp_code` VARCHAR(36) NOT NULL DEFAULT '' COMMENT 'Supplier code used in the accounting system and mapped in the inventory system.',
                `in_api_tran_supp_name` TEXT COMMENT 'Supplier name, as recorded in the inventory system.',
                `in_api_tran_supp_address` TEXT COMMENT 'Supplier address, as recorded in the inventory system.',
                `in_api_tran_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'Date and time that the API record was created in the inventory system.',

                `in_api_tran_voided` TINYINT NOT NULL DEFAULT 0,
                `in_api_tran_date` TIMESTAMP NOT NULL COMMENT 'Date and time at which the transaction was processed.',
            PRIMARY KEY (`in_api_tran_ix`),
            COMMENT = 'This table records the header details of PO, COS, Issue and Transfer transactions as received via the inventory API.'
        ");

        // ========== in_api_item ==========
        $this->addSql("
            DROP TABLE IF EXISTS `in_api_item`;
            CREATE TABLE IF NOT EXISTS `in_api_item` (
                `in_api_item_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `in_api_item_id` INT(11) NOT NULL DEFAULT '0',
                `in_api_item_ix` VARCHAR(36) NOT NULL,
                `in_api_header_id` VARCHAR(36) NOT NULL COMMENT 'fk link to the transaction header record. 
                    Link to [in_api_po] if [in_api_item_type_ind] = 1 or 2.
                    Link to [in_api_tran] if [in_api_item_type_ind] > 2.',
                `in_api_api_item_id` VARCHAR(36) NOT NULL COMMENT 'Item line Id received from api',
                `in_api_item_type_ind` INT(3) NOT NULL COMMENT '1 = PO, 2 = Return, 3=COS, 4 = Issue, 5 = Transfer',
                `in_api_item_stock_code` VARCHAR(36) COMMENT 'SKU of the stock item being transacted.',
                `in_api_item_invent_code` VARCHAR(36) NOT NULL COMMENT 'The inventory account code used in the accounting system to represent the stock item. This is derived in the inventory system by mapping on the department structure.',
                `in_api_item_exp_code` VARCHAR(36) NOT NULL COMMENT 'The COS or expense account code used in the accounting system to represent the stock usage. This is derived in the inventory system by mapping on the department structure.',
                `in_api_item_qty` INT(5) NOT NULL COMMENT 'The quantity of the stock item transacted. This, together with unit price, is used to calculate the item amount.',
                `in_api_item_unit_price` DECIMAL(16,2) NULL COMMENT 'As received from the api. Used to check that total received is correct.',
                `in_api_item_price` DECIMAL(16,2) NOT NULL COMMENT 'The total cost value of the transaction received from the api.',
                `in_api_item_voided` TINYINT NOT NULL DEFAULT 0,
            PRIMARY KEY (`in_api_item_ix`),
            COMMENT = 'This table records the stock detail of all transactions pulled via the inventory API.';
        ");

        // ========== ac_stock ==========
        $this->addSql("
            DROP TABLE IF EXISTS `ac_stock`;
            CREATE TABLE IF NOT EXISTS `ac_stock` (
            `ac_stock_db` CHAR(2) NOT NULL DEFAULT 'RS',
            `ac_stock_id` INT(11) NOT NULL DEFAULT '0',
            `ac_stock_ix` VARCHAR(36) NOT NULL,
            `fn_cost_centre_1_id` VARCHAR(36) NOT NULL,
            `fn_cost_centre_2_id` VARCHAR(36) NOT NULL,
            `pr_business_id` VARCHAR(36) NOT NULL,
            `ac_stock_key_pos` VARCHAR(45) NOT NULL,
            `ac_stock_name_rr` VARCHAR(45) NOT NULL,
            `ac_stock_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0',
            `ac_stock_trf_yn` TINYINT(1) NOT NULL DEFAULT '0',
            PRIMARY KEY (`ac_stock_ix`));
        ");

        // ========== ac_stock_oride ==========
        $this->addSql("
            DROP TABLE IF EXISTS `ac_stock_oride`;
            CREATE TABLE IF NOT EXISTS `ac_stock_oride` (
            `ac_stock_oride_db` CHAR(2) NOT NULL DEFAULT 'RS',
            `ac_stock_oride_id` INT(11) NOT NULL DEFAULT '0',
            `ac_stock_oride_ix` VARCHAR(36) NOT NULL,
            `fn_cost_centre_2_id` VARCHAR(36) NOT NULL,
            `fn_ledger_default_id` VARCHAR(36) NOT NULL,
            `fn_ledger_oride_id` VARCHAR(36) NOT NULL,
            `pr_business_id` VARCHAR(36) NOT NULL,
            `ac_stock_oride_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0',
            `ac_stock_oride_trf_yn` TINYINT(1) NOT NULL DEFAULT '0',
            PRIMARY KEY (`ac_stock_oride_ix`));
        ");

        // ========== tc_table entry ==========
        $this->addSql("
            INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_trf_yn)
            VALUES ('ac_stock', 35, 0, 0, 1), ('ac_stock_oride', 36, 0, 0, 1);
        ");

        // ========== ac_pos ==========
        $this->addSql("
            ALTER TABLE `ac_pos` 
            ADD COLUMN `fn_cost_centre_1_id` VARCHAR(36) NULL AFTER `rf_bank_id`,
            ADD COLUMN `fn_cost_centre_2_id` VARCHAR(36) NULL AFTER `fn_cost_centre_1_id`;
        ");

        // ========== pr_business ==========
        $this->addSql("
            ALTER TABLE `pr_business` 
            ADD COLUMN `fn_ledger_id_input_vat` VARCHAR(36) NULL AFTER `fn_ledger_id_forex`,
            ADD COLUMN `pr_bus_post_inventory_yn` TINYINT(1) DEFAULT '0' AFTER `fn_ledger_id_input_vat`,
            ADD COLUMN `pr_bus_post_in_po_yn` TINYINT(1) DEFAULT '0' AFTER `pr_bus_post_inventory_yn`,
            ADD COLUMN `pr_bus_post_in_returns_yn` TINYINT(1) DEFAULT '0' AFTER `pr_bus_post_in_po_yn`, 
            ADD COLUMN `pr_bus_post_in_cos_yn` TINYINT(1) DEFAULT '0' AFTER `pr_bus_post_in_returns_yn`, 
            ADD COLUMN `pr_bus_post_in_issues_yn` TINYINT(1) DEFAULT '0' AFTER `pr_bus_post_in_cos_yn`, 
            ADD COLUMN `pr_bus_post_in_trfs_yn` TINYINT(1) DEFAULT '0' AFTER `pr_bus_post_in_issues_yn`, 
            ADD COLUMN `pr_bus_api_client` VARCHAR(36) NULL AFTER `pr_bus_post_in_trfs_yn`, 
            ADD COLUMN `pr_bus_api_token` VARCHAR(36) NULL AFTER `pr_bus_api_client`, 
            ADD COLUMN `pr_bus_api_url_base` VARCHAR(100) DEFAULT 'cloud.tallorder.mobi/integrations-prod/v1' AFTER `pr_bus_api_token`, 
            ADD COLUMN `pr_bus_api_url_po` VARCHAR(100) DEFAULT '/inventory/purchase-order-receipts' AFTER `pr_bus_api_url_base`, 
            ADD COLUMN `pr_bus_api_url_returns` VARCHAR(100) DEFAULT '/inventory/supplier-returns' AFTER `pr_bus_api_url_po`, 
            ADD COLUMN `pr_bus_api_url_cos` VARCHAR(100) DEFAULT '/sales/cost-of-sales'  AFTER `pr_bus_api_url_returns`, 
            ADD COLUMN `pr_bus_api_url_issues` VARCHAR(100) DEFAULT '/inventory/stock-issues'  AFTER `pr_bus_api_url_cos`, 
            ADD COLUMN `pr_bus_api_url_transfers` VARCHAR(100) DEFAULT '/inventory/stock-requisitions' AFTER `pr_bus_api_url_issues`; 
        ");

        // ========== fn_tran_item ==========
        $this->addSql("
            ALTER TABLE `fn_tran_item` 
            ADD COLUMN `fn_supplier_code` VARCHAR(36) NULL AFTER `fn_debtor_id`;
            ");

        // ========== operational and menu changes ==========
        // ========== job ==========
        $this->addSql("
            INSERT INTO sc_job (sc_job_id, sc_job_desc,sc_job_level,sc_job_cords,sc_job_homepage_yn,sc_job_trf_yn) 
            VALUES(4001,'Stock Locations',6,'\"1:4001:1\"',0,1),
                (4002,'GL Account Detail popup - Stock Locations Tab',6, '\"1:4002:1\"',0,1),
                (4003,'GL Account Detail popup - Sales Locations Tab',6,'\"1:4003:1\"',0,1),
                (4004,'Inventory Processing',6,'\"1:4004:1\"',0,1);
            ");
        
        // ========== fun_job ==========
        $this->addSql("
            INSERT INTO sc_fun_job (sc_fun_job_id, sc_job_id,sc_function_id,sc_fun_job_trf_yn) 
            VALUES('779','4001','86','0'),
                ('780','4002','100','0'),
                ('781','4003','100','0'),
                ('782','4004','100','0'),
                ('783','4005','100','0');
        ");        
        
        // ========== Menu ==========
        $this->addSql("
            INSERT INTO sc_menu 
                (sc_menu_id,sc_menu_parent,sc_menu_seq,sc_menu_title,sc_function_id,sc_job_id,sc_menu_format_id,sc_menu_trf_yn)
            VALUES('4001','9019',3,'Stock Locations',86,4001,15,0);
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
