<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20220225155820 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs

        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");
                
        // ========== in_api_tran ==========
        $this->addSql("
            DROP TABLE IF EXISTS `in_api_tran`;
            CREATE TABLE IF NOT EXISTS `in_api_tran` (
                `in_api_tran_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `in_api_tran_id` INT(11) NOT NULL DEFAULT '0',
                `in_api_tran_ix` VARCHAR(36) NOT NULL,
                `in_api_request_id` VARCHAR(36) NOT NULL COMMENT 'fk link to identify the pull event that imported the transaction.',
                `in_api_api_id` VARCHAR(36) NOT NULL COMMENT 'Transaction Id received from api',
                `in_api_tran_ref` VARCHAR(50) NOT NULL COMMENT 'This is the PO received Supplier invoice number.',
                `in_api_tran_doc_ref` VARCHAR(50) NOT NULL COMMENT 'In the case of an Issue or Transfer this is the document reference, in the case of COS it is the POS sales invoice number, PO received - Supplier invoice number.',
                `in_api_tran_location` VARCHAR(36) NOT NULL COMMENT 'This is the key of the sales or stock location that generated the transaction.  fk link to [ac_stock] or [ac_sales]',

                `in_api_tran_inv_amt` DECIMAL(16,2) NOT NULL DEFAULT 0 COMMENT 'Total payable amount of the supplier invoice.',
                `in_api_tran_vat_amt` DECIMAL(16,2) NOT NULL DEFAULT 0 COMMENT 'Amount of Input VAT included in the supplier invoice.',
                `in_api_tran_supp_code` VARCHAR(36) NOT NULL DEFAULT '' COMMENT 'Supplier code used in the accounting system and mapped in the inventory system.',
                `in_api_tran_supp_name` TEXT COMMENT 'Supplier name, as recorded in the inventory system.',
                `in_api_tran_supp_address` TEXT COMMENT 'Supplier address, as recorded in the inventory system.',
                `in_api_tran_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'Date and time that the API record was created in the inventory system.',

                `in_api_tran_voided` TINYINT NOT NULL DEFAULT 0,
                `in_api_tran_date` TIMESTAMP NOT NULL COMMENT 'Date and time at which the transaction was processed.',
            PRIMARY KEY (`in_api_tran_ix`)) 
            COMMENT = 'This table records the header details of PO, COS, Issue and Transfer transactions as received via the inventory API.'
        ");

        // ========== in_api_item ==========
        $this->addSql("
            DROP TABLE IF EXISTS `in_api_item`;
            CREATE TABLE IF NOT EXISTS `in_api_item` (
                `in_api_item_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `in_api_item_id` INT(11) NOT NULL DEFAULT '0',
                `in_api_item_ix` VARCHAR(36) NOT NULL,
                `in_api_header_id` VARCHAR(36) NOT NULL COMMENT 'fk link to the transaction header record. 
                    Link to [in_api_po] if [in_api_item_type_ind] = 1 or 2.
                    Link to [in_api_tran] if [in_api_item_type_ind] > 2.',
                `in_api_api_item_id` VARCHAR(36) NOT NULL COMMENT 'Item line Id received from api',
                `in_api_item_type_ind` INT(3) NOT NULL COMMENT '1 = PO, 2 = Return, 3=COS, 4 = Issue, 5 = Transfer',
                `in_api_item_stock_code` VARCHAR(36) COMMENT 'SKU of the stock item being transacted.',
                `in_api_item_invent_code` VARCHAR(36) NOT NULL COMMENT 'The inventory account code used in the accounting system to represent the stock item. This is derived in the inventory system by mapping on the department structure.',
                `in_api_item_exp_code` VARCHAR(36) NOT NULL COMMENT 'The COS or expense account code used in the accounting system to represent the stock usage. This is derived in the inventory system by mapping on the department structure.',
                `in_api_item_qty` INT(5) NOT NULL COMMENT 'The quantity of the stock item transacted. This, together with unit price, is used to calculate the item amount.',
                `in_api_item_unit_price` DECIMAL(16,2) NULL COMMENT 'As received from the api. Used to check that total received is correct.',
                `in_api_item_price` DECIMAL(16,2) NOT NULL COMMENT 'The total cost value of the transaction received from the api.',
                `in_api_item_voided` TINYINT NOT NULL DEFAULT 0,
            PRIMARY KEY (`in_api_item_ix`)) 
            COMMENT = 'This table records the stock detail of all transactions pulled via the inventory API.';
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
