<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 * Alters / creates Enterprise tables for Fiscalisation
 */
class Version20220701123911 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");
        
        $this->addSql("
            ALTER TABLE `fn_invoice` 
            ADD COLUMN `fn_inv_fiscal_status_ind` INT NULL COMMENT 'Status of fiscal verification requests. 1=Pending, 2=Verified, 3=Rejected, 4=Error, 5=credit upload pending, 6=credit pending, 7=credit approved, 8=credit error. (applicable to invoicing units for which fiscalisation is active)' AFTER `pr_business_id`;
        ");

        $this->addSql("
            CREATE TABLE `fn_invoice_fiscal_api` (
                `fn_invoice_fiscal_api_id` VARCHAR(36) NOT NULL,
                `fn_invoice_id` VARCHAR(36) NOT NULL,
                `fn_api_post_rr` TEXT NOT NULL COMMENT 'A copy of the api request string posted to Fiscalator',
                `fn_api_post_fs` TEXT NULL COMMENT 'A copy of the api string returned by Fiscalator',
                `fn_api_time_post` TIMESTAMP NOT NULL DEFAULT now() COMMENT 'Date and time at which the request was posted.',
                `fn_api_time_response` TIMESTAMP NULL COMMENT 'Date and time of response from fiscalator.',
                PRIMARY KEY (`fn_invoice_fiscal_api_id`),
                UNIQUE INDEX `fn_invoice_fiscal_api_id_UNIQUE` (`fn_invoice_fiscal_api_id` ASC)
            ) ENGINE=InnoDB COMMENT = 'Maintains a log of transaction communication with Fiscalator.'
        ");

        $this->addSql("
            CREATE TABLE `fs_invoice` (
                `fs_invoice_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `fs_invoice_id` INT(11) NOT NULL DEFAULT '0',
                `fs_invoice_ix` VARCHAR(36) NOT NULL,
                `fn_invoice_id` VARCHAR(36) NOT NULL,
                `fn_invoice_doc` TEXT NULL COMMENT 'Fiscalised document numbers',
                `fs_data` TEXT NULL COMMENT 'Json string with last integrator results returned by Fiscalator.',
                `fs_time_created` TIMESTAMP NOT NULL DEFAULT now() COMMENT 'Date and time at which the request was posted.',
                `fs_time_changed` TIMESTAMP NULL COMMENT 'Date and time of last response from fiscalator.',
                `dt_temp_id` VARCHAR(36),
                `fs_invoice_trf_yn` TINYINT(4) NOT NULL DEFAULT 0,
                PRIMARY KEY (`fs_invoice_ix`),
                UNIQUE INDEX `fs_invoice_ix_UNIQUE` (`fs_invoice_ix` ASC),
                INDEX `fs_invoice_doc_idx` (`fs_invoice_ix` ASC)
            ) ENGINE=InnoDB COMMENT = 'Maintains the fiscalised results per invoice.'
        ");

        $this->addSql("
            INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_trf_yn)
            VALUES ('fs_invoice', 60, 0, 0, 1)
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
