<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 * Alters / creates Enterprise tables for Fiscalisation
 */
class Version20220802190611 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("CALL sp_set_environment('RS')");
        $this->addSql("CALL sp_transfer_flagging(FALSE)");
        $this->addSql("CALL sp_master_override(TRUE)");
        
        $this->addSql("
            CREATE TABLE `fs_tax_commodity` (
                `fs_tax_commodity_db` CHAR(2) NOT NULL DEFAULT 'RS',
                `fs_tax_commodity_id` INT(11) NOT NULL DEFAULT '0',
                `fs_tax_commodity_ix` VARCHAR(36) NOT NULL,
                `pr_business_id` VARCHAR(36) NOT NULL COMMENT 'ID of invoicing unit',
                `rf_tax_rate_id` VARCHAR(36) NOT NULL COMMENT 'ID of tax rate',
                `fs_commodity_id` TEXT NULL COMMENT 'ID of component or extra',
                `fs_time_created` TIMESTAMP NOT NULL DEFAULT NOW(),
                `dt_temp_id` VARCHAR(36),
                `fs_tax_commodity_trf_yn` TINYINT(4) NOT NULL DEFAULT 0,
                PRIMARY KEY (`fs_tax_commodity_ix`),
                UNIQUE INDEX `fs_tax_commodity_ix_UNIQUE` (`fs_tax_commodity_ix` ASC),
                INDEX `fs_tax_commodity_doc_idx` (`fs_tax_commodity_ix` ASC)
            ) ENGINE=InnoDB COMMENT = 'Maps tax rate to commodities'
        ");

        $this->addSql("
            INSERT INTO tc_table (tc_table_name, tc_table_seq, tc_table_sys_code, tc_table_key_ind, tc_table_trf_yn)
            VALUES ('fs_tax_commodity', 60, 0, 0, 1)
        ");

        $this->addSql("CALL sp_transfer_flagging(TRUE)");
        $this->addSql("CALL sp_master_override(FALSE)");

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
