<?php

namespace Resrequest\DB\Enterprise\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20230227085015 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->addSql("DROP PROCEDURE IF EXISTS sp_check_environment; ");
        $this->addSql("
CREATE PROCEDURE sp_check_environment() -- Checks if the environment has been set
BEGIN
    IF @db_code IS NULL THEN
        SIGNAL SQLSTATE '45000' SET
        MYSQL_ERRNO = '30001',
        MESSAGE_TEXT = \"Environment not set. Set environment using CALL sp_set_environment('WB');\";
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_set_environment; ");
        $this->addSql("
CREATE PROCEDURE sp_set_environment(IN db_code CHAR(2)) -- Sets the environment
BEGIN
    SET @db_code = db_code COLLATE utf8mb4_general_ci;
    SELECT rf_database_id FROM rf_database WHERE rf_db_code = @db_code INTO @environment_id;
    IF @environment_id IS NULL THEN
        SIGNAL SQLSTATE '45000' SET
        MYSQL_ERRNO = '30003',
        MESSAGE_TEXT = 'Specified environment does not exist';
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_is_environment_master; ");
        $this->addSql("
CREATE PROCEDURE sp_is_environment_master() -- Sets global variable true or false if environment is master or not
is_environment_master: BEGIN
    IF @enable_master_override = TRUE THEN
        SET @is_env_master = TRUE;
        LEAVE is_environment_master;
    END IF;
    SELECT rf_sys_db_master_id FROM rf_system INTO @master_env_id;
    IF @master_env_id = @environment_id THEN
        SET @is_env_master = TRUE;
    ELSE
        SET @is_env_master = FALSE;
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_is_environment_web; ");
        $this->addSql("
CREATE PROCEDURE sp_is_environment_web() -- Sets global variable true or false if environment is web or not
BEGIN
    DECLARE is_env_web TINYINT(1);

    CALL sp_check_environment();
    IF IF(LEFT(@db_code, 1) = 'W', TRUE, FALSE) THEN
        SET @is_env_web = TRUE;
    ELSE
        SELECT -- Check if environment type is web
            rf_db_env_type_web_yn
        INTO
            is_env_web
        FROM
            rf_database
        WHERE
            rf_db_code = @db_code;

        IF is_env_web = 1 THEN
            SET @is_env_web = TRUE;
        ELSE
            SET @is_env_web = FALSE;
        END IF;
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_flag_record_for_transfer; ");
        $this->addSql("
CREATE PROCEDURE sp_flag_record_for_transfer(IN tc_table_id INT(11), IN record_id VARCHAR(36)) -- Flags specified record for data transfer
flag_record_for_transfer: BEGIN
    DECLARE ch_done TINYINT(1) DEFAULT FALSE;
    DECLARE remote_db_code CHAR(2); -- Environment code to transfer record to
    DECLARE remote_codes CURSOR FOR
        SELECT -- Get environment code list to transfer records to
            rf_db_code
        FROM
            rf_database
        WHERE
            rf_db_code NOT LIKE \"W%\"
            AND rf_db_env_type_web_yn = 0
            AND rf_db_inactive_yn = 0;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET ch_done = TRUE;

    IF @is_env_web THEN
        OPEN remote_codes;
        REPEAT
            FETCH remote_codes INTO remote_db_code;
            IF NOT ch_done THEN
                INSERT IGNORE INTO tc_property_trf
                    (rf_db_code, tc_table_id, tc_prop_record_id)
                VALUES (
                    remote_db_code,
                    tc_table_id,
                    record_id
                );
            END IF;
        UNTIL ch_done END REPEAT;
        CLOSE remote_codes;
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_flag_record_for_delete; ");
        $this->addSql("
CREATE PROCEDURE sp_flag_record_for_delete(IN tc_table_id INT(11), IN record_id CHAR(36)) -- Flags specified record for deletion
flag_record_for_delete: BEGIN
    DECLARE ch_done TINYINT(1) DEFAULT FALSE;
    DECLARE remote_db_code CHAR(2); -- Environment code to remove record from
    DECLARE remote_codes CURSOR FOR
    SELECT -- Get environment code list to remove records from
        rf_db_code
    FROM
        rf_database
    WHERE
        rf_db_code NOT LIKE \"W%\"
        AND rf_db_env_type_web_yn = 0
        AND rf_db_inactive_yn = 0;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET ch_done = TRUE;

    IF @is_env_web THEN
        OPEN remote_codes;
        REPEAT -- Remove records for each remote environment
            FETCH remote_codes INTO remote_db_code;
            IF NOT ch_done THEN
                DELETE FROM tc_property_trf
                WHERE
                    rf_db_code = remote_db_code
                    AND tc_table_id = tc_table_id
                    AND tc_prop_record_id = record_id;

                DELETE FROM tc_property_trf_prc
                WHERE
                    rf_db_code = remote_db_code
                    AND tc_table_id = tc_table_id
                    AND tc_prop_record_id = record_id;

                INSERT IGNORE INTO td_prop_deletions (
                    rf_db_code,
                    tc_table_id,
                    td_record_id
                ) VALUES (
                    remote_db_code,
                    tc_table_id,
                    record_id
                );
            END IF;
        UNTIL ch_done END REPEAT;
        CLOSE remote_codes;
    ELSE
        INSERT INTO td_deletions (td_dlt_table_id, td_dlt_rec_id) VALUES (tc_table_id, record_id);
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_transfer_flagging; ");
        $this->addSql("
CREATE PROCEDURE sp_transfer_flagging(IN enable_transfer_flagging TINYINT(1)) -- Flags specified record for deletion
BEGIN
    IF enable_transfer_flagging = FALSE THEN
        SET @transfer_flagging = FALSE;
    ELSE
        SET @transfer_flagging = TRUE;
    END IF;
END; ");
        $this->addSql("

DROP PROCEDURE IF EXISTS sp_master_override; ");
        $this->addSql("
CREATE PROCEDURE sp_master_override(IN enable_master_override TINYINT(1)) -- Flags specified record for deletion
BEGIN
    IF enable_master_override = TRUE THEN
        SET @enable_master_override = TRUE;
    ELSE
        SET @enable_master_override = FALSE;
    END IF;
END");
        
        

    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
