<?php

use Doctrine\Common\Collections\ArrayCollection;

abstract class Base {

    public function __construct() {
    }

    /* Abstract class inheritance boilerplate methods {{{ */
    /**
     * getEntityManager() - Get the Doctrine 2.0 Entity manager
     *
     * @return Doctrine\ORM\EntityManager
     */
    public function getEntityManager() {
        $registry = Zend_Registry::getInstance();
        return $registry->em;
    }

    public abstract function fetchAll();

    public abstract function fetchRow($id);

    /**
     * flush() - Flush any persisted DB changes
     *
     * @return Merlin_Model_Product
     */
    public function flush() {
        $this->getEntityManager()->flush();

        return $this;
    }
    /* Abstract class inheritance boilerplate methods */

?>
