DROP PROCEDURE IF EXISTS delete_triggers;

DELIMITER //

CREATE PROCEDURE delete_triggers()
BEGIN
    DECLARE ch_done TINYINT(1) DEFAULT FALSE;
    DECLARE table_name VARCHAR(36);
    DECLARE table_key_indicator TINYINT(4);
    DECLARE table_user_facing TINYINT(1);

    DECLARE tc_table CURSOR FOR SELECT tc_table_name FROM tc_table;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET ch_done = TRUE;
    SET @delete_sql = CONCAT("DELIMITER //", CHAR(13));

    OPEN tc_table;

    REPEAT -- Remove records for each remote environment
        FETCH tc_table INTO table_name;
        IF NOT ch_done THEN
            -- Generate insert trigger
            SET @sql = CONCAT(
                'DROP TRIGGER IF EXISTS tr_', table_name, '_ins; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_upd; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_del; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_ins_be; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_ins_af; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_upd_be; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_upd_af; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_del_be; //', CHAR(13),
                'DROP TRIGGER IF EXISTS tr_', table_name, '_del_af; //', CHAR(13));

            SET @delete_sql = CONCAT(@delete_sql, @sql);
        END IF;
    UNTIL ch_done END REPEAT;
    CLOSE tc_table;
END; //

CALL delete_triggers(); //
DROP PROCEDURE delete_triggers; //
SELECT @delete_sql; //