DELIMITER //

DROP PROCEDURE IF EXISTS insert_triggers; //

CREATE PROCEDURE insert_triggers()
BEGIN
    DECLARE ch_done TINYINT(1) DEFAULT FALSE;
    DECLARE table_name VARCHAR(50);
    DECLARE table_key_indicator TINYINT(4);
    DECLARE table_user_facing TINYINT(1);

    DECLARE trigger_tables CURSOR FOR SELECT tc_table_name, tc_table_key_ind, tc_table_user_facing_yn FROM tc_table;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET ch_done = TRUE;

    SET @triggers_sql = CONCAT("DELIMITER $$", CHAR(13));

    OPEN trigger_tables;

    REPEAT
        FETCH trigger_tables INTO table_name, table_key_indicator, table_user_facing;
        IF NOT ch_done THEN
            -- Generate insert trigger
            SET @insert_trigger_sql = CONCAT('
                DROP TRIGGER IF EXISTS tr_', table_name, '_ins_be; $$
                CREATE TRIGGER tr_', table_name, '_ins_be
                BEFORE INSERT ON ', table_name, ' FOR EACH ROW
                tr_', table_name, '_ins_be: BEGIN
                    -- Indicator: ', table_key_indicator, '
                    DECLARE table_max_id INT(255);
                    DECLARE tc_sequence_already_exists TINYINT(1);
                    DECLARE new_tc_sequence_increment INT(255);
                    DECLARE ix_already_exists TINYINT(1);
                    DECLARE prefix VARCHAR(5);
                    DECLARE id INT(255); -- Calculated ID for record
                    DECLARE ix VARCHAR(36); -- Calculated IX for record', CHAR(13));

                IF IF(table_key_indicator IN(0, 2), TRUE, FALSE) THEN
                    IF table_user_facing THEN -- Use tc_sequence. IX field is DB code + ID
                        SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.', table_name, '_ix IS NULL or NEW.', table_name, '_ix = "", FALSE, TRUE) THEN
                                LEAVE tr_', table_name, '_ins_be;
                            END IF;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = "', table_name, '"
                                AND tc_sequence_db_code = @db_code;

                            IF tc_sequence_already_exists IS FALSE THEN 
                                SELECT IFNULL(MAX(', table_name, '.', table_name, '_id),0) + 1
                                INTO
                                    new_tc_sequence_increment
                                FROM
                                    ', table_name, '
                                WHERE
                                    ', table_name, '.', table_name, '_db = @db_code;

                                INSERT IGNORE INTO tc_sequence (
                                    tc_sequence_table_name,
                                    tc_sequence_db_code,
                                    tc_sequence_prefix,
                                    tc_sequence_next_id
                                )
                                VALUES (
                                    "', table_name, '",
                                    @db_code,
                                    prefix,
                                    new_tc_sequence_increment
                                );
                            END IF;

                            SELECT -- Get the ID to use for this insert
                                tc_sequence_next_id
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = "', table_name, '"
                                AND tc_sequence_db_code = @db_code
                            INTO id;
                            
                            SET ix = CONCAT(@db_code, id);

                            SELECT COUNT(*) -- Check if a record with the next ID already exists
                            FROM
                                ', table_name, '
                            WHERE
                                ', table_name, '.', table_name, '_ix = ix
                            INTO ix_already_exists;

                            SELECT MAX(', table_name, '.', table_name, '_id) -- Get the highest ID in table
                            FROM
                                ', table_name, '
                            WHERE
                                ', table_name, '_db = @db_code
                            INTO table_max_id;

                            IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN ', table_name, ' ON ', table_name, '.', table_name, '_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = table_max_id + 1
                                WHERE
                                    tc_sequence_table_name = "', table_name, '"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = table_max_id + 1;
                                SET ix = CONCAT(@db_code, id);
                            ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                UPDATE
                                    tc_sequence
                                    INNER JOIN ', table_name, ' ON ', table_name, '.', table_name, '_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = "', table_name, '"
                                    AND tc_sequence_db_code = @db_code;
                                SET id = id + 1;
                                SET ix = CONCAT(@db_code, id);
                            END IF;
                            
                            SET NEW.', table_name, '_db = @db_code;
                            SET NEW.', table_name, '_id = id;
                            SET NEW.', table_name, '_ix = ix;

                            IF NEW.', table_name, '_trf_yn IS NULL THEN
                                SET NEW.', table_name, '_trf_yn = 0;
                            END IF;

                            UPDATE -- Increment tc_sequence entry for next record
                                tc_sequence
                                INNER JOIN ', table_name, ' ON ', table_name, '.', table_name, '_db = tc_sequence.tc_sequence_db_code
                            SET
                                tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                            WHERE
                                tc_sequence.tc_sequence_id = CONCAT(@db_code, "', table_name, '");', CHAR(13));
                    ELSE -- IX field is UUID
                        SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF IF(NEW.', table_name, '_ix IS NULL or NEW.', table_name, '_ix = "", FALSE, TRUE) THEN
                                LEAVE tr_', table_name, '_ins_be;
                            END IF;

                            SELECT GET_UUID() INTO ix;
                            SET NEW.', table_name, '_ix = ix;
                            SET NEW.', table_name, '_id = 0;
                            SET NEW.', table_name, '_db = @db_code;

                            IF NEW.', table_name, '_trf_yn IS NULL THEN
                                SET NEW.', table_name, '_trf_yn = 0;
                            END IF;', CHAR(13));
                    END IF;
                ELSEIF table_key_indicator = 3 THEN -- User facing tables
                        SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();
                            
                            IF IF(NEW.', table_name, '_ix IS NULL or NEW.', table_name, '_ix = "", FALSE, TRUE) THEN
                                LEAVE tr_', table_name, '_ins_be;
                            END IF;

                            SET prefix = NEW.', table_name, '_prefix;

                            SELECT
                                COUNT(tc_sequence_next_id)
                            INTO
                                tc_sequence_already_exists
                            FROM
                                tc_sequence
                            WHERE
                                tc_sequence_table_name = "', table_name, '"
                                AND tc_sequence_db_code = @db_code
                                AND tc_sequence_prefix = prefix;

                            IF tc_sequence_already_exists IS FALSE THEN', CHAR(13));

                            IF table_name = "fn_invoice" THEN
                                SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                                    SELECT DISTINCT
                                        pr_bus_inv_number
                                    INTO
                                        new_tc_sequence_increment
                                    FROM
                                        pr_business
                                    WHERE
                                        pr_bus_inv_prefix = prefix;', CHAR(13));
                            ELSE
                                SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                                    SELECT 
                                        IFNULL(MAX(', table_name, '.', table_name, '_id),0) + 1
                                    INTO
                                        new_tc_sequence_increment
                                    FROM
                                        ', table_name, '
                                    WHERE
                                        ', table_name, '.', table_name, '_db = @db_code
                                        AND ', table_name, '.', table_name, '_prefix = prefix;', CHAR(13));
                            END IF;

                            SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                                    IF new_tc_sequence_increment IS NULL THEN
                                        SET new_tc_sequence_increment = 1;
                                    ELSEIF new_tc_sequence_increment = 0 THEN
                                        SET new_tc_sequence_increment = 1;
                                    END IF;

                                    INSERT IGNORE INTO tc_sequence (
                                        tc_sequence_table_name,
                                        tc_sequence_db_code,
                                        tc_sequence_prefix,
                                        tc_sequence_next_id
                                    ) VALUES (
                                        "', table_name, '",
                                        @db_code,
                                        prefix,
                                        new_tc_sequence_increment
                                    );
                                END IF;

                                SELECT -- Get the ID to use for this insert
                                    tc_sequence_next_id
                                FROM
                                    tc_sequence
                                WHERE
                                    tc_sequence_table_name = "', table_name, '"
                                    AND tc_sequence_db_code = @db_code
                                    AND tc_sequence_prefix = prefix
                                INTO id;
                                
                                SET ix = CONCAT(@db_code, prefix, id);

                                SELECT COUNT(*) -- Check if a record with the next ID already exists
                                FROM
                                    ', table_name, '
                                WHERE
                                    ', table_name, '.', table_name, '_ix = ix
                                INTO ix_already_exists;

                                SELECT MAX(', table_name, '.', table_name, '_id) -- Get the highest ID in table
                                FROM
                                    ', table_name, '
                                WHERE
                                    ', table_name, '_db = @db_code
                                    AND ', table_name, '_prefix = prefix
                                INTO table_max_id;

                                IF id <= table_max_id THEN -- If tc_sequence is behind, update it and recalculate IX
                                    UPDATE
                                        tc_sequence
                                        INNER JOIN ', table_name, ' ON ', table_name, '.', table_name, '_db = tc_sequence.tc_sequence_db_code
                                    SET
                                        tc_sequence.tc_sequence_next_id = table_max_id + 1
                                    WHERE
                                        tc_sequence_table_name = "', table_name, '"
                                        AND tc_sequence_db_code = @db_code
                                        AND tc_sequence_prefix = prefix;
                                    SET id = table_max_id + 1;
                                    SET ix = CONCAT(@db_code, prefix, id);
                                ELSEIF ix_already_exists = 1 THEN -- If the record already exists, increment tc_sequence by 1 and recalculate IX
                                    UPDATE
                                        tc_sequence
                                        INNER JOIN ', table_name, ' ON ', table_name, '.', table_name, '_db = tc_sequence.tc_sequence_db_code
                                    SET
                                        tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                    WHERE
                                        tc_sequence_table_name = "', table_name, '"
                                        AND tc_sequence_db_code = @db_code
                                        AND tc_sequence_prefix = prefix;
                                    SET id = id + 1;
                                    SET ix = CONCAT(@db_code, prefix, id);
                                END IF;

                                SET NEW.', table_name, '_db = @db_code;
                                SET NEW.', table_name, '_id = id;
                                SET NEW.', table_name, '_ix = ix;
                                
                                IF NEW.', table_name, '_trf_yn IS NULL THEN
                                    SET NEW.', table_name, '_trf_yn = 0;
                                END IF;

                                UPDATE -- Increment tc_sequence entry for next record
                                    tc_sequence
                                    INNER JOIN ', table_name, ' ON ', table_name, '.', table_name, '_db = tc_sequence.tc_sequence_db_code
                                SET
                                    tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
                                WHERE
                                    tc_sequence_table_name = "', table_name, '"
                                    AND tc_sequence_db_code = @db_code
                                    AND tc_sequence_prefix = prefix;', CHAR(13));
                END IF;

                IF table_key_indicator = 1 THEN
                    SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                            CALL sp_check_environment();
                            CALL sp_is_environment_web();

                            IF NEW.', table_name, '_id IS NOT NULL THEN
                                LEAVE tr_', table_name, '_ins_be;
                            END IF;
                        END; $$

                        DROP TRIGGER IF EXISTS tr_', table_name, '_ins_af; $$
                        CREATE TRIGGER tr_', table_name, '_ins_af
                        AFTER INSERT ON ', table_name, ' FOR EACH ROW
                        tr_', table_name, '_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = "', table_name, '" INTO @tc_table_id;
                            SET @last_insert_id = NEW.', table_name, '_id;

                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_', table_name, '_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; $$', CHAR(13));
                ELSE
                    SET @insert_trigger_sql = CONCAT(@insert_trigger_sql, '
                        END; $$

                        DROP TRIGGER IF EXISTS tr_', table_name, '_ins_af; $$
                        CREATE TRIGGER tr_', table_name, '_ins_af
                        AFTER INSERT ON ', table_name, ' FOR EACH ROW
                        tr_', table_name, '_ins_af: BEGIN
                            SELECT tc_table_id FROM tc_table WHERE tc_table_name = "', table_name, '" INTO @tc_table_id;
                            SET @last_insert_id = NEW.', table_name, '_ix;
                            
                            IF @transfer_flagging IS FALSE THEN
                                LEAVE tr_', table_name, '_ins_af;
                            ELSE
                                CALL sp_flag_record_for_transfer(@tc_table_id, @last_insert_id);
                            END IF;
                        END; $$', CHAR(13));
                END IF;

                -- Generate update trigger
                SET @update_trigger_sql = CONCAT('
                    DROP TRIGGER IF EXISTS tr_', table_name, '_upd_be; $$
                    CREATE TRIGGER tr_', table_name, '_upd_be
                    BEFORE UPDATE ON ', table_name, ' FOR EACH ROW
                    BEGIN
                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "', table_name, '" INTO @tc_table_id;', CHAR(13));

                IF table_name != "tc_sequence" THEN -- Exception: tc_sequence can be modified on slave environments
                    SET @update_trigger_sql = CONCAT(@update_trigger_sql, '
                        SET row_transferred = OLD.', table_name, '_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE "45000" SET
                                MYSQL_ERRNO = "30002",
                                MESSAGE_TEXT = "Cannot edit data transferred row on slave environment";
                            END IF;
                        END IF;', CHAR(13));
                END IF;

                IF table_key_indicator = 1 THEN
                    SET @update_trigger_sql = CONCAT(@update_trigger_sql, '
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_transfer(@tc_table_id, OLD.', table_name, '_id);
                                IF @is_env_web IS FALSE THEN
                                    SET NEW.', table_name, '_trf_yn = 0;
                                END IF;
                            END IF;

                            IF @is_env_web IS FALSE THEN
                                IF NEW.', table_name, '_trf_yn IS NULL THEN
                                    SET NEW.', table_name, '_trf_yn = 0;
                                END IF;
                            END IF;
                    END; $$', CHAR(13));
                ELSE
                    SET @update_trigger_sql = CONCAT(@update_trigger_sql, '
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.', table_name, '_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.', table_name, '_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.', table_name, '_trf_yn IS NULL THEN
                                SET NEW.', table_name, '_trf_yn = 0;
                            END IF;
                        END IF;
                    END; $$', CHAR(13));
                END IF;

                -- Generate delete trigger
                SET @delete_trigger_sql = CONCAT('
                    DROP TRIGGER IF EXISTS tr_', table_name, '_del_be; $$
                    CREATE TRIGGER tr_', table_name, '_del_be
                    BEFORE DELETE ON ', table_name, ' FOR EACH ROW
                    BEGIN

                        DECLARE row_transferred TINYINT(1); -- True if the row has been data transferred

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "', table_name, '" INTO @tc_table_id;', CHAR(13));

                    IF table_key_indicator = 1 THEN
                        SET @delete_trigger_sql = CONCAT(@delete_trigger_sql, '
                            SELECT ', table_name, '_trf_yn FROM ', table_name, ' WHERE ', table_name, '_id = OLD.', table_name, '_id INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE "45000" SET
                                    MYSQL_ERRNO = "30002",
                                    MESSAGE_TEXT = "Cannot delete data transferred row on slave environment";
                                END IF;
                            END IF;
                            
                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.', table_name, '_id);
                            END IF;

                            END; $$', CHAR(13));
                    ELSE
                        SET @delete_trigger_sql = CONCAT(@delete_trigger_sql, '
                            SELECT ', table_name, '_trf_yn FROM ', table_name, ' WHERE ', table_name, '_ix = OLD.', table_name, '_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE "45000" SET
                                    MYSQL_ERRNO = "30002",
                                    MESSAGE_TEXT = "Cannot delete data transferred row on slave environment";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.', table_name, '_ix);
                            END IF;

                            END; $$', CHAR(13));
                    END IF;

            IF IF(table_name NOT IN("tc_res_update", "td_deletions", "rf_link_type", "rf_mail"), TRUE, FALSE) THEN -- Exclude these tables
                SET @triggers_sql = CONCAT(@triggers_sql, @insert_trigger_sql, @update_trigger_sql, @delete_trigger_sql);
            END IF;
        END IF;
    UNTIL ch_done END REPEAT;
    CLOSE trigger_tables;
END; //

CALL insert_triggers(); //
DROP PROCEDURE insert_triggers; //
SELECT @triggers_sql; //
