<?php

namespace Resrequest\Resnova;

class Module
{
    public function getConfig()
    {
        $moduleConfig = include __DIR__ . '/config/module.config.php';
        $principalId = array_key_exists('principal_id', $GLOBALS) ? $GLOBALS['principal_id'] : '0000';
        $resnovaDir = __DIR__ . '/../../../../images/' . $principalId . '/resnova';


        return array_merge(
            $moduleConfig,
            [
                'asset_manager' => [
                    'resolver_configs' => [
                        'map' => [
                            'resnova' => $resnovaDir . '/index.html',
                        ],
                        'aliases' => [
                            'resnova/' => $resnovaDir
                        ],
                    ]
                ]
            ]
        );
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . str_replace("\\", "/", __NAMESPACE__),
                ),
            ),
        );
    }
}
