<?php
namespace Resrequest\Setup;

use Zend\Console\Request as ConsoleRequest;
use Zend\Console\Console;
use Zend\Session\SessionManager;
use Zend\Session\Container;
use Zend\Mvc\ModuleRouteListener;
use Resrequest\Setup\Service\Enterprise;

class Module
{
    public function onBootstrap($e)
    {
        $application = $e->getApplication();
        $eventManager = $application->getEventManager();
        $sm = $application->getServiceManager();
        $moduleRouteListener = new ModuleRouteListener();
        $moduleRouteListener->attach($eventManager);

        if (!Console::isConsole()) {
            $enterpriseSetup = $sm->get('Resrequest\Setup\Service\Enterprise');
            $application->getEventManager()->attachAggregate($application->getServiceManager()->get('AclListener'));
        }
    }

    public function getConfig()
    {
        $config = array();

        if (!Console::isConsole()) {
            $config = Enterprise::setup();
        }

        $modulesConfig = include __DIR__ . '/config/module.config.php';
        return array_merge_recursive($config, $modulesConfig);
    }

    public function getServiceConfig() {
        return array(
            'factories' => array(
                'Zend\Session\SessionManager' => function ($sm) {
                    $config = $sm->get('config')['enterprise'];
                    if (isset($config['session'])) {
                        $session = $config['session'];

                        $sessionConfig = null;
                        if (isset($session['config'])) {
                            $class = isset($session['config']['class'])  ? $session['config']['class'] : 'Zend\Session\Config\SessionConfig';
                            $options = isset($session['config']['options']) ? $session['config']['options'] : array();
                            $sessionConfig = new $class();
                            $sessionConfig->setOptions($options);
                        }

                        $sessionStorage = null;
                        if (isset($session['storage'])) {
                            $class = $session['storage'];
                            $sessionStorage = new $class();
                        }

                        $sessionSaveHandler = null;
                        if (isset($session['save_handler'])) {
                            // class should be fetched from service manager since it will require constructor arguments
                            $sessionSaveHandler = $sm->get($session['save_handler']);
                        }

                        $sessionManager = new SessionManager($sessionConfig, $sessionStorage, $sessionSaveHandler);
                    } else {
                        $sessionManager = new SessionManager();
                    }
                    Container::setDefaultManager($sessionManager);
                    return $sessionManager;
                },
                'Resrequest\Setup\Service\Enterprise' => function($sm) {
                    return new Enterprise($sm);
                },
            ),
        );
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__=>  __DIR__ . '/src/Resrequest/Setup',
                ),
            ),
        );
    }
}
