<?php
namespace Resrequest\Tools;

use Zend\Mvc\Controller\ControllerManager as ControllerManager;
use Zend\ModuleManager\Feature\ConsoleUsageProviderInterface;
use Zend\Console\Adapter\AdapterInterface as Console;
use Resrequest\Tools\Controller\EnterpriseController;
use Resrequest\DB\Service\EnterpriseDatabaseService;
class Module implements ConsoleUsageProviderInterface
{
    private $sm;

    public function onBootstrap($e)
    {
        $application = $e->getTarget();
        $this->sm = $application->getServiceManager();
    }

    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
					__NAMESPACE__ => __DIR__ . '/src/' . str_replace("\\", "/", __NAMESPACE__),
                ),
            ),
        );
    }

    public function getServiceConfig()
    {
        return array(
        );
    }

    public function getConsoleUsage(Console $console)
    {
        return array(
            'Enterprise database commands:',
            'resrequest:enterprise:triggers [--generate]' => 'Generate and import database triggers',
            array('--generate', 'Only generate triggers into triggers.sql'),
            'resrequest:enterprise:tz [--generate]' => 'Generate and import MariaDB timezones',
            array('--generate', 'Only generate timezones into tz.sql'),
            'resrequest:enterprise:sctables [--generate]' => 'Generate and import sc table data',
            array('--generate', 'Only generate sc table data into sctables.sql'),
            'resrequest:enterprise:defaults [--generate]' => 'Generate and import database default data',
            array('--generate', 'Only generate default data into defaults.sql'),
            'resrequest:enterprise:upgradedb <principal ID>' => 'Upgrades Enterprise system to the latest version',
            array('<principal ID>', 'Enterprise system to upgrade'),
            'resrequest:enterprise:template <principal ID>' => 'Create an empty template database',
            array('<principal ID>', 'Principal database ID to create'),
            'resrequest:enterprise:create <principal ID>' => 'Create a new Enterprise system and add censys entry.',
            array('<principal ID>', 'Enterprise principal ID to create'),
            'resrequest:enterprise:buildresources [--verbose] [--install]' => 'Build and minify Enterprise resources (js, css)',
            array('--verbose', 'Output more verbose information'),
            array('--install', 'Install minified files'),
            array('--node-modules', 'Run npm install before building'),
            'Enterprise reminders commands:',
            'resrequest:enterprise:sendreminders' => 'Send all active reminders',
            array('--shortname', 'Shortname of the principal system (e.g. welcome)'),
            array('--database', 'Name of the database (e.g. cn_live_0001)'),
            'Enterprise workflow commands:',
            'resrequest:enterprise:createworkflowreminders' => 'Create reminders based on the defined workflows',
            array('--shortname', 'Shortname of the principal system (e.g. welcome)'),
            array('--database', 'Name of the database (e.g. cn_live_0001)'),
        );
    }
}
