<?php
return array(
    'console' => array(
        'router' => array(
            'routes' => array(
                'resrequest' => array(
                    'options' => array(
                        'route'    => 'resrequest',
                        'defaults' => array(
                            'controller' => 'Resrequest',
                            'action'     => 'index'
                        )
                    )
                ),
                'resrequest-enterprise' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'index'
                        )
                    )
                ),
                'resrequest-enterprise-template' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:template --principal-id=',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'template'
                        )
                    )
                ),
                'resrequest-enterprise-create' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:create --principal-id= --principal-name= --principal-short-name= --environment=',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'create'
                        )
                    )
                ),
                'resrequest-enterprise-sc-tables' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:sctables --database= [--generate]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'scTables'
                        )
                    )
                ),
                'resrequest-enterprise-defaults' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:defaults --database=',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'defaults'
                        )
                    )
                ),
                'resrequest-enterprise-tz' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:tz [--generate]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'tz'
                        )
                    )
                ),
                'resrequest-enterprise-triggers' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:triggers --database= [--generate]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'triggers'
                        )
                    )
                ),
                'resrequest-enterprise-version' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:version [--database=] --version= [--generate]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'version'
                        )
                    )
                ),
                'resrequest-enterprise-migrations' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:migrations --database= [--generate]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'migrations'
                        )
                    )
                ),
                'resrequest-enterprise-functions' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:functions --database=',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'functions'
                        )
                    )
                ),
                'resrequest-enterprise-procedures' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:procedures --database=',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'procedures'
                        )
                    )
                ),
                'resrequest-enterprise-build' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:build --version=',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'build'
                        )
                    )
                ),
                'resrequest-enterprise-build-resources' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:buildresources [--verbose] [--install] [--node-modules]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'buildResources'
                        )
                    )
                ),
                'resrequest-enterprise-upgrade-db' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:upgradedb [--database=] [--no-backup] [--verbose] [--offline]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'upgradeDb'
                        )
                    )
                ),
                'resrequest-enterprise-send-reminders' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:sendreminders [--database=] [--shortname=] [--log=]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'sendReminders'
                        )
                    )
                ),
                'resrequest-enterprise-create-workflow-reminders' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:createworkflowreminders [--database=] [--shortname=] [--log=]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'createWorkflowReminders'
                        )
                    )
                ),
                'resrequest-enterprise-reminder-and-awf-trigger' => array(
                    'options' => array(
                        'route'    => 'resrequest:enterprise:reminderandawftrigger [--database=] [--shortname=] [--log=]',
                        'defaults' => array(
                            'controller' => 'Enterprise',
                            'action'     => 'reminderandawftrigger'
                        )
                    )
                ),
                'resrequest-censys' => array(
                    'options' => array(
                        'route'    => 'resrequest:censys',
                        'defaults' => array(
                            'controller' => 'Censys',
                            'action'     => 'index'
                        )
                    )
                ),
                'resrequest-censys-template' => array(
                    'options' => array(
                        'route'    => 'resrequest:censys:template',
                        'defaults' => array(
                            'controller' => 'Censys',
                            'action'     => 'template'
                        )
                    )
                ),
                'resrequest-censys-create' => array(
                    'options' => array(
                        'route'    => 'resrequest:censys:create [--generate]',
                        'defaults' => array(
                            'controller' => 'Censys',
                            'action'     => 'create'
                        )
                    )
                ),
            ),
        )
    ),
	'controllers' => array(
		'invokables' => array(
            'Resrequest' => 'Resrequest\Tools\Controller\ResrequestController',
            'Censys' => 'Resrequest\Tools\Controller\CensysController',
        ),
        'factories' => array(
            'Enterprise' => function($cm) {
                $request = $this->sm->get('Request');
                $router = $this->sm->get('router');
                $routerMatch = $router->match($request);

                $databaseName = $routerMatch->getParam('database');
                if (!empty($databaseName)) {
                    // Check if database exists
                    $connection = @mysqli_connect('localhost', 'root', '', $databaseName);
                    if($connection != true)  {
                        die("Database '$databaseName' does not exist\n");
                    }
                    mysqli_close($connection);
                    
                    // Setup database connection only if required
                    $globalConfig = $this->sm->get('config');
                    $globalConfig['doctrine']['connection']['orm_enterprise']['params']['dbname'] = $databaseName;
                    $isAllowOverride = $this->sm->getAllowOverride();
                    $this->sm->setAllowOverride(true);
                    $this->sm->setService('config', $globalConfig);
                    $this->sm->setAllowOverride($isAllowOverride);
                    $em = $this->sm->get('doctrine.entitymanager.orm_enterprise');
                } else {
                    $em = false;
                }
                
                $enterpriseDatabaseService = new Resrequest\DB\Service\EnterpriseDatabaseService($this->sm, $em);
                return new Resrequest\Tools\Controller\EnterpriseController($enterpriseDatabaseService);
            },
        )
    ),
);
