<?php

namespace Resrequest\Tools\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Resrequest\Application\Reminder\Reminder;
use Resrequest\Application\Workflow\Workflow;

define('ENTERPRISECONTROLLER_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))); //Go back 5 directories
define('ENTERPRISECONTROLLER_ROOT', ENTERPRISECONTROLLER_SERVER. '/Application/src/Resrequest/legacy');

class EnterpriseController extends AbstractActionController
{
  private $sm;
  private $enterpriseDatabase;
  private $spaPath;

  public function __construct(
    \Resrequest\DB\Service\EnterpriseDatabaseService $enterpriseDatabase
  ) {
    $this->enterpriseDatabase = $enterpriseDatabase;
    $this->spaPath = realpath(__DIR__ . "/../../../../../UI/public/");
  }

  public function indexAction()
  {
    return "Enterprise";
  }

  public function reminderandawftriggerAction()
  {
    // Consolidation of function sendRemindersAction() and function createWorkflowRemindersAction()
    // for use by Neuro Agent in order to execute a single command instead of 2.
    // Code is duplicated because somehow these functions can not be called one after the other
    // (global variables blah blah)
    
    $request = $this->getRequest();
    $shortname = $request->getParam('shortname');
    $database = $request->getParam('database');
    $logUrl = $request->getParam('log');

    if (empty($database)) {
      die("ERROR: Database not specified\n");
    }
    if (empty($shortname)) {
      die("ERROR: Shortname not specified\n");
    }

    require_once(ENTERPRISECONTROLLER_ROOT . '/class.mysqldb.php');
    require_once(ENTERPRISECONTROLLER_ROOT . '/inc.config.php');
    $GLOBALS['environment'] = 'WB';
    $GLOBALS['dbcode'] = 'WB';
    $GLOBALS['userid'] = 'RS1'; // system
    $GLOBALS['userStatusId'] = '3'; // system user status id
    $GLOBALS['lDB'] = new \MySQLDB($database, $user, $pass, $dbHost);
    // needed by functions.mail.php
    $GLOBALS['images_dir_on_disk'] = __DIR__ . "/../../../../../../../images";
    $GLOBALS['principal_id'] = substr($database, -7);
    $GLOBALS['isWebServer'] = true;
    $GLOBALS['envWebOverride'] = true;
    $domain = gethostname() == "resrequestvagrant" ? "vagrant" : "resrequest.com";
    $host = $_SERVER['SERVER_NAME'] = "{$shortname}.{$domain}";
    $reminder = new Reminder($this->enterpriseDatabase, $host, $database);
    $result = $reminder->send();

    $this->output("Reminder and AWF Trigger");
    $this->output("Sending reminders");
    $this->output($result);

    if (!empty($logUrl)) {
      $this->logResponseToAgent($logUrl, "reminders", $result, $database, $shortname);
    }

    $this->output("Creating workflow reminders");
    $host = $_SERVER['SERVER_NAME'] = "$shortname.resrequest.com";
    $workflow = new Workflow($this->enterpriseDatabase, $host, $database);
    $result = $workflow->run();
    $this->output($result);

    if (!empty($logUrl)) {
      $this->logResponseToAgent($logUrl, "workflowReminders", $result, $database, $shortname);
    }
  }

  public function logResponseToAgent($logUrl, $action, $result, $database, $shortname)
  {
    if (strpos($logUrl, "http") !== false) {
      // URL provided, make an API call to a Neuro Agent to log the result of the action
      $curl = curl_init();
      curl_setopt($curl, CURLOPT_URL, $logUrl);
      curl_setopt($curl, CURLOPT_POST, true);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($curl, CURLOPT_POSTFIELDS, [
        'action' => $action,
        'result' => json_encode($result),
        'database' => $database,
        'shortname' => $shortname
      ]);
      curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        "Authtoken: whatdoesthefoxsay",
      ));
      curl_exec($curl);
      curl_close($curl);
    } else if (substr_count($logUrl, '.') == 1) {
      // Database and table provided, write the result of the action directly to the database
      $details = explode('.', $logUrl);
      $error = 0;

      // Mark record as having an error, so that Agent could send out an email on next run
      foreach ($result['data'] as $item) {
        $item = json_decode(json_encode($item), true);
        if ($action == "reminders" && $item['status'] != "40") {
          $error = 1;
        }
        if ($action == "workflowReminders" && $item['status'] != "success") {
          $error = 1;
        }
      }

      // Open DB connection to specified database, and write log to table
      global $dbHost, $user, $pass;
      $aDB = new \MySQLDB($details[0], $user, $pass, $dbHost);
      $aDB->put(
        "
          INSERT INTO " . $details[1] . " (
            principal_id,
            principal_shortname,
            log_action,
            data,
            error_status
          ) VALUES (
            '" . str_replace("cn_live_", "", $database) . "',
            '" . $shortname . "',
            '" . $action . "',
            '" . json_encode($result['data']) . "',
            " . $error . "
          );
        "
      );

    }
  }

  public function sendRemindersAction()
  {
    $this->output("Sending reminders");
    $request = $this->getRequest();
    $shortname = $request->getParam('shortname');
    $database = $request->getParam('database');
    $logUrl = $request->getParam('log');

    if (empty($database)) {
      die("ERROR: Database not specified\n");
    }
    if (empty($shortname)) {
      die("ERROR: Shortname not specified\n");
    }

    require_once(ENTERPRISECONTROLLER_ROOT . '/class.mysqldb.php');
    require_once(ENTERPRISECONTROLLER_ROOT . '/inc.config.php');
    $GLOBALS['environment'] = 'WB';
    $GLOBALS['dbcode'] = 'WB';
    $GLOBALS['userid'] = 'RS1'; // system
    $GLOBALS['userStatusId'] = '3'; // system user status id
    global $lDB;
    $_SESSION['principal_id'] = substr($database, -7);
    $lDB = new \MySQLDB($database, $user, $pass, $dbHost);
    // needed by functions.mail.php
    $GLOBALS['images_dir_on_disk'] = __DIR__ . "/../../../../../../../images";
    $GLOBALS['principal_id'] = substr($database, -7);
    $GLOBALS['isWebServer'] = true;
    $GLOBALS['envWebOverride'] = true;
    $domain = gethostname() == "resrequestvagrant" ? "vagrant" : "resrequest.com";
    $host = $_SERVER['SERVER_NAME'] = "{$shortname}.{$domain}";

    $GLOBALS['http'] = 'https://';
    $GLOBALS['domain'] = $domain;
    $GLOBALS['system'] = 'live';
    $GLOBALS['principal_name_short'] = $shortname;
    $_SESSION['userStatusId'] = '3'; // system user status id
    $_SESSION['principal_name_short'] = $shortname;
    $_SESSION['principal_id'] = $GLOBALS['principal_id'];

    $reminder = new Reminder($this->enterpriseDatabase, $host, $database);
    $result = $reminder->send();
    $this->output($result);

    if (!empty($logUrl)) {
      $this->logResponseToAgent($logUrl, "reminders", $result, $database, $shortname);
    }
  }

  public function createWorkflowRemindersAction()
  {
    $this->output("Creating workflow reminders");
    $request = $this->getRequest();
    $shortname = $request->getParam('shortname');
    $database = $request->getParam('database');
    $logUrl = $request->getParam('log');
    
    if (empty($database)) {
      die("ERROR: Database not specified\n");
    }
    if (empty($shortname)) {
      die("ERROR: Shortname not specified\n");
    }

    require_once(ENTERPRISECONTROLLER_ROOT . '/class.mysqldb.php');
    require_once(ENTERPRISECONTROLLER_ROOT . '/inc.config.php');
    $GLOBALS['environment'] = 'WB';
    $GLOBALS['dbcode'] = 'WB';
    $GLOBALS['userid'] = 'RS1'; // system
    $GLOBALS['userStatusId'] = '3'; // system user status id
    $GLOBALS['lDB'] = new \MySQLDB($database, $user, $pass, $dbHost);
    // needed by functions.mail.php
    $GLOBALS['images_dir_on_disk'] = __DIR__ . "/../../../../../../../images";
    $GLOBALS['principal_id'] = substr($database, -7);
    $GLOBALS['isWebServer'] = true;
    $GLOBALS['envWebOverride'] = true;
    $host = $_SERVER['SERVER_NAME'] = "$shortname.resrequest.com";
    $domain = gethostname() == "resrequestvagrant" ? "vagrant" : "resrequest.com";
    $GLOBALS['http'] = 'https://';
    $GLOBALS['domain'] = $domain;
    $GLOBALS['system'] = 'live';
    $GLOBALS['principal_name_short'] = $shortname;
    $_SESSION['userStatusId'] = '3'; // system user status id
    $_SESSION['principal_name_short'] = $shortname;
    $_SESSION['principal_id'] = $GLOBALS['principal_id'];
    $workflow = new Workflow($this->enterpriseDatabase, $host, $database);
    $result = $workflow->run();
    $this->output($result);

    if (!empty($logUrl)) {
      $this->logResponseToAgent($logUrl, "workflowReminders", $result, $database, $shortname);
    }
  }

  public function upgradeDbAction() {
    $request = $this->getRequest();
    $noBackup = $request->getParam('no-backup');
    $offline = $request->getParam('offline');
    $verbose = $request->getParam('verbose');

    if ($noBackup === true) {
      $backup = false;
    } else {
      $backup = true;
    }

    if ($verbose === true) {
      $displayMigrationsOutput = true;
    } else {
      $displayMigrationsOutput = false;
    }

    if ($offline) {
      $result = $this->enterpriseDatabase->offlineUpgrade($backup, $displayMigrationsOutput);
    } else {
      if (empty($request->getParam('database'))) {
        die("Database not specified\n");
      }
      $result = $this->enterpriseDatabase->upgrade($backup, $verbose);
    }

    return $result;
  }

  public function triggersAction() {
    $request = $this->getRequest();
    $generate = $request->getParam('generate');
    if ($generate === true) {
      $result = $this->enterpriseDatabase->generateTriggers();
    } else {
      $result = $this->enterpriseDatabase->insertTriggers();
    }

    return $result;
  }

  public function versionAction() {
    $request = $this->getRequest();
    $generate = $request->getParam('generate');
    if ($generate === true) {
      $versionNumber = $request->getParam('version');
      if (empty($versionNumber)) {
        die("Version not specified\n");
      }
      $result = $this->enterpriseDatabase->generateVersion($versionNumber);
    } else {
      if (empty($request->getParam('database'))) {
        die("Database not specified\n");
      }

      $result = $this->enterpriseDatabase->insertVersion();
    }

    return $result;
  }

  public function templateAction() {
    $request = $this->getRequest();
    $principalId = $request->getParam('principal-id');

    $result = $this->enterpriseDatabase->template($principalId);

    return $result;
  }

  public function tzAction() {
    $request = $this->getRequest();
    $generate = $request->getParam('generate');
    if ($generate === true) {
      $result = $this->enterpriseDatabase->generateTimezoneInfo();
    } else {
      $result = $this->enterpriseDatabase->insertTimezoneInfo();
    }

    return $result;
  }

  public function scTablesAction() {
    $request = $this->getRequest();
    $generate = $request->getParam('generate');
    if ($generate === true) {
      $result = $this->enterpriseDatabase->generateScTables();
    } else {
      $result = $this->enterpriseDatabase->insertScTables();
    }

    return $result;
  }

  public function defaultsAction() {
    $result = $this->enterpriseDatabase->insertDefaults();

    return $result;
  }

  public function functionsAction() {
    $result = $this->enterpriseDatabase->insertFunctions();

    return $result;
  }

  public function proceduresAction() {
    $result = $this->enterpriseDatabase->insertProcedures();

    return $result;
  }

  public function migrationsAction() {
    $request = $this->getRequest();
    $generate = $request->getParam('generate');
    if ($generate === true) {
      $result = $this->enterpriseDatabase->generateMigrationsTable();
    } else {
      $result = $this->enterpriseDatabase->insertMigrationsTable();
    }

    return $result;
  }

  public function buildAction() {
    $request = $this->getRequest();
    $version = $request->getParam('version');
    $result = $this->enterpriseDatabase->build($version);

    return $result;
  }

  public function buildResourcesAction() {
    $request = $this->getRequest();
    $install = $request->getParam('install');
    $nodeModules = $request->getParam('node-modules');
    $verbose = $request->getParam('verbose');

    if ($nodeModules) {
      $this->output("Installing resource build requirements");
      $this->runCommand("export NG_CLI_ANALYTICS=ci; npm install --production", $this->spaPath, $verbose);
    }
    $this->output("Building resources");
    // build legacy resources
    $this->output("  - Legacy");
    $this->runCommand("npm run build-legacy", $this->spaPath, $verbose);
    if ($install) {
      $this->output("      Installing minified legacy files");
      $this->runCommand("npm run install-legacy", $this->spaPath, $verbose);
    }
    $this->output("Building resources complete");
  }

  public function runCommand($cmd, $cwd = __DIR__, $verbose = true) {
    if (empty($cmd)) { 
      $this->output(" No command specified; skipping");
    };

    $descriptors = array(
      0 => array("pipe", "r"), 
      1 => array("pipe", "w"), 
      2 => array("pipe", "a")
    );
    $pipes = array();
    $process = proc_open($cmd, $descriptors, $pipes, $cwd, null);
    $lines = "";

    if(is_resource($process)) {
      do {
        $line = fgets($pipes[1]);  //will wait for a end of line
        if ($verbose) {
          $this->output($line);
        }
        $lines .= $line;
        $arr = proc_get_status($process);
      } while($arr['running']);
    }else{
      $this->output("ERROR: Could not build resources");
    }

    fclose($pipes[0]);
    fclose($pipes[1]);
    fclose($pipes[2]);
    proc_close($process);
  }

  public function output($message)
  {
    if (is_array($message)) {
      echo(json_encode($message) . PHP_EOL);
    } else {
      echo($message . PHP_EOL);
    }
  }
}

