<?php

return array(
	'router' => [
		'routes' => [
			'app' => [
				'type' => 'literal',
				'options' => [
					'route' => '/app',
					'defaults' => array(
						'controller' => 'MaglLegacyApplication\Controller\Legacy',
						'action'     => 'index',
						'script'	 => 'index.html'
					),
				],
				'may_terminate' => true,
				'child_routes' => [
					'any' => [
						'type' => 'regex',
						'options' => [
							'regex' => '(?:.*)',
							'spec' => ""
						]
					],
				]
			],
			'guest' => [
				'type' => 'Zend\Mvc\Router\Http\Regex',
				'options' => [
					'regex' => '^\/guest(?<path>\/[a-zA-Z0-9\.\-_\/~\?]+|\/?)$',
					'defaults' => array(
						'controller' => 'MaglLegacyApplication\Controller\Legacy',
						'action'     => 'index',
						'script'	 => '/../guest-experience/index.html'
					),
					'spec' => '/guest[:path]',
				],
				'may_terminate' => true,
				'child_routes' => [
					'any' => [
						'type' => 'regex',
						'options' => [
							'regex' => '(?:.*)',
							'spec' => ""
						]
					],
				],
				'priority' => 50
			],
		],
	],
	'magl_legacy_application' => array(
		'doc_root' => array(
			'module/Resrequest/UI/public/dist/ui',
		), // the legacy apps DOCUMENT_ROOT (can be more than one) for including files
	),
	'view_manager' => array(
		'display_not_found_reason' => true,
		'display_exceptions'       => true,
		'doctype'                  => 'HTML5',
		'not_found_template'       => 'error/404',
		'exception_template'       => 'error/index',
		'template_map' => array(
			'layout/layout'           => __DIR__ . '/../view/layout/layout.phtml',
			'error/404'               => __DIR__ . '/../view/error/404.phtml',
			'error/index'             => __DIR__ . '/../view/error/index.phtml',
		),
	),
	'asset_manager' => array(
		'resolver_configs' => array(
			// Serve static content from public/dist
			'paths' => array(
				'Resrequest\UI' => __DIR__ . '/../public/dist',
			),
			'aliases' => [
				'guest/' =>  __DIR__ . '/../public/dist/guest-experience/'
			],
			// Use index.htm for the default (/) route
			'map' => array(
				'' => __DIR__ . '/../public/dist/ui/index.html',
				'/' => __DIR__ . '/../public/dist/ui/index.html',
				false => __DIR__ . '/../public/dist/ui/index.html',
			),
		),
	),
);
