import { CommonModule } from '@angular/common';
import { NgModule, ModuleWithProviders } from '@angular/core';
import { PortalModule } from '@angular/cdk/portal';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonModule } from '@angular/material/button';
import { OverlayModule } from '@angular/cdk/overlay';
import { MatSelectModule } from '@angular/material/select';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatMenuModule } from '@angular/material/menu';

import { AppComponent } from './app.component';
import { ChartComponent } from './chart/chart.component';
import { SettingsButtonComponent } from './settings-button/settings-button.component';
import { ChartContainerComponent } from './chart-container/chart-container.component';
import { ChartFilterComponent } from './chart-filter/chart-filter.component';
import { CurrencyConverterComponent } from './inputs/currency-converter/currency-converter.component';

import { FusionChartsModule } from 'angular-fusioncharts';
import { GridsterModule } from 'angular-gridster2';
import * as Maps from 'projects/charts/src/assets/fusioncharts/fusioncharts.maps';
import * as FusionCharts from 'projects/charts/src/assets/fusioncharts/fusioncharts';
import * as Charts from 'projects/charts/src/assets/fusioncharts/fusioncharts.charts';
import * as Widgets from 'projects/charts/src/assets/fusioncharts/fusioncharts.widgets';
import * as PowerCharts from 'projects/charts/src/assets/fusioncharts/fusioncharts.powercharts';
import * as FusionTheme from 'projects/charts/src/assets/fusioncharts/themes/fusioncharts.theme.fusion';
import * as WorldWithCountries from 'projects/charts/src/assets/fusioncharts/maps/fusioncharts.worldwithcountries.js';

import { MultiselectDropdownComponent } from './inputs/multiselect-dropdown/multiselect-dropdown.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { CalendarComponent } from './inputs/calendar/calendar.component';
import { MatMomentDateModule } from '@angular/material-moment-adapter';

import { MatExpansionModule } from '@angular/material/expansion';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MAT_DATE_LOCALE } from '@angular/material/core';
import { MatDividerModule } from '@angular/material/divider';
import { MatInputModule } from '@angular/material/input';
import { MatRadioModule } from '@angular/material/radio';
import { MatSidenavModule } from '@angular/material/sidenav';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { MatTooltipModule } from '@angular/material/tooltip';

import { FontAwesomeModule, FaIconLibrary } from '@fortawesome/angular-fontawesome';
import { fas, faCog, faDownload, faListUl, faTimes, faStar, faChartLine, faQuestionCircle } from '@fortawesome/free-solid-svg-icons';
import { faStar as farStar } from '@fortawesome/free-regular-svg-icons';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';
import { SharedModule } from 'src/app/shared/shared.module';
import { OptionsPortalComponent } from './options-portal/options-portal.component';
import { ContainerOptionsPortalComponent } from './container-options-portal/container-options-portal.component';
import { OptionsPageComponent } from './options-page/options-page.component';
import { ContainerOptionsPageComponent } from './container-options-page/container-options-page.component';
import { PageSectionComponent } from './options-page/page-section/page-section.component';
import { ContainerPageSectionComponent } from './container-options-page/container-page-section/container-page-section.component';
import { RadioGroupComponent } from './inputs/radio-group/radio-group.component';
import { ButtonToggleComponent } from './inputs/button-toggle/button-toggle.component';
import { SliderToggleComponent } from './inputs/slider-toggle/slider-toggle.component';
import { ChartService } from './services/chart.service';
import { AccommodationFilterInputComponent } from './inputs/accommodation-filter-input/accommodation-filter-input.component';
import { OptionInputComponent } from './inputs/option-input/option-input.component';
import { MultiSelectComponent } from './inputs/multi-select/multi-select.component';
import { DateRangeComponent } from './inputs/date-range/date-range.component';
import { ScrollingModule } from '@angular/cdk/scrolling';
import { ChartContainerMenuComponent } from './chart-container/chart-container-menu/chart-container-menu.component';
import { PowerBiComponent } from './power-bi/power-bi.component';
import { ResvegaComponent } from './resvega/resvega.component';

import { EngagementComponent } from './engagement/engagement.component';
import { EngagementSidebarComponent } from './engagement/engagement-sidebar/engagement-sidebar.component';
import { EngagementService } from './services/engagement.service';
import { EngagementGraphMonthValuesPipe } from './engagement/pipes/engagement.graph.month.values.pipe';
import { EngagementGraphTotalValuePipe } from './engagement/pipes/engagement.graph.total.value.pipe';
import { EngagementCardsPipe } from './engagement/pipes/engagement.cards.pipe';

FusionChartsModule.fcRoot(
  FusionCharts,
  PowerCharts,
  Charts,
  Widgets,
  FusionTheme,
  Maps,
  WorldWithCountries
);

@NgModule({
  declarations: [
    AppComponent,
    ChartComponent,
    SettingsButtonComponent,
    ChartContainerComponent,
    ChartFilterComponent,
    MultiselectDropdownComponent,
    CalendarComponent,
    CurrencyConverterComponent,
    OptionsPortalComponent,
    ContainerOptionsPortalComponent,
    OptionsPageComponent,
    ContainerOptionsPageComponent,
    PageSectionComponent,
    ContainerPageSectionComponent,
    RadioGroupComponent,
    SliderToggleComponent,
    ButtonToggleComponent,
    AccommodationFilterInputComponent,
    OptionInputComponent,
    MultiSelectComponent,
    DateRangeComponent,
    ChartContainerMenuComponent,
    EngagementComponent,
    EngagementSidebarComponent,
    EngagementGraphMonthValuesPipe,
    EngagementGraphTotalValuePipe,
    EngagementCardsPipe,
    PowerBiComponent,
    ResvegaComponent
  ],
  imports: [
    CommonModule,
    FusionChartsModule,
    GridsterModule,
    MatButtonModule,
    MatIconModule,
    PortalModule,
    OverlayModule,
    MatSelectModule,
    FormsModule,
    MatDatepickerModule,
    MatMomentDateModule,
    MatInputModule,
    MatExpansionModule,
    ReactiveFormsModule,
    FontAwesomeModule,
    MatTooltipModule,
    MatProgressSpinnerModule,
    MatSidenavModule,
    SharedModule,
    MatDividerModule,
    MatRadioModule,
    MatButtonToggleModule,
    MatSlideToggleModule,
    MatCheckboxModule,
    ScrollingModule,
    MatMenuModule
  ],
  exports: [
    ChartComponent,
    ChartContainerComponent,
    EngagementComponent,
    PowerBiComponent,
    ResvegaComponent
  ],
  providers: [
    ChartService,
    { provide: MAT_DATE_LOCALE, useValue: 'en-GB' }
  ],
  bootstrap: [AppComponent]
})
export class AppModule {
  constructor(library: FaIconLibrary) {
    library.addIconPacks(fas);
    library.addIcons(
      faCog,
      faDownload,
      faListUl,
      faTimes,
      farStar,
      faStar,
      faChartLine,
      faQuestionCircle
    );
  }
}

@NgModule({})
export class ChartModule {
  static forRoot(): ModuleWithProviders<AppModule> {
    return {
      ngModule: AppModule,
      providers: []
    };
  }
}
