import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
  selector: 'app-chart-filter',
  templateUrl: './chart-filter.component.html',
  styleUrls: ['./chart-filter.component.scss'],
})
export class ChartFilterComponent implements OnInit {
  @Input() filter;
  @Output() filterChanged: EventEmitter<{}>;

  name = '';
  type = '';
  enabled = false;
  visible = false;
  options = [];

  constructor() {
    this.filterChanged = new EventEmitter();
  }

  ngOnInit() {
    this.name = this.filter.name;
    this.type = this.filter.filter;
    this.enabled = this.filter.enabled;
    this.visible = this.filter.visible;
    this.options = this.filter.options;
  }

  getConfig() {
    const name = this.name;
    const type = this.type;
    const enabled = this.enabled;
    const visible = this.visible;
    const options = this.options;

    return {
      name,
      type,
      enabled,
      visible,
      options
    };
  }

  valueChanged(optionIndex: number, value: any) {
    // Update filter option value
    this.filter.options[optionIndex].value = value;

    this.applyChanges();
  }

  applyChanges() {
    const config = this.getConfig();

    this.filterChanged.emit(config);
  }

}
