import { Component, OnInit, Input } from '@angular/core';
import { Observable } from 'rxjs';
import { PageSection } from '../core/ui-config/page-section.model';
import { map } from 'rxjs/operators';
import { ChartContainerOptionsPageService } from '../services/chart-container-options-page.service';
import { PortalService } from 'src/app/shared/components/portal';
import { ChartContainerOptionService } from '../services/chart-container-option.service';

@Component({
  selector: 'app-container-options-page',
  templateUrl: './container-options-page.component.html',
  styleUrls: ['./container-options-page.component.scss'],
  providers: []
})
export class ContainerOptionsPageComponent implements OnInit {
  @Input() name: string;

  refreshing$ = this.pageService.refreshing$;
  optionsChanged$ = this.pageService.optionsChanged$;
  sections$: Observable<PageSection[]>;

  constructor(
    private pageService: ChartContainerOptionsPageService,
    private optionsService: ChartContainerOptionService
  ) { }

  ngOnInit() {
    this.sections$ = this.pageService.pageToSections$.pipe(
      map(pageToSections => {
        // Force a rerender by changing references.
        const sections = pageToSections[this.name];
        const newSections = sections.map(section => ({...section}));
        return newSections;
      })
    );
  }

  clear(): void {
    this.pageService.reset();
  }

  apply(): void {
    this.pageService.apply();
    this.close();
  }

  applyAll(): void {
    this.pageService.applyAll();
    this.close();
  }

  close() {
    this.optionsService.onClose();
  }

}
